/*
 * ADropTargetListener
 * Created on 20/04/2005
 *
 *
 */
package dguitar.gui.listeners;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import dguitar.gui.DGuitar;

/**
 * The Drop action happens in this order: 1. dragEnter =
when the mouse enters
 * the component 2. dragOver = after the mouse has entered
but has not been
 * released 3. drop = when the mouse is released
 * 
 * @author Mauricio Gracia G
 */
public class ADropTargetListener implements DropTargetListener {
	private DGuitar parent;

	public ADropTargetListener(DGuitar dguitar) {
		if (dguitar != null) {
			this.parent = dguitar;
		} else {
			throw new NullPointerException("dguitar is null");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
java.awt.dnd.DropTargetListener#drop(java.awt.dnd.DropTargetDropE
vent)
	 */
	public void drop(DropTargetDropEvent dtde) {
		Transferable transfer;
//		UNUSED String str;
//		UNUSED java.util.List list;

		//      DEBUG
		//      System.out.println("drop" + ":" + dtde) ;

		transfer = dtde.getTransferable();

//		UNUSED		DataFlavor[] currentFlavors = dtde.getCurrentDataFlavors();

		//we must accept the transfer to process it
		//TODO other actions to accept ?
		dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);

//		UNUSED		DataFlavor[] flavors = transfer.getTransferDataFlavors();
		importData(parent, transfer);
		/*try {
		 boolean success = false;
		 for (int i = 0; i < flavors.length; i++) {
		 if (success)
		 break;
		 DataFlavor flavor = flavors[i];
		 //list = (List)
		 // transfer.getTransferData(DataFlavor.javaFileListFlavor);
		 list = (List) transfer.getTransferData(flavor);
		 parent.displayMultipleFiles(list);
		 success = true;
		 }
		 } catch (UnsupportedFlavorException e) {
		 e.printStackTrace();
		 } catch (IOException e) {
		 e.printStackTrace();
		 }*/
	}

	public void importData(DGuitar dguitar, Transferable t) {
		if (canImport(t.getTransferDataFlavors())) {
			try {
				DataFlavor[] flavors = t.getTransferDataFlavors();
				for (int i = 0; i < flavors.length; i++) {
					//    	 Drop from Windows
					if (DataFlavor.javaFileListFlavor.equals(flavors[i])) {
						if (t.getTransferData(DataFlavor.javaFileListFlavor)
instanceof java.util.List) {
							java.util.List fileList = (java.util.List) t
									.getTransferData(DataFlavor.javaFileListFlavor);
							dguitar.displayMultipleFiles(fileList);

						}

					}
					//    	 Drop from GNOME or kde
					// delimited by \n  (\r\n) on gnome
					// will need to remove file:// at start
					else if (DataFlavor.stringFlavor.equals(flavors[i])) {
						if (t.getTransferData(DataFlavor.stringFlavor)
instanceof String) {
							String path = (String) t
									.getTransferData(DataFlavor.stringFlavor);
							List fileList = convertStringsToFileList(path);
							dguitar.displayMultipleFiles(fileList);

						}

					}
				}
			} catch (UnsupportedFlavorException e) {
				e.printStackTrace();

			} catch (IOException e) {
				e.printStackTrace();

			}
		}
	}

	private List convertStringsToFileList(String filestr) {
		ArrayList files = new ArrayList();
		String[] tokenizedFiles = filestr.split("\n");
		for (int i = 0; i < tokenizedFiles.length; i++) {
			String path = tokenizedFiles[i];
			if (path.startsWith("file://")) {
				if (path.endsWith("\r")) {
					//appears to be the case for gnome but not kde
					path = path.substring(7);
					path = path.replaceAll("\r", "");

					path = path.replaceAll("%20", " ");
				} else {
					path = path.substring(7);
				}
			}
			files.add(new File(path));

		}
		return files;
	}

	public boolean canImport(DataFlavor[] flavors) {
		for (int i = 0; i < flavors.length; i++) {
			if (DataFlavor.javaFileListFlavor.equals(flavors[i])) {
				return true;
			} else if (DataFlavor.stringFlavor.equals(flavors[i])) {
				return true;
			}
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
java.awt.dnd.DropTargetListener#dragEnter(java.awt.dnd.DropTarget
DragEvent)
	 */
	public void dragEnter(DropTargetDragEvent dtde) {
		//DEBUG
		//System.out.println("dragEnter" + ":" + dtde) ;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
java.awt.dnd.DropTargetListener#dragOver(java.awt.dnd.DropTargetD
ragEvent)
	 */
	public void dragOver(DropTargetDragEvent dtde) {
		//      DEBUG
		//System.out.println("dragOver" + ":" + dtde) ;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
java.awt.dnd.DropTargetListener#dropActionChanged(java.awt.dnd.Dr
opTargetDragEvent)
	 */
	public void dropActionChanged(DropTargetDragEvent dtde) {
		//      DEBUG
		//System.out.println("dropActionChanged" + ":" + dtde) ;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
java.awt.dnd.DropTargetListener#dragExit(java.awt.dnd.DropTargetE
vent)
	 */
	public void dragExit(DropTargetEvent dte) {
		//      DEBUG
		//System.out.println("dragExit" + ":" + dte) ;
	}

}