/*
 * Decompiled with CFR 0.152.
 */
package common;

public class UtilErrors {
    private int errorCode;
    private String detail;
    public static final UtilErrors NO_ERROR = new UtilErrors(0);
    public static final UtilErrors UNKNOWN_ERROR = new UtilErrors(1);
    public static final UtilErrors PARAM_NULL = new UtilErrors(2);
    public static final UtilErrors DOES_NOT_EXIST = new UtilErrors(3);
    public static final UtilErrors NOT_A_FILE = new UtilErrors(4);
    public static final UtilErrors NOT_READABLE = new UtilErrors(5);
    private static final UtilErrors[] errors = new UtilErrors[]{NO_ERROR, UNKNOWN_ERROR, PARAM_NULL, DOES_NOT_EXIST, NOT_A_FILE, NOT_READABLE};
    private String[] errorStrings = new String[]{"NO ERROR", "UNKNOWN ERROR", "PARAMETER IS NULL", "DOES NOT EXIST", "IS NOT A FILE", "IS NOT READABLE"};

    public UtilErrors(int error) {
        this.errorCode = error;
        this.detail = "NO MORE DETAILS - ";
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        String resp = this.errorStrings[1];
        if (this.errorCode == 0 || this.errorCode > 1 && this.errorCode < errors.length) {
            resp = this.errorStrings[this.errorCode];
        }
        resp = String.valueOf(this.detail) + " " + resp;
        return resp;
    }

    public void setDetails(String s) {
        this.detail = s;
    }
}

