#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#################################################################
# This block contains all the functions to convert a video file #
# into an MPEG2-PS DVD-compliant file                           #
#################################################################

import time
import select
import signal
import subprocess
import sys
import os
import re
import locale
import gettext
import shutil
import glob
import posixpath
if sys.platform=='win32':
	import win32_helper
	import win32api
	import win32con
	import win32process
	import thread


from devede_other import *
from devede_gtk_helper import *

locale.setlocale(locale.LC_ALL,"")
gettext.textdomain('devede')
_ = gettext.gettext


def return_time(seconds,empty):

	""" cuts a time in seconds into seconds, minutes and hours """

	seconds2=int(seconds)

	hours=str(seconds2/3600)
	if empty:
		if len(hours)==1:
			hours="0"+hours
	else:
		if hours=="0":
			hours=""
	if hours!="":
		hours+=":"
	
	minutes=str((seconds2/60)%60)
	if empty or (hours!=""):
		if len(minutes)==1:
			minutes="0"+minutes
	elif (minutes=="0") and (hours==""):
			minutes=""
	if minutes!="":
		minutes+=":"

	secs=str(seconds2%60)
	if (len(secs)==1) and (minutes!=""):
		secs="0"+secs

	return hours+minutes+secs


def erase_all_files(filefolder,filename,global_vars):

	""" Erases the files that have the same global name than the selected, to
	avoid collissions when doing the soft links or other problems """
	
	newfilename=addbarr(filefolder+filename)

	print "filename: ", filename
	newfilename=addbarr(filefolder+filename)
	print "newfilename: ", newfilename
	
	try:
		os.remove(newfilename+".xml")
	except OSError:
		print newfilename.strip(),".xml not found"

	try:
		os.remove(newfilename+"_sub.xml")
	except OSError:
		print newfilename.strip()+"_sub.xml not found"

	if (global_vars["disctocreate"]=="dvd") or (global_vars["disctocreate"]=="divx"):
		try:
			os.remove(newfilename.strip()+".iso")
		except OSError:
			print newfilename ,  ".iso not found"
	else:
		try:
			os.remove(newfilename+".bin")
		except OSError:
			print newfilename ,  ".bin not found"
		try:
			os.remove(newfilename+".cue")
		except OSError:
			print newfilename ,  ".cue not found"
	
	try:
		z=glob.glob(newfilename+"_[0-9][0-9]_[0-9][0-9]"+".mpg")
		for x in z:
			try:
				os.remove(x)
			except OSError:
				print str(x)+" not found to remove"
		#os.remove(newfilename+"_??_??.mpg") # ??_?? is bash regex, seems to also work with os.remove
	except OSError:
		print newfilename ,  "._??_?? not found"

	try:
		os.remove(newfilename)
	except OSError:
		print newfilename ,  " not found"



def create_filename(filename,title,file):

	currentfile=filename+"_"
	if title<10:
		currentfile+="0"
	currentfile+=str(title)+"_"
	if file<10:
		currentfile+="0"
	currentfile+=str(file)+'.mpg'
	return currentfile

#TODO
def add_subtitle(arbol,global_vars,afile,filefolder,filename,cfiles,titles,files,total,erase_temporary_files):

	""" Adds the subtitles to a movie """
	
	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")
	label.set_text(_("Adding subtitles to")+"\n"+afile["filename"])
	
	percent1=((100*(cfiles+.5))/total)
	ptotal.set_fraction(percent1/100)
	ptotal.set_text(str(int(percent1))+"%")
	ppartial.pulse()
	refresh_screen()
	refresh_screen()
	currentfile=create_filename(filefolder+filename,titles,files)
	global_vars["cancel_prog"]=False
		
	#first delete the file with the same name (just in case...)
		
	newfilename=addbarr(currentfile)
	
	# generate the XML file

	try:
		fichero=open(filefolder+filename+"_sub.xml","w")
		fichero.write('<subpictures>\n\t<stream>')
		fichero.write('\n\t\t<textsub filename="'+afile["subtitles"]+'"')
		fichero.write('\n\t\tfont="devedesans.ttf"')
		if ((afile["sub_codepage"]!="") and (afile["sub_codepage"]!="ASCII")):
			fichero.write('\n\t\tcharacterset="'+afile["sub_codepage"]+'"')
		fichero.write('\n\t\thorizontal-alignment="center"')

		if (afile["fps"]==25):
			ancho=716
			alto=572
			tamanofont=27
		else:
			ancho=716
			alto=476
			tamanofont=27

		margin_hor=int((58*ancho)/720)
		margin_vert=int((28*alto)/576)
		bottom_margin=margin_vert

		fichero.write('\n\t\tmovie-width="'+str(ancho-4)+'"')
		fichero.write('\n\t\tmovie-height="'+str(alto-4)+'"')
		fichero.write('\n\t\tleft-margin="'+str(margin_hor)+'"')
		fichero.write('\n\t\tright-margin="'+str(margin_hor)+'"')

		if afile["subtitles_up"]:
			tamanofont-=1
			bottom_margin=4+(alto/8) # put it in the border of 16:9 aspect ratio

		fichero.write('\n\t\tbottom-margin="'+str(bottom_margin)+'"')
		fichero.write('\n\t\ttop-margin="'+str(margin_vert)+'"')

		fichero.write('\n\t\tfontsize="'+str(tamanofont)+'.0"')

		if (afile["fps"]==30):
			if (afile["ofps"]==24) and ((global_vars["disctocreate"]=="dvd") or (global_vars["disctocreate"]=="divx")):
				fps_out="24000/1001"
			else:
				fps_out="30000/1001"
		else:
			fps_out="25"

		fichero.write('\n\t\tmovie-fps="'+str(fps_out)+'"')
		fichero.write('\n\t\tsubtitle-fps="'+str(fps_out)+'"')
		fichero.write('\n\t\tvertical-alignment="bottom" />')
		fichero.write("\n\t</stream>\n</subpictures>")
		fichero.close()
	except IOError:
		wprogress=arbol.get_widget("wprogress")
		wprogress.hide()
		show_error2(_("Failed to write to the destination directory.\nCheck that you have privileges and free space there."),arbol)
		return True
	comando=""
	if sys.platform=='win32':
		comando="spumux.exe -m "
	else:
		comando="spumux -m "
	if global_vars["disctocreate"]=="vcd":
		comando+="svcd"
	else:
		comando+=global_vars["disctocreate"]
		
	comando+=" "+filefolder+filename+"_sub.xml < "+currentfile+" > "+currentfile+".sub"
	print "Launch: "+comando

	handle=subprocess.Popen(comando,shell=True,bufsize=32767, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
		
	while (None==handle.poll()):
		if sys.platform=='win32':
			try:
				v1=win32_helper.recv_some(handler)
			except Exception:
				break
		else:
			v1,v2,v3=select.select([handle.stderr,handle.stdout],[],[],0)

		for elem in v1:
			temporal=elem.readline(80)
			print temporal,
			ppartial.pulse()
			position=temporal.find("STAT: ")
			if (position!=-1):
				position2=temporal.find(".",position+6)
				if position2!=-1:
					ppartial.set_text(temporal[position:position2])	
		refresh_screen()

		if global_vars["cancel_prog"]:
			if sys.platform=='win32':
				try:
					win32api.TerminateProcess(int(handle._handle), -1)
				except Exception , err:
					print "Error: ", err
			else:
				handle2=subprocess.Popen("pkill -P "+str(handle.pid),bufsize=8192,shell=True)
			break

	
	error_ret=handle.wait()
	
	if global_vars["cancel_prog"]:
		wprogress=arbol.get_widget("wprogress")
		wprogress.hide()
		w=arbol.get_widget("w_aborted")
		w.show()
		return True
	
	if error_ret!=0:
		wprogress=arbol.get_widget("wprogress")
		wprogress.hide()
		show_error2(_("Conversion failed.\nIt seems a bug of SPUMUX."),arbol)
		return True
	
	#TODO
	if erase_temporary_files:
		try:
			os.remove(filefolder+filename+"_sub.xml")
		except OSError:
			print "Error removing ", filefolder+filename+"_sub.xml"
	
	shutil.move(currentfile+".sub", currentfile)
	#comando="mv "+currentfile+".sub "+currentfile
	#print "Launch: "+comando
	#handle=subprocess.Popen(comando,bufsize=8192,shell=True)
	#handle.wait()
	#comando="rm "+filefolder+filename+"_sub.xml"
	#print "Launch: "+comando
	#handle=subprocess.Popen(comando,bufsize=8192,shell=True)
	#handle.wait()
	return False

def convert_file(arbol,global_vars,afile,filefolder,filename,cfiles,titles,files,total,erase_temporary_files,seconds=0):

	""" Converts a video file to an MPEG1-PS or MPEG2-PS file, compliant with DVD players.
	TITLES is the current title number; FILES is the current file number into that tile;
	CFILES is the current file in total, and TOTAL is the number of steps needed to do
	the job """

	print "\nafile is: ", afile , "\n" 
	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")

	if afile["subtitles"]=="":
		has_subtitles=False
	else:
		has_subtitles=True

	if afile["ismpeg"]: # if the file hasn't to be converted, we simply copy it
		if seconds==0:
			texto=_("Copying the file")+"\n"
			ptotal.show()
		else:
			texto=_("Creating preview")+"\n"
			ptotal.hide()
		label.set_text(texto+afile["filename"])
		percent1=((100*cfiles)/total)
		ptotal.set_fraction(percent1/100)
		ptotal.set_text(str(int(percent1))+"%")
		ppartial.set_fraction(0)
		ppartial.set_text("0%")
		refresh_screen()
		refresh_screen()
		currentfile=create_filename(filefolder+filename,titles,files)
		global_vars["cancel_prog"]=False
		
		print "\ncurrentfile is: ", currentfile , "\n" 
		#first delete the file with the same name (just in case...)
		
		newfilename=addbarr(currentfile)
		
		try:
			os.remove(newfilename)
		except OSError:
			print "Error removing ", newfilename

		#TODO
		handle=''
		if sys.platform=='win32':
			#shutil.copyfile(afile["path"],"\""+currentfile+"\"")
			handle=subprocess.Popen("copy \""+afile["path"] +"\" \""+ currentfile+"\"", shell=True)
		else:
			if afile["subtitles"]=="":
				handle=subprocess.Popen("ln -s \""+afile["path"]+"\" \""+currentfile+"\"",bufsize=8192,shell=True)
			else:
				handle=subprocess.Popen("cp \""+afile["path"]+"\" \""+currentfile+"\"",bufsize=8192,shell=True)

		ppartial.set_text("")
		while (None==handle.poll()):
			refresh_screen()
			time.sleep(1)
			ppartial.pulse()
			if global_vars["cancel_prog"]:
				if sys.platform=='win32':
					try:
						win32api.TerminateProcess(int(handle._handle), -1)
					except Exception , err:
						print "Error: ", err
				else:
					os.kill(handle.pid,signal.SIGKILL)
				break
		
		handle.wait()
		retorno=handle.returncode
		if global_vars["cancel_prog"]:
			wprogress=arbol.get_widget("wprogress")
			wprogress.hide()
			w=arbol.get_widget("w_aborted")
			w.show()
			return True

		if retorno!=0:
			wprogress=arbol.get_widget("wprogress")
			wprogress.hide()
			show_error2(_("File copy failed\nMaybe you ran out of disk space?"),arbol)
			return True

		if afile["subtitles"]!="":
			return add_subtitle(arbol,global_vars,afile,filefolder,filename,cfiles,titles,files,total,erase_temporary_files)
		return False

	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")

	if global_vars["cancel_prog"]:
		wprogress=arbol.get_widget("wprogress")
		wprogress.hide()
		w=arbol.get_widget("w_aborted")
		w.show()
		return True
	
	addbars=False
	framerate=int(afile["ofps"])
	videorate=int(afile["vrate"])
	audiorate=int(afile["arate"])
	audio_final_rate=int(afile["arateunc"])
	audiodelay=float(afile["adelay"])
	final_framerate=float(afile["fps"])
	aspect_ratio_original=afile["oaspect"]
	aspect_ratio_final=afile["aspect"]
	
	if aspect_ratio_original<1.3:
		aspect_ratio_original=float(afile["owidth"])/(float(afile["oheight"]))
	if aspect_ratio_original<1.33333333:
		aspect_ratio_original=1.33333333
	
	max_videorate=int(videorate*1.5)
	
	if global_vars["disctocreate"]=="vcd":
		max_videorate=1152
	elif (global_vars["disctocreate"]=="svcd") or (global_vars["disctocreate"]=="cvd"):
		if max_videorate>2375:
			max_videorate=2375
	elif (global_vars["disctocreate"]=="dvd") or (global_vars["disctocreate"]=="divx"):
		if max_videorate>8500:
			max_videorate=8500
	else:
		print ("Error, disc format is not DVD, DIVX, VCD, SVCD or CVD. Contact with the author")
		print global_vars["disctocreate"]
		sys.exit(1)

	resx_final=afile["width"]
	resy_final=afile["height"]
	resx_original=afile["owidth"]
	resy_original=afile["oheight"]
	
	if afile["blackbars"]==0: # check if has to add black bars
		addbars=True
		if (resx_original%2)==1:
			resx_original+=1
		if (resy_original%2)==1:
			resy_original+=1
		resx_inter=resx_original
		resy_inter=int((resy_original*aspect_ratio_original)/aspect_ratio_final)
		if (resy_inter%2)==1:
			resy_inter+=1
		if ((resy_inter<resy_original) or (resy_original+5>resy_inter)):
			addbars=False # due to a bug in MENCODER, we put bars only up and down, never left and right
		# and we don't scale it if we have to add only 4 or less lines, because is too much work for little profit
	
	if addbars==False:
		resx_inter=resx_original
		resy_inter=resy_original
	else:
		addx=0
		addy=int((resy_inter-resy_original)/2)

	# TODO
	command_var=[]
	if not sys.platform=='win32':
		command_var=["mencoder"]
	else:
		command_var=["mencoder.exe"]

	if (global_vars["disctocreate"]=="dvd") or (global_vars["disctocreate"]=="divx"):
		audio_desired_final_rate=48000
	else:
		audio_desired_final_rate=44100

	if audio_final_rate!=audio_desired_final_rate:
		command_var.append("-srate")
		command_var.append(str(audio_desired_final_rate))
		command_var.append("-af")
		command_var.append("lavcresample="+str(audio_desired_final_rate))

	command_var.append("-oac")
	if (global_vars["disctocreate"]=="divx"):
		command_var.append("mp3lame")
	else:
		command_var.append("lavc")
	command_var.append("-ovc")
	command_var.append("lavc")
	if (global_vars["disctocreate"]!="divx"):
		command_var.append("-of")
		command_var.append("mpeg")
		command_var.append("-mpegopts")
		if global_vars["disctocreate"]=="dvd":
			command_var.append("format=dvd:tsaf")
		elif global_vars["disctocreate"]=="vcd":
			command_var.append("format=xvcd")
		elif (global_vars["disctocreate"]=="svcd") or (global_vars["disctocreate"]=="cvd"):
			command_var.append("format=xsvcd")
		else:
			print "Error, disc format incorrect. Talk with the creator."
			sys.exit(1)
	
	halffile=False
	if seconds!=0:
		command_var.append("-endpos")
		command_var.append(str(seconds))
	else:
		if afile["cutting"]==1: # first half only
			command_var.append("-endpos")
			command_var.append(str(afile["olength"]/2))
			halffile=True
		elif afile["cutting"]==2: # second half only
			command_var.append("-ss")
			command_var.append(str((afile["olength"]/2)-5)) # start 5 seconds before
			halffile=True

	if audiodelay!=0.0:
		command_var.append("-delay")
		command_var.append(str(audiodelay))

	if final_framerate==30:
		if (framerate==24) and ((global_vars["disctocreate"]=="dvd") or (global_vars["disctocreate"]=="divx")):
			str_final_framerate="24000/1001"
		else:
			str_final_framerate="30000/1001"
		keyintv=18
	else:
		str_final_framerate=str(int(final_framerate))
		keyintv=15
	
	command_var.append("-ofps")
	command_var.append(str_final_framerate)

	if global_vars["disctocreate"]=="divx":
		command_var.append("-ffourcc")
		command_var.append("DX50")
	
	command_var.append("-vf")
	lineatemp=""
	
	acoma=False;
	
	if afile["deinterlace"]!="none":
		lineatemp+="pp="+afile["deinterlace"]
		acoma=True

	if addbars and ((resx_inter!=resx_original) or (resy_inter!=resy_original)):
		if acoma:
			lineatemp+=","
		lineatemp+="expand="+str(resx_inter)+":"+str(resy_inter)+":"+str(addx)+":"+str(addy)
		acoma=True

	if (resx_inter!=resx_final) or (resy_inter!=resy_final):
		if acoma:
			lineatemp+=","
		lineatemp+="scale="+str(resx_final)+":"+str(resy_final)
		acoma=True
	if global_vars["disctocreate"]!="divx":
		if acoma:
			lineatemp+=","
		lineatemp+="harddup"
	command_var.append(lineatemp)
	command_var.append("-lavcopts")
	
	lavcopts="vcodec="
	if global_vars["disctocreate"]=="vcd":
		lavcopts+="mpeg1video"
	elif global_vars["disctocreate"]=="divx":
		lavcopts+="mpeg4"
	else:
		lavcopts+="mpeg2video"
	
	if afile["trellis"]:
		lavcopts+=":trell"
	
	if afile["mbd"]==0:
		lavcopts+=":mbd=0"	
	elif afile["mbd"]==1:
		lavcopts+=":mbd=1"
	elif afile["mbd"]==2:
		lavcopts+=":mbd=2"


	if global_vars["disctocreate"]!="divx":
		lavcopts+=":vstrict=0:vrc_maxrate="+str(max_videorate)
		lavcopts+=":vrc_buf_size="
		if (global_vars["disctocreate"]=="divx"):
			lavcopts+="1835"
		elif (global_vars["disctocreate"]=="vcd"):
			lavcopts+="327:vrc_minrate=1152"
		elif (global_vars["disctocreate"]=="svcd") or (global_vars["disctocreate"]=="cvd"):
			lavcopts+="917:vrc_minrate=600"
		elif (global_vars["disctocreate"]=="dvd"):
			lavcopts+="1835"
	
	lavcopts+=":vbitrate="+str(videorate)
	
	if global_vars["disctocreate"]!="divx":
		lavcopts+=":keyint="+str(keyintv)+":acodec=mp2"
		lavcopts+=":abitrate="+str(audiorate)
	if aspect_ratio_final>1.4:
		lavcopts+=":aspect=16/9"
	else:
		lavcopts+=":aspect=4/3"

	command_var.append(lavcopts)
	
	if global_vars["disctocreate"]=="divx":
		lameopts="abr:br="+str(audiorate)
		command_var.append("-lameopts")
		command_var.append(lameopts)
	
	currentfile=create_filename(filefolder+filename,titles,files)	
	command_var.append("-o")
	command_var.append(currentfile)
	command_var.append(afile["path"])
	
	extra_params=afile["params"] # take the extra params
	while (extra_params!=""):
		extra_params,new_param=get_new_param(extra_params)
		if new_param!="":
			command_var.append(new_param)
	
	percent2=120
	refresh=False
	
	busqueda=re.compile("Pos:[0-9 ]*\.[0-9]s")
	if seconds==0:
		divide=float(afile["olength"])
		ptotal.show()
	else:
		divide=float(seconds)
		ptotal.hide()
	if divide==0:
		divide=1
	
	espera=False
	salta=False
	handler=launch_program(command_var)
	#abc='"C:\Documents and Settings\Peter Gill\My Documents\devede26-dev\mencoder.exe" -oac lavc -ovc lavc -of mpeg -mpegopts format=dvd -ofps 30000/1001 -vf scale=720:480,harddup -lavcopts vcodec=mpeg2video:trell:mbd=0:vrc_maxrate=7501:vrc_buf_size=1835:vbitrate=5001:keyint=18:acodec=ac3:abitrate=224:aspect=4/3 -o "C:\Documents and Settings\Peter Gill\Desktop\movie_01_01.mpg" "C:\Documents and Settings\Peter Gill\Desktop\downloads\The_Simpsons_S18E05_PDTV_XviD-LOL.avi"'
	#handler=win32subprocess.Popen(abc, stdin=subprocess.PIPE, stdout=subprocess.PIPE)

	linea="\n"
	first_time=time.time()
	#if sys.platform=='win32':
	#	v1=win32subprocess.recv_some(handler)

	v1=""
	while (handler.poll()==None):
		#if handler.poll() != None:
		#	break
		
		#v1,v2,v3=select.select([handler.stderr,handler.stdout],[],[],0)
		if sys.platform=='win32':
			try:
				v1=win32_helper.recv_some(handler)
			except Exception:
				break
		else:
			v1,v2,v3=select.select([handler.stderr,handler.stdout],[],[],0)

		if (len(v1)==0):
			if espera:
				refresh_screen()
				time.sleep(.1)
				salta=False
				first_time=time.time()
			continue
		else:
			new_time=time.time()
			if (new_time>(2.0+first_time)): # ensure a screen refresh each two seconds at least
				refresh_screen()
				refresh_screen()
				first_time=new_time
		for elem in v1:
			if elem==handler.stderr:
				linea=handler.stderr.readline(80)
			else:
				refresh=False
				linea=handler.stdout.readline(2400)
				if global_vars["cancel_prog"]:
					break
				if linea=="":
					continue
				if linea[-1]=="\n":
					break
				if salta:
					break
				salta=True
				pos=linea.find("Pos:")
				if pos==-1:
					break
				espera=True
				while(pos+10)>len(linea):
					linea+=handler.stdout.read(2)
				elemento=busqueda.findall(linea)
				if len(elemento)==0:
					break
				valuetemp=float(elemento[0][4:-1])
				if (halffile):
					valuetemp*=2
				value=(100*valuetemp)/divide
				if (value!=percent2) or (percent2==120):
					percent1=((100*cfiles)/total)
					if has_subtitles:
						percent1+=(value/(total*2))
					else:
						percent1+=(value/total)
					ptotal.set_fraction(percent1/100)
					ptotal.set_text(str(int(percent1))+"%")
					if seconds==0:
						texto=_("Converting files from title")
						label.set_text(texto+str(titles)+"\n"+afile["filename"])
					else:
						texto=_("Creating preview")+"\n"
						label.set_text(texto+afile["filename"])
					if (value)>100:
						value=100
					ppartial.set_fraction(value/100)
					percent2=value
					ppartial.set_text(str(int(percent2))+"%")
					refresh=True
		if global_vars["cancel_prog"]:
			break
		if linea[-1]=="\n":
			continue

	if global_vars["cancel_prog"]:
		if sys.platform=='win32':
			try:
				win32api.TerminateProcess(int(handler._handle), -1)
			except Exception , err:
				print "Error: ", err
		else:
			os.kill(handler.pid,signal.SIGKILL)

	print "outside convert loop just before handler.wait()"
	handler.wait()
	print "after handler.wait()\n"
	retcode=handler.returncode
	print "after retcode=handler.returncode\n"

	if (retcode!=0) or global_vars["cancel_prog"]:
	
		print "Deleting "+currentfile+" due to error or aborting."
		try:
			os.remove(currentfile)
		except OSError:
			print currentfile+" didn't exists"
		if global_vars["cancel_prog"]:
			wprogress=arbol.get_widget("wprogress")
			wprogress.hide()
			w=arbol.get_widget("w_aborted")
			w.show()
			return True
		else:
			wprogress=arbol.get_widget("wprogress")
			wprogress.hide()

			if percent2==120: # still hadn't take a value, so it seems it failed (core dump)
				show_error2(_("Conversion failed.\nIt seems a bug of Mencoder."),arbol)
			else:
				show_error2(_("Conversion failed\nMaybe you ran out of disk space?"),arbol)
			return True

	if afile["subtitles"]!="":
		return add_subtitle(arbol,global_vars,afile,filefolder,filename,cfiles,titles,files,total,erase_temporary_files)
	return False


def check_free_space(arbol,filefolder,structure,actions,erase_temporary_files):

	""" Returns TRUE if the free space in FILEFOLDER is insuficient to generate
	the disk STRUCTURE """
	# TODO Windows Stuff
	estado=''
	freespace=''
	if not sys.platform=='win32':
		estado=os.statvfs(filefolder) # eg. f="C:\Documents and Settings\Peter Gill\Desktop"
		freespace=95*estado.f_bsize*estado.f_bavail/100000
	else:
		try:
			spc, bps, fc, tc = win32api.GetDiskFreeSpace(filefolder)
			freespace=fc * spc * bps

		except ImportError:
			pass
	print "Free space in "+str(filefolder)+": "+str(freespace)
	print "estatus ", estado, "\n"
	
	total=calcula_tamano_total(structure)
	

	print "Libre: "+str(freespace)
	print "Necesario: "+str(total)
	
	if (actions!=3):
		total*=actions # if we only create the MPEG files or the DVD structure...
	else:
		if erase_temporary_files: # or if we create the ISO image
			total*=2
		else:
			total*=3
	total*=1.1 # a safe margin of 10%

	if (freespace<total):
		show_error2(_("Insuficient free space. To create this disk\n%(total)d MBytes are needed, but only %(free)d MBytes are available." % {'total':int(total/1000),'free':int(freespace/1000)}),arbol)
		return True
	else:
		return False


def get_filename_with_underscores(arbol):

	""" Gets the general filename and changes the blank spaces with underscores """

	w=arbol.get_widget("iso_name")
	filename2=w.get_text()
	filename=""
	for letra in filename2:
		if letra==" ":
			filename+="_"
		else:
			filename+=letra
	return filename


def get_actions(arbol,global_vars):

	""" Returns the number of actions to do """

	actions=0	
	w=arbol.get_widget("only_convert")
	if w.get_active():
		actions=1
	else:
		w=arbol.get_widget("create_dvd")
		if (w.get_active()) or ((global_vars["disctocreate"]!="dvd") and (global_vars["disctocreate"]!="divx")):
			actions=2
		else:
			actions=3
	return actions


def create_xml(arbol,filefolder,filename,structure):

	""" Creates the XML file for DVDAuthor """

	try:
		fichero=open(filefolder+filename+".xml","w")
		fichero.write('<dvdauthor dest="'+filefolder+filename+'">\n')
		fichero.write("<vmgm> </vmgm>\n<titleset>\n<titles>\n")
		titles=0
		for elemento in structure:
			titles+=1
			fichero.write("<pgc>\n")
			if len(elemento)>1:
				files=0
				for elemento2 in elemento[1:]:
					files+=1
					currentfile=create_filename(filefolder+filename,titles,files)
					fichero.write('<vob file="'+currentfile+'" ')
					fichero.write('chapters="0')
					if (elemento2["olength"]>5):
						if (elemento2["lchapters"]!=0): # add chapters
							toadd=int(elemento2["lchapters"])
							seconds=toadd*60
							while seconds<(elemento2["olength"]-4):
								thetime=return_time(seconds,False)
								fichero.write(","+thetime)
								seconds+=(toadd*60)
						fichero.write(','+return_time((elemento2["olength"]-2),False))
					fichero.write('" />\n')
				fichero.write("</pgc>\n")
		fichero.write("</titles>\n</titleset>\n</dvdauthor>")
		fichero.close()
		return False
	except IOError:
		wprogress=arbol.get_widget("wprogress")
		wprogress.hide()
		show_error2(_("Failed to write to the destination directory.\nCheck that you have privileges and free space there."),arbol)
		return True


def create_dvd_structure(arbol,global_vars,filefolder,filename,total,erase_temporary_files):

	""" Uses DVDAuthor to create the DVD structure in disk """
	
	global_vars["cancel_prog"]=False
	
	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")
	wprogress=arbol.get_widget("wprogress")

	label.set_text(_("Creating DVD tree structure"))
	total2=0
	total_films=total-1
	percent1=float((100*(total-2))/total)
	ptotal.set_fraction(percent1/100)
	ptotal.set_text(str(int(percent1))+"%")
	ppartial.set_text("")

	command=""
	if sys.platform=='win32':
		command="dvdauthor.exe"
	else:
		command="dvdauthor"

	handler=launch_program([command,"-x",filefolder+filename+".xml"])

	refresh_screen()
	temporal=""
	#if sys.platform=='win32':
	#	v1=win32subprocess.recv_some(handler)
	
	v1=""
	contador=0
	chars_to_read=80
	while (handler.poll()==None):
		if sys.platform=='win32':
			try:
				v1=win32_helper.recv_some(handler)
			except Exception:
				break
		else:
			v1,v2,v3=select.select([handler.stderr,handler.stdout],[],[],0)

		if len(v1)!=0:
			for elem in v1:
				temporal=elem.readline(chars_to_read)
				print temporal,
				ppartial.pulse()
				if temporal=="":
					continue
				if temporal.find("INFO: Video")!=-1:
					total2+=1
					percent2=float((100*total2)/total_films)
					percent1=float((100*(total-2))/total)+(percent2/total)
					ptotal.set_fraction(percent1/100)
					ptotal.set_text(str(int(percent1))+"%")
				else:
					position=temporal.find("STAT: VOBU ")
					if position!=-1:
						ppartial.set_text("VOBU "+temporal[position+11:temporal.find(" ",position+11)])
					else:
						position=temporal.find("STAT: fixing VOBU at ")
						if (position!=-1):
							position2=temporal.find("%",position+21)
							if (position2!=-1):
								cadena=temporal[position2-2:position2]
								ppartial.set_text(cadena+"%")
								ppartial.set_fraction((float(cadena))/100.0)
								chars_to_read=200

			contador+=1
			if contador==50:
				refresh_screen() # if there's always lines, we refresh each 50 lines
		else:
			if chars_to_read==80:
				time.sleep(.2) # as soon as there are no lines, we wait 1/5 of second
			else:
				time.sleep(1) # or one second if we are with percentages
			refresh_screen() # and refresh the screen
		if (global_vars["cancel_prog"]):
			break
	
	cause=0
	if global_vars["cancel_prog"]:
		if sys.platform=='win32':
			try:
				win32api.TerminateProcess(int(handler._handle), -1)
			except Exception , err:
				print "Error: ", err
		else:
			os.kill(handler.pid,signal.SIGKILL)
	handler.wait()
	retcode=handler.returncode
	
	if (retcode!=0) and (retcode!=-9):
		cause=1
		global_vars["cancel_prog"]=True
	
	if global_vars["cancel_prog"]:
		wprogress.hide()
		if cause==0:
			w=arbol.get_widget("w_aborted")
			w.show()
			return True
		if cause==1:
			show_error2(_("Failed to create the DVD tree\nMaybe you ran out of disk space"),arbol)
			return True

	if erase_temporary_files:
		# TODO rm
		print "Deleting temporary files: "+filename+"_??_??.mpg and .xml"
		newfilename=""
		if sys.platform!='win32':
			newfilename=addbarr(filefolder+filename)
		else:
			newfilename=filefolder+filename

		#b=re.compile(filename+"_[0-9][0-9]_[0-9][0-9]")
		#d=os.listdir(filefolder)
		print "Newfilename: " + newfilename
		for thefile in glob.glob(newfilename+"_[0-9][0-9]_[0-9][0-9]"+".mpg"):
			print "removing file: " , thefile
			try:
				os.remove(thefile)
			except OSError:
				print str(thefile)+" not removed because it doesn't exists"

		try:
			print newfilename+".xml"
			os.remove(newfilename+".xml")
		except OSError:
			print newfilename+".xml not found.  Cannot delete"
	
	return False


def create_vcd_structure(arbol,structure,global_vars,filefolder,filename,erase_temporary_files):

	""" Uses VCDImager to create the ISO file """

	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")
	wprogress=arbol.get_widget("wprogress")
	
	print "Convirtiendo xCD"
	label.set_text(_("Creating BIN/CUE files"))
	
	cantidad=len(structure[0])-1
	if sys.platform!='win32':
		lista=["vcdimager","-c",filefolder+filename+".cue","-b",filefolder+filename+".bin","-t"]
	else:
		lista=["vcdimager.exe","-c",filefolder+filename+".cue","-b",filefolder+filename+".bin","-t"]

	if global_vars["disctocreate"]=="vcd":
		lista.append("vcd2")
	else:
		lista.append("svcd")
	
	for variable in range(cantidad):
		currentfile=create_filename(filefolder+filename,1,variable+1)
		lista.append(currentfile)
	
	ppartial.set_fraction(0)
	cantidad2=float(cantidad)
	fraccion=cantidad2/(cantidad2+1)
	ptotal.set_fraction(fraccion)
	ptotal.set_text(str(int(fraccion*100))+"%")
	
	cause=0
	global_vars["cancel_prog"]=False
	refresh_screen()

	handler=launch_program(lista,False)
	while (None==handler.poll()):
		refresh_screen()
		time.sleep(1)
		ppartial.pulse()
		if global_vars["cancel_prog"]:
			if sys.platform=='win32':
				try:
					win32api.TerminateProcess(int(handler._handle), -1)
				except Exception , err:
					print "Error: ", err
			else:
				os.kill(handler.pid,signal.SIGKILL)
			break
	
	handler.wait()
	retcode=handler.returncode
	print "Retorno: "+str(retcode)
	
	if (retcode!=0) and (retcode!=-9):
		cause=1
		global_vars["cancel_prog"]=True

	if global_vars["cancel_prog"]:
		wprogress.hide()
		if cause==0:
			w=arbol.get_widget("w_aborted")
			w.show()
			return True
		if cause==1:
			show_error2(_("Failed to create the BIN/CUE files\nMaybe you ran out of disk space"),arbol)
			return True
	
	if erase_temporary_files:
		print "Deleting temporary files: "+filename+"_01_??.mpg and .xml"
		newfilename=""
		if sys.platform=='win32':
			newfilename=filefolder+filename
		else:
			newfilename=addbarr(filefolder+filename)
		# TODO
		for file in glob.glob(newfilename+"_[0-9][0-9]_[0-9][0-9]"+".mpg"):
			print "removing file: " , newfilename
			try: 
				os.remove(file)
			except OSError:
				print "not removed because it doesn't exists"

		#handle=subprocess.Popen("rm "+newfilename+".xml",bufsize=8192,shell=True)
		#handle.wait()
		try:
			os.remove(newfilename+".xml")
		except OSError:
				print "not removed because it doesn't exists"
	
	return False


def create_iso(arbol,global_vars,total,filefolder,filename,erase_temporary_files):

	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")
	wprogress=arbol.get_widget("wprogress")

	label.set_text(_("Creating ISO file"))
	percent1=float((100*(total-1))/total)
	ptotal.set_fraction(percent1/100)
	ptotal.set_text(str(int(percent1))+"%")
	ppartial.set_fraction(0)
	ppartial.set_text("0%")
	
	command=""

	if sys.platform=='win32':
		command="mkisofs.exe"
	else:
		command="mkisofs"

	volume="DVD-VIDEO"
	handler=launch_program([command,"-dvd-video","-V",volume,"-v","-o",filefolder+filename+".iso",filefolder+filename])
	refresh_screen()
	temporal=''

	v1=""
	while (handler.poll()==None):
		if sys.platform=='win32':
			try:
				v1=win32_helper.recv_some(handler)
			except Exception:
				break
		else:
			v1,v2,v3=select.select([handler.stderr,handler.stdout],[],[],0)

		for elem in v1:
			temporal=elem.readline(80)
			if temporal=="":
				continue
			punto=temporal.find("done, estimate")
			if (punto!=-1):
				if ((temporal[2].isdigit()) and ((temporal[1].isdigit()) or (temporal[1]==" "))):
					percent2=float(temporal[1:3])
					percent1=float(((100*(total-1))/total)+(percent2/total))
					ptotal.set_fraction(percent1/100)
					ptotal.set_text(str(int(percent1))+"%")
					ppartial.set_fraction(percent2/100)
					ppartial.set_text(str(int(percent2))+"%")

		refresh_screen()
		if (global_vars["cancel_prog"]):
			break
	cause=0
	
	if global_vars["cancel_prog"]:
		if sys.platform=='win32':
			try:
				win32api.TerminateProcess(int(handler._handle), -1)
			except Exception , err:
				print "Error: ", err
		else:
			os.kill(handler.pid,signal.SIGKILL)
	
	handler.wait()
	retcode=handler.returncode
	if retcode!=0:
		cause=1
		global_vars["cancel_prog"]=True

	if global_vars["cancel_prog"]:
		wprogress.hide()
		if cause==0:
			w=arbol.get_widget("w_aborted")
			w.show()
			return True
		if cause==1:
			show_error2(_("Failed to create the ISO image\nMaybe you ran out of disk space"),arbol)
			return True

	if erase_temporary_files:
		print "erasing DVD tree folder"
		# TODO
		#handle=subprocess.Popen("rm -rf \""+filefolder+filename+"\"",bufsize=8192,shell=True)
		#handle.wait()
		shutil.rmtree(filefolder+filename)
		
	return False


def create_dvd3(args,arbol,structure,global_vars):

	""" Takes the CD/DVD structure, converts the files, creates the filesystem
	and puts all into an ISO image if needed """

	wmain=arbol.get_widget("wmain")
	wmain.hide()
	wprogress=arbol.get_widget("wprogress")
	tiempo=time.time()
	
	w=arbol.get_widget("erase_files")
	erase_temporary_files=w.get_active()
	
	w=arbol.get_widget("wfolder")
	w.hide()
	w=arbol.get_widget("directorio_final")
	filefolder=w.get_filename()
	actions=get_actions(arbol,global_vars)
	
	# check if there's suficient free space in the final directory

	if check_free_space(arbol,filefolder,structure,actions,erase_temporary_files):
		return
	# remove the blank spaces in the generic name, changing them with underscores

	filename=get_filename_with_underscores(arbol)
	if filefolder[-1]!=os.sep:
		filefolder+=os.sep
	global_vars["cancel_prog"]=False

	erase_all_files(filefolder,filename,global_vars)

	# less priority to allow to use the computer without speed penalty while compressing
	if sys.platform=='win32':
		handle = win32api.OpenProcess(win32con.PROCESS_ALL_ACCESS, True, win32api.GetCurrentProcessId())
		win32process.SetPriorityClass(handle, win32process.BELOW_NORMAL_PRIORITY_CLASS)
	else:
		os.nice(1)
	# show the progress window, but clear it before

	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")
	ptotal.set_fraction(0)
	ptotal.set_text("0%")
	ppartial.set_fraction(0)
	ppartial.set_text("0%")
	label.set_text("")

	wprogress.show()
	refresh_screen()
	refresh_screen()

	# calculate the number of operations to do

	total=0
	for elemento in structure:
		total+=((len(elemento))-1)
	total+=(actions-1)

	# create the XML file (even with VCD, SVCD or CVD, to check if we have write permissions)

	if create_xml(arbol,filefolder,filename,structure):
		return
	print "filefolder 4:", filefolder
	resx_inter=0
	resy_inter=0
	addx=0
	addy=0
	titles=0
	cfiles=0.0
	percent1=0
	counter=0
	cause=0
	
	# convert to MPEG1-PS or MPEG2-PS each file
	print "structure: ", structure
	for title in structure:
		if global_vars["cancel_prog"]:
			break
		titles+=1
		if len(title)>1:
			files=0
			for afile in title[1:]:
				files+=1
				if False==convert_file(arbol,global_vars,afile,filefolder,filename,cfiles,titles,files,total,erase_temporary_files):
					cfiles+=1.0
				else:
					break

	# if the conversion fails, check why and show the message

	if global_vars["cancel_prog"]:
		return

	# if user is creating a DVD and wanted to do the DVD structure:

	if (actions>1) and (global_vars["disctocreate"]=="dvd"):
		if create_dvd_structure(arbol,global_vars,filefolder,filename,total,erase_temporary_files):
			return # if returns True, there was an error
	
	
	# but if user is creating a VCD, SVCD or CVD and wants to create the BIN/CUE files
	
	if (actions>1) and (global_vars["disctocreate"]!="dvd"):
		if create_vcd_structure(arbol,structure,global_vars,filefolder,filename,erase_temporary_files):
			return # if returns True, there was an error

	# and now, we create the ISO file if the user wanted to create a DVD

	if actions>2:
		if create_iso(arbol,global_vars,total,filefolder,filename,erase_temporary_files):
			return

	wprogress.hide()
	tiempo2=return_time(time.time()-tiempo,True)
	print (tiempo2)
	w=arbol.get_widget("elapsed")
	w.set_text((_("Elapsed time: "))+tiempo2)
	w=arbol.get_widget("w_end")
	w.show()
