#!/bin/bash
#
# 	multistation-audio-hotplug.sh
#
# 	Author:
# 		Jason Kim <jason@userful.com>
#
# 	Copyright (c) 2002-2007 by Userful Corporation
#
# 	Description:
# 		  This scipt is run as a HAL fdi callout function when a audio device is added/removed and should be
# 		located at /usr/lib/hal/scripts directory.
#
# 	Called from: 99-userful-policy.fdi

logfile="/var/log/userful-start.log"
CONFIG_FILE="/etc/usbaudio"
ProgramName=`basename $0`

if [ ! -e /var/run/x.pid -o ! -d /proc/`cat /var/run/x.pid` ]; then
	# If MX is not running, just exit.
	exit 1
fi

if [ "$HALD_ACTION" == "remove" ] ; then
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) $HAL_PROP_ALSA_DEVICE_FILE removed. hw:$HAL_PROP_ALSA_CARD" >> $logfile

	if [ -f $CONFIG_FILE ]; then
		#Remove device from usbaudio. add a new line if the removed device was configured manually.
		cp -f $CONFIG_FILE $CONFIG_FILE.old

		ALSA_DEV="hw:$HAL_PROP_ALSA_CARD"
		sed -i -e "/$ALSA_DEV/d" $CONFIG_FILE

		# Save the current device's configuration if it was manually configured.
		PRE_ASSIGNED_FLAG=`grep "$ALSA_DEV" $CONFIG_FILE.old | awk '{print $4}'`
		if [ "$PRE_ASSIGNED_FLAG" == "W" ]; then
			echo "`date +"%b %d %T"` $ProgramName: $ALSA_DEV has been manually configured." >> $logfile
    		grep "$ALSA_DEV" $CONFIG_FILE.old | awk '{print "N/A","N/A",$3,$4,$5}' >> $CONFIG_FILE
		fi

	else
		# Create /etc/usbaudio file
		/opt/userful/bin/multistation-audio-refresh.sh
	fi

elif [ "$HALD_ACTION" == "add" ] ; then
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) $HAL_PROP_ALSA_DEVICE_FILE added. hw:$HAL_PROP_ALSA_CARD" >> $logfile

	ALSA_CARD="$HAL_PROP_ALSA_CARD"

	# Find device vendor name
	PARENT_UDI="$HAL_PROP_INFO_PARENT"
	PARENT_SUBSYSTEM=`hal-get-property --udi "$PARENT_UDI" --key "linux.subsystem"`

	if [ "$PARENT_SUBSYSTEM" == "usb" ]; then
		# USB audio device
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "usb.vendor"`

	elif [ "$PARENT_SUBSYSTEM" == "pci" ]; then
		# PCI audio device
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "pci.vendor"`

	else
		# Unknown type audio device
		DEV_VENDOR=`hal-get-property --udi "$PARENT_UDI" --key "info.vendor"`
	fi

	if [ "$DEV_VENDOR" == "" ]; then
		DEV_VENDOR="Unkown"
	else # remove blank
		DEV_VENDOR=`echo $DEV_VENDOR | tr "[[:blank:]]" "_"`
	fi

	# Find device sys path
	DEV_PATH=`hal-get-property --udi "$PARENT_UDI" --key "linux.sysfs_path"`

	PRE_ASSIGNED_SCREEN=
	PRE_ASSIGNED_FLAG=
	if [ -f $CONFIG_FILE ]; then
		PRE_ASSIGNED_SCREEN=`grep $DEV_PATH $CONFIG_FILE | awk '{print $3}'`
		PRE_ASSIGNED_FLAG=`grep $DEV_PATH $CONFIG_FILE | awk '{print $4}'`
	fi

	if [ "$PRE_ASSIGNED_SCREEN" != "" -a "$PRE_ASSIGNED_FLAG" == "W" ] ; then
		# If the current audio device was configured manually before, follow the old configuration.
		echo "`date +"%b %d %T"` $ProgramName: Found $DEV_VENDOR($PARENT_SUBSYSTEM) on $CONFIG_FILE."  >> $logfile
		ASSIGNED_SCREEN="$PRE_ASSIGNED_SCREEN"
		ASSIGNED_FLAG="W"

		if [ "${ASSIGNED_SCREEN:0:4}" == "Srn:" ]; then
			SCREEN_NUM=`echo $ASSIGNED_SCREEN | awk -F':' '{print $2}' | awk -F'.' '{print $1}'`
		else
			SCREEN_NUM="-1"
		fi

	else
		if [ "$PARENT_SUBSYSTEM" == "usb" ]; then
			# Find screen number base on the current audio device path.
			SCREEN_NUM=`/opt/userful/bin/get-screen-num-from-devpath -T 12 -P $DEV_PATH 2>/dev/null`

			if [ "$SCREEN_NUM" == "-1" ]; then
				# Couldn't find screen number for the current audio device
				ASSIGNED_SCREEN="Disabled"
			else
				ASSIGNED_SCREEN="Srn:$SCREEN_NUM.0"
			fi

		else # It may not possible to get hotplug event from other device type than usb.
			ASSIGNED_SCREEN="Disabled"
		fi

		ASSIGNED_FLAG="R/W"
	fi

	if [ "$ASSIGNED_SCREEN" != "Disabled" ]; then
		# Check if there is any audio device already assigned to the same screen.
		# If then, disable the old device.
		if [ -f $CONFIG_FILE ]; then
			CONFLICT=`grep -c $ASSIGNED_SCREEN $CONFIG_FILE`

			if [ $CONFLICT -gt 0 ]; then
				echo "`date +"%b %d %T"` $ProgramName:(Hotplug) Another audio device already assigned to screen $ASSIGNED_SCREEN" >> $logfile
				sed -i -e "s/$ASSIGNED_SCREEN/Disabled/g" $CONFIG_FILE
			fi
		fi

		#Deal with popup message when hotplug USB audio device only when station is log in.
   		if [ -f /etc/stations ] && [ -f /etc/startat ]; then
			STARTAT=`cat /etc/startat`
			REAL_STATION_NUM=`expr $SCREEN_NUM + $STARTAT`

           	if [ -e /opt/userful/locks/username$REAL_STATION_NUM ]; then
           		echo 1 > /opt/userful/locks/audio$REAL_STATION_NUM
			fi
		fi
	fi

	# remove same device entry(s) from /etc/usbaudio
	if [ -f $CONFIG_FILE -a "$DEV_PATH" != "" ]; then
		DEL_STR=`basename $DEV_PATH`
		sed -i -e "/$DEL_STR/d" $CONFIG_FILE
	fi

	# add current device to the config file /etc/usbaudio
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) Assign hw:$ALSA_CARD to $ASSIGNED_SCREEN." >> $logfile
	echo "$DEV_VENDOR($PARENT_SUBSYSTEM) hw:$ALSA_CARD $ASSIGNED_SCREEN $ASSIGNED_FLAG $DEV_PATH" >> $CONFIG_FILE
    chmod 644 $CONFIG_FILE

else
	echo "`date +"%b %d %T"` $ProgramName: Unkown action for the ALSA device $HAL_PROP_ALSA_DEVICE_FILE." >> $logfile

fi
