/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.lib;

import com.vladium.jcd.cls.IAccessFlags;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class Types {
    public static String getClassPackageName(Class c) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        return lastDot >= 0 ? className.substring(0, lastDot) : "";
    }

    public static String accessFlagsToString(int flags, boolean isClass) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        if (isClass) {
            for (int f = 0; f < IAccessFlags.ALL_ACC.length; ++f) {
                int bit = IAccessFlags.ALL_ACC[f];
                if ((flags & bit) == 0) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(" ");
                }
                if (bit == 32) {
                    result.append("super");
                    continue;
                }
                result.append(IAccessFlags.ALL_ACC_NAMES[f]);
            }
        } else {
            for (int f = 0; f < IAccessFlags.ALL_ACC.length; ++f) {
                int bit = IAccessFlags.ALL_ACC[f];
                if ((flags & bit) == 0) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(" ");
                }
                result.append(IAccessFlags.ALL_ACC_NAMES[f]);
            }
        }
        return result.toString();
    }

    public static String javaNameToVMName(String javaName) {
        if (javaName == null) {
            return null;
        }
        return javaName.replace('.', '/');
    }

    public static String vmNameToJavaName(String vmName) {
        if (vmName == null) {
            return null;
        }
        return vmName.replace('/', '.');
    }

    public static String signatureToDescriptor(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("null input: method");
        }
        return Types.signatureToDescriptor(method.getParameterTypes(), method.getReturnType());
    }

    public static String signatureToDescriptor(Class[] parameterTypes, Class returnType) {
        return new signatureCompiler().signatureDescriptor(parameterTypes, returnType);
    }

    public static String typeToDescriptor(Class type) {
        return new signatureCompiler().typeDescriptor(type);
    }

    public static Class descriptorToType(String typedescriptor) throws ClassNotFoundException {
        return new typeDescriptorCompiler().descriptorToClass(typedescriptor);
    }

    public static String descriptorToReturnType(String methoddescriptor) {
        int i1 = methoddescriptor.indexOf(40);
        int i2 = methoddescriptor.lastIndexOf(41);
        if (i1 < 0 || i2 <= 0 || i1 >= i2 || i2 >= methoddescriptor.length() - 1) {
            throw new IllegalArgumentException("malformed method descriptor: [" + methoddescriptor + "]");
        }
        return methoddescriptor.substring(i2 + 1);
    }

    public static String[] descriptorToParameterTypes(String methoddescriptor) {
        try {
            methodDescriptorCompiler compiler = new methodDescriptorCompiler(methoddescriptor);
            compiler.methodDescriptor();
            return compiler.getResult();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error parsing [" + methoddescriptor + "]: " + e.toString());
        }
    }

    public static String signatureToMethodDescriptor(String[] parameterTypeDescriptors, String returnTypeDescriptor) {
        StringBuffer result = new StringBuffer("(");
        for (int p = 0; p < parameterTypeDescriptors.length; ++p) {
            result.append(parameterTypeDescriptors[p]);
        }
        result.append(')');
        result.append(returnTypeDescriptor);
        return result.toString();
    }

    public static String typeDescriptorToUserName(String typedescriptor) {
        return new typeDescriptorCompiler2().descriptorToClass(typedescriptor);
    }

    public static String methodDescriptorToUserName(String methoddescriptor) {
        String[] parameterTypes = Types.descriptorToParameterTypes(methoddescriptor);
        StringBuffer result = new StringBuffer("(");
        for (int p = 0; p < parameterTypes.length; ++p) {
            String typeUserName;
            int lastDot;
            if (p > 0) {
                result.append(", ");
            }
            if ((lastDot = (typeUserName = Types.typeDescriptorToUserName(parameterTypes[p])).lastIndexOf(46)) < 0 || !"java.lang.".equals(typeUserName.substring(0, lastDot + 1))) {
                result.append(typeUserName);
                continue;
            }
            result.append(typeUserName.substring(lastDot + 1));
        }
        result.append(')');
        return result.toString();
    }

    public static String fullMethodDescriptorToUserName(String classJavaName, String methodName, String methoddescriptor) {
        if ("<init>".equals(methodName)) {
            methodName = Types.simpleClassName(classJavaName);
        }
        if ("<clinit>".equals(methodName)) {
            methodName = "<static class initializer>";
        }
        return methodName + ' ' + Types.methodDescriptorToUserName(methoddescriptor);
    }

    public static String fullMethodDescriptorToFullUserName(String classJavaName, String methodName, String methoddescriptor) {
        if ("<init>".equals(methodName)) {
            methodName = Types.simpleClassName(classJavaName);
        }
        if ("<clinit>".equals(methodName)) {
            methodName = "<static class initializer>";
        }
        return classJavaName + '.' + methodName + ' ' + Types.methodDescriptorToUserName(methoddescriptor);
    }

    private static String simpleClassName(String classJavaName) {
        int lastDot = classJavaName.lastIndexOf(46);
        if (lastDot < 0) {
            return classJavaName;
        }
        return classJavaName.substring(lastDot + 1);
    }

    private static class methodDescriptorCompiler {
        final List m_result = new ArrayList();
        private StringBuffer m_token = new StringBuffer();
        private PushbackReader m_in;

        methodDescriptorCompiler(String methoddescriptor) {
            this.m_in = new PushbackReader(new StringReader(methoddescriptor));
        }

        String[] getResult() {
            String[] result = new String[this.m_result.size()];
            this.m_result.toArray(result);
            return result;
        }

        void methodDescriptor() throws IOException {
            char c;
            this.consume('(');
            while ((c = (char)this.m_in.read()) != ')') {
                this.m_in.unread(c);
                this.parameterDescriptor();
            }
            this.returnDescriptor();
        }

        void parameterDescriptor() throws IOException {
            this.fieldType();
            this.newToken();
        }

        void returnDescriptor() throws IOException {
            char c = (char)this.m_in.read();
            switch (c) {
                case 'V': {
                    this.m_token.append(c);
                    break;
                }
                default: {
                    this.m_in.unread(c);
                    this.fieldType();
                }
            }
        }

        void componentType() throws IOException {
            this.fieldType();
        }

        void objectType() throws IOException {
            char c;
            this.consume('L');
            this.m_token.append('L');
            while ((c = (char)this.m_in.read()) != ';') {
                this.m_token.append(c);
            }
            this.m_token.append(';');
        }

        void arrayType() throws IOException {
            this.consume('[');
            this.m_token.append('[');
            this.componentType();
        }

        void fieldType() throws IOException {
            char c = (char)this.m_in.read();
            this.m_in.unread(c);
            switch (c) {
                case 'L': {
                    this.objectType();
                    break;
                }
                case '[': {
                    this.arrayType();
                    break;
                }
                default: {
                    this.baseType();
                }
            }
        }

        void baseType() throws IOException {
            char c = (char)this.m_in.read();
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    this.m_token.append(c);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown base type: " + c);
                }
            }
        }

        private void consume(char expected) throws IOException {
            char c = (char)this.m_in.read();
            if (c != expected) {
                throw new IllegalArgumentException("consumed '" + c + "' while expecting '" + expected + "'");
            }
        }

        private void newToken() {
            this.m_result.add(this.m_token.toString());
            this.m_token.setLength(0);
        }
    }

    private static class typeDescriptorCompiler2 {
        private typeDescriptorCompiler2() {
        }

        String descriptorToClass(String typedescriptor) {
            char first = typedescriptor.charAt(0);
            if (first == '[') {
                return this.arrayOf(typedescriptor.substring(1));
            }
            if (first == 'L') {
                return Types.vmNameToJavaName(typedescriptor.substring(1, typedescriptor.length() - 1));
            }
            return this.primitive(first);
        }

        String arrayOf(String typedescriptor) {
            char first = typedescriptor.charAt(0);
            String component = first == '[' ? this.arrayOf(typedescriptor.substring(1)) : (first == 'L' ? Types.vmNameToJavaName(typedescriptor.substring(1, typedescriptor.length() - 1)) : this.primitive(first));
            String array = component + " []";
            return array;
        }

        String primitive(char c) {
            switch (c) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
            }
            throw new IllegalArgumentException("unknown primitive: " + c);
        }
    }

    private static class typeDescriptorCompiler {
        private typeDescriptorCompiler() {
        }

        Class descriptorToClass(String typedescriptor) throws ClassNotFoundException {
            char first = typedescriptor.charAt(0);
            if (first == '[') {
                return this.arrayOf(typedescriptor.substring(1));
            }
            if (first == 'L') {
                return Class.forName(Types.vmNameToJavaName(typedescriptor.substring(1, typedescriptor.length() - 1)));
            }
            return this.primitive(first);
        }

        Class arrayOf(String typedescriptor) throws ClassNotFoundException {
            char first = typedescriptor.charAt(0);
            Class<Object> component = first == '[' ? this.arrayOf(typedescriptor.substring(1)) : (first == 'L' ? Class.forName(Types.vmNameToJavaName(typedescriptor.substring(1, typedescriptor.length() - 1))) : this.primitive(first));
            Object array = Array.newInstance(component, 0);
            return array.getClass();
        }

        Class primitive(char c) throws ClassNotFoundException {
            if (c == 'B') {
                return Byte.TYPE;
            }
            if (c == 'C') {
                return Character.TYPE;
            }
            if (c == 'D') {
                return Double.TYPE;
            }
            if (c == 'F') {
                return Float.TYPE;
            }
            if (c == 'I') {
                return Integer.TYPE;
            }
            if (c == 'J') {
                return Long.TYPE;
            }
            if (c == 'S') {
                return Short.TYPE;
            }
            if (c == 'Z') {
                return Boolean.TYPE;
            }
            throw new ClassNotFoundException("unknown base type: " + c);
        }
    }

    private static final class signatureCompiler {
        private StringBuffer m_desc = new StringBuffer();

        private signatureCompiler() {
        }

        String signatureDescriptor(Class[] _parameterTypes, Class _returnType) {
            this.emit('(');
            this.parameterTypes(_parameterTypes);
            this.emit(')');
            this.returnType(_returnType);
            return this.m_desc.toString();
        }

        String typeDescriptor(Class type) {
            this.parameterType(type);
            return this.m_desc.toString();
        }

        private void parameterTypes(Class[] _parameterTypes) {
            if (_parameterTypes != null) {
                for (int p = 0; p < _parameterTypes.length; ++p) {
                    this.parameterType(_parameterTypes[p]);
                }
            }
        }

        private void returnType(Class _returnType) {
            if (_returnType == null || _returnType == Void.TYPE) {
                this.emit('V');
            } else {
                this.parameterType(_returnType);
            }
        }

        private void parameterType(Class _parameterType) {
            if (_parameterType != null) {
                if (_parameterType.isPrimitive()) {
                    if (Byte.TYPE == _parameterType) {
                        this.emit('B');
                    } else if (Character.TYPE == _parameterType) {
                        this.emit('C');
                    } else if (Double.TYPE == _parameterType) {
                        this.emit('D');
                    } else if (Float.TYPE == _parameterType) {
                        this.emit('F');
                    } else if (Integer.TYPE == _parameterType) {
                        this.emit('I');
                    } else if (Long.TYPE == _parameterType) {
                        this.emit('J');
                    } else if (Short.TYPE == _parameterType) {
                        this.emit('S');
                    } else if (Boolean.TYPE == _parameterType) {
                        this.emit('Z');
                    }
                } else if (_parameterType.isArray()) {
                    this.emit('[');
                    this.parameterType(_parameterType.getComponentType());
                } else {
                    this.emit('L');
                    this.emit(Types.javaNameToVMName(_parameterType.getName()));
                    this.emit(';');
                }
            }
        }

        private void emit(String s) {
            this.m_desc.append(s);
        }

        private void emit(char c) {
            this.m_desc.append(c);
        }
    }
}

