#!/bin/bash

# This script runs the Charva test program.
# It is intended to be run from the "charva/java/src" directory.

if [ "$TERM" = "dumb" ]; then
    echo "The TERM environment variable is not set!"
    exit
fi

# We built the native library in ../../c/src; make the shared
# library available to the dynamic linker.
export LD_LIBRARY_PATH=../../c/src:$LD_LIBRARY_PATH

# JAVA_HOME must be set to the JDK or JRE installation directory (for example,
# /usr/local/jdk1.3 or /usr/local/jre1.3).

if [ -z "$JAVA_HOME" ]
then
    echo "The JAVA_HOME environment variable is not set!"
    exit
fi

# Uncomment the next line to log keystrokes and mouse-clicks, and 
# to debug key-mappings (the logfile in this case is $HOME/script.charva).
TEST_OPTS="-Dcharva.script.record=${HOME}/script.charva"

# Uncomment the following line to play back a script that was previously
# recorded using "charva.script.record".
#TEST_OPTS=-Dcharva.script.playback=${HOME}/script.charva

# Uncomment the next line to enable color.
TEST_OPTS="${TEST_OPTS} -Dcharva.color=1"

# Uncomment the following option to test for memory leaks.
#TEST_OPTS="${TEST_OPTS} -Xrunhprof:heap=sites"

# Note that the "-classic" option is no longer supported in JDK1.4,
# but in JDK1.3 and earlier it is useful on Linux because otherwise
# each Charva application shows up as dozens of processes (one for
# each thread).
#TEST_OPTS="-classic ${TEST_OPTS}"

${JAVA_HOME}/bin/java \
    ${TEST_OPTS} \
    -cp "../classes:../lib/charva.jar" \
    tutorial.charva.Tutorial 2> $HOME/charva.log
stty sane
