/* 

Copyright 2006 Eric Hakenholz

This file is part of C.a.R. software.

C.a.R. is a free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

C.a.R. is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
package eric.applet.dock;

import eric.*;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;

import rene.zirkel.ZirkelCanvas;

public class dockIcon extends JButton implements MouseListener {

    /**
     *
     */
    private static final long serialVersionUID=1L;
    String name;
    ZirkelCanvas ZC;
    dock DK;
    Vector group;// button group : null->simple button , contain 1 elt->
    // togglebutton , contain more elts-> group member
    boolean isSelected; // icon state
    boolean isDisabled=false; // icon disabled ?
    boolean isEntered=false; // Mouseover ?
    private final ImageIcon myimage;
    int iconsize;
    static String moveonreselect=",delete,hide,rename,edit,zoom,animate,";
    // Runnable doactualisemacrostree;
    String ToolTipText;

    
    // String Shortcut;
//    @Override
    @Override
    public void paint(final java.awt.Graphics g) {
        /*
         * I learned things from this pages :
         * http://java.sun.com/developer/technicalArticles
         * /GUI/java2d/java2dpart1.html
         * http://www.apl.jhu.edu/~hall/java/Java2D-Tutorial.html
         */
        // super.paintComponent(g);
        final java.awt.Dimension d=this.getSize();
        final int w=d.width;
        final int h=d.height;

        // g.drawImage(myimage.getImage(),0,0,w, h,this);

        final Graphics2D g2=(Graphics2D) g;

        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
                RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
                RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL,
                RenderingHints.VALUE_STROKE_PURE);

        if (isDisabled) {

            final ImageFilter filter=new GrayFilter(true, 60);

            final Image disImage=createImage(new FilteredImageSource(myimage.getImage().getSource(), filter));
            final ImageIcon myicn=new ImageIcon(disImage);
            g2.drawImage(myicn.getImage(), 0, 0, w, h, this);
            return;
        }


        final Composite ac0=g2.getComposite();

        if (isSelected) {
            final AlphaComposite ac=AlphaComposite.getInstance(
                    AlphaComposite.SRC_OVER, 0.5f);
            g2.setComposite(ac);
            g2.setColor(new Color(255, 255, 255));
            g2.fillRect(1, 1, w-1, h-1);
        }
        g2.setComposite(ac0);
        g2.drawImage(myimage.getImage(), 0, 0, w, h, this);
    }

    @Override
    public void setSelected(final boolean b) {
        isSelected=b;
    }

    @Override
    public boolean isSelected() {
        return isSelected;
    }

    public void ShowToolTip() {
    }

    public void HideToolTip() {
    }

    private void fixsize(final int sze) {
        final Dimension d=new Dimension(sze, sze);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setSize(d);
    }

    // Create an Icon wich belongs to group (if not null) :
    public dockIcon(final dock dk, final int size, final String nm, final Vector mygroup) {
        DK=dk;
        ZC=dk.ZC;
        name=nm;
        this.isSelected=false;

        this.group=mygroup;

        URL myurl=getClass().getResource(
                "/eric/icons/palette/"+name+".png");
        if (myurl==null) {
            myurl=getClass().getResource(
                    "/eric/icons/palette/"+name+".gif");
        }
        myimage=new ImageIcon(myurl);
//        setIcon(myimage);
        this.setBorder(BorderFactory.createEmptyBorder());
        fixsize(size);
        setAlignmentX(0.5f);
        setAlignmentY(0.5f);
//        dock.fixsize(this, size, DK.HEIGHT);

        // if (Shortcut.equals(name)) Shortcut="";
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(this);
        if (group!=null) {
            group.add(this);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    // Graphical appearence of button(s) and changing of state :
    private void toggleselect() {
        // remember : isSelected of a simple button never goes to true, so
        // here, group is not a null object...
        if (isSelected) {
            if (group.size()==1) { // I am a togglebutton
                isSelected=false;
                // isEntered=true;
                ZC.repaint();
            }
        } else {

            if (group!=null) {

                for (int i=0; i<group.size(); i++) {
                    final JButton myicn=(JButton) group.get(i);
                    if (myicn.isSelected()) {
                        myicn.setSelected(false);
                    }
                }
                isSelected=true;
                isEntered=false;
                ZC.repaint();
            }
        }
    }

    public void TasksBeforeClick() {
        toggleselect();
    }

    public void ClicOnMe() {
		TasksBeforeClick();
    }

    public void mouseClicked(final MouseEvent e) {
        System.out.println("clic");
    }

    public void mousePressed(final MouseEvent e) {
        if (isDisabled) {
            return;
        }
        ClicOnMe();
    }

    public void mouseReleased(final MouseEvent e) {
        JGlobals.RefreshBar();
        if (isDisabled) {
            return;
        }
        if (!(isSelected)) {
            repaint();
        }

    }

    public void mouseEntered(final MouseEvent e) {
        System.out.println(name);
        if (isDisabled) {
            return;
        }
        if (!name.equals("blank")) {
            if (!(isSelected)) {
                isEntered=true;
                ShowToolTip();
                repaint();
            }
        }


    }

    public void mouseExited(final MouseEvent e) {
        if (isDisabled) {
            return;
        }
        if (!name.equals("blank")) {
            HideToolTip();
            if (!(isSelected)) {
                isEntered=false;
                repaint();
            }
        }
    }
}
