namespace boost { namespace logging {

/** 
@mainpage Boost Logging Library v2 - Table of contents


- @ref main_intro
    - @ref main_motivation
    - @ref main_feeback
    - @ref page_changelog
        - @ref changelog_cur_ver 
    - @ref acknowledgements

- @ref workflow
    - @ref workflow_introduction 
    - @ref workflow_filter 
    - @ref workflow_processing 
    - @ref workflow_2a 
    - @ref workflow_2b 
    - @ref workflow_formatters_destinations 

- @ref common_scenarios
    - @ref common_scenarios_1
    - @ref common_scenarios_2
    - @ref common_scenarios_3
    - @ref common_your_scenario
    - @ref common_scenario_using_tags 
    - @ref common_scenarios "More scenarios..."
    - @ref scenario_multiple_files
    - @ref starter_project 

- @ref headers_to_include "Headers to #include"
- @ref defining_your_logger_filter 
- @ref scenario::usage "Choose the best filter/logger class, based on your application's needs"
- @ref tag "Using tags"
- @ref thread_safety 
- @ref macros
    - @ref macros_if_else_strategy 
    - @ref macros_using 
        - @ref macros_define_declare 
        - @ref macros_use 
        - @ref macros_set_formatters 
        - @ref macros_use_tags 
        - @ref macros_compile_time 
        - @ref macros_tss 

- @ref logger "The logger class"
    - @ref gather "The gather namespace"
    - @ref writer "The writer namespace"
- @ref filter "The filters (namespace)"
- @ref namespace_concepts
    - @ref namespace_general
    - @ref namespace_process 
    - @ref namespace_manipulator
    - @ref namespace_write
- @ref manipulator "Formatters and/or destinations (manipulators namespace)"
    - @ref manipulator_common 
    - @ref manipulator_base_class 
    - @ref manipulator_default_base_class
    - @ref manipulator_generic 
    - @ref manipulator_create 
    - @ref manipulator_share_data 
    - @ref formatter "Formatters"
    - @ref destination "Destinations"

- @ref boost_logging_requirements 



*/

}}
