/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.ArrayValueCommand;
import com.google.gwt.rpc.client.ast.BooleanValueCommand;
import com.google.gwt.rpc.client.ast.ByteValueCommand;
import com.google.gwt.rpc.client.ast.CharValueCommand;
import com.google.gwt.rpc.client.ast.DoubleValueCommand;
import com.google.gwt.rpc.client.ast.EnumValueCommand;
import com.google.gwt.rpc.client.ast.FloatValueCommand;
import com.google.gwt.rpc.client.ast.IdentityValueCommand;
import com.google.gwt.rpc.client.ast.InstantiateCommand;
import com.google.gwt.rpc.client.ast.IntValueCommand;
import com.google.gwt.rpc.client.ast.InvokeCustomFieldSerializerCommand;
import com.google.gwt.rpc.client.ast.LongValueCommand;
import com.google.gwt.rpc.client.ast.NullValueCommand;
import com.google.gwt.rpc.client.ast.RpcCommandVisitor;
import com.google.gwt.rpc.client.ast.ScalarValueCommand;
import com.google.gwt.rpc.client.ast.SetCommand;
import com.google.gwt.rpc.client.ast.ShortValueCommand;
import com.google.gwt.rpc.client.ast.StringValueCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.server.CommandSerializationUtil;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandServerSerializationStreamReader
implements SerializationStreamReader {
    final Map<IdentityValueCommand, Object> backRefs;
    Iterator<ValueCommand> values;

    public CommandServerSerializationStreamReader() {
        this(new HashMap<IdentityValueCommand, Object>());
    }

    private CommandServerSerializationStreamReader(Map<IdentityValueCommand, Object> backRefs) {
        this.backRefs = backRefs;
    }

    public void prepareToRead(List<ValueCommand> commands) {
        this.values = commands.iterator();
    }

    @Override
    public boolean readBoolean() throws SerializationException {
        return this.readNumberCommand(BooleanValueCommand.class).getValue();
    }

    @Override
    public byte readByte() throws SerializationException {
        return this.readNumberCommand(ByteValueCommand.class).getValue();
    }

    @Override
    public char readChar() throws SerializationException {
        return this.readNumberCommand(CharValueCommand.class).getValue().charValue();
    }

    @Override
    public double readDouble() throws SerializationException {
        return this.readNumberCommand(DoubleValueCommand.class).getValue();
    }

    @Override
    public float readFloat() throws SerializationException {
        return this.readNumberCommand(FloatValueCommand.class).getValue().floatValue();
    }

    @Override
    public int readInt() throws SerializationException {
        return this.readNumberCommand(IntValueCommand.class).getValue();
    }

    @Override
    public long readLong() throws SerializationException {
        return this.readNumberCommand(LongValueCommand.class).getValue();
    }

    @Override
    public Object readObject() throws SerializationException {
        ValueCommand command = this.readNextCommand(ValueCommand.class);
        Visitor v = new Visitor();
        v.accept(command);
        return v.values.pop();
    }

    @Override
    public short readShort() throws SerializationException {
        return this.readNumberCommand(ShortValueCommand.class).getValue();
    }

    @Override
    public String readString() throws SerializationException {
        return (String)this.readObject();
    }

    private <T extends ValueCommand> T readNextCommand(Class<T> clazz) throws SerializationException {
        if (!this.values.hasNext()) {
            throw new SerializationException("Reached end of stream");
        }
        ValueCommand next = this.values.next();
        if (!clazz.isInstance(next)) {
            throw new SerializationException("Cannot assign " + next.getClass().getName() + " to " + clazz.getName());
        }
        return (T)((ValueCommand)clazz.cast(next));
    }

    private <T extends ValueCommand> T readNumberCommand(Class<T> clazz) throws SerializationException {
        if (!this.values.hasNext()) {
            throw new SerializationException("Reached end of stream");
        }
        ValueCommand next = this.values.next();
        if (clazz.isInstance(next)) {
            return (T)((ValueCommand)clazz.cast(next));
        }
        if (next instanceof LongValueCommand) {
            if (!clazz.isInstance(next)) {
                throw new SerializationException("Cannot assign " + next.getClass().getName() + " to " + clazz.getName());
            }
            return (T)((ValueCommand)clazz.cast(next));
        }
        if (next instanceof DoubleValueCommand) {
            Exception ex;
            try {
                Constructor<T> c = clazz.getConstructor(Double.TYPE);
                return (T)((ValueCommand)c.newInstance((double)((DoubleValueCommand)next).getValue()));
            }
            catch (SecurityException e) {
                throw new SerializationException("Cannot construct ValueCommand type", e);
            }
            catch (NoSuchMethodException e) {
                throw new SerializationException("Connot initialize a " + clazz.getName() + " from a DoubleValueCommand", e);
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (InstantiationException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            throw new SerializationException("Cannot create ValueCommand", ex);
        }
        throw new SerializationException("Cannot create a numeric ValueCommand from a " + next.getClass().getName());
    }

    class Visitor
    extends RpcCommandVisitor {
        private final Stack<Object> values = new Stack();

        Visitor() {
        }

        public void endVisit(BooleanValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(ByteValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(CharValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(DoubleValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(EnumValueCommand x, RpcCommandVisitor.Context ctx) {
            this.push(x, x.getValue());
        }

        public void endVisit(FloatValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(IntValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(LongValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(NullValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(SetCommand x, RpcCommandVisitor.Context ctx) {
            Exception ex;
            try {
                Field f = x.getFieldDeclClass().getDeclaredField(x.getField());
                Object value = this.values.pop();
                Object instance = this.values.peek();
                assert (value == null || CommandSerializationUtil.getAccessor(f.getType()).canSet(value.getClass())) : "Cannot assign a " + value.getClass().getName() + " into " + f.getType().getName();
                CommandSerializationUtil.getAccessor(f.getType()).set(instance, f, value);
                return;
            }
            catch (SecurityException e) {
                ex = e;
            }
            catch (NoSuchFieldException e) {
                ex = e;
            }
            this.halt(new SerializationException("Unable to set field value", ex));
        }

        public void endVisit(ShortValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public void endVisit(StringValueCommand x, RpcCommandVisitor.Context ctx) {
            this.pushScalar(x);
        }

        public boolean visit(ArrayValueCommand x, RpcCommandVisitor.Context ctx) {
            if (this.maybePushBackRef(x)) {
                Object array = Array.newInstance(x.getComponentType(), x.getComponentValues().size());
                this.push(x, array);
                int size = x.getComponentValues().size();
                CommandSerializationUtil.Accessor a = CommandSerializationUtil.getAccessor(x.getComponentType());
                for (int i = 0; i < size; ++i) {
                    this.accept(x.getComponentValues().get(i));
                    a.set(array, i, this.values.pop());
                }
            }
            return false;
        }

        public boolean visit(InstantiateCommand x, RpcCommandVisitor.Context ctx) {
            if (this.maybePushBackRef(x)) {
                try {
                    Object instance = CommandSerializationUtil.allocateInstance(x.getTargetClass());
                    this.push(x, instance);
                    return true;
                }
                catch (InstantiationException e) {
                    this.halt(new SerializationException("Unable to create instance", e));
                }
            }
            return false;
        }

        public boolean visit(InvokeCustomFieldSerializerCommand x, RpcCommandVisitor.Context ctx) {
            if (this.maybePushBackRef(x)) {
                CommandServerSerializationStreamReader subReader = new CommandServerSerializationStreamReader(CommandServerSerializationStreamReader.this.backRefs);
                subReader.prepareToRead(x.getValues());
                Class<?> serializerClass = x.getSerializerClass();
                assert (serializerClass != null);
                Method instantiate = null;
                Method deserialize = null;
                for (Method m : serializerClass.getMethods()) {
                    if ("instantiate".equals(m.getName())) {
                        instantiate = m;
                    } else if ("deserialize".equals(m.getName())) {
                        deserialize = m;
                    }
                    if (instantiate != null && deserialize != null) break;
                }
                assert (deserialize != null) : "No deserialize method in " + serializerClass.getName();
                Object instance = null;
                if (instantiate != null) {
                    assert (Modifier.isStatic(instantiate.getModifiers())) : "instantiate method in " + serializerClass.getName() + " must be static";
                    try {
                        instance = instantiate.invoke(null, subReader);
                    }
                    catch (IllegalArgumentException e) {
                        this.halt(new SerializationException("Unable to create instance", e));
                    }
                    catch (IllegalAccessException e) {
                        this.halt(new SerializationException("Unable to create instance", e));
                    }
                    catch (InvocationTargetException e) {
                        this.halt(new SerializationException("Unable to create instance", e));
                    }
                } else {
                    try {
                        instance = x.getTargetClass().newInstance();
                    }
                    catch (InstantiationException e) {
                        this.halt(new SerializationException("Unable to create instance", e));
                    }
                    catch (IllegalAccessException e) {
                        this.halt(new SerializationException("Unable to create instance", e));
                    }
                }
                assert (instance != null) : "Did not create instance";
                this.push(x, instance);
                this.accept(x.getSetters());
                try {
                    deserialize.invoke(null, subReader, instance);
                }
                catch (IllegalArgumentException e) {
                    this.halt(new SerializationException("Unable to deserialize instance", e));
                }
                catch (IllegalAccessException e) {
                    this.halt(new SerializationException("Unable to deserialize instance", e));
                }
                catch (InvocationTargetException e) {
                    this.halt(new SerializationException("Unable to deserialize instance", e));
                }
            }
            return false;
        }

        private boolean maybePushBackRef(IdentityValueCommand x) {
            Object instance = CommandServerSerializationStreamReader.this.backRefs.get(x);
            if (instance == null) {
                return true;
            }
            this.values.push(instance);
            return false;
        }

        private void push(IdentityValueCommand x, Object value) {
            assert (!CommandServerSerializationStreamReader.this.backRefs.containsKey(x)) : "Trying to redefine a backref";
            CommandServerSerializationStreamReader.this.backRefs.put(x, value);
            this.values.push(value);
        }

        private void pushScalar(ScalarValueCommand x) {
            this.values.push(x.getValue());
        }
    }
}

