/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDriver;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import com.google.gwt.editor.client.impl.DelegateMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleViolation {
    public static Iterable<SimpleViolation> iterableFromConstrantViolations(Iterable<ConstraintViolation<?>> violations) {
        return new ConstraintViolationIterable(violations);
    }

    public static void pushViolations(Iterable<SimpleViolation> violations, EditorDriver<?> driver, DelegateMap.KeyMethod keyMethod) {
        DelegateMap delegateMap = DelegateMap.of(driver, keyMethod);
        for (SimpleViolation error : violations) {
            Object key = error.getKey();
            List<AbstractEditorDelegate<?, ?>> delegateList = delegateMap.get(key);
            if (delegateList == null) continue;
            for (AbstractEditorDelegate<?, ?> baseDelegate : delegateList) {
                String basePath = baseDelegate.getPath();
                String absolutePath = (basePath.length() > 0 ? basePath + "." : "") + error.getPath();
                List<AbstractEditorDelegate<?, ?>> leafDelegates = delegateMap.getDelegatesByPath(absolutePath);
                List<Editor<?>> editors = delegateMap.getEditorByPath(absolutePath);
                if (leafDelegates != null) {
                    for (AbstractEditorDelegate abstractEditorDelegate : leafDelegates) {
                        abstractEditorDelegate.recordError(error.getMessage(), null, error.getUserDataObject());
                    }
                    continue;
                }
                if (editors == null) continue;
                for (Editor editor : editors) {
                    baseDelegate.recordError(error.getMessage(), null, error.getUserDataObject(), error.getPath(), editor);
                }
            }
        }
    }

    protected SimpleViolation() {
    }

    public abstract Object getKey();

    public abstract String getMessage();

    public abstract String getPath();

    public abstract Object getUserDataObject();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleViolationAdapter
    extends SimpleViolation {
        private final ConstraintViolation<?> v;

        public SimpleViolationAdapter(ConstraintViolation<?> v) {
            this.v = v;
        }

        @Override
        public Object getKey() {
            return this.v.getLeafBean();
        }

        @Override
        public String getMessage() {
            return this.v.getMessage();
        }

        @Override
        public String getPath() {
            return this.v.getPropertyPath().toString();
        }

        @Override
        public Object getUserDataObject() {
            return this.v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstraintViolationIterable
    implements Iterable<SimpleViolation> {
        private final Iterable<ConstraintViolation<?>> violations;

        public ConstraintViolationIterable(Iterable<ConstraintViolation<?>> violations) {
            this.violations = violations;
        }

        @Override
        public Iterator<SimpleViolation> iterator() {
            final Iterator<ConstraintViolation<?>> source = this.violations.iterator();
            return new Iterator<SimpleViolation>(){

                @Override
                public boolean hasNext() {
                    return source.hasNext();
                }

                @Override
                public SimpleViolation next() {
                    return new SimpleViolationAdapter((ConstraintViolation)source.next());
                }

                @Override
                public void remove() {
                    source.remove();
                }
            };
        }
    }
}

