                   
/*
 * File:        SIDL_cxx.hh
 * Copyright:   (c) 2001-2002 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.58 $
 * Date:        $Date: 2003/10/23 19:59:10 $
 * Description: Babel/C++ base classes 
 * AUTOMATICALLY GENERATED BY genSIDLcxx.py
 *
 */

#ifndef included_SIDL_cxx_hh
#define included_SIDL_cxx_hh

#ifndef __cplusplus
#error C++ headerfile: not meant for C compilers
#endif


// get babel configuration information
#include "babel_config.h"
#include <stdlib.h>

// need free()
#include <stddef.h>

// need exception
#include <exception>

// need iterator
#include <iterator>

// need vector
#include <vector>

// include complex<T>
#ifndef HAVE_COMPLEX
#  error C++ bindings assume complex<T> is available
#else
#  ifdef HAVE_COMPLEX_MATH_IN_NAMESPACE_STD
#    include <complex>
#  else
#    include <complex.h>
#  endif
#endif

// include C++ strings
#include <string>

#ifdef SIDL
/* AIX /usr/include/sys/proc.h has #define SIDL 4 (groan) */
#undef SIDL 
#endif

#ifndef included_SIDL_interface_IOR_h
#include "SIDL_interface_IOR.h"
#endif

#ifndef included_SIDL_BaseInterface_h
#include "SIDL_BaseInterface.h"
#endif

#ifndef included_SIDLArray_h
#include "SIDLArray.h"
#endif

namespace SIDL { 


  // redefine types inside SIDL namespace
  // typedef bool bool;
  // typedef char char;
  // typedef ::int32_t int;
  // typedef ::int64_t long;
  // typedef float float;
  // typedef double double;
  typedef ::std::complex<float> fcomplex;
  typedef ::std::complex<double> dcomplex;
  typedef ::std::string string;
  typedef void * opaque;
  
  // rescope enum
  enum array_ordering { 
    general_order = SIDL_general_order,
    column_major_order = SIDL_column_major_order, 
    row_major_order = SIDL_row_major_order
  };

  struct dcomplex_less { 
    bool operator() ( const SIDL::dcomplex& a, const SIDL::dcomplex& b) const {
      if ( a.real() == b.real() ) { 
        return a.imag() < b.imag();
      } else { 
        return a.real() < b.real();
      }
    }
  };

  struct fcomplex_less { 
    bool operator() ( const SIDL::fcomplex& a, const SIDL::fcomplex& b) const {
      if ( a.real() == b.real() ) { 
        return a.imag() < b.imag();
      } else { 
        return a.real() < b.real();
      }
    }
  };

  // This class is particular to C++ Stub Bindings.
  class NullIORException : public ::std::exception {
  private:
    ::std::string msg;

  public:
    NullIORException( const char * c ): msg(c) { }
    NullIORException( const ::std::string &s ): msg(s) { }
    virtual const char *what() const throw() { 
      return msg.c_str();
    }
#if defined(__GNUG__) && (__GNUG__ < 3)
    virtual ~NullIORException() { }
#else
    virtual ~NullIORException() throw() { }
#endif
  };

  // This is throw when a particular method is not supported
  class UnsupportedException : public ::std::exception {
  private:
    ::std::string msg;

  public:
    UnsupportedException( const ::std::string &s ): msg(s) { }
    virtual const char *what() const throw() { 
      return msg.c_str();
    }
#if defined(__GNUG__) && (__GNUG__ < 3)
    virtual ~UnsupportedException() { }
#else
    virtual ~UnsupportedException() throw() { }
#endif
  };

  // introduce StubBase into the SIDL namespace
  // StubBase is the abstract base class for all C++ stubs.
  class StubBase {
  public:
    virtual void* _cast(const char* type) const = 0;
    virtual ~StubBase() {}
  };

  /////////////////////////////////////////////////////////////////
  // 
  // array iterators:
  // 
  //   array_iter_base  : common base class
  //   array_iter       : standard iterator for SIDL::array
  //   const_array_iter : standard const_iterator for SIDL::array
  template <typename array_traits>
  class array_iter_base
  { 
  public:
    typedef array_iter_base< array_traits >    iterator;
    typedef typename array_traits::reference   reference;
    typedef typename array_traits::pointer     pointer;
    typedef typename array_traits::cxx_array_t cxx_array_t;
    typedef typename array_traits::cxx_item_t  cxx_item_t;

  protected:
    cxx_array_t d_array;
    int32_t d_index;
    
  public:
    array_iter_base( cxx_array_t a, int32_t i) : d_array(a), d_index(i) {}
    array_iter_base( const iterator& x ) : d_array(x.d_array), d_index(x.d_index) {}
    
    cxx_item_t operator*() const { return d_array.get(d_index); }
    pointer operator->() const { return &(d_array.get(d_index)); }
    
    bool operator==( const array_iter_base& x ) const { return (d_array==x.d_array)&&(d_index==x.d_index); }
    bool operator!=( const array_iter_base& x ) const { return (d_array!=x.d_array)||(d_index!=x.d_index); }
  };
 

  template < typename array_traits > 
  class  array_iter : public array_iter_base< array_traits > 
  { 
  public:
    typedef array_iter_base< array_traits >    Base;
    typedef std::input_iterator_tag            iterator_category;
    typedef typename array_traits::value_type  value_type;
    typedef typename array_traits::pointer     pointer;
    typedef typename array_traits::reference   reference;
    typedef size_t                             size_type;
    typedef int32_t                            difference_type;
    typedef typename array_traits::cxx_array_t cxx_array_t;

    array_iter( cxx_array_t a, int32_t i) : Base(a,i) {}
    array_iter( const array_iter<array_traits>& x) : Base(x) {}

    array_iter& operator++() { ++d_index; return *this; } 
    array_iter operator++(int) { return array_iter(d_array, d_index++); }
  };

  template <typename array_traits > 
  class  const_array_iter : public array_iter_base<array_traits>
  { 
  public:
    typedef array_iter_base<array_traits>       Base;
    typedef std::input_iterator_tag              iterator_category;
    typedef typename array_traits::value_type    value_type;
    typedef typename array_traits::const_pointer const_pointer;
    typedef typename array_traits::const_reference const_reference;
    typedef size_t                              size_type;
    typedef int32_t                             difference_type;
    typedef typename array_traits::cxx_array_t   cxx_array_t;

    const_array_iter( const cxx_array_t a, int32_t i) : Base(a,i) {}
    const_array_iter( const array_iter<cxx_array_t>& x) : Base(x) {}

    const_array_iter& operator++() { ++d_index; return *this; } 
    const_array_iter operator++(int) { return const_array_iter( d_array, d_index++); }
  };

  ////////////////////////////////////////////////////////////
  //
  // SIDL::array base classes & specializations
  //
  //     array_mixin<array_traits>     : root template class for all others
  //     enum_array<array_traits>      : intermediate class for all 
  //                                     SIDL::array<enum> specializations
  //     interface_array<array_traits> : intermediate class for all 
  //                                     SIDL::array<class|interface> specializations
  //     array<T> : specializations for T = {bool,char,int32_t, int64_t, float, 
  //                                         double, fcomplex, dcomplex, opaque, string}
  // 
  template< typename array_traits > 
  class array_mixin { 
  public:
    typedef typename array_traits::value_type           value_type;
    typedef typename array_traits::reference            reference;
    typedef typename array_traits::pointer              pointer;
    typedef typename array_traits::const_reference      const_reference;
    typedef typename array_traits::const_pointer        const_pointer;
    typedef typename array_traits::iterator             iterator; 
    typedef typename array_traits::const_iterator       const_iterator;
    typedef typename array_traits::ior_array_t          ior_array_t;
    typedef typename array_traits::ior_array_internal_t ior_array_internal_t;

  protected:
    ior_array_internal_t *d_array;

  public:
    // default destructor
    // deleteRef is handled by destructors down the type hierarchy
    virtual ~array_mixin() { }

    // conversion from ior to C++ class
    array_mixin(ior_array_t* src=0 ) 
      : d_array(reinterpret_cast<ior_array_internal_t *>(src)) {}

    virtual void addRef() throw ( NullIORException ) = 0;

    virtual void deleteRef() throw ( NullIORException ) = 0;
    
    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // check if no pointer to array
    bool _is_nil() const throw() {
      return (d_array==0);
    }

    // check if no pointer to array
    bool _not_nil() const throw (){
      return (d_array!=0);
    }

    // check if no pointer to array
    bool operator !() const throw (){
      return (d_array==0);
    }

    // check if the array is allocated
    operator void *() const throw () {
      return (void *)d_array;
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () { 
      if (d_array) deleteRef();
      d_array=reinterpret_cast<ior_array_internal_t *>(s);
    }

    // the following methods are C++ specific extensions to the base SIDL::array api
    bool operator==(const array_mixin& x) const { return d_array == x.d_array; }
    bool operator!=(const array_mixin& x) const { return d_array != x.d_array; }
  };

  // All arrays of objects/interfaces inherit from this
  // template.
  template <typename array_traits>
  class interface_array :
     public array_mixin< array_traits > 
  {
  public:
    typedef array_mixin<array_traits>              Base;
    typedef typename array_traits::cxx_array_t     cxx_array_t;
    typedef typename array_traits::cxx_item_t      cxx_item_t;
    typedef typename array_traits::ior_array_t     ior_array_t;
    typedef struct SIDL_interface__array           ior_internal_array;
    typedef typename array_traits::ior_item_t      ior_item_t;
    typedef typename array_traits::iterator        iterator;
    typedef typename array_traits::const_iterator  const_iterator;

    interface_array(ior_array_t *src=0) : Base( src ) { }

    // must be included to make sure deleteRef is instantiated
    virtual ~interface_array() { if (d_array) deleteRef(); }
  
    // static constructor
    static cxx_array_t
    createRow(int32_t dimen, 
              const int32_t lower[],
              const int32_t upper[]) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (SIDL_interface__array_createRow(dimen, lower, upper)));
    }

    /**
     * static constructor: createCol
     */
    static cxx_array_t
    createCol(int32_t dimen,
            const int32_t lower[],
            const int32_t upper[]) {
    return cxx_array_t(reinterpret_cast< ior_array_t * >
      (SIDL_interface__array_createCol( dimen, lower, upper )));
    }

    /**
     * static constructor: create1d
     */
    static cxx_array_t
    create1d(int32_t len) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (SIDL_interface__array_create1d(len)));
    }

    /**
     * static constructor: create1d[Init]
     */
    static cxx_array_t
    create1d(int32_t len, const ior_item_t* data) {
      return create1dInit( len, data );
    }

    /**
     * static constructor: create1dInit
     */
    static cxx_array_t
    create1dInit(int32_t len, const SIDL_BaseInterface* data) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (SIDL_interface__array_create1dInit(len,ior_data.begin())));
    }

    /**
     * static constructor: create2dCol
     */
    static cxx_array_t
    create2dCol(int32_t m, int32_t n) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (SIDL_interface__array_create2dCol(m,n)));
    }

    /**
     * static constructor: create2dRow
     */
    static cxx_array_t
    create2dRow(int32_t m, int32_t n) {
      return cxx_array_t (reinterpret_cast< ior_array_t * >
        (SIDL_interface__array_create2dRow(m,n)));
    }


    virtual void addRef() throw ( NullIORException ) {
    if ( d_array == 0 ) {
      throw NullIORException( ::std::string(
        "Null IOR Pointer in 'array_mixin<>::addRef()'"
      ));
      }
      SIDL_interface__array_addRef(d_array);
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array_mixin<>::deleteRef()'"
        ));
      }
      SIDL_interface__array_deleteRef(d_array);
      d_array = 0;
    }
    
    // borrow
    void borrow(struct SIDL_BaseInterface__object* * first_element,
                int32_t dimen,
                const int32_t lower[],
                const int32_t upper[],
                const int32_t stride[])
      throw ()
    {
      if (d_array) deleteRef();
      d_array = 
        SIDL_interface__array_borrow(first_element, dimen, lower,
                                     upper, stride);
    }

    // smartCopy
    void smartCopy( ) throw () {
      if (d_array) {
        struct SIDL_interface__array *p = 
       	  SIDL_interface__array_smartCopy(d_array);
        deleteRef();
        d_array = p;
      }
    }

    // copy from one array to another
    void copy( const cxx_array_t& src ) throw (){
      SIDL_interface__array_copy(src.d_array, d_array);
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) throw() {
      if (d_array) {
        struct SIDL_interface__array *p = 
          SIDL_interface__array_ensure(d_array, dimen, (SIDL_array_ordering) ordering);
        deleteRef();
        d_array = p;
      }
    }
    
    cxx_array_t
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw () 
    {
      return cxx_array_t ( reinterpret_cast< ior_array_t * >
        (SIDL_interface__array_slice( d_array, dimen, numElem,
                                     srcStart, srcStride, newStart)));
    }

    // isColumnOrder
    bool isColumnOrder() const throw () {
      return SIDL_interface__array_isColumnOrder(d_array) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const throw () {
      return SIDL_interface__array_isRowOrder(d_array) == TRUE;
    }

    // get dimension
    int32_t dimen() const throw() { 
      return SIDL_interface__array_dimen(d_array);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
	return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const throw () {
      return SIDL_interface__array_lower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const throw () {
      return SIDL_interface__array_upper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const throw () {
      return SIDL_interface__array_stride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get1(d_array, i);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get2(d_array, i, j);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) throw ()  {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get3(d_array, i, j, k);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get4(d_array, i, j, k, l);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get5(d_array, i, j, k, l, m);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get6(d_array, i, j, k, l, m, n);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get7(d_array, i, j, k, l, m, n, o);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }


    // get
    cxx_item_t get(const int32_t ind[]) throw () {
      SIDL_BaseInterface sbi =
        SIDL_interface__array_get(d_array, ind);
      cxx_item_t icwt(reinterpret_cast<ior_item_t * >(sbi));
      if (sbi) {
        SIDL_BaseInterface_deleteRef(sbi);
      }
      return icwt;
    }

    // set
    void set(int32_t i, cxx_item_t element) throw () {
      SIDL_interface__array_set1(d_array, i,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, cxx_item_t element) throw () {
      SIDL_interface__array_set2(d_array, i, j,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, cxx_item_t element) throw () {
      SIDL_interface__array_set3(d_array, i, j, k,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, cxx_item_t element) throw () {
      SIDL_interface__array_set4(d_array, i, j, k, l,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, cxx_item_t element) throw () {
      SIDL_interface__array_set5(d_array, i, j, k, l, m,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, cxx_item_t element) throw () {
      SIDL_interface__array_set6(d_array, i, j, k, l, m, n,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, cxx_item_t element) throw () {
      SIDL_interface__array_set7(d_array, i, j, k, l, m, n, o,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(const int32_t ind[], cxx_item_t element) throw (){
      SIDL_interface__array_set(d_array, ind,
         reinterpret_cast<struct SIDL_BaseInterface__object *>
         (element._get_ior()));
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return get(i); 
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };


  // All arrays of enumerated types inherit from this
  // template.
  template<typename array_traits> 
  class enum_array : public array_mixin<array_traits> 
  { 
  public:
    typedef array_mixin<array_traits>             Base;
    typedef typename array_traits::cxx_array_t    cxx_array_t;
    typedef typename array_traits::cxx_item_t     cxx_item_t;
    typedef typename array_traits::ior_array_t    ior_array_t;
    typedef struct SIDL_int__array                ior_array_internal_t;
    typedef typename array_traits::ior_item_t     ior_item_t;
    typedef typename array_traits::iterator       iterator;
    typedef typename array_traits::const_iterator const_iterator;

  public:
    enum_array(ior_array_t *src=0) : Base(src) {} 

    // must be included to make sure deleteRef is instantiated
    virtual ~enum_array() { if (d_array) deleteRef(); }

    // static constructor
    static cxx_array_t
    createRow(int32_t dimen, 
              const int32_t lower[],
              const int32_t upper[]) {
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (SIDL_int__array_createRow(dimen, lower, upper)));
    }

    /**
     * static constructor: createCol
     */
    static cxx_array_t
    createCol(int32_t dimen,
            const int32_t lower[],
            const int32_t upper[]) {
    return cxx_array_t(reinterpret_cast<ior_array_t *>
      (SIDL_int__array_createCol( dimen, lower, upper ) ));
    }

    /**
     * static constructor: create1d
     */
    static cxx_array_t
    create1d(int32_t len) {
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (SIDL_int__array_create1d(len)));
    }

    /**
     * static constructor: create1d[Init]
     */
    static cxx_array_t
    create1d(int32_t len, const ior_item_t* data) {
      return create1dInit(len, data);
    }

    /**
     * static constructor: create1dInit
     */
    static cxx_array_t
    create1dInit(int32_t len, const ior_item_t* data) {
      std::vector<ior_item_t> ior_data(len);
      for( int i=0; i<len; ++i) { 
         ior_data[i]=reinterpret_cast<ior_item_t>(data[i]);
      }
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (SIDL_int__array_create1d(len,ior_data.begin())));
    }

    /**
     * static constructor: create2dCol
     */
    static cxx_array_t
    create2dCol(int32_t m, int32_t n) {
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (SIDL_int__array_create2dCol(m,n)));
    }

    /**
     * static constructor: create2dRow
     */
    static cxx_array_t
    create2dRow(int32_t m, int32_t n) {
      return cxx_array_t (reinterpret_cast<ior_array_t *>
        (SIDL_int__array_create2dRow(m,n)));
    }

    void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException("Null IOR Pointer in 'enum_array<>::addRef()'"
        );
      }
      SIDL_int__array_addRef(d_array);
    }

    void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException("Null IOR Pointer in 'enum_array<>::deleteRef()'"
        );
      }
      SIDL_int__array_deleteRef(d_array);
      d_array = 0;
    }
    
    // borrow is not implementable for arrays of enum given that
    // C++ is not explicit about the sizeof(ior_item_t).
    void borrow( ior_item_t * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[])
        throw (UnsupportedException)
    {
      throw UnsupportedException("borrow is not implementable in C++ for enum_array<>");
    }

    // smartCopy
    void smartCopy( ) throw () {
      if (d_array) {
        struct SIDL_int__array *p = 
       	  SIDL_int__array_smartCopy(d_array);
        deleteRef();
        d_array = p;
      }
    }

    // copy from one array to another
    void copy( const cxx_array_t& src ) throw (){
      SIDL_int__array_copy(src.d_array, d_array);
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) throw() {
      if (d_array) {
        struct SIDL_int__array *p = 
          SIDL_int__array_ensure(d_array, dimen, (SIDL_array_ordering) ordering);
        deleteRef();
        d_array = p;
      }
    }

    cxx_array_t
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw () 
    {
      return cxx_array_t ( reinterpret_cast<ior_array_t *>
        (SIDL_int__array_slice( d_array, dimen, numElem,
                               srcStart, srcStride, newStart)) );
    }
    
    // isColumnOrder
    bool isColumnOrder() const throw() {
      return SIDL_int__array_isColumnOrder(d_array) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const throw () {
      return SIDL_int__array_isRowOrder(d_array) == TRUE;
    }

    // get dimension
    int32_t dimen() const throw () { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const throw() {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const throw() {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const  throw() {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const throw() {
      return cxx_item_t(SIDLArrayElem1(d_array, i));
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const throw() {
      return cxx_item_t(SIDLArrayElem2(d_array, i, j));
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const throw() {
      return cxx_item_t(SIDLArrayElem3(d_array, i, j, k));
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const throw() {
      return cxx_item_t(SIDLArrayElem4(d_array, i, j, k, l));
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const throw() {
      return cxx_item_t(SIDLArrayElem5(d_array, i, j, k, l, m));
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const throw() {
      return cxx_item_t(SIDLArrayElem6(d_array, i, j, k, l, m, n));
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const throw() {
      return cxx_item_t(SIDLArrayElem7(d_array, i, j, k, l, m, n, o));
    }


    // get
    cxx_item_t get(const int32_t ind[]) const throw() {
      return cxx_item_t(SIDL_int__array_get(d_array, ind));
    }

    // set
    void set(int32_t i, cxx_item_t element) throw() {
      SIDLArrayElem1(d_array, i) =  (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, cxx_item_t element) throw(){
      SIDLArrayElem2(d_array, i, j) = (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, cxx_item_t element) throw() {
      SIDLArrayElem3(d_array, i, j, k) = (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, cxx_item_t element) throw() {
      SIDLArrayElem4(d_array, i, j, k, l) =  (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, cxx_item_t element) throw() {
      SIDLArrayElem5(d_array, i, j, k, l, m) = (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, cxx_item_t element) throw() {
      SIDLArrayElem6(d_array, i, j, k, l, m, n) =  (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, cxx_item_t element) throw() {
      SIDLArrayElem7(d_array, i, j, k, l, m, n, o) = (ior_item_t)element;
    }
    
    // set
    void set(const int32_t ind[], cxx_item_t element) throw() {
      SIDL_int__array_set(d_array, ind, (ior_item_t)element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return get(i); 
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };


  // These are bogus templates that don't do anything.
  // But we specialize off of these to the more complicated
  // forms below.
  template < typename T >
  struct array_traits {};

  template< typename T > 
  class array {  };
 
  // template specialization for array_traits<string>
  template<>
  struct array_traits<string> { 
    typedef array<string>                            cxx_array_t;
    typedef string                                   cxx_item_t;
    typedef struct SIDL_string__array                ior_array_t;
    typedef struct SIDL_string__array                ior_array_internal_t;
    typedef char*                                    ior_item_t;
    typedef const char **                            ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type                               reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type                         const_reference;
    typedef array_iter< array_traits<string> >       iterator;
    typedef const_array_iter< array_traits<string> > const_iterator;
  };

  // template specialization for array<string>
  template<> 
  class array< string > 
    : public array_mixin< array_traits<string> >
  { 
  public:
    typedef array_mixin< array_traits<string> >        Base;
    typedef array_traits<string>::cxx_array_t          cxx_array_t;
    typedef array_traits<string>::cxx_item_t           cxx_item_t;
    typedef array_traits<string>::ior_array_t          ior_array_t;
    typedef array_traits<string>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<string>::ior_item_t           ior_item_t;
    typedef array_traits<string>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< string >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< string >(SIDL_string__array_createRow(dimen, lower, upper) );
    }
    
    static array< string >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< string >( SIDL_string__array_createCol(dimen, lower, upper) );
    }
    
    static array< string >
    create1d(int32_t len) throw() {
      return array< string >(SIDL_string__array_create1d( len ) );
    }

    static array< string >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< string >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< string >(SIDL_string__array_create1dInit( len, data ) );
    }

    static array< string >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< string > ( SIDL_string__array_create2dCol(m,n) );
    }

    static array< string >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< string > ( SIDL_string__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< string >::addRef()'"
        ));
      }
      SIDL_string__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< string >::deleteRef()'"
        ));
      }
      SIDL_string__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( char * * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_string__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    // Arrays of strings do not have first(), their implementation is hidden.
    //
    // const char ** first() const throw() {
    //   return const_cast<const char **>(SIDL_string__array_first( _get_ior() ) );
    // }
    //
    // char** first() throw() {
    //   return SIDL_string__array_first( _get_ior() );
    // }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_string__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< string >& src )  throw() {
      SIDL_string__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_string__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< string >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_string__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_string__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_string__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDL_string__array_dimen(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDL_string__array_lower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDL_string__array_upper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDL_string__array_stride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
       string s;
      char *tmp =  SIDL_string__array_get1(d_array,i);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      string s;
      char *tmp =  SIDL_string__array_get2(d_array,i,j);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      string s;
      char *tmp =  SIDL_string__array_get3(d_array,i,j,k);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      string s;
      char *tmp =  SIDL_string__array_get4(d_array,i,j,k,l);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      string s;
      char *tmp =  SIDL_string__array_get5(d_array,i,j,k,l,m);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      string s;
      char *tmp =  SIDL_string__array_get6(d_array,i,j,k,l,m,n);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      string s;
      char *tmp =  SIDL_string__array_get7(d_array,i,j,k,l,m,n,o);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      string s;
      char *tmp =  SIDL_string__array_get(d_array, ind);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // set
    void set(int32_t i, string element) {
      SIDL_string__array_set1(d_array,i,element.c_str());
    } 

    // set
    void set(int32_t i, int32_t j, string element) {
      SIDL_string__array_set2(d_array,i,j,element.c_str());
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, string element) {
      SIDL_string__array_set3(d_array,i,j,k,element.c_str());
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, string element) {
      SIDL_string__array_set4(d_array,i,j,k,l,element.c_str());
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, string element) {
      SIDL_string__array_set5(d_array,i,j,k,l,m,element.c_str());
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, string element) {
      SIDL_string__array_set6(d_array,i,j,k,l,m,n,element.c_str());
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, string element) {
      SIDL_string__array_set7(d_array,i,j,k,l,m,n,o,element.c_str());
    }

    void set(int32_t ind[], string element ) {
      SIDL_string__array_set(d_array,ind,element.c_str());		
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      string s;
      char *tmp =  SIDL_string__array_get1(d_array,i);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<bool>
  template<>
  struct array_traits<bool> { 
    typedef array<bool>                            cxx_array_t;
    typedef bool                               cxx_item_t;
    typedef struct SIDL_bool__array                       ior_array_t;
    typedef struct SIDL_bool__array                       ior_array_internal_t;
    typedef SIDL_bool                               ior_item_t;
    typedef const SIDL_bool*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<bool> >       iterator;
    typedef const_array_iter< array_traits<bool> > const_iterator;
  };

  // template specialization for array<bool>
  template<> 
  class array< bool > 
    : public array_mixin< array_traits<bool> >
  { 
  public:
    typedef array_mixin< array_traits<bool> >        Base;
    typedef array_traits<bool>::cxx_array_t          cxx_array_t;
    typedef array_traits<bool>::cxx_item_t           cxx_item_t;
    typedef array_traits<bool>::ior_array_t          ior_array_t;
    typedef array_traits<bool>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<bool>::ior_item_t           ior_item_t;
    typedef array_traits<bool>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< bool >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< bool >(SIDL_bool__array_createRow(dimen, lower, upper) );
    }
    
    static array< bool >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< bool >( SIDL_bool__array_createCol(dimen, lower, upper) );
    }
    
    static array< bool >
    create1d(int32_t len) throw() {
      return array< bool >(SIDL_bool__array_create1d( len ) );
    }

    static array< bool >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< bool >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< bool >(SIDL_bool__array_create1dInit( len, data ) );
    }

    static array< bool >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< bool > ( SIDL_bool__array_create2dCol(m,n) );
    }

    static array< bool >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< bool > ( SIDL_bool__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< bool >::addRef()'"
        ));
      }
      SIDL_bool__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< bool >::deleteRef()'"
        ));
      }
      SIDL_bool__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( SIDL_bool * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_bool__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const SIDL_bool* first() const throw() {
      return const_cast<const SIDL_bool*>(SIDL_bool__array_first( _get_ior() ) );
    }

    SIDL_bool* first() throw() {
      return SIDL_bool__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_bool__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< bool >& src )  throw() {
      SIDL_bool__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_bool__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< bool >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_bool__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_bool__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_bool__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o) == TRUE;
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_bool__array_get(d_array, ind) == TRUE;
    }

    // set
    void set(int32_t i, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem1(d_array,i) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem2(d_array,i,j) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem3(d_array,i,j,k) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem4(d_array,i,j,k,l) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem5(d_array,i,j,k,l,m) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, bool element) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = _local_element;
    }

    void set(int32_t ind[], bool element ) {
      SIDL_bool _local_element = (( element ) ? TRUE : FALSE);
      SIDL_bool__array_set(d_array,ind,_local_element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i) == TRUE;
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<char>
  template<>
  struct array_traits<char> { 
    typedef array<char>                            cxx_array_t;
    typedef char                               cxx_item_t;
    typedef struct SIDL_char__array                       ior_array_t;
    typedef struct SIDL_char__array                       ior_array_internal_t;
    typedef char                               ior_item_t;
    typedef const char*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<char> >       iterator;
    typedef const_array_iter< array_traits<char> > const_iterator;
  };

  // template specialization for array<char>
  template<> 
  class array< char > 
    : public array_mixin< array_traits<char> >
  { 
  public:
    typedef array_mixin< array_traits<char> >        Base;
    typedef array_traits<char>::cxx_array_t          cxx_array_t;
    typedef array_traits<char>::cxx_item_t           cxx_item_t;
    typedef array_traits<char>::ior_array_t          ior_array_t;
    typedef array_traits<char>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<char>::ior_item_t           ior_item_t;
    typedef array_traits<char>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< char >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< char >(SIDL_char__array_createRow(dimen, lower, upper) );
    }
    
    static array< char >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< char >( SIDL_char__array_createCol(dimen, lower, upper) );
    }
    
    static array< char >
    create1d(int32_t len) throw() {
      return array< char >(SIDL_char__array_create1d( len ) );
    }

    static array< char >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< char >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< char >(SIDL_char__array_create1dInit( len, data ) );
    }

    static array< char >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< char > ( SIDL_char__array_create2dCol(m,n) );
    }

    static array< char >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< char > ( SIDL_char__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< char >::addRef()'"
        ));
      }
      SIDL_char__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< char >::deleteRef()'"
        ));
      }
      SIDL_char__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( char * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_char__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const char* first() const throw() {
      return const_cast<const char*>(SIDL_char__array_first( _get_ior() ) );
    }

    char* first() throw() {
      return SIDL_char__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_char__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< char >& src )  throw() {
      SIDL_char__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_char__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< char >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_char__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_char__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_char__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_char__array_get(d_array, ind);
    }

    // set
    void set(int32_t i, char element) {
      SIDLArrayElem1(d_array,i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, char element) {
      SIDLArrayElem2(d_array,i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, char element) {
      SIDLArrayElem3(d_array,i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, char element) {
      SIDLArrayElem4(d_array,i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, char element) {
      SIDLArrayElem5(d_array,i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, char element) {
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, char element) {
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], char element ) {
      SIDL_char__array_set(d_array,ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<int32_t>
  template<>
  struct array_traits<int32_t> { 
    typedef array<int32_t>                            cxx_array_t;
    typedef int32_t                               cxx_item_t;
    typedef struct SIDL_int__array                       ior_array_t;
    typedef struct SIDL_int__array                       ior_array_internal_t;
    typedef int32_t                               ior_item_t;
    typedef const int32_t*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<int32_t> >       iterator;
    typedef const_array_iter< array_traits<int32_t> > const_iterator;
  };

  // template specialization for array<int32_t>
  template<> 
  class array< int32_t > 
    : public array_mixin< array_traits<int32_t> >
  { 
  public:
    typedef array_mixin< array_traits<int32_t> >        Base;
    typedef array_traits<int32_t>::cxx_array_t          cxx_array_t;
    typedef array_traits<int32_t>::cxx_item_t           cxx_item_t;
    typedef array_traits<int32_t>::ior_array_t          ior_array_t;
    typedef array_traits<int32_t>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<int32_t>::ior_item_t           ior_item_t;
    typedef array_traits<int32_t>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< int32_t >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< int32_t >(SIDL_int__array_createRow(dimen, lower, upper) );
    }
    
    static array< int32_t >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< int32_t >( SIDL_int__array_createCol(dimen, lower, upper) );
    }
    
    static array< int32_t >
    create1d(int32_t len) throw() {
      return array< int32_t >(SIDL_int__array_create1d( len ) );
    }

    static array< int32_t >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< int32_t >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< int32_t >(SIDL_int__array_create1dInit( len, data ) );
    }

    static array< int32_t >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< int32_t > ( SIDL_int__array_create2dCol(m,n) );
    }

    static array< int32_t >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< int32_t > ( SIDL_int__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< int32_t >::addRef()'"
        ));
      }
      SIDL_int__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< int32_t >::deleteRef()'"
        ));
      }
      SIDL_int__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( int32_t * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_int__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const int32_t* first() const throw() {
      return const_cast<const int32_t*>(SIDL_int__array_first( _get_ior() ) );
    }

    int32_t* first() throw() {
      return SIDL_int__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_int__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< int32_t >& src )  throw() {
      SIDL_int__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_int__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< int32_t >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_int__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_int__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_int__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_int__array_get(d_array, ind);
    }

    // set
    void set(int32_t i, int32_t element) {
      SIDLArrayElem1(d_array,i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t element) {
      SIDLArrayElem2(d_array,i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t element) {
      SIDLArrayElem3(d_array,i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t element) {
      SIDLArrayElem4(d_array,i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t element) {
      SIDLArrayElem5(d_array,i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t element) {
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, int32_t element) {
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], int32_t element ) {
      SIDL_int__array_set(d_array,ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<int64_t>
  template<>
  struct array_traits<int64_t> { 
    typedef array<int64_t>                            cxx_array_t;
    typedef int64_t                               cxx_item_t;
    typedef struct SIDL_long__array                       ior_array_t;
    typedef struct SIDL_long__array                       ior_array_internal_t;
    typedef int64_t                               ior_item_t;
    typedef const int64_t*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<int64_t> >       iterator;
    typedef const_array_iter< array_traits<int64_t> > const_iterator;
  };

  // template specialization for array<int64_t>
  template<> 
  class array< int64_t > 
    : public array_mixin< array_traits<int64_t> >
  { 
  public:
    typedef array_mixin< array_traits<int64_t> >        Base;
    typedef array_traits<int64_t>::cxx_array_t          cxx_array_t;
    typedef array_traits<int64_t>::cxx_item_t           cxx_item_t;
    typedef array_traits<int64_t>::ior_array_t          ior_array_t;
    typedef array_traits<int64_t>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<int64_t>::ior_item_t           ior_item_t;
    typedef array_traits<int64_t>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< int64_t >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< int64_t >(SIDL_long__array_createRow(dimen, lower, upper) );
    }
    
    static array< int64_t >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< int64_t >( SIDL_long__array_createCol(dimen, lower, upper) );
    }
    
    static array< int64_t >
    create1d(int32_t len) throw() {
      return array< int64_t >(SIDL_long__array_create1d( len ) );
    }

    static array< int64_t >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< int64_t >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< int64_t >(SIDL_long__array_create1dInit( len, data ) );
    }

    static array< int64_t >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< int64_t > ( SIDL_long__array_create2dCol(m,n) );
    }

    static array< int64_t >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< int64_t > ( SIDL_long__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< int64_t >::addRef()'"
        ));
      }
      SIDL_long__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< int64_t >::deleteRef()'"
        ));
      }
      SIDL_long__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( int64_t * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_long__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const int64_t* first() const throw() {
      return const_cast<const int64_t*>(SIDL_long__array_first( _get_ior() ) );
    }

    int64_t* first() throw() {
      return SIDL_long__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_long__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< int64_t >& src )  throw() {
      SIDL_long__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_long__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< int64_t >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_long__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_long__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_long__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_long__array_get(d_array, ind);
    }

    // set
    void set(int32_t i, int64_t element) {
      SIDLArrayElem1(d_array,i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int64_t element) {
      SIDLArrayElem2(d_array,i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int64_t element) {
      SIDLArrayElem3(d_array,i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int64_t element) {
      SIDLArrayElem4(d_array,i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int64_t element) {
      SIDLArrayElem5(d_array,i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int64_t element) {
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, int64_t element) {
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], int64_t element ) {
      SIDL_long__array_set(d_array,ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<float>
  template<>
  struct array_traits<float> { 
    typedef array<float>                            cxx_array_t;
    typedef float                               cxx_item_t;
    typedef struct SIDL_float__array                       ior_array_t;
    typedef struct SIDL_float__array                       ior_array_internal_t;
    typedef float                               ior_item_t;
    typedef const float*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<float> >       iterator;
    typedef const_array_iter< array_traits<float> > const_iterator;
  };

  // template specialization for array<float>
  template<> 
  class array< float > 
    : public array_mixin< array_traits<float> >
  { 
  public:
    typedef array_mixin< array_traits<float> >        Base;
    typedef array_traits<float>::cxx_array_t          cxx_array_t;
    typedef array_traits<float>::cxx_item_t           cxx_item_t;
    typedef array_traits<float>::ior_array_t          ior_array_t;
    typedef array_traits<float>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<float>::ior_item_t           ior_item_t;
    typedef array_traits<float>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< float >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< float >(SIDL_float__array_createRow(dimen, lower, upper) );
    }
    
    static array< float >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< float >( SIDL_float__array_createCol(dimen, lower, upper) );
    }
    
    static array< float >
    create1d(int32_t len) throw() {
      return array< float >(SIDL_float__array_create1d( len ) );
    }

    static array< float >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< float >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< float >(SIDL_float__array_create1dInit( len, data ) );
    }

    static array< float >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< float > ( SIDL_float__array_create2dCol(m,n) );
    }

    static array< float >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< float > ( SIDL_float__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< float >::addRef()'"
        ));
      }
      SIDL_float__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< float >::deleteRef()'"
        ));
      }
      SIDL_float__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( float * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_float__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const float* first() const throw() {
      return const_cast<const float*>(SIDL_float__array_first( _get_ior() ) );
    }

    float* first() throw() {
      return SIDL_float__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_float__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< float >& src )  throw() {
      SIDL_float__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_float__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< float >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_float__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_float__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_float__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_float__array_get(d_array, ind);
    }

    // set
    void set(int32_t i, float element) {
      SIDLArrayElem1(d_array,i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, float element) {
      SIDLArrayElem2(d_array,i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, float element) {
      SIDLArrayElem3(d_array,i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, float element) {
      SIDLArrayElem4(d_array,i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, float element) {
      SIDLArrayElem5(d_array,i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, float element) {
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, float element) {
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], float element ) {
      SIDL_float__array_set(d_array,ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<double>
  template<>
  struct array_traits<double> { 
    typedef array<double>                            cxx_array_t;
    typedef double                               cxx_item_t;
    typedef struct SIDL_double__array                       ior_array_t;
    typedef struct SIDL_double__array                       ior_array_internal_t;
    typedef double                               ior_item_t;
    typedef const double*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<double> >       iterator;
    typedef const_array_iter< array_traits<double> > const_iterator;
  };

  // template specialization for array<double>
  template<> 
  class array< double > 
    : public array_mixin< array_traits<double> >
  { 
  public:
    typedef array_mixin< array_traits<double> >        Base;
    typedef array_traits<double>::cxx_array_t          cxx_array_t;
    typedef array_traits<double>::cxx_item_t           cxx_item_t;
    typedef array_traits<double>::ior_array_t          ior_array_t;
    typedef array_traits<double>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<double>::ior_item_t           ior_item_t;
    typedef array_traits<double>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< double >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< double >(SIDL_double__array_createRow(dimen, lower, upper) );
    }
    
    static array< double >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< double >( SIDL_double__array_createCol(dimen, lower, upper) );
    }
    
    static array< double >
    create1d(int32_t len) throw() {
      return array< double >(SIDL_double__array_create1d( len ) );
    }

    static array< double >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< double >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< double >(SIDL_double__array_create1dInit( len, data ) );
    }

    static array< double >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< double > ( SIDL_double__array_create2dCol(m,n) );
    }

    static array< double >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< double > ( SIDL_double__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< double >::addRef()'"
        ));
      }
      SIDL_double__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< double >::deleteRef()'"
        ));
      }
      SIDL_double__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( double * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_double__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const double* first() const throw() {
      return const_cast<const double*>(SIDL_double__array_first( _get_ior() ) );
    }

    double* first() throw() {
      return SIDL_double__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_double__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< double >& src )  throw() {
      SIDL_double__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_double__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< double >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_double__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_double__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_double__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_double__array_get(d_array, ind);
    }

    // set
    void set(int32_t i, double element) {
      SIDLArrayElem1(d_array,i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, double element) {
      SIDLArrayElem2(d_array,i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, double element) {
      SIDLArrayElem3(d_array,i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, double element) {
      SIDLArrayElem4(d_array,i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, double element) {
      SIDLArrayElem5(d_array,i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, double element) {
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, double element) {
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], double element ) {
      SIDL_double__array_set(d_array,ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<fcomplex>
  template<>
  struct array_traits<fcomplex> { 
    typedef array<fcomplex>                            cxx_array_t;
    typedef fcomplex                               cxx_item_t;
    typedef struct SIDL_fcomplex__array                       ior_array_t;
    typedef struct SIDL_fcomplex__array                       ior_array_internal_t;
    typedef struct SIDL_fcomplex                               ior_item_t;
    typedef const struct SIDL_fcomplex*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type            const_reference;
    typedef array_iter< array_traits<fcomplex> >       iterator;
    typedef const_array_iter< array_traits<fcomplex> > const_iterator;
  };

  // template specialization for array<fcomplex>
  template<> 
  class array< fcomplex > 
    : public array_mixin< array_traits<fcomplex> >
  { 
  public:
    typedef array_mixin< array_traits<fcomplex> >        Base;
    typedef array_traits<fcomplex>::cxx_array_t          cxx_array_t;
    typedef array_traits<fcomplex>::cxx_item_t           cxx_item_t;
    typedef array_traits<fcomplex>::ior_array_t          ior_array_t;
    typedef array_traits<fcomplex>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<fcomplex>::ior_item_t           ior_item_t;
    typedef array_traits<fcomplex>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< fcomplex >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< fcomplex >(SIDL_fcomplex__array_createRow(dimen, lower, upper) );
    }
    
    static array< fcomplex >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< fcomplex >( SIDL_fcomplex__array_createCol(dimen, lower, upper) );
    }
    
    static array< fcomplex >
    create1d(int32_t len) throw() {
      return array< fcomplex >(SIDL_fcomplex__array_create1d( len ) );
    }

    static array< fcomplex >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< fcomplex >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< fcomplex >(SIDL_fcomplex__array_create1dInit( len, data ) );
    }

    static array< fcomplex >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< fcomplex > ( SIDL_fcomplex__array_create2dCol(m,n) );
    }

    static array< fcomplex >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< fcomplex > ( SIDL_fcomplex__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< fcomplex >::addRef()'"
        ));
      }
      SIDL_fcomplex__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< fcomplex >::deleteRef()'"
        ));
      }
      SIDL_fcomplex__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( struct SIDL_fcomplex * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_fcomplex__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const struct SIDL_fcomplex* first() const throw() {
      return const_cast<const struct SIDL_fcomplex*>(SIDL_fcomplex__array_first( _get_ior() ) );
    }

    struct SIDL_fcomplex* first() throw() {
      return SIDL_fcomplex__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_fcomplex__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< fcomplex >& src )  throw() {
      SIDL_fcomplex__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_fcomplex__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< fcomplex >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_fcomplex__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_fcomplex__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_fcomplex__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem1(d_array,i);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem2(d_array,i,j);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem3(d_array,i,j,k);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem4(d_array,i,j,k,l);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem5(d_array,i,j,k,l,m);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem6(d_array,i,j,k,l,m,n);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      SIDL_fcomplex _local_result =
         SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      SIDL_fcomplex _local_result =
         SIDL_fcomplex__array_get(d_array, ind);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // set
    void set(int32_t i, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem1(d_array,i) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem2(d_array,i,j) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem3(d_array,i,j,k) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem4(d_array,i,j,k,l) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem5(d_array,i,j,k,l,m) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, fcomplex element) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = _local_element;
    }

    void set(int32_t ind[], fcomplex element ) {
      SIDL_fcomplex _local_element = { element.real(), element.imag() };
      SIDL_fcomplex__array_set(d_array,ind,_local_element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      SIDL_fcomplex _local_result =
         SIDLArrayElem1(d_array,i);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<dcomplex>
  template<>
  struct array_traits<dcomplex> { 
    typedef array<dcomplex>                            cxx_array_t;
    typedef dcomplex                               cxx_item_t;
    typedef struct SIDL_dcomplex__array                       ior_array_t;
    typedef struct SIDL_dcomplex__array                       ior_array_internal_t;
    typedef struct SIDL_dcomplex                               ior_item_t;
    typedef const struct SIDL_dcomplex*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type            const_reference;
    typedef array_iter< array_traits<dcomplex> >       iterator;
    typedef const_array_iter< array_traits<dcomplex> > const_iterator;
  };

  // template specialization for array<dcomplex>
  template<> 
  class array< dcomplex > 
    : public array_mixin< array_traits<dcomplex> >
  { 
  public:
    typedef array_mixin< array_traits<dcomplex> >        Base;
    typedef array_traits<dcomplex>::cxx_array_t          cxx_array_t;
    typedef array_traits<dcomplex>::cxx_item_t           cxx_item_t;
    typedef array_traits<dcomplex>::ior_array_t          ior_array_t;
    typedef array_traits<dcomplex>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<dcomplex>::ior_item_t           ior_item_t;
    typedef array_traits<dcomplex>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< dcomplex >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< dcomplex >(SIDL_dcomplex__array_createRow(dimen, lower, upper) );
    }
    
    static array< dcomplex >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< dcomplex >( SIDL_dcomplex__array_createCol(dimen, lower, upper) );
    }
    
    static array< dcomplex >
    create1d(int32_t len) throw() {
      return array< dcomplex >(SIDL_dcomplex__array_create1d( len ) );
    }

    static array< dcomplex >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< dcomplex >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< dcomplex >(SIDL_dcomplex__array_create1dInit( len, data ) );
    }

    static array< dcomplex >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< dcomplex > ( SIDL_dcomplex__array_create2dCol(m,n) );
    }

    static array< dcomplex >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< dcomplex > ( SIDL_dcomplex__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< dcomplex >::addRef()'"
        ));
      }
      SIDL_dcomplex__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< dcomplex >::deleteRef()'"
        ));
      }
      SIDL_dcomplex__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( struct SIDL_dcomplex * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_dcomplex__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const struct SIDL_dcomplex* first() const throw() {
      return const_cast<const struct SIDL_dcomplex*>(SIDL_dcomplex__array_first( _get_ior() ) );
    }

    struct SIDL_dcomplex* first() throw() {
      return SIDL_dcomplex__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_dcomplex__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< dcomplex >& src )  throw() {
      SIDL_dcomplex__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_dcomplex__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< dcomplex >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_dcomplex__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_dcomplex__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_dcomplex__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem1(d_array,i);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem2(d_array,i,j);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem3(d_array,i,j,k);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem4(d_array,i,j,k,l);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem5(d_array,i,j,k,l,m);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem6(d_array,i,j,k,l,m,n);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      SIDL_dcomplex _local_result =
         SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      SIDL_dcomplex _local_result =
         SIDL_dcomplex__array_get(d_array, ind);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // set
    void set(int32_t i, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem1(d_array,i) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem2(d_array,i,j) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem3(d_array,i,j,k) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem4(d_array,i,j,k,l) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem5(d_array,i,j,k,l,m) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, dcomplex element) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = _local_element;
    }

    void set(int32_t ind[], dcomplex element ) {
      SIDL_dcomplex _local_element = { element.real(), element.imag() };
      SIDL_dcomplex__array_set(d_array,ind,_local_element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      SIDL_dcomplex _local_result =
         SIDLArrayElem1(d_array,i);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<opaque>
  template<>
  struct array_traits<opaque> { 
    typedef array<opaque>                            cxx_array_t;
    typedef void*                               cxx_item_t;
    typedef struct SIDL_opaque__array                       ior_array_t;
    typedef struct SIDL_opaque__array                       ior_array_internal_t;
    typedef void*                               ior_item_t;
    typedef void*const*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef value_type&                  reference;
    typedef const value_type*                        const_pointer;
    typedef const value_type&            const_reference;
    typedef array_iter< array_traits<opaque> >       iterator;
    typedef const_array_iter< array_traits<opaque> > const_iterator;
  };

  // template specialization for array<opaque>
  template<> 
  class array< opaque > 
    : public array_mixin< array_traits<opaque> >
  { 
  public:
    typedef array_mixin< array_traits<opaque> >        Base;
    typedef array_traits<opaque>::cxx_array_t          cxx_array_t;
    typedef array_traits<opaque>::cxx_item_t           cxx_item_t;
    typedef array_traits<opaque>::ior_array_t          ior_array_t;
    typedef array_traits<opaque>::ior_array_internal_t ior_array_internal_t;
    typedef array_traits<opaque>::ior_item_t           ior_item_t;
    typedef array_traits<opaque>::ior_item_internal_t  ior_item_internal_t;

    array(ior_array_t* src=0) : Base(src) {}

    array(const array &src)
    {
      d_array = src.d_array;
      if (d_array) addRef();
    }

    // assignment operator
    array& 
    operator=(const array& rhs) {
      if ( d_array != rhs.d_array ) {
        if ( d_array ) { deleteRef(); }
        d_array=rhs.d_array;
        if ( d_array ) { addRef(); }
      }
      return *this;
    }

    // must be included to make sure deleteRef is instantiated
    virtual ~array() { if (d_array) deleteRef(); }

    // static constructor: createRow
    static array< opaque >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< opaque >(SIDL_opaque__array_createRow(dimen, lower, upper) );
    }
    
    static array< opaque >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< opaque >( SIDL_opaque__array_createCol(dimen, lower, upper) );
    }
    
    static array< opaque >
    create1d(int32_t len) throw() {
      return array< opaque >(SIDL_opaque__array_create1d( len ) );
    }

    static array< opaque >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< opaque >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< opaque >(SIDL_opaque__array_create1dInit( len, data ) );
    }

    static array< opaque >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< opaque > ( SIDL_opaque__array_create2dCol(m,n) );
    }

    static array< opaque >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< opaque > ( SIDL_opaque__array_create2dRow(m,n) );
    }

    virtual void addRef() throw ( NullIORException ) {
      if ( d_array == 0 ) { 
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< opaque >::addRef()'"
        ));
      }
      SIDL_opaque__array_addRef( d_array );
    }

    virtual void deleteRef() throw ( NullIORException ) {
      if ( d_array == 0 ) {
        throw NullIORException( ::std::string(
          "Null IOR Pointer in 'array< opaque >::deleteRef()'"
        ));
      }
      SIDL_opaque__array_deleteRef( d_array );
      d_array = 0;
    }
       
    // borrow
    void borrow( void* * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (d_array) deleteRef();
      d_array = SIDL_opaque__array_borrow(first_element, dimen, lower,
                                        upper, stride);
    }

    const void** first() const throw() {
      return const_cast<const void**>(SIDL_opaque__array_first( _get_ior() ) );
    }

    void** first() throw() {
      return SIDL_opaque__array_first( _get_ior() );
    }

    // smartCopy
    void smartCopy( ) throw () {
       ior_array_t* p = SIDL_opaque__array_smartCopy( _get_ior() );
       _set_ior( p );
    }
    
    void copy( const array< opaque >& src )  throw() {
      SIDL_opaque__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = SIDL_opaque__array_ensure( _get_ior(), dimen, (SIDL_array_ordering) ordering );
      _set_ior( p );
    }

    array< opaque >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  SIDL_opaque__array_slice( d_array, dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // isColumnOrder
    bool isColumnOrder() const {
      return SIDL_opaque__array_isColumnOrder( d_array ) == TRUE;
    }

    // isRowOrder
    bool isRowOrder() const {
      return SIDL_opaque__array_isRowOrder( d_array ) == TRUE;
    }

    // get dimension
    int32_t dimen() const { 
      return SIDLArrayDim(d_array);
    }
    
    // get lower bound along particular dimension
    int32_t lower( int32_t d ) const {
      return SIDLLower(d_array, d);
    } 
    
    // get upper bound along particular dimension
    int32_t upper( int32_t d ) const {
      return SIDLUpper(d_array, d);
    }
    
    // get stride along particular dimension
    int32_t stride( int32_t d ) const {
      return SIDLStride(d_array, d);
    }

    // get
    cxx_item_t get(int32_t i) const {
      return SIDLArrayElem1(d_array,i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return SIDLArrayElem2(d_array,i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return SIDLArrayElem3(d_array,i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return SIDLArrayElem4(d_array,i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return SIDLArrayElem5(d_array,i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return SIDLArrayElem6(d_array,i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return SIDLArrayElem7(d_array,i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return SIDL_opaque__array_get(d_array, ind);
    }

    // set
    void set(int32_t i, void* element) {
      SIDLArrayElem1(d_array,i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, void* element) {
      SIDLArrayElem2(d_array,i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, void* element) {
      SIDLArrayElem3(d_array,i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, void* element) {
      SIDLArrayElem4(d_array,i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, void* element) {
      SIDLArrayElem5(d_array,i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, void* element) {
      SIDLArrayElem6(d_array,i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, void* element) {
      SIDLArrayElem7(d_array,i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], void* element ) {
      SIDL_opaque__array_set(d_array,ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return SIDLArrayElem1(d_array,i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

}

#endif // defined included_SIDL_cxx_hh
