// 
// File:        StringTest.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.3 $
// Date:        $Date: 2002/07/25 16:03:14 $
// Description: string regression test case for Java calling other languages
// 

/**
 * The following class runs the string regression test cases for Java.
 */
public class StringTest {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {
      /*
       * Begin the test
       */
      System.out.println("NPARTS -1");

      s_part   = 0;
      s_result = PASS;

      /*
       * Run the string tests
       */

      String             in    = "Three";
      SIDL.String.Holder out   = new SIDL.String.Holder();
      SIDL.String.Holder inout = new SIDL.String.Holder("Three");
      String             rbr   = null;

      Strings.Cstring obj = new Strings.Cstring();

      check(PASS,
            (obj.returnback(true).equals("Three")),
           "(obj.returnback(true).equals(\"Three\"))");
      rbr = obj.returnback(false);
      check(PASS,
            ((rbr == null) || rbr.equals("")),
           "(obj.returnback(false) == null)");
      check(PASS,
            (obj.passin(in) == true),
           "(obj.passin(in) == true)");
      check(PASS,
            (obj.passin(null) == false),
           "(obj.passin(null) == false)");
      check(PASS,
            (obj.passout(true,out) == true && out.get().equals("Three")),
           "(obj.passout(true,out) == true && out.get().equals(\"Three\"))");
      check(PASS,
            (obj.passinout(inout) == true && inout.get().equals("threes")),
           "(obj.passinout(inout) == true && inout.get().equals(\"threes\"))");
      check(PASS,
            (obj.passeverywhere(in , out, inout).equals("Three")
          && out.get().equals("Three")
          && inout.get().equals("Three")),
           "(obj.passeverywhere(in, out, inout).equals(\"Three\")"
      + " && out.get().equals(\"Three\")"
      + " && inout.get().equals(\"Three\"))");
      check(PASS,
            (obj.mixedarguments("Test", 'z', "Test", 'z')),
           "(obj.mixedarguments(\"Test\", 'z', \"Test\", 'z'))");
      check(PASS,
            (!obj.mixedarguments("Not", 'A', "Equal", 'a')),
           "(!obj.mixedarguments(\"Not\", 'A', \"Equal\", 'a'))");

      /*
       * Output final test results
       */

      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    /*
     * Catch any unexpected exceptions and return a test failure
     */
    } catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
