!
! File:       sorttest.f90
! Copyright:  (c) 2002 The Regents of the University of California
! Release:    $Name: release-0-8-8 $
! Revision:   @(#) $Revision: 1.9 $
! Date:       $Date: 2003/09/03 15:09:27 $
! Description:Exercise the FORTRAN interface for sorting
!
!
#include "sort_SortingAlgorithm_fAbbrev.h"
#include "sort_MergeSort_fAbbrev.h"
#include "sort_QuickSort_fAbbrev.h"
#include "sort_HeapSort_fAbbrev.h"
#include "sort_SortTest_fAbbrev.h"

subroutine starttest(number)
  implicit none
  integer (selected_int_kind(9)) :: number
  write (6, 100) number
100 format ('PART ', I4)
end subroutine starttest

subroutine reporttest(test, number, pass, fail)
  implicit none
  integer (selected_int_kind(9)) :: number, pass, fail
  logical                        :: test
  if (test) then
     write (6, 100) number, 'PASS'
     pass = pass + 1
  else
     write (6, 100) number, 'FAIL'
     fail = fail + 1
  endif
100 format ('RESULT', 1x, i2, 1x, A4)
  number = number + 1
end subroutine reporttest

subroutine testsort(test, pass, fail)
  use sort_SortingAlgorithm
  use sort_QuickSort
  use sort_HeapSort
  use sort_MergeSort
  use sort_SortTest
  use sort_SortingAlgorithm_array
  implicit none
  type(sort_SortingAlgorithm_1d) :: algs
  type(sort_SortingAlgorithm_t) :: alg
  type(sort_MergeSort_t) :: merge
  type(sort_HeapSort_t) :: heap
  type(sort_QuickSort_t) :: quick
  integer (selected_int_kind(9))  :: test, pass, fail
  logical                         :: retval

  call create1d(3, algs)
  call starttest(test)
  call new(merge)
  call reporttest(not_null(merge), test, pass, fail)
  call starttest(test)
  call new(quick)
  call reporttest(not_null(quick), test, pass, fail)
  call starttest(test)
  call new(heap)
  call reporttest(not_null(heap), test, pass, fail)

  call cast(merge, alg)
  call set(algs, 0, alg)
  call cast(heap, alg)
  call set(algs, 1, alg)
  call cast(quick, alg)
  call set(algs, 2, alg)
  ! remove extraneous references
  call deleteRef(merge)
  call deleteRef(quick)
  call deleteRef(heap)

  call starttest(test)
  call stressTest(algs, retval)
  call reporttest(retval, test, pass, fail)
  call deleteRef(algs)
end subroutine testsort

program sorttest
  implicit none
  integer (selected_int_kind(9)) :: test, pass, fail
  test = 1
  pass = 0
  fail = 0
  write(6,120) 4
  write(6,110) 'Sort tests'
  call testsort(test, pass, fail)
  if ((fail .eq. 0) .and. (pass .eq. 4)) then
     write(6, 100) 'PASS'
  else
     write(6, 100) 'FAIL'
  endif
100 format ('TEST_RESULT', 1x, a4)
110 format ('COMMENT:', 1x, a20)
120 format ('NPARTS', 1x, i4)
end program sorttest
