/*
 * File:        sorttest.cc
 * Copyright:   (c) 2002 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.4 $
 * Date:        $Date: 2002/08/12 15:12:08 $
 * Description: Simple C++ driver for the sort regression test
 *
 */

#include <iostream>
#include <stdlib.h>
#include <time.h>

#include "sort_SortTest.hh"
#include "sort_MergeSort.hh"
#include "sort_QuickSort.hh"
#include "sort_HeapSort.hh"
#include "sort_SortingAlgorithm.hh"

const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}


#define MYASSERT( AAA ) \
  magicNumber = clearstack(magicNumber); \
  declare_part( &part_no ); \
  std::cout << "COMMENT: " <<  #AAA << std::endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  magicNumber = clearstack(magicNumber); \
  declare_part( &part_no ); \
  std::cout << "COMMENT: " << #AAA << std::endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  magicNumber = clearstack(magicNumber); \
  declare_part( &part_no ); \
  std::cout << "COMMENT: " << #AAA << std::endl; \
  end_part( part_no, unsupported, &final_result );

int main(int argc, char **argv)
{
  int magicNumber = 1;
  int result = pass;
  int final_result = pass;
  int part_no = 0;
  sort::MergeSort merge = sort::MergeSort::_create();
  sort::QuickSort quick = sort::QuickSort::_create();
  sort::HeapSort heap = sort::HeapSort::_create();
  SIDL::array<sort::SortingAlgorithm> algs = SIDL::array<sort::SortingAlgorithm>::create1d(3);
  srandom(time(NULL));
  std::cout << "NPARTS 4\n";
  MYASSERT(merge._not_nil());
  MYASSERT(quick._not_nil());
  MYASSERT(heap._not_nil());
  algs.set(0, merge);
  algs.set(1, quick);
  algs.set(2, heap);
  MYASSERT(sort::SortTest::stressTest(algs));  
  std::cout << "TEST_RESULT " << result_string[ final_result ] << std::endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  std::cout << "PART " << *part_no << std::endl;
}

void end_part( int part_no, int result, int *final_result ) {
  std::cout << "RESULT " << part_no << " " << result_string[ result ] << std::endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

