! 
! File:          sort_QuickSort_Impl.F90
! Symbol:        sort.QuickSort-v0.1
! Symbol Type:   class
! Babel Version: 0.8.8
! Description:   Server-side implementation for sort.QuickSort
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.8.8
! 


! 
! Symbol "sort.QuickSort" (version 0.1)
! 
! Quick sort
! 


#include "sort_Counter_fAbbrev.h"
#include "sort_SortingAlgorithm_fAbbrev.h"
#include "sort_QuickSort_fAbbrev.h"
#include "SIDL_BaseInterface_fAbbrev.h"
#include "SIDL_BaseClass_fAbbrev.h"
#include "sort_Comparator_fAbbrev.h"
#include "SIDL_ClassInfo_fAbbrev.h"
#include "sort_Container_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
#include "sort_MergeSort_fAbbrev.h"


logical function notEmpty(self)
  use sort_QuickSort
  use sort_QuickSort_impl
  implicit none
  type(sort_QuickSort_t) :: self
  type(sort_QuickSort_wrap) :: dp
  call sort_QuickSort__get_data_m(self, dp)
  notEmpty = (dp%d_private_data%depth .gt. 0)
end function notEmpty

subroutine push(self, low, up)
  use sort_QuickSort
  use sort_QuickSort_impl
  implicit none
  type(sort_QuickSort_t) :: self
  type(sort_QuickSort_wrap) :: dp
  integer(selected_int_kind(9)) low, up
  call sort_QuickSort__get_data_m(self, dp)
  if (dp%d_private_data%depth .lt. 32) then
     call set(dp%d_private_data%lower, dp%d_private_data%depth, low)
     call set(dp%d_private_data%upper, dp%d_private_data%depth, up)
     dp%d_private_data%depth = dp%d_private_data%depth + 1
  else
     write(*,*) 'ERROR: stack overflow in QuickSort', &
          dp%d_private_data%depth
     stop
  endif
end subroutine push

subroutine pop(self, low, up)
  use sort_QuickSort
  use sort_QuickSort_impl
  implicit none
  type(sort_QuickSort_t) :: self
  integer(selected_int_kind(9)) low, up, stackdepth
  type(sort_QuickSort_wrap) :: dp
  call sort_QuickSort__get_data_m(self, dp)
  if (dp%d_private_data%depth .gt. 0) then
     dp%d_private_data%depth = dp%d_private_data%depth - 1
     stackdepth = dp%d_private_data%depth
     call get(dp%d_private_data%lower, stackdepth, low)
     call get(dp%d_private_data%upper, stackdepth, up)
  else
     write(*,*) 'ERROR: stack underflow in QuickSort'
     stop
  endif
end subroutine pop

!
! Choose the middle of the first, middle and last element of the
! list.  For small lists, return the middle without checking.
!
integer(selected_int_kind(9)) function choosePivot(elems, comp, cmp, start, end)
  use sort_Container
  use sort_Comparator
  use sort_Counter
  implicit none
  type(sort_Container_t) :: elems
  type(sort_Comparator_t) :: comp
  type(sort_Counter_t) cmp
  integer(selected_int_kind(9)) start, end, pivot, mid, cmpres, counter
  pivot = (start + end) / 2
  if ((end - start) .gt. 4) then
     mid = pivot
     call inc(cmp, counter)
     call compare(elems, start, mid, comp, cmpres)
     if (cmpres .le. 0) then
        call inc(cmp, counter)
        call compare(elems, mid, end -1, comp, cmpres)
        if (cmpres .gt. 0) then
           call inc(cmp, counter)
           call compare(elems, start, end - 1, comp, &
                cmpres)
           if (cmpres .lt. 0) then
              pivot = end - 1
           else
              pivot = start
           endif
        endif
     else
        call inc(cmp, counter)
        call compare(elems, mid, end - 1, comp, cmpres)
        if (cmpres .lt. 0) then
           call inc(cmp, counter)
           call compare(elems, start, end - 1, comp, &
                cmpres)
           if (cmpres .gt. 0) then
              pivot = end - 1
           else
              pivot = start
           endif
        endif
     endif
  endif
  choosePivot = pivot
end function choosePivot

subroutine quickSort(self, elems, comp, cmp, swp)
  use sort_QuickSort
  use sort_Container
  use sort_Comparator
  use sort_Counter
  implicit none
  type(sort_QuickSort_t) :: self
  type(sort_Container_t) :: elems
  type(sort_Comparator_t) :: comp
  type(sort_Counter_t) :: cmp, swp
  integer(selected_int_kind(9)) start, end, pivot, choosePivot
  integer(selected_int_kind(9)) i, j, cmpres, counter
  logical notEmpty
  call getLength(elems, end)
  start = 0
  call push(self, start, end)
  do while (notEmpty(self))
     call pop(self, start, end)
     if ((end - start) .gt. 1) then
        pivot = choosePivot(elems, comp, cmp, start, end)
        i = start
        j = end
        if (pivot .ne. start) then
           call inc(swp, counter)
           call swap(elems, start, pivot)
        endif
100     j = j - 1
        call inc(cmp, counter)
        call compare(elems, start, j, comp, cmpres)
        if (cmpres .lt. 0) goto 100
        i = i + 1
        do while (i .lt. j)
           call inc(cmp, counter)
           call compare(elems, start, i, comp, cmpres)
           if (cmpres .lt. 0) goto 200
           i = i + 1
        enddo
200     if (i .ge. j) goto 300
        call inc(swp, counter)
        call swap(elems, i, j)
        goto 100
300     if (j .ne. start) then
           call inc(swp, counter)
           call swap(elems, start, j)
        endif
        call push(self, start, j)
        call push(self, j + 1, end)
     endif
  enddo
end subroutine quickSort

! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine sort_QuickSort__ctor_mi(self)
  use sort_QuickSort
  use sort_QuickSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.QuickSort._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.QuickSort._ctor.use)
  implicit none
  type(sort_QuickSort_t) :: self

! DO-NOT-DELETE splicer.begin(sort.QuickSort._ctor)
  type(sort_QuickSort_wrap) :: dp
  allocate(dp%d_private_data)
  call create1d(32, dp%d_private_data%lower)
  call create1d(32, dp%d_private_data%upper)
  dp%d_private_data%depth = 0
  call sort_QuickSort__set_data_m(self, dp)
! DO-NOT-DELETE splicer.end(sort.QuickSort._ctor)
end subroutine sort_QuickSort__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine sort_QuickSort__dtor_mi(self)
  use sort_QuickSort
  use sort_QuickSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.QuickSort._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.QuickSort._dtor.use)
  implicit none
  type(sort_QuickSort_t) :: self

! DO-NOT-DELETE splicer.begin(sort.QuickSort._dtor)
  type(sort_QuickSort_wrap) :: dp
  call sort_QuickSort__get_data_m(self, dp)
  call deleteRef(dp%d_private_data%lower)
  call deleteRef(dp%d_private_data%upper)
  deallocate(dp%d_private_data)
! DO-NOT-DELETE splicer.end(sort.QuickSort._dtor)
end subroutine sort_QuickSort__dtor_mi


! 
! Sort elements using Quick Sort.
! 

recursive subroutine sort_QuickSort_sort_mi(self, elems, comp)
  use sort_QuickSort
  use sort_Comparator
  use sort_Container
  use sort_QuickSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.QuickSort.sort.use)
  use sort_Counter
  ! DO-NOT-DELETE splicer.end(sort.QuickSort.sort.use)
  implicit none
  type(sort_QuickSort_t) :: self
  type(sort_Container_t) :: elems
  type(sort_Comparator_t) :: comp

! DO-NOT-DELETE splicer.begin(sort.QuickSort.sort)
  type (sort_Counter_t) :: swp, cmp
  call getCompareCounter(self, cmp)
  call getSwapCounter(self, swp)
  call quickSort(self, elems, comp, cmp, swp)
  call deleteRef(cmp)
  call deleteRef(swp)
! DO-NOT-DELETE splicer.end(sort.QuickSort.sort)
end subroutine sort_QuickSort_sort_mi


! 
! Return quick sort.
! 

recursive subroutine sort_QuickSort_getName_mi(self, retval)
  use sort_QuickSort
  use sort_QuickSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.QuickSort.getName.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.QuickSort.getName.use)
  implicit none
  type(sort_QuickSort_t) :: self
  character (len=*) :: retval

! DO-NOT-DELETE splicer.begin(sort.QuickSort.getName)
  retval = 'Quick sort'
! DO-NOT-DELETE splicer.end(sort.QuickSort.getName)
end subroutine sort_QuickSort_getName_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
