// 
// File:          sort_SortTest_Impl.cc
// Symbol:        sort.SortTest-v0.1
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for sort.SortTest
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 
#include "sort_SortTest_Impl.hh"

// DO-NOT-DELETE splicer.begin(sort.SortTest._includes)
#include <stdlib.h>
#include <iostream>
#include "sort_CompInt.hh"
#include "sort_IntegerContainer.hh"

static const int32_t s_testSizes[] = {
  0,
  1,
  2,
  3,
  4,
  7,
  10,
  51,
  100,
  -1
};

static bool
notSorted(sort::Container  &cont,
          sort::Comparator &comp)
{
  const int32_t length = cont.getLength();
  for(int32_t i = 1 ; i < length ; ++i ){
    if (cont.compare(i-1, i, comp) > 0) return true;
  }
  return false;
}

static void
sortAndReport(sort::SortingAlgorithm &alg,
	      sort::Container        &cont,
	      sort::Comparator       &comp, 
	      bool                   &result)
{
  sort::Counter swpCnt;
  sort::Counter cmpCnt;
  alg.reset();
  alg.sort(cont, comp);
  swpCnt = alg.getSwapCounter();
  cmpCnt = alg.getCompareCounter();
  std::cout << "COMMENT: compares (" << cmpCnt.getCount() << ") swaps ("
	    << swpCnt.getCount() << ")\n";
  if (notSorted(cont, comp)) {
    std::cout << "COMMENT: sort failed!!\n";
    result = false;
  }
}
// DO-NOT-DELETE splicer.end(sort.SortTest._includes)

// user defined constructor
void sort::SortTest_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(sort.SortTest._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.SortTest._ctor)
}

// user defined destructor
void sort::SortTest_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(sort.SortTest._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.SortTest._dtor)
}

// user defined static methods:
/**
 * Perform the array stress test.
 * 
 * Return true if all the algorithms work okay.
 */
bool
sort::SortTest_impl::stressTest (
  /*in*/ ::SIDL::array< ::sort::SortingAlgorithm> algs ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest)
  bool result = false;
  if (algs._not_nil()) {
    const int32_t lower = algs.lower(0);
    const int32_t upper = algs.upper(0);
    int32_t i,j;
    result = true;
    for(i = lower; i <= upper; ++i) {
      sort::SortingAlgorithm alg = algs.get(i);
      if (alg._not_nil()) {
        sort::IntegerContainer data = sort::IntegerContainer::_create();
        sort::Container cont = data;
	sort::CompInt intcomp = sort::CompInt::_create();
        sort::Comparator comp = intcomp;
        std::string name = alg.getName();
        j = 0;
	std::cout <<"COMMENT: ****ALGORITHM IS " << name << "****\n";
        while (s_testSizes[j] >= 0) {
	  intcomp.setSortIncreasing(true);
	  std::cout << "COMMENT: DATA SIZE " << s_testSizes[j] << '\n';
	  data.setLength(s_testSizes[j]);
	  sortAndReport(alg, cont, comp, result);
	  std::cout << "COMMENT: pre-sorted list\n";
	  sortAndReport(alg, cont, comp, result);
          std::cout << "COMMENT: reverse sorted list\n";
          intcomp.setSortIncreasing(false);
	  sortAndReport(alg, cont, comp, result);
          ++j;
        }
      }
      else{
        result = false;
      }
    }
  }
  std::cout.flush();
  return result;
  // DO-NOT-DELETE splicer.end(sort.SortTest.stressTest)
}


// user defined non-static methods: (none)

// DO-NOT-DELETE splicer.begin(sort.SortTest._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.SortTest._misc)

