#include <stdio.h>
#include "objarg_Employee.h"
#include "objarg_EmployeeArray.h"
#include "SIDL_BaseInterface.h"

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  puts("COMMENT: " #AAA); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  puts("COMMENT: " #AAA); \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  puts("COMMENT: " #AAA); \
  end_part( part_no, unsupported, &final_result );

struct TmpData_t {
  char  *name;
  int    age;
  float  salary;
  char   status;
};

struct TmpData_t TmpData[] = {
  { "John Smith", 35, 75.7e3, 'c' },
  { "Jane Doe", 40, 85.5e3, 'm' },
  { "Ella Vader", 64, 144.2e3, 'r' },
  { "Marge Inovera", 32, 483.2e3, 's' },
  { "Hughy Louis Dewey", 45, 182.9e3, 'm' },
  { "Heywood Yubuzof", 12, 20.8e3, 'x' },
  { "Picov Andropov", 90, 120.6e3, 'r' }
};

int main(int argc, char **argv) {
  int result = pass; 
  int final_result = pass;
  int part_no = 0;
  int i, NewRidersFound=0;
  const int numEmp = sizeof(TmpData)/sizeof(struct TmpData_t);
  objarg_EmployeeArray a = objarg_EmployeeArray__create();
  objarg_Employee f;
  puts("NPARTS 78");
  for(i = 0; i < numEmp; ++i) {
    objarg_Employee e = objarg_Employee__create();
    objarg_Employee tmp;
    MYASSERT(objarg_Employee_init(e,
                                  TmpData[i].name, TmpData[i].age, 
                                  TmpData[i].salary, TmpData[i].status));
    MYASSERT(objarg_EmployeeArray_appendEmployee(a, e));
    MYASSERT(objarg_EmployeeArray_getLength(a) == (i+1));
    tmp = objarg_EmployeeArray_at(a, i+1);
    MYASSERT(objarg_Employee_isSame(e, (SIDL_BaseInterface)tmp));
    MYASSERT(objarg_Employee_getAge(e) == TmpData[i].age);
    MYASSERT(objarg_Employee_getSalary(e) == TmpData[i].salary);
    MYASSERT(objarg_Employee_getStatus(e) == TmpData[i].status);
    if (tmp) objarg_Employee_deleteRef(tmp);
    objarg_Employee_deleteRef(e);
  }
  for(i = 0; i < numEmp; ++i) {
    objarg_Employee e;
    objarg_Employee fromArray;
    int empInd = objarg_EmployeeArray_findByName(a, TmpData[i].name, &e);
    MYASSERT(empInd == (i+1));
    if (empInd != 0) {
      fromArray = objarg_EmployeeArray_at(a, empInd);
      MYASSERT(fromArray);
      if (fromArray) {
        MYASSERT(objarg_Employee_isSame(e, (SIDL_BaseInterface)fromArray));
        objarg_Employee_deleteRef(fromArray);
      }
    }
    if (e) objarg_Employee_deleteRef(e);
  }
  f = objarg_Employee__create();
  objarg_Employee_init(f, "Hire High", 21, 0, 's');
  MYASSERT(objarg_EmployeeArray_promoteToMaxSalary(a, &f));
  MYASSERT(f);
  if (f) {
    MYASSERT(objarg_Employee_getSalary(f) == (float)483.2e3);
    MYASSERT(objarg_EmployeeArray_appendEmployee(a, f));
    objarg_Employee_deleteRef(f);
  }
  f = objarg_Employee__create();
  objarg_Employee_init(f, "Amadeo Avogadro, conte di Quaregna",
                       225, 6.022045e23, 'd');
  MYASSERT(!objarg_EmployeeArray_promoteToMaxSalary(a, &f));
  if (f) objarg_Employee_deleteRef(f);
  /*  Adding a NULL employee should fail  */
  MYASSERT(!objarg_EmployeeArray_appendEmployee(a, NULL));
  /* Search for a non-existent employee  */
  NewRidersFound = objarg_EmployeeArray_findByName(a, "New Riders", &f);
  MYASSERT(!(NewRidersFound || f));
  f = NULL;
  MYASSERT(!objarg_EmployeeArray_promoteToMaxSalary(a, &f));
  objarg_EmployeeArray_deleteRef(a);
  printf("TEST_RESULT %s\n", result_string[ final_result ]);
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no);
}

void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[result]);
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}
