// 
// File:        EnumTest.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.2 $
// Date:        $Date: 2002/02/14 19:48:17 $
// Description: enum regression test case for Java calling other languages
// 

/**
 * The following class runs the enum regression test cases for Java.
 */
public class EnumTest {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {
      /*
       * Begin the test
       */
      System.out.println("NPARTS -1");

      s_part   = 0;
      s_result = PASS;

      /*
       * Look at the pretty colors...
       */
      if (true) {
        SIDL.Integer.Holder out   = new SIDL.Integer.Holder(0);
        SIDL.Integer.Holder inout = new SIDL.Integer.Holder(enums.color.green);

        enums.colorwheel obj = new enums.colorwheel();

        check(PASS,
              (obj.returnback() == enums.color.violet),
             "(obj.returnback() == enums.color.violet)");
        check(PASS,
              (obj.passin(enums.color.blue) == true),
             "(obj.passin(enums.color.blue) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == enums.color.violet),
             "(obj.passout(out) == true && out.get() == enums.color.violet)");
        check(PASS,
              (obj.passinout(inout) == true
            && inout.get() == enums.color.red),
             "(obj.passinout(inout) == true "
        + " && inout.get() == enums.color.red)");
        check(PASS,
              (obj.passeverywhere(enums.color.blue, out, inout) ==
                enums.color.violet 
            && out.get() == enums.color.violet
            && inout.get() == enums.color.green),
             "(obj.passeverywhere(enums.color.blue, out, inout) =="
        +     " enums.color.violet"
        + " && out.get() == enums.color.violet"
        + " && inout.get() == enums.color.green)");
      }

      /*
       * I want a porsche - zoom, zoom...
       */
      if (true) {
        SIDL.Integer.Holder out   = new SIDL.Integer.Holder(0);
        SIDL.Integer.Holder inout = new SIDL.Integer.Holder(enums.car.ford);

        enums.cartest obj = new enums.cartest();

        check(PASS,
              (obj.returnback() == enums.car.porsche),
             "(obj.returnback() == enums.car.porsche)");
        check(PASS,
              (obj.passin(enums.car.mercedes) == true),
             "(obj.passin(enums.car.mercedes) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == enums.car.ford),
             "(obj.passout(out) == true && out.get() == enums.car.ford)");
        check(PASS,
              (obj.passinout(inout) == true
            && inout.get() == enums.car.porsche),
             "(obj.passinout(inout) == true "
        + " && inout.get() == enums.car.porsche)");
        check(PASS,
              (obj.passeverywhere(enums.car.mercedes, out, inout) ==
                enums.car.porsche
            && out.get() == enums.car.ford
            && inout.get() == enums.car.mercedes),
             "(obj.passeverywhere(enums.car.mercedes, out, inout) =="
        +     " enums.car.porsche"
        + " && out.get() == enums.car.ford"
        + " && inout.get() == enums.car.mercedes)");
      }

      /*
       * When I started programming, we only had zeros...
       */
      if (true) {
        SIDL.Integer.Holder out   = new SIDL.Integer.Holder(0);
        SIDL.Integer.Holder inout = new SIDL.Integer.Holder(enums.number.zero);

        enums.numbertest obj = new enums.numbertest();

        check(PASS,
              (obj.returnback() == enums.number.notOne),
             "(obj.returnback() == enums.number.notOne)");
        check(PASS,
              (obj.passin(enums.number.notZero) == true),
             "(obj.passin(enums.number.notZero) == true)");
        check(PASS,
              (obj.passout(out) == true && out.get() == enums.number.negOne),
             "(obj.passout(out) == true && out.get() == enums.number.negOne)");
        check(PASS,
              (obj.passinout(inout) == true
            && inout.get() == enums.number.notZero),
             "(obj.passinout(inout) == true "
        + " && inout.get() == enums.number.notZero)");
        check(PASS,
              (obj.passeverywhere(enums.number.notZero, out, inout) ==
                enums.number.notOne
            && out.get() == enums.number.negOne
            && inout.get() == enums.number.zero),
             "(obj.passeverywhere(enums.number.notZero, out, inout) =="
        +     " enums.number.notOne"
        + " && out.get() == enums.number.negOne"
        + " && inout.get() == enums.number.zero)");
      }

      /*
       * Output final test results
       */

      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    /*
     * Catch any unexpected exceptions and return a test failure
     */
    } catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
