
#include <iostream>
using namespace std;
#ifndef included_enums_hh
#include "enums.hh"
#endif

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " <<  #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );

int main() { 
  int result = pass; 
  int final_result = pass;
  int part_no = 0;
  cout << "NPARTS -1" << endl;
  
  { // undefined integer values 
    enums::color out = (enums::color) -5;
    enums::color inout = enums::green;
    enums::colorwheel obj = enums::colorwheel::_create();
 
    MYASSERT( obj.returnback( ) == enums::violet );
    MYASSERT( obj.passin( enums::blue ) == true );
    MYASSERT( obj.passout( out ) == true && out == enums::violet );
    MYASSERT( obj.passinout( inout ) == true && inout == enums::red );
    MYASSERT( obj.passeverywhere( enums::blue, out, inout ) == enums::violet &&
	      out == enums::violet && inout == enums::green );    
  } 

  { // fully defined integer values 
    enums::car out = (enums::car) -5;
    enums::car inout = enums::ford;
    enums::cartest obj = enums::cartest::_create();
 
    MYASSERT( obj.returnback( ) == enums::porsche );
    MYASSERT( obj.passin( enums::mercedes ) == true );
    MYASSERT( obj.passout( out ) == true && out == enums::ford );
    MYASSERT( obj.passinout( inout ) == true && inout == enums::porsche );
    MYASSERT( obj.passeverywhere( enums::mercedes, out, inout ) == enums::porsche &&
	      out == enums::ford && inout == enums::mercedes );
  }


  { // partially defined integer values
    enums::number out = (enums::number) -5;
    enums::number inout = enums::zero;
    enums::numbertest obj = enums::numbertest::_create();
 
    MYASSERT( obj.returnback( ) == enums::notOne );
    MYASSERT( obj.passin( enums::notZero ) == true );
    MYASSERT( obj.passout( out ) == true && out == enums::negOne );
    MYASSERT( obj.passinout( inout ) == true && inout == enums::notZero );
    MYASSERT( obj.passeverywhere( enums::notZero, out, inout ) == enums::notOne &&
	      out == enums::negOne && inout == enums::zero );
  }

  {
    const int32_t numElem[] = { 2 };
    const int32_t stride[] = { 2 };
    SIDL::array<enums::car> enumArray = SIDL::array<enums::car>::create1d(4);
    SIDL::array<enums::car> tmpArray;
    MYASSERT(enumArray);
    enumArray.set(0, enums::porsche);
    enumArray.set(1, enums::ford);
    enumArray.set(2, enums::mercedes);
    enumArray.set(3, enums::porsche);
    MYASSERT(enums::porsche == enumArray.get(0));
    MYASSERT(enums::porsche == enumArray.get(3));
    MYASSERT(enums::ford == enumArray.get(1));
    tmpArray = enumArray;
    MYASSERT(tmpArray);
    tmpArray = tmpArray.slice(1, numElem, 0, stride);
    MYASSERT(enums::porsche == tmpArray.get(0));
    MYASSERT(enums::mercedes == tmpArray.get(1));
    tmpArray.smartCopy();
    MYASSERT(tmpArray);
    MYASSERT(enums::porsche == tmpArray.get(0));
    MYASSERT(enums::mercedes == tmpArray.get(1));
  }

  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

