// 
// File:        arraytests.cc
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.20 $
// Date:        $Date: 2003/08/19 23:17:07 $
// Description: Simple test on the ArrayTest static methods
// 
// 

#include <iostream>
using namespace std;

#include "ArrayTest_ArrayOps.hh"
using ArrayTest::ArrayOps;

const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

static const int TEST_SIZE = 345; /* size of one dimensional arrays */
static const int TEST_DIM1 = 17; /* first dimension of 2-d arrays */
static const int TEST_DIM2 = 13; /* second dimension of 2-d arrays */

void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


#define MYASSERT( CMT, AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #CMT << ": " << #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );


/*
static double powTwo(register int32_t i)
{
  register double result = 1;
  if (i >= 0) {
    while (i--) {
      result *= 2;
    }
  }
  else {
    while (i++) {
      result *= 0.5;
    }
  }
  return result;
}

static float fpowTwo(register int32_t i)
{
  register float result = 1;
  static volatile float forcestore;
  if (i >= 0) {
    while (i--) {
      result *= 2.0F;
    }
  }
  else {
    while (i++) {
      result *= 0.5F;
    }
  }
  forcestore = result;
  return forcestore;
}

static SIDL::array<double>
makeDTestMatrix(int32_t rows, int32_t cols) {
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {rows-1, cols-1};
  SIDL::array<double> result = SIDL::array<double>::createRow(2,lower,upper);
  for( int32_t i=0; i<rows; ++i ) {
    for( int32_t j=0;  j<cols; ++j ) {
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = powTwo(i-j);
        break;
      case 1:
        SIDL_double__array_set2(result._get_ior(), i, j, powTwo(i-j));
        break;
      case 2:
        result.set(i, j, powTwo(i-j));
        break;
      }
    }
  }
  return result;
}

static SIDL::array<float>
makeFTestMatrix(int32_t rows, int32_t cols) {
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = { rows-1, cols-1};
  SIDL::array<float> result = SIDL::array<float>::createRow(2, lower, upper);
  for( int32_t i=0; i<rows; ++i) {
    for( int32_t j=0; j<cols; ++j) {
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = powTwo(i-j);
        break;
      case 1:
        SIDL_float__array_set2(result._get_ior(), i, j, powTwo(i-j));
        break;
      case 2:
        result.set(i, j, powTwo(i-j));
        break;
      }
    }
  }
  return result;
}

static SIDL::array<SIDL::dcomplex> 
makeDCTestMatrix(int32_t rows, int32_t cols) {
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {rows-1, cols-1};
  SIDL::array<SIDL::dcomplex> result = SIDL::array<SIDL::dcomplex>::createRow(2, lower, upper);
  for(int32_t i=0; i<rows; ++i) {
    for(int32_t j=0; j<cols; ++j) {
      complex<double> tmp( powTwo(i), powTwo(-j) );
      struct SIDL_dcomplex tmp2;
      tmp2.real = tmp.real();
      tmp2.imaginary = tmp.imag();
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = tmp2;
        break;
      case 1:
        SIDL_dcomplex__array_set2(result._get_ior(), i, j, tmp2);
        break;
      case 2:
	result.set(i, j, tmp);
        break;
      }
    }
  }
  return result;
}

static SIDL::array<SIDL::fcomplex>
makeFCTestMatrix(int32_t rows, int32_t cols) {
  int32_t lower[2] = {0,0};
  int32_t upper[2] = { rows-1, cols-1};
  SIDL::array<SIDL::fcomplex> result = SIDL::array<SIDL::fcomplex>::createRow(2, lower, upper);
  for(int32_t i=0; i<rows; ++i) {
    for(int32_t j=0; j<cols; ++j) {
      complex<float> tmp2( fpowTwo(i), fpowTwo(-j) );
      struct SIDL_fcomplex tmp;
      tmp.real = fpowTwo(i);
      tmp.imaginary = fpowTwo(-j);
      switch(rand() % 3) {
      case 0:
        SIDLArrayElem2(result._get_ior(),i,j) = tmp;
        break;
      case 1:
        SIDL_fcomplex__array_set2(result._get_ior(), i, j, tmp);
        break;
      case 2:
        result.set(i, j, tmp2);
        break;
      }
    }
  }
  return result;
}

static int32_t intFunc(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0;i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static bool
next(const int dimen, int32_t ind[],
     const int32_t lower[], const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static SIDL::array<int32_t>
makeIntTestMatrix(int dimen)
{
  struct SIDL::array<int32_t> result;
  static const int32_t lower[] = {0, 0, 0, 0};
  static const int32_t upper[] = {3, 3, 2, 2};
  int32_t ind[] = {0, 0, 0, 0};
  int32_t value;
  result  = SIDL::array<int32_t>::createCol(dimen, lower, upper);
  do {
    value = intFunc(dimen, ind);
    switch(rand() % 2) {
    case 0:
      if (dimen == 3) {
	result.set(ind[0], ind[1], ind[2], value);
      }
      else {
        result.set(ind[0], ind[1], ind[2], ind[3], value);
      }
      break;
    case 1:
      result.set(ind, value);
      break;
    }
  } while (next(dimen, ind, lower, upper));
  return result;
}
*/

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}


int main(int argc, char **argv) {
  int result = pass;
  int final_result = pass;
  int part_no = 0;
  int magicNumber = 1;

  cout << "NPARTS -1\n";

  {
    const int32_t numElem[] = { TEST_SIZE/2 };
    const int32_t start[] = { 0 };
    const int32_t stride[] = { 2 };
    magicNumber = clearstack(magicNumber);
    SIDL::array<bool> barray = ArrayOps::createBool(TEST_SIZE);
    MYASSERT(createBool, barray._not_nil());
    MYASSERT(createBool, ArrayOps::checkBool(barray) == true);
    MYASSERT(createBool, ArrayOps::reverseBool(barray, true) == true);
    SIDL::array<bool> sliced = barray.slice(1, numElem, start, stride);
    SIDL::array<bool> cpy;
    MYASSERT(createBool, sliced._not_nil());
    sliced.smartCopy();
    MYASSERT(createBool, sliced._not_nil());
    cpy = barray;
    cpy.smartCopy();
    MYASSERT(createBool, cpy._not_nil());
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<bool> barray;
    ArrayOps::makeBool(218, barray);
    MYASSERT(makeBool218, ArrayOps::checkBool(barray) == true);
    MYASSERT(makeBool218, ArrayOps::reverseBool(barray, false) == true);
    MYASSERT(makeBool218, ArrayOps::checkBool(barray) == false);
    barray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }
  
  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<bool> barray;
    ArrayOps::makeBool(9, barray);
    MYASSERT(makeBool9, ArrayOps::reverseBool(barray, false) == true);
    MYASSERT(makeBool9, ArrayOps::checkBool(barray) == true);
    barray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }
  
  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<char> carray = ArrayOps::createChar(TEST_SIZE);
    MYASSERT(createChar, carray._not_nil());
    MYASSERT(createChar, ArrayOps::checkChar(carray) == true);
    MYASSERT(createChar, ArrayOps::reverseChar(carray, true) == true);
    carray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<char> carray;
    ArrayOps::makeChar(218, carray);
    MYASSERT(makeChar, ArrayOps::checkChar(carray) == true);
    MYASSERT(makeChar, ArrayOps::reverseChar(carray, false) == true);
    MYASSERT(makeChar, ArrayOps::checkChar(carray) == false);
    carray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }
  
  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray = ArrayOps::createInt(TEST_SIZE);
    MYASSERT(createInt, iarray._not_nil());
    MYASSERT(createInt, ArrayOps::checkInt(iarray) == true);
    MYASSERT(createInt, ArrayOps::reverseInt(iarray, true) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray;
    ArrayOps::makeInt(218, iarray);
    MYASSERT(makeInt, ArrayOps::checkInt(iarray) == true);
    MYASSERT(makeInt, ArrayOps::reverseInt(iarray, false) == true);
    MYASSERT(makeInt, ArrayOps::checkInt(iarray) == false);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> borrowed;
    int32_t elements[] = {
      2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37,
      41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83,
      89, 97, 101, 103, 107, 109, 113, 127, 131
    };
    const int32_t lower[] = { 0 };
    const int32_t upper[] = { sizeof(elements)/sizeof(int32_t)-1 };
    const int32_t stride[] = { 1 };
    MYASSERT(borrowed_int, !borrowed);
    borrowed.borrow(elements, 1, lower, upper, stride);
    MYASSERT(borrowed_int, borrowed._not_nil());
    MYASSERT(borrowed int, ArrayOps::checkInt(borrowed) == true);
    borrowed.smartCopy();
    MYASSERT(borrowed int, ArrayOps::checkInt(borrowed) == true);
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int64_t> larray = ArrayOps::createLong(TEST_SIZE);
    MYASSERT(createLong, larray._not_nil());
    MYASSERT(createLong, ArrayOps::checkLong(larray) == true);
    MYASSERT(createLong, ArrayOps::reverseLong(larray, true) == true);
    larray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<int64_t> larray;
    ArrayOps::makeLong(218, larray);
    MYASSERT(makeLong, ArrayOps::checkLong(larray) == true);
    MYASSERT(makeLong, ArrayOps::reverseLong(larray, false) == true);
    MYASSERT(makeLong, ArrayOps::checkLong(larray) == false);
    larray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<string> sarray = ArrayOps::createString(TEST_SIZE);
    MYASSERT(createString, sarray._not_nil());
    MYASSERT(createString, ArrayOps::checkString(sarray) == true);
    MYASSERT(createString, ArrayOps::reverseString(sarray, true) == true);
    sarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<string> sarray; 
    ArrayOps::makeString(218, sarray);
    MYASSERT(makeString, ArrayOps::checkString(sarray) == true);
    MYASSERT(makeString, ArrayOps::reverseString(sarray, false) == true);
    MYASSERT(makeString, ArrayOps::checkString(sarray) == false);
    sarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<double> darray = ArrayOps::createDouble(TEST_SIZE);
    MYASSERT(createDouble, darray._not_nil());
    MYASSERT(createDouble, ArrayOps::checkDouble(darray) == true);
    MYASSERT(createDouble, ArrayOps::reverseDouble(darray, true) == true);
    darray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<double> darray;
    ArrayOps::makeDouble(218, darray);
    MYASSERT(makeDouble, ArrayOps::checkDouble(darray) == true);
    MYASSERT(makeDouble, ArrayOps::reverseDouble(darray, false) == true);
    MYASSERT(makeDouble, ArrayOps::checkDouble(darray) == false);
    darray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 
  
  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<float> farray = ArrayOps::createFloat(TEST_SIZE);
    MYASSERT(createFloat, farray._not_nil());
    MYASSERT(createFloat, ArrayOps::checkFloat(farray) == true);
    MYASSERT(createFloat, ArrayOps::reverseFloat(farray, true) == true);
    farray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<float> farray; 
    ArrayOps::makeFloat(218, farray);
    MYASSERT(makeFloat, ArrayOps::checkFloat(farray) == true);
    MYASSERT(makeFloat, ArrayOps::reverseFloat(farray, false) == true);
    MYASSERT(makeFloat, ArrayOps::checkFloat(farray) == false);
    farray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 
  
  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::fcomplex> fcarray = ArrayOps::createFcomplex(TEST_SIZE);
    MYASSERT(createFcomplex, fcarray._not_nil());
    MYASSERT(createFcomplex, ArrayOps::checkFcomplex(fcarray) == true);
    MYASSERT(createFcomplex, ArrayOps::reverseFcomplex(fcarray, true) == true);
    fcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::fcomplex> fcarray;
    ArrayOps::makeFcomplex(218, fcarray);
    MYASSERT(makeFcomplex, ArrayOps::checkFcomplex(fcarray) == true);
    MYASSERT(makeFcomplex, ArrayOps::reverseFcomplex(fcarray, false) == true);
    MYASSERT(makeFcomplex, ArrayOps::checkFcomplex(fcarray) == false);
    fcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 
  
  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::dcomplex> dcarray = ArrayOps::createDcomplex(TEST_SIZE);
    MYASSERT(createDcomplex, dcarray._not_nil());
    MYASSERT(createDcomplex, ArrayOps::checkDcomplex(dcarray) == true);
    MYASSERT(createDcomplex, ArrayOps::reverseDcomplex(dcarray, true) == true);
    dcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::dcomplex> dcarray;
    ArrayOps::makeDcomplex(218, dcarray);
    MYASSERT(makeDcomplex, ArrayOps::checkDcomplex(dcarray) == true);
    MYASSERT(makeDcomplex, ArrayOps::reverseDcomplex(dcarray, false) == true);
    MYASSERT(makeDcomplex, ArrayOps::checkDcomplex(dcarray) == false);
    dcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray;
    magicNumber = clearstack(magicNumber);
    iarray = ArrayOps::create2Int(TEST_DIM1,TEST_DIM2);
    MYASSERT(create2Int, ArrayOps::check2Int(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<double> darray;
    darray = ArrayOps::create2Double(TEST_DIM1,TEST_DIM2);
    MYASSERT(create2Double, ArrayOps::check2Double(darray) == true);
    darray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<float> farray;
    farray = ArrayOps::create2Float(TEST_DIM1,TEST_DIM2);
    MYASSERT(create2Float, ArrayOps::check2Float(farray) == true);
    farray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::dcomplex> dcarray;
    dcarray = ArrayOps::create2Dcomplex(TEST_DIM1,TEST_DIM2);
    MYASSERT(create2Dcomplex, ArrayOps::check2Dcomplex(dcarray) == true);
    dcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  { 
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::fcomplex> fcarray;
    fcarray = ArrayOps::create2Fcomplex(TEST_DIM1,TEST_DIM2);
    MYASSERT(create2Fcomplex, ArrayOps::check2Fcomplex(fcarray) == true);
    fcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  } 

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray;
    iarray = ArrayOps::create3Int();
    MYASSERT(create3Int, ArrayOps::check3Int(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray;
    iarray = ArrayOps::create4Int();
    MYASSERT(create4Int, ArrayOps::check4Int(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<bool> barray;
    ArrayOps::makeInOutBool(barray, 218);
    MYASSERT(makeInOutBool, ArrayOps::checkBool(barray) == true);
    barray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<char> carray;
    ArrayOps::makeInOutChar(carray, 218);
    MYASSERT(makeInOutChar, ArrayOps::checkChar(carray) == true);
    carray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray;
    ArrayOps::makeInOutInt(iarray, 218);
    MYASSERT(makeInOutInt, ArrayOps::checkInt(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int64_t> larray;
    ArrayOps::makeInOutLong(larray, 218);
    MYASSERT(makeInOutLong, ArrayOps::checkLong(larray) == true);
    larray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<string> sarray;
    ArrayOps::makeInOutString(sarray, 218);
    MYASSERT(makeInOutString, ArrayOps::checkString(sarray) == true);
    sarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<double> darray;
    ArrayOps::makeInOutDouble(darray, 218);
    MYASSERT(makeInOutDouble, ArrayOps::checkDouble(darray) == true);
    darray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<float> farray;
    ArrayOps::makeInOutFloat(farray, 218);
    MYASSERT(makeInOutFloat, ArrayOps::checkFloat(farray) == true);
    farray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::dcomplex> dcarray;
    ArrayOps::makeInOutDcomplex(dcarray, 218);
    MYASSERT(makeInOutDcomplex, ArrayOps::checkDcomplex(dcarray) == true);
    dcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::fcomplex> fcarray;
    ArrayOps::makeInOutFcomplex(fcarray, 218);
    MYASSERT(makeInOutFcomplex, ArrayOps::checkFcomplex(fcarray) == true);
    fcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int32_t> iarray;
    ArrayOps::makeInOut2Int(iarray, TEST_DIM1, TEST_DIM2);
    MYASSERT(makeInOut2Int, ArrayOps::check2Int(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<double> darray;
    ArrayOps::makeInOut2Double(darray, TEST_DIM1, TEST_DIM2);
    MYASSERT(makeInOut2Double, ArrayOps::check2Double(darray) == true);
    darray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<float> farray;
    ArrayOps::makeInOut2Float(farray, TEST_DIM1, TEST_DIM2);
    MYASSERT(makeInOut2Float, ArrayOps::check2Float(farray) == true);
    farray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::dcomplex> dcarray;
    ArrayOps::makeInOut2Dcomplex(dcarray, TEST_DIM1, TEST_DIM2);
    MYASSERT(makeInOut2Dcomplex, ArrayOps::check2Dcomplex(dcarray) == true);
    dcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<SIDL::fcomplex> fcarray;
    ArrayOps::makeInOut2Fcomplex(fcarray, TEST_DIM1, TEST_DIM2);
    MYASSERT(makeInOut2Fcomplex, ArrayOps::check2Fcomplex(fcarray) == true);
    fcarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int> iarray;
    ArrayOps::makeInOut3Int(iarray);
    MYASSERT(makeInOut3Int, ArrayOps::check3Int(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    magicNumber = clearstack(magicNumber);
    SIDL::array<int> iarray;
    ArrayOps::makeInOut4Int(iarray);
    MYASSERT(makeInOut4Int, ArrayOps::check4Int(iarray) == true);
    iarray.deleteRef();
    magicNumber = clearstack(magicNumber);
  }

  {
    const int32_t numElem[] = { (TEST_SIZE+1)/2 };
    const int32_t numElemTwo[] = { TEST_SIZE/2 };
    const int32_t start[] = { 0 };
    const int32_t startTwo[] = { 1 };
    const int32_t stride[] = { 2 };
    magicNumber = clearstack(magicNumber);
    SIDL::array<ArrayTest::ArrayOps> objarray = 
      SIDL::array<ArrayTest::ArrayOps>::create1d(TEST_SIZE);
    MYASSERT(create1d, objarray._not_nil());
    MYASSERT(create1d, ArrayOps::checkObject(objarray) == 0);
    for(int32_t i = 0; i < TEST_SIZE; i += 2) {
      objarray.set(i, ArrayOps::_create());
    }
    MYASSERT(create1d, ArrayOps::checkObject(objarray) == ((TEST_SIZE+1)/2));
    SIDL::array<ArrayTest::ArrayOps> sliced = 
      objarray.slice(1, numElem, start, stride);
    MYASSERT(create1d, sliced._not_nil());
    MYASSERT(create1d, ArrayOps::checkObject(sliced) == ((TEST_SIZE+1)/2));
    sliced = objarray.slice(1, numElemTwo, startTwo, stride);
    MYASSERT(create1d, sliced._not_nil());
    MYASSERT(create1d, ArrayOps::checkObject(sliced) == 0);
    objarray.smartCopy();
    MYASSERT(create1d, ArrayOps::checkObject(objarray) == ((TEST_SIZE+1)/2));
    sliced.smartCopy();
    MYASSERT(create1d, ArrayOps::checkObject(sliced) == 0);

    MYASSERT(createObjectNegOne, ArrayOps::createObject(-1)._is_nil());
    MYASSERT(checkObjectNull, !ArrayOps::checkObject(NULL));
    magicNumber = clearstack(magicNumber);
  }


  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<bool> ary;
    MYASSERT(createBoolNegOne, ArrayOps::createBool(-1)._is_nil());
    ArrayOps::makeBool(-1, ary);
    MYASSERT(makeBoolNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<char> ary;
    MYASSERT(createCharNegOne, ArrayOps::createChar(-1)._is_nil());
    ArrayOps::makeChar(-1, ary);
    MYASSERT(makeCharNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<int32_t> ary;
    MYASSERT(createIntNegOne, ArrayOps::createInt(-1)._is_nil());
    ArrayOps::makeInt(-1, ary);
    MYASSERT(makeIntNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<int64_t> ary;
    MYASSERT(createLongNegOne, ArrayOps::createLong(-1)._is_nil());
    ArrayOps::makeLong(-1, ary);
    MYASSERT(makeLongNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<string> ary;
    MYASSERT(createStringNegOne, ArrayOps::createString(-1)._is_nil());
    ArrayOps::makeString(-1, ary);
    MYASSERT(makeStringNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<double> ary;
    MYASSERT(createDoubleNegOne, ArrayOps::createDouble(-1)._is_nil());
    ArrayOps::makeDouble(-1, ary);
    MYASSERT(makeDoubleNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<float> ary;
    MYASSERT(createFloatNegOne, ArrayOps::createFloat(-1)._is_nil());
    ArrayOps::makeFloat(-1, ary);
    MYASSERT(makeFloatNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<SIDL::dcomplex> ary;
    MYASSERT(createDcomplexNegOne, ArrayOps::createDcomplex(-1)._is_nil());
    ArrayOps::makeDcomplex(-1, ary);
    MYASSERT(makeDcomplexNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    ::SIDL::array<SIDL::fcomplex> ary;
    MYASSERT(createFcomplexNegOne, ArrayOps::createFcomplex(-1)._is_nil());
    ArrayOps::makeFcomplex(-1, ary);
    MYASSERT(makeFcomplexNegOne, ary._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    MYASSERT(create2DoubleNegOne, ArrayOps::create2Double(-1,-1)._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    MYASSERT(create2FcomplexNegOne, ArrayOps::create2Fcomplex(-1,-1)._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    MYASSERT(create2DcomplexNegOne, ArrayOps::create2Dcomplex(-1,-1)._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    MYASSERT(create2FloatNegOne, ArrayOps::create2Float(-1,-1)._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  {
    magicNumber = clearstack(magicNumber);
    MYASSERT(create2IntNegOne, ArrayOps::create2Int(-1,-1)._is_nil());
    magicNumber = clearstack(magicNumber);
  }



  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

