/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public abstract class Extendable
extends Symbol {
    private ArrayList d_all_abstract_methods = new ArrayList();
    private HashMap d_all_interfaces = new HashMap();
    private ArrayList d_all_methods = new ArrayList();
    private HashMap d_all_methods_long = new HashMap();
    private HashMap d_all_methods_short = new HashMap();
    private HashSet d_all_references = new HashSet();
    private HashSet d_all_basicarrays = new HashSet();
    private ArrayList d_all_nonstatic_methods = new ArrayList();
    private ArrayList d_all_static_methods = new ArrayList();
    private HashMap d_local_interfaces = new HashMap();
    private ArrayList d_local_methods = new ArrayList();
    private HashMap d_local_methods_long = new HashMap();
    private HashMap d_local_methods_short = new HashMap();
    private ArrayList d_local_nonstatic_methods = new ArrayList();
    private ArrayList d_local_static_methods = new ArrayList();

    public Extendable(SymbolID id, int type, Comment comment) {
        super(id, type, comment);
        this.d_all_references.add(id);
    }

    public Extendable(SymbolID id, int type, Comment comment, Metadata m) {
        super(id, type, comment, m);
        this.d_all_references.add(id);
    }

    public abstract boolean isAbstract();

    public abstract boolean isInterface();

    public void addMethod(Method method) {
        this.addToMethodLists(method, false);
        this.d_all_references.addAll(method.getSymbolReferences());
        this.d_all_basicarrays.addAll(method.getBasicArrays());
    }

    public Collection getMethods(boolean all) {
        return all ? this.d_all_methods : this.d_local_methods;
    }

    public Collection getNonstaticMethods(boolean all) {
        return all ? this.d_all_nonstatic_methods : this.d_local_nonstatic_methods;
    }

    public Collection getStaticMethods(boolean all) {
        return all ? this.d_all_static_methods : this.d_local_static_methods;
    }

    public Collection getAbstractMethods() {
        return this.d_all_abstract_methods;
    }

    public boolean isLocal(Method m) {
        return m != null && m.equals(this.d_local_methods_long.get(m.getLongMethodName()));
    }

    public Method lookupMethodByLongName(String name, boolean all) {
        return (Method)(all ? this.d_all_methods_long.get(name) : this.d_local_methods_long.get(name));
    }

    public Collection lookupMethodByShortName(String name, boolean all) {
        return (Collection)(all ? this.d_all_methods_short.get(name) : this.d_local_methods_short.get(name));
    }

    public boolean hasMethodByLongName(String name, boolean all) {
        return all ? this.d_all_methods_long.containsKey(name) : this.d_local_methods_long.containsKey(name);
    }

    public boolean hasMethodByShortName(String name, boolean all) {
        return all ? this.d_all_methods_short.containsKey(name) : this.d_local_methods_short.containsKey(name);
    }

    public abstract boolean hasStaticMethod(boolean var1);

    public boolean hasExceptionThrowingMethod(boolean all) {
        boolean has_exception_throwing_method = false;
        Iterator i = this.getMethods(all).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            if (method.getThrows().size() <= 0) continue;
            has_exception_throwing_method = true;
            break;
        }
        return has_exception_throwing_method;
    }

    public abstract void addParentInterface(Interface var1);

    public Collection getParentInterfaces(boolean all) {
        return all ? this.d_all_interfaces.values() : this.d_local_interfaces.values();
    }

    public Collection getParents(boolean all) {
        return this.getParentInterfaces(all);
    }

    public boolean hasAncestor(Extendable ext) {
        Extendable parent;
        if (ext == null) {
            return false;
        }
        Collection parents = this.getParents(false);
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            parent = (Extendable)i.next();
            if (ext != parent) continue;
            return true;
        }
        i = parents.iterator();
        while (i.hasNext()) {
            parent = (Extendable)i.next();
            if (!parent.hasAncestor(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentInterface(SymbolID id, boolean all) {
        return all ? this.d_all_interfaces.containsKey(id) : this.d_local_interfaces.containsKey(id);
    }

    public Set getSymbolReferences() {
        return this.d_all_references;
    }

    public Set getAllSymbolReferences() {
        return this.getSymbolReferences();
    }

    public Set getBasicArrayRefs() {
        return this.d_all_basicarrays;
    }

    protected void addParentData(Extendable ext) {
        Iterator m = ext.getMethods(true).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.addToMethodLists(method, true);
        }
        if (ext.isInterface()) {
            this.d_all_interfaces.put(ext.getSymbolID(), ext);
            this.d_local_interfaces.put(ext.getSymbolID(), ext);
        }
        Collection parents = ext.getParentInterfaces(true);
        Iterator p = parents.iterator();
        while (p.hasNext()) {
            Extendable e = (Extendable)p.next();
            this.d_all_interfaces.put(e.getSymbolID(), e);
        }
        this.d_all_references.addAll(ext.getSymbolReferences());
        this.d_all_basicarrays.addAll(ext.getBasicArrayRefs());
    }

    private void findExistingEntry(ArrayList list, Method method, boolean replaceIt) {
        String name = method.getLongMethodName();
        boolean found = false;
        Method item = null;
        ListIterator iter = list.listIterator();
        while (iter.hasNext() && !found) {
            item = (Method)iter.next();
            if (!item.getLongMethodName().equals(name)) continue;
            found = true;
            iter.remove();
        }
        if (replaceIt) {
            list.add(method);
        }
    }

    private void addToShortMethodList(HashMap list, Method method) {
        String name = method.getShortMethodName();
        if (list.containsKey(name)) {
            this.findExistingEntry((ArrayList)list.get(name), method, true);
        } else {
            ArrayList<Method> sublist = new ArrayList<Method>();
            sublist.add(method);
            list.put(name, sublist);
        }
    }

    private void addToMethodLists(Method method, boolean isParent) {
        String long_name = method.getLongMethodName();
        if (!this.hasMethodByLongName(long_name, true) || !method.isAbstract()) {
            boolean is_static = method.isStatic();
            this.findExistingEntry(this.d_all_methods, method, true);
            this.d_all_methods_long.put(long_name, method);
            this.addToShortMethodList(this.d_all_methods_short, method);
            if (is_static) {
                this.findExistingEntry(this.d_all_static_methods, method, true);
            } else {
                this.findExistingEntry(this.d_all_nonstatic_methods, method, true);
            }
            if (method.isAbstract()) {
                this.findExistingEntry(this.d_all_abstract_methods, method, true);
            } else {
                this.findExistingEntry(this.d_all_abstract_methods, method, false);
            }
            if (!isParent) {
                this.findExistingEntry(this.d_local_methods, method, true);
                this.d_local_methods_long.put(long_name, method);
                this.addToShortMethodList(this.d_local_methods_short, method);
                if (is_static) {
                    this.findExistingEntry(this.d_local_static_methods, method, true);
                } else {
                    this.findExistingEntry(this.d_local_nonstatic_methods, method, true);
                }
            }
        }
    }
}

