/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.xml;

import gov.llnl.babel.parsers.xml.DTDManager;
import gov.llnl.babel.parsers.xml.ParseSymbolException;
import gov.llnl.babel.parsers.xml.StringXML;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import gov.llnl.babel.xml.ElementIterator;
import gov.llnl.babel.xml.XMLUtilities;
import java.io.IOException;
import java.text.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseSymbolXML {
    private static final String EOL = "\n";
    private Symbol d_symbol;

    public static Symbol convert(InputSource is) throws ParseSymbolException {
        ParseSymbolXML xml2sym = new ParseSymbolXML(is);
        return xml2sym.getSymbol();
    }

    public static Symbol convert(Document doc) throws ParseSymbolException {
        ParseSymbolXML doc2sym = new ParseSymbolXML(doc);
        return doc2sym.getSymbol();
    }

    public ParseSymbolXML(InputSource is) throws ParseSymbolException {
        Document document = null;
        try {
            document = XMLUtilities.parse(is, DTDManager.getInstance());
        }
        catch (IOException ex) {
            throw new ParseSymbolException(ex.getMessage());
        }
        catch (SAXException ex) {
            throw new ParseSymbolException(ex.getMessage());
        }
        this.parseSymbol(document.getDocumentElement());
    }

    public ParseSymbolXML(Document doc) throws ParseSymbolException {
        this.parseSymbol(doc.getDocumentElement());
    }

    public Symbol getSymbol() {
        return this.d_symbol;
    }

    private void error(String message) throws ParseSymbolException {
        throw new ParseSymbolException(message);
    }

    private void parseSymbol(Element symbol) throws ParseSymbolException {
        if (symbol == null || !"Symbol".equals(symbol.getNodeName())) {
            this.error("No <Symbol> root element found in XML/DOM document");
        }
        SymbolID id = this.parseSymbolID(this.getElement(symbol, "SymbolName"));
        Comment cm = this.parseComment(this.getElement(symbol, "Comment"));
        Metadata md = this.parseMetadata(this.getElement(symbol, "Metadata"));
        if (this.hasChildElement(symbol, "Class")) {
            this.d_symbol = new Class(id, cm, md);
            this.parseClass(this.getElement(symbol, "Class"));
        } else if (this.hasChildElement(symbol, "Enumeration")) {
            this.d_symbol = new Enumeration(id, cm, md);
            this.parseEnum(this.getElement(symbol, "Enumeration"));
        } else if (this.hasChildElement(symbol, "Interface")) {
            this.d_symbol = new Interface(id, cm, md);
            this.parseInterface(this.getElement(symbol, "Interface"));
        } else if (this.hasChildElement(symbol, "Package")) {
            this.d_symbol = new Package(id, cm, md);
            this.parsePackage(this.getElement(symbol, "Package"));
        } else {
            this.error("Unknown SIDL symbol type in XML document");
        }
    }

    private void parseClass(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Class");
        Class cls = (Class)this.d_symbol;
        Element extends_element = this.getElement(element, "Extends");
        ElementIterator parent = new ElementIterator(extends_element, "SymbolName");
        if (parent.hasNext()) {
            SymbolID id = this.parseSymbolID((Element)parent.next());
            try {
                Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
                if (sym == null) {
                    this.error("Class \"" + id.getSymbolName() + "\" not found");
                } else if (sym.getSymbolType() != 12) {
                    this.error("Symbol \"" + id.getSymbolName() + "\"  not a class");
                } else {
                    cls.setParentClass((Class)sym);
                }
            }
            catch (SymbolRedefinitionException ex) {
                this.error(ex.getMessage());
            }
        }
        Element implblock_element = this.getElement(element, "ImplementsBlock");
        ElementIterator parents = new ElementIterator(implblock_element, "SymbolName");
        while (parents.hasNext()) {
            SymbolID id = this.parseSymbolID((Element)parents.next());
            try {
                Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
                if (sym == null) {
                    this.error("Interface \"" + id.getSymbolName() + "\" not found");
                    continue;
                }
                if (sym.getSymbolType() != 13) {
                    this.error("Symbol \"" + id.getSymbolName() + "\"  not interface");
                    continue;
                }
                cls.addParentInterface((Interface)sym);
            }
            catch (SymbolRedefinitionException ex) {
                this.error(ex.getMessage());
            }
        }
        Element methodsblock_element = this.getElement(element, "MethodsBlock");
        ElementIterator methods = new ElementIterator(methodsblock_element, "Method");
        while (methods.hasNext()) {
            cls.addMethod(this.parseMethod((Element)methods.next()));
        }
    }

    private void parseEnum(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Enumeration");
        Enumeration enm = (Enumeration)this.d_symbol;
        ElementIterator enumerators = new ElementIterator(element, "Enumerator");
        while (enumerators.hasNext()) {
            Element entry = (Element)enumerators.next();
            String name = this.getAttribute(entry, "name");
            String sval = this.getAttribute(entry, "value");
            boolean user = this.getAttribute(entry, "fromuser").equals("true");
            Comment cmt = null;
            if (this.hasChildElement(entry, "Comment")) {
                cmt = this.parseComment(this.getElement(entry, "Comment"));
            }
            try {
                enm.addEnumerator(name, Integer.parseInt(sval), user, cmt);
            }
            catch (NumberFormatException ex) {
                this.error("Invalid integer value \"" + sval + "\" for enumerated type");
            }
        }
    }

    private void parseInterface(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Interface");
        Interface ifc = (Interface)this.d_symbol;
        Element extends_block = this.getElement(element, "ExtendsBlock");
        ElementIterator parents = new ElementIterator(extends_block, "SymbolName");
        while (parents.hasNext()) {
            SymbolID id = this.parseSymbolID((Element)parents.next());
            try {
                Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
                if (sym == null) {
                    this.error("Interface \"" + id.getSymbolName() + "\" not found");
                    continue;
                }
                if (sym.getSymbolType() != 13) {
                    this.error("Symbol \"" + id.getSymbolName() + "\"  not interface");
                    continue;
                }
                ifc.addParentInterface((Interface)sym);
            }
            catch (SymbolRedefinitionException ex) {
                this.error(ex.getMessage());
            }
        }
        Element methods_block = this.getElement(element, "MethodsBlock");
        ElementIterator methods = new ElementIterator(methods_block, "Method");
        while (methods.hasNext()) {
            ifc.addMethod(this.parseMethod((Element)methods.next()));
        }
    }

    private static Version chooseVersion(String version, Version parent) {
        if (version == null) {
            return parent;
        }
        return new Version(version);
    }

    private void parsePackage(Element element) throws ParseSymbolException {
        this.validateSymbolName(element, "Package");
        Package p = (Package)this.d_symbol;
        Version pkgVersion = p.getSymbolID().getVersion();
        p.setFinal("true".equals(this.getAttribute(element, "final")));
        try {
            ElementIterator entries = new ElementIterator(element, "PackageSymbol");
            while (entries.hasNext()) {
                Element entry = (Element)entries.next();
                String name = this.getAttribute(entry, "name");
                String type = this.getAttribute(entry, "type");
                String version = this.getAttribute(entry, "version");
                p.addSymbol(new SymbolID(p.getScopedName(name), ParseSymbolXML.chooseVersion(version, pkgVersion)), StringXML.fromSymbolXML(type));
            }
        }
        catch (NumberFormatException nfe) {
            new ParseSymbolException("Bad version string: " + nfe.getMessage());
        }
    }

    private Comment parseComment(Element comment) throws ParseSymbolException {
        this.validateSymbolName(comment, "Comment");
        String s = XMLUtilities.decodeXMLString(XMLUtilities.decodeXMLString(XMLUtilities.decodeXMLString(XMLUtilities.decodeXMLString(XMLUtilities.getXMLString(comment)))));
        int nlines = 0;
        int index = s.indexOf(EOL);
        while (index > 0) {
            ++nlines;
            index = s.indexOf(EOL, index + 1);
        }
        String[] lines = null;
        if (nlines > 1) {
            lines = new String[nlines - 1];
            int start_index = s.indexOf(EOL);
            int n = 0;
            while (n < nlines - 1) {
                int end_index = s.indexOf(EOL, start_index + 1);
                lines[n] = s.substring(start_index + 1, end_index);
                start_index = end_index;
                ++n;
            }
        }
        return new Comment(lines);
    }

    private Metadata parseMetadata(Element m) throws ParseSymbolException {
        this.validateSymbolName(m, "Metadata");
        Metadata metadata = null;
        String date = this.getAttribute(m, "date");
        try {
            metadata = new Metadata(date);
        }
        catch (ParseException ex) {
            this.error("Invalid date format \"" + date + "\" in metadata element");
        }
        ElementIterator entries = new ElementIterator(m, "MetadataEntry");
        while (entries.hasNext()) {
            Element entry = (Element)entries.next();
            String key = this.getAttribute(entry, "key");
            String val = this.getAttribute(entry, "value");
            metadata.addMetadata(key, val);
        }
        return metadata;
    }

    private Method parseMethod(Element e) throws ParseSymbolException {
        this.validateSymbolName(e, "Method");
        Method method = new Method();
        method.setMethodName(this.getAttribute(e, "shortname"), this.getAttribute(e, "extension"));
        method.setCommunicationModifier(StringXML.fromComXML(this.getAttribute(e, "communication")));
        method.setDefinitionModifier(StringXML.fromDefXML(this.getAttribute(e, "definition")));
        method.setReturnCopy(this.getAttribute(e, "copy").equals("true"));
        method.setComment(this.parseComment(this.getElement(e, "Comment")));
        method.setReturnType(this.parseType(this.getElement(e, "Type")));
        Element arglist = this.getElement(e, "ArgumentList");
        ElementIterator args = new ElementIterator(arglist, "Argument");
        while (args.hasNext()) {
            method.addArgument(this.parseArgument((Element)args.next()));
        }
        Element throwslist = this.getElement(e, "ThrowsList");
        ElementIterator thrws = new ElementIterator(throwslist, "SymbolName");
        while (thrws.hasNext()) {
            method.addThrows(this.parseSymbolID((Element)thrws.next()));
        }
        return method;
    }

    private Argument parseArgument(Element e) throws ParseSymbolException {
        this.validateSymbolName(e, "Argument");
        boolean copy = this.getAttribute(e, "copy").equals("true");
        int mode = StringXML.fromModeXML(this.getAttribute(e, "mode"));
        String name = this.getAttribute(e, "name");
        Type type = this.parseType(this.getElement(e, "Type"));
        return new Argument(copy, mode, type, name);
    }

    private Type parseType(Element e) throws ParseSymbolException {
        this.validateSymbolName(e, "Type");
        int typeid = StringXML.fromTypeXML(this.getAttribute(e, "type"));
        Type type = null;
        if (typeid == 15) {
            type = new Type(this.parseSymbolID(this.getElement(e, "SymbolName")));
        } else if (typeid == 16) {
            Element array = this.getElement(e, "Array");
            String sdim = this.getAttribute(array, "dim");
            String sorder = this.getAttribute(array, "order");
            int dim = 0;
            int order = StringXML.fromOrderXML(sorder);
            try {
                dim = Integer.parseInt(sdim);
            }
            catch (NumberFormatException ex) {
                this.error("Invalid array dimension \"" + sdim + "\"");
            }
            type = new Type(this.parseType(this.getElement(array, "Type")), dim, order);
        } else {
            type = new Type(typeid);
        }
        return type;
    }

    private SymbolID parseSymbolID(Element id) throws ParseSymbolException {
        this.validateSymbolName(id, "SymbolName");
        String name = this.getAttribute(id, "name");
        String vers = this.getAttribute(id, "version");
        SymbolID sid = null;
        try {
            sid = new SymbolID(name, new Version(vers));
        }
        catch (NumberFormatException ex) {
            this.error("Invalid version format \"" + vers + "\" in symbol name");
        }
        return sid;
    }

    private Element getElement(Element parent, String child) throws ParseSymbolException {
        Element element = XMLUtilities.lookupElement(parent, child);
        if (element == null) {
            this.error("Child element \"" + child + "\" not found in parent \"" + parent.getTagName() + "\"");
        }
        return element;
    }

    private boolean hasChildElement(Element parent, String child) {
        return XMLUtilities.lookupElement(parent, child) != null;
    }

    private void validateSymbolName(Element e, String name) throws ParseSymbolException {
        String tag = e.getTagName();
        if (!name.equals(tag)) {
            this.error("Invalid element name \"" + tag + "\" (expected \"" + name + "\")");
        }
    }

    private String getAttribute(Element e, String attr) throws ParseSymbolException {
        String value = e.getAttribute(attr);
        if (value == null) {
            this.error("Attribute \"" + attr + "\" not found in \"" + e.getTagName() + "\"");
        }
        return value;
    }

    private String getOptionalAttribute(Element e, String attr) {
        return e.getAttribute(attr);
    }

    static {
        EOL = EOL;
    }
}

