/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.parsers.sidl.Grammar;
import gov.llnl.babel.parsers.sidl.ParseException;
import gov.llnl.babel.parsers.sidl.SIDLException;

public class GrammarException
extends SIDLException {
    private static final String EOL = "\n";
    private String d_error_token;
    private String[] d_expected_tokens;

    public GrammarException(ParseException ex, int production) {
        super(ex.currentToken.next.beginLine, ex.currentToken.next.beginColumn, production);
        this.d_error_token = ex.currentToken.next.kind == 0 ? "END-OF-FILE" : ex.currentToken.next.image;
        int[][] expected = ex.expectedTokenSequences;
        int n = expected.length;
        this.d_expected_tokens = new String[n];
        int i = 0;
        while (i < n) {
            this.d_expected_tokens[i] = Grammar.getTokenString(expected[i][0]);
            ++i;
        }
    }

    public String getErrorToken() {
        return this.d_error_token;
    }

    public String[] getExpectedTokens() {
        return this.d_expected_tokens;
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Grammar exception at line=");
        buffer.append(String.valueOf(this.getLineNumber()));
        buffer.append(" column=");
        buffer.append(String.valueOf(this.getColumnNumber()));
        buffer.append(EOL);
        buffer.append("Grammar production: ");
        buffer.append(Grammar.getProduction(this.getProductionNumber()));
        buffer.append(EOL);
        buffer.append("Encountered \"");
        buffer.append(this.d_error_token);
        buffer.append("\"\n");
        int n = this.d_expected_tokens.length;
        if (n == 1) {
            buffer.append("Expected ");
        } else {
            buffer.append("Expected one of ");
        }
        int i = 0;
        while (i < n) {
            buffer.append(this.d_expected_tokens[i]);
            if (i != n - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        return buffer.toString();
    }

    static {
        EOL = EOL;
    }
}

