/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.parsers.sidl.ParserConstants;

public class Grammar {
    public static final int SPECIFICATION = 1;
    public static final int REQUIRE = 2;
    public static final int IMPORT = 3;
    public static final int PACKAGE = 4;
    public static final int DEFINITION = 5;
    public static final int CLASS = 6;
    public static final int ENUM = 7;
    public static final int ENUMERATOR = 8;
    public static final int INTERFACE = 9;
    public static final int CLASS_METHOD = 10;
    public static final int METHOD = 11;
    public static final int ARGUMENT = 12;
    public static final int TYPE = 13;
    public static final int ARRAY = 14;
    public static final int SCOPED_IDENTIFIER = 15;
    public static final int ARRAY_ORDER = 16;
    public static final int MIN_PRODUCTION = 1;
    public static final int MAX_PRODUCTION = 16;

    public static String getProduction(int production) {
        String s = null;
        switch (production) {
            case 1: {
                s = "Specification := (Require)* (Import)* (Package)* EOF";
                break;
            }
            case 2: {
                s = "Require := \"require\" ScopedIdentifier \"version\" V1.V2...Vn \";\"";
                break;
            }
            case 3: {
                s = "Import := \"import\" ScopedIdentifier [ \"version\" V1.V2...Vn ] \";\"";
                break;
            }
            case 4: {
                s = "Package := [ \"final\" ] \"package\" ScopedIdentifier [ \"version\" V1.V2...Vn ] \"{\" (Definition)* \"}\" [ \";\" ]";
                break;
            }
            case 5: {
                s = "Definition := Class | Enum | Interface | Package";
                break;
            }
            case 6: {
                s = "Class := [ \"abstract\" ] \"class\" Identifier [ \"extends\" ScopedIdentifier ] [ \"implements-all\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] [ \"implements\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] \"{\" ( ClassMethod )* \"}\" [ \";\" ]";
                break;
            }
            case 7: {
                s = "Enum := \"enum\" Identifier \"{\" Enumerator (\",\" Enumerator)* \"}\" [ \";\" ]";
                break;
            }
            case 8: {
                s = "Enumerator := Identifier [\"=\" Integer]";
                break;
            }
            case 9: {
                s = "Interface := \"interface\" Identifier [ \"extends\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] \"{\" ( Method )* \"}\" [ \";\" ]";
                break;
            }
            case 10: {
                s = "ClassMethod := [ \"abstract\" | \"final\" | \"static\" ] Method";
                break;
            }
            case 11: {
                s = "Method := ( \"void\" | [ \"copy\" ] Type ) Identifier [ \"[\" Identifier \"]\" ] \"(\" [ Argument ( \",\" Argument )* ] \")\" [ \"local\" | \"oneway\" ] [ \"throws\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] \";\"";
                break;
            }
            case 12: {
                s = "Argument := [ \"copy\" ] ( \"in\" | \"inout\" | \"out\" ) Type Identifier";
                break;
            }
            case 13: {
                s = "Type : = \"bool\" | \"char\" | \"dcomplex\" | \"double\" | \"fcomplex\" | \"float\" | \"int\" | \"long\" | \"opaque\" | \"string\" | Array | ScopedIdentifier";
                break;
            }
            case 14: {
                s = "Array := \"array<\" Type [ \",\" ( Integer [ \",\" ArrayOrder ] | ArrayOrder ) ] \">\"";
                break;
            }
            case 15: {
                s = "ScopedIdentifier := Identifier ( \".\" Identifier )*";
                break;
            }
            case 16: {
                s = "ArrayOrder := ( \"column-major\" | \"row-major\" )";
                break;
            }
            default: {
                s = "Internal error (unknown production)";
            }
        }
        return s;
    }

    public static String getTokenString(int token) {
        switch (token) {
            case 0: {
                return "\"END-OF-FILE\"";
            }
            case 56: {
                return "\"identifier\"";
            }
            case 57: {
                return "\"V1.V2...Vn\"";
            }
            case 58: {
                return "\"integer\"";
            }
            case 59: {
                return "\"[0-9]\"";
            }
            case 60: {
                return "\"[a-z,A-Z]\"";
            }
        }
        return ParserConstants.tokenImage[token];
    }

    public static void main(String[] args) {
        int p = 1;
        while (p <= 16) {
            System.out.println(Grammar.getProduction(p));
            ++p;
        }
    }

    static {
        SPECIFICATION = 1;
        REQUIRE = 2;
        IMPORT = 3;
        PACKAGE = 4;
        DEFINITION = 5;
        CLASS = 6;
        ENUM = 7;
        ENUMERATOR = 8;
        INTERFACE = 9;
        CLASS_METHOD = 10;
        METHOD = 11;
        ARGUMENT = 12;
        TYPE = 13;
        ARRAY = 14;
        SCOPED_IDENTIFIER = 15;
        ARRAY_ORDER = 16;
        MIN_PRODUCTION = 1;
        MAX_PRODUCTION = 16;
    }
}

