/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class ChangeWriter
extends Writer {
    private File d_finalDestination;
    private File d_temporaryFile;
    private Writer d_output;

    public ChangeWriter(File destination, File directory) throws IOException {
        this.d_finalDestination = destination;
        this.d_temporaryFile = File.createTempFile("babel", null, directory);
        this.d_temporaryFile.deleteOnExit();
        this.d_output = new BufferedWriter(new FileWriter(this.d_temporaryFile));
    }

    public static Writer createWriter(String filename, String directory) throws IOException {
        File dest = new File(directory + filename);
        if (!dest.canWrite()) {
            return new FileWriter(dest);
        }
        if (directory.length() > 1) {
            return new ChangeWriter(dest, new File(directory.substring(0, directory.length() - 1)));
        }
        return new ChangeWriter(dest, new File("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.d_output) {
                throw new IOException("Cannot write to closed Writer.");
            }
            this.d_output.write(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.d_output) {
                throw new IOException("Cannot write to closed Writer.");
            }
            this.d_output.write(cbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.d_output) {
                throw new IOException("Cannot write to closed Writer.");
            }
            this.d_output.write(str, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.d_output) {
                throw new IOException("Cannot write to closed Writer.");
            }
            this.d_output.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.d_output) {
                throw new IOException("Cannot write to closed Writer.");
            }
            this.d_output.write(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.d_output) {
                throw new IOException("Cannot flush closed Writer.");
            }
            this.d_output.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean filesDiffer() throws IOException {
        Object v1;
        boolean bl;
        long currentLength = this.d_finalDestination.length();
        if (currentLength <= 0L || this.d_temporaryFile.length() != currentLength) return true;
        InputStream finalIn = null;
        InputStream temp = null;
        try {
            int tempChar;
            int finalChar;
            finalIn = new FileInputStream(this.d_finalDestination);
            finalIn = new BufferedInputStream(finalIn);
            temp = new FileInputStream(this.d_temporaryFile);
            temp = new BufferedInputStream(temp);
            while ((finalChar = finalIn.read()) == (tempChar = temp.read()) && finalChar >= 0) {
            }
            bl = finalChar != tempChar;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var9_8 = null;
            try {
                if (finalIn != null) {
                    finalIn.close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var11_12;
                v0 = var11_12 = null;
            }
            if (temp == null) throw throwable;
            temp.close();
            throw throwable;
        }
        try {
            if (finalIn != null) {
                finalIn.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var11_11;
            v1 = var11_11 = null;
        }
        if (temp == null) return bl;
        temp.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void copyTempToFinal() throws IOException {
        Object v1;
        FileInputStream temp = null;
        FileOutputStream finalOut = null;
        byte[] buffer = new byte[1024];
        try {
            int numBytes;
            temp = new FileInputStream(this.d_temporaryFile);
            finalOut = new FileOutputStream(this.d_finalDestination);
            while ((numBytes = temp.read(buffer)) >= 0) {
                void var3_4;
                finalOut.write(buffer, 0, (int)var3_4);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var6_6 = null;
            try {
                if (temp != null) {
                    temp.close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var8_10;
                v0 = var8_10 = null;
            }
            if (finalOut != null) {
                finalOut.close();
            }
            throw throwable;
        }
        try {
            if (temp != null) {
                temp.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var8_9;
            v1 = var8_9 = null;
        }
        if (finalOut != null) {
            finalOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.d_output) {
                try {
                    this.d_output.close();
                    if (this.filesDiffer()) {
                        this.copyTempToFinal();
                    }
                    Object var3_2 = null;
                    this.d_output = null;
                    this.d_finalDestination = null;
                    this.d_temporaryFile.delete();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.d_output = null;
                    this.d_finalDestination = null;
                    this.d_temporaryFile.delete();
                    this.d_temporaryFile = null;
                    throw throwable;
                }
                this.d_temporaryFile = null;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

