/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.SymbolID;

public class PythonServerLaunch {
    LanguageWriterForC d_lw = null;
    Class d_cls;
    boolean d_hasStatic;

    PythonServerLaunch(Class cls) {
        this.d_cls = cls;
        this.d_hasStatic = this.d_cls.hasStaticMethod(false);
    }

    private void writeIncludes() {
        this.d_lw.generateInclude("SIDL_Python.h", true);
        this.d_lw.generateInclude("SIDL_Loader.h", true);
        this.d_lw.println();
    }

    private void writeForwardDecls() {
        SymbolID id = this.d_cls.getSymbolID();
        this.d_lw.println(IOR.getEPVName(id) + ";");
        if (this.d_hasStatic) {
            this.d_lw.println(IOR.getSEPVName(id) + ";");
        }
        this.d_lw.println();
    }

    private void writeStaticVars() {
        SymbolID id = this.d_cls.getSymbolID();
        this.d_lw.println("static void (*s_getEPV)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("(" + IOR.getEPVName(id) + " *);");
        this.d_lw.decreaseTabLevel();
        if (this.d_hasStatic) {
            this.d_lw.println("static void (*s_getSEPV)");
            this.d_lw.increaseTabLevel();
            this.d_lw.println("(" + IOR.getSEPVName(id) + " *);");
            this.d_lw.decreaseTabLevel();
        }
        this.d_lw.println();
    }

    private void writeInit() {
        SymbolID id = this.d_cls.getSymbolID();
        this.d_lw.println("static void");
        this.d_lw.println("initImplementation(void) {");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("static int notInitialized = 1;");
        this.d_lw.println("if (notInitialized) {");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("notInitialized = 0;");
        this.d_lw.println("SIDL_Python_Init();");
        this.d_lw.println("s_getEPV = (void (*)(" + IOR.getEPVName(id) + " *))");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("SIDL_Loader_lookupSymbol(\"" + Python.getSetEPVName(this.d_cls.getSymbolID()) + "\");");
        this.d_lw.decreaseTabLevel();
        if (this.d_hasStatic) {
            this.d_lw.increaseTabLevel();
            this.d_lw.println("s_getSEPV = (void (*)(" + IOR.getSEPVName(id) + " *))");
            this.d_lw.println("SIDL_Loader_lookupSymbol(\"" + Python.getSetSEPVName(this.d_cls.getSymbolID()) + "\");");
            this.d_lw.decreaseTabLevel();
        }
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("}");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void writeGetEPV() {
        SymbolID id = this.d_cls.getSymbolID();
        this.d_lw.println("void");
        this.d_lw.println(IOR.getSetEPVName(id) + "(" + IOR.getEPVName(id) + " *epv) {");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("initImplementation();");
        this.d_lw.println("if (s_getEPV) (*s_getEPV)(epv);");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    private void writeGetSEPV() {
        SymbolID id = this.d_cls.getSymbolID();
        this.d_lw.println("void");
        this.d_lw.println(IOR.getSetSEPVName(id) + "(" + IOR.getSEPVName(id) + " *sepv) {");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("initImplementation();");
        this.d_lw.println("if (s_getSEPV) (*s_getSEPV)(sepv);");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("}");
        this.d_lw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        try {
            this.d_lw = Python.createLaunch(this.d_cls, "launch the implementation");
            this.writeIncludes();
            this.writeForwardDecls();
            this.writeStaticVars();
            this.writeInit();
            this.writeGetEPV();
            if (this.d_hasStatic) {
                this.writeGetSEPV();
            }
            Object var2_1 = null;
            if (this.d_lw == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.d_lw == null) throw throwable;
            this.d_lw.close();
            this.d_lw = null;
            throw throwable;
        }
        this.d_lw.close();
        this.d_lw = null;
    }
}

