/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ior;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.SortComparator;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.ior.IORSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IORHeader {
    private static final String SIDL_EXCEPTION = BabelConfiguration.getBaseException();
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        IORHeader header = new IORHeader(writer);
        header.generateCode(symbol);
    }

    public IORHeader(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol != null) {
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
                case 11: {
                    this.generateEnumeration((Enumeration)symbol);
                    break;
                }
                case 13: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
                case 14: {
                    this.generatePackage((Package)symbol);
                }
            }
        }
    }

    private void generateEnumeration(Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(enm, header, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
        this.d_writer.generateInclude("SIDLType.h", true);
        this.d_writer.openCxxExtern();
        this.d_writer.writeComment(enm, false);
        this.d_writer.print(IOR.getEnumName(id));
        this.d_writer.println(" {");
        this.d_writer.increaseTabLevel();
        int maxlength = Utilities.getWidth(enm.getEnumerators());
        String namespace = id.getFullName().replace('.', '_') + "_";
        maxlength += namespace.length();
        Iterator e = enm.getIterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            Comment cmt = enm.getEnumeratorComment(name);
            this.d_writer.writeComment(cmt, true);
            this.d_writer.printAligned(namespace + name, maxlength);
            this.d_writer.print(" = ");
            this.d_writer.print(String.valueOf(enm.getEnumeratorValue(name)));
            if (e.hasNext()) {
                this.d_writer.print(",");
            }
            this.d_writer.println();
            if (cmt == null) continue;
            this.d_writer.println();
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.closeCxxExtern();
        this.d_writer.closeHeaderGuard();
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(ext, header, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
        Set defined = this.generateIncludes(ext);
        this.d_writer.openCxxExtern();
        this.generateExportedSymbols(ext);
        defined.add(id);
        this.generateForwardDeclarations(ext, defined);
        if (ext.hasStaticMethod(true)) {
            this.generateEPV(ext, true);
        }
        this.generateEPV(ext, false);
        if (ext.isInterface()) {
            this.generateInterfaceObject((Interface)ext);
        } else {
            this.generateClassObject((Class)ext);
            this.generateExternalStruct(ext);
            IORSource.generateExternalSignature(this.d_writer, ext, ";");
            this.d_writer.println();
        }
        this.d_writer.closeCxxExtern();
        this.d_writer.closeHeaderGuard();
    }

    private void generatePackage(Package p) {
        SymbolID id = p.getSymbolID();
        String header = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(p, header, false, "Intermediate Object Representation for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
        this.d_writer.writeComment(p, false);
        ArrayList entries = Utilities.sort(p.getSymbols().keySet());
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String include = IOR.getHeaderFile((SymbolID)i.next());
            this.d_writer.generateInclude(include, true);
        }
        this.d_writer.println();
        this.d_writer.closeHeaderGuard();
    }

    private void generateExternalStruct(Symbol sym) {
        if (sym instanceof Class) {
            Class cls = (Class)sym;
            SymbolID id = sym.getSymbolID();
            String symbolType = IOR.getSymbolType(sym);
            int maxDim = BabelConfiguration.getMaximumArray();
            this.d_writer.println(IOR.getExternalName(id) + " {");
            this.d_writer.increaseTabLevel();
            if (!cls.isAbstract()) {
                this.d_writer.println(symbolType);
                this.d_writer.println("(*createObject)(void);");
                this.d_writer.println();
            }
            this.d_writer.println(symbolType);
            this.d_writer.println("(*createRemote)(const char *url);");
            this.d_writer.println();
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println(IOR.getSEPVName(id) + "*");
                this.d_writer.println("(*getStaticEPV)(void);");
                this.d_writer.println();
            }
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("};");
            this.d_writer.println();
        }
    }

    private Set generateIncludes(Extendable ext) throws CodeGenerationException {
        Set dependencies;
        HashSet<SymbolID> includes = new HashSet<SymbolID>();
        if (!ext.isInterface()) {
            Class cls = (Class)ext;
            includes.addAll(Utilities.getUniqueInterfaceIDs(cls));
            Class parent = cls.getParentClass();
            if (parent != null) {
                includes.add(parent.getSymbolID());
            }
        }
        if ((dependencies = ext.getSymbolReferences()) != null && !dependencies.isEmpty()) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                Symbol symbol = Utilities.lookupSymbol(id);
                if (symbol.getSymbolType() != 11) continue;
                includes.add(id);
            }
        }
        this.d_writer.generateInclude("SIDL_header.h", true);
        if (!includes.isEmpty()) {
            ArrayList entries = Utilities.sort(includes);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                String header = IOR.getHeaderFile((SymbolID)i.next());
                this.d_writer.generateInclude(header, true);
            }
            this.d_writer.println();
        }
        return includes;
    }

    private void generateExportedSymbols(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String type = IOR.getObjectName(id);
        String sepv = IOR.getSEPVName(id);
        this.d_writer.writeComment(ext, false);
        this.d_writer.println(IOR.getArrayName(id) + ";");
        this.d_writer.println(type + ";");
        if (ext.hasStaticMethod(true)) {
            this.d_writer.println(sepv + ";");
        }
        this.d_writer.println();
        if (!ext.isAbstract()) {
            this.d_writer.println("extern " + type + "*");
            this.d_writer.println(IOR.getNewName(id) + "(void);");
            this.d_writer.println();
        }
        this.d_writer.println("extern " + type + "*");
        this.d_writer.println(IOR.getRemoteName(id) + "(const char *url);");
        this.d_writer.println();
        if (ext.hasStaticMethod(true)) {
            this.d_writer.println("extern " + sepv + "*");
            this.d_writer.println(IOR.getStaticsName(id) + "(void);");
            this.d_writer.println();
        }
        if (!ext.isInterface()) {
            this.d_writer.println("extern void " + IOR.getInitName(id) + "(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(type + "* self);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("extern void " + IOR.getFiniName(id) + "(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println(type + "* self);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("extern void " + IOR.getVersionName(id) + "(int32_t *major, int32_t *minor);");
            this.d_writer.println();
        }
    }

    private void generateForwardDeclarations(Extendable ext, Set defined) throws CodeGenerationException {
        HashSet<SymbolID> references = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            references.addAll(method.getSymbolReferences());
            if (method.getThrows().isEmpty()) continue;
            Symbol symbol = Utilities.lookupSymbol(SIDL_EXCEPTION);
            references.add(symbol.getSymbolID());
        }
        references.removeAll(defined);
        if (!references.isEmpty()) {
            HashSet<SymbolID> declare = new HashSet<SymbolID>();
            Iterator i2 = references.iterator();
            while (i2.hasNext()) {
                SymbolID id = (SymbolID)i2.next();
                Symbol symbol = Utilities.lookupSymbol(id);
                int type = symbol.getSymbolType();
                if (type != 13 && type != 12) continue;
                declare.add(id);
            }
            if (!declare.isEmpty()) {
                this.d_writer.writeComment("Forward references for external classes and interfaces.", false);
                ArrayList entries = Utilities.sort(declare);
                Iterator i3 = entries.iterator();
                while (i3.hasNext()) {
                    SymbolID id = (SymbolID)i3.next();
                    this.d_writer.println(IOR.getArrayName(id) + ";");
                    this.d_writer.println(IOR.getObjectName(id) + ";");
                }
                this.d_writer.println();
            }
        }
    }

    private void generateEPVEntry(Method m, String self, Set alreadySeen) throws CodeGenerationException {
        String name = m.getLongMethodName();
        if (!alreadySeen.contains(name)) {
            alreadySeen.add(name);
            this.d_writer.print(IOR.getReturnString(m.getReturnType()));
            this.d_writer.print(" (*");
            this.d_writer.print(IOR.getVectorEntry(name));
            this.d_writer.println(")(");
            this.d_writer.increaseTabLevel();
            boolean has_throws = !m.getThrows().isEmpty();
            ArrayList args = m.getArgumentList();
            if (!m.isStatic()) {
                this.d_writer.print(self);
                if (args.size() > 0 || has_throws) {
                    this.d_writer.println(",");
                }
            } else if (args.size() == 0 && !has_throws) {
                this.d_writer.print("void");
            }
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                this.d_writer.print(IOR.getArgumentWithFormal(arg));
                if (!a.hasNext() && !has_throws) continue;
                this.d_writer.println(",");
            }
            if (has_throws) {
                this.d_writer.print(IOR.getExceptionType());
                this.d_writer.print("*_ex");
            }
            this.d_writer.println(");");
            this.d_writer.decreaseTabLevel();
        }
    }

    private void generateLocalEntries(Extendable ext, String self, boolean doStatic, Set methodsAlreadySeen) throws CodeGenerationException {
        this.d_writer.writeCommentLine("Methods introduced in " + ext.getSymbolID().getSymbolName());
        Iterator m = null;
        m = doStatic ? ext.getStaticMethods(false).iterator() : ext.getNonstaticMethods(false).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateEPVEntry(method, self, methodsAlreadySeen);
        }
    }

    private void generateBuiltinEntries(Extendable ext, String self, boolean doStatic, Set alreadySeen) throws CodeGenerationException {
        if (!doStatic) {
            SymbolID id = ext.getSymbolID();
            int numBuiltins = ext.isInterface() ? 2 : 4;
            this.d_writer.writeCommentLine("Implicit builtin methods");
            int i = 0;
            while (i < numBuiltins) {
                Method b = IOR.getBuiltinMethod(i, id);
                this.generateEPVEntry(b, self, alreadySeen);
                ++i;
            }
        }
    }

    private void generateParentEntries(Extendable ext, String self, boolean doStatic, Set methodsAlreadySeen, Set extAlreadySeen) throws CodeGenerationException {
        if (ext instanceof Class) {
            this.generateEPVEntries(((Class)ext).getParentClass(), self, doStatic, methodsAlreadySeen, extAlreadySeen);
        }
        Object[] parents = ext.getParentInterfaces(false).toArray();
        Arrays.sort(parents, new SortComparator());
        int i = 0;
        while (i < parents.length) {
            this.generateEPVEntries((Extendable)parents[i], self, doStatic, methodsAlreadySeen, extAlreadySeen);
            ++i;
        }
    }

    private static final boolean isBaseClass(Extendable ext) {
        return ext instanceof Class && ((Class)ext).getParentClass() == null;
    }

    private static final boolean hasParents(Extendable ext) {
        return !IORHeader.isBaseClass(ext) || !ext.getParentInterfaces(false).isEmpty();
    }

    private void generateEPVEntries(Extendable ext, String self, boolean doStatic, Set methodsAlreadySeen, Set extAlreadySeen) throws CodeGenerationException {
        if (ext != null && !extAlreadySeen.contains(ext)) {
            if (IORHeader.hasParents(ext)) {
                this.generateParentEntries(ext, self, doStatic, methodsAlreadySeen, extAlreadySeen);
            }
            this.generateLocalEntries(ext, self, doStatic, methodsAlreadySeen);
            extAlreadySeen.add(ext);
        }
    }

    private void generateEPV(Extendable ext, boolean do_static) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String self = null;
        self = ext.isInterface() ? "void* self" : IOR.getObjectName(id) + "* self";
        String comment = null;
        comment = do_static ? "Declare the static entry point vector." : "Declare the method entry point vector.";
        this.d_writer.writeComment(comment, false);
        if (do_static) {
            this.d_writer.print(IOR.getSEPVName(id));
        } else {
            this.d_writer.print(IOR.getEPVName(id));
        }
        this.d_writer.println(" {");
        this.d_writer.increaseTabLevel();
        HashSet methodsAlreadySeen = new HashSet();
        HashSet extAlreadySeen = new HashSet();
        this.generateBuiltinEntries(ext, self, do_static, methodsAlreadySeen);
        this.generateEPVEntries(ext, self, do_static, methodsAlreadySeen, extAlreadySeen);
        methodsAlreadySeen = null;
        extAlreadySeen = null;
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("};");
        this.d_writer.println();
    }

    private void generateInterfaceObject(Interface ifc) {
        SymbolID id = ifc.getSymbolID();
        String epv = IOR.getEPVName(id);
        String type = IOR.getObjectName(id);
        this.d_writer.writeComment("Define the interface object structure.", false);
        int width = epv.length() + 2;
        this.d_writer.println(type + " {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(epv + "* d_epv;");
        this.d_writer.printAligned("void*", width);
        this.d_writer.println("d_object;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("};");
        this.d_writer.println();
    }

    private void generateClassObject(Class cls) {
        SymbolID id;
        String epv;
        this.d_writer.writeComment("Define the class object structure.", false);
        ArrayList unique = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        int width = Utilities.getWidth(unique) + "struct __object".length();
        Class parent = cls.getParentClass();
        SymbolID pid = null;
        String ptype = null;
        if (parent != null && (ptype = IOR.getObjectName(pid = parent.getSymbolID())).length() > width) {
            width = ptype.length();
        }
        if ((epv = IOR.getEPVName(id = cls.getSymbolID()) + "*").length() > width) {
            width = epv.length();
        }
        this.d_writer.println(IOR.getObjectName(id) + " {");
        this.d_writer.increaseTabLevel();
        if (parent != null) {
            this.d_writer.printAligned(ptype, width);
            this.d_writer.println(" d_" + IOR.getSymbolName(pid).toLowerCase() + ";");
        }
        Iterator i = unique.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            this.d_writer.printAligned(IOR.getObjectName(sid), width);
            this.d_writer.println(" d_" + IOR.getSymbolName(sid).toLowerCase() + ";");
        }
        this.d_writer.printAligned(epv, width);
        this.d_writer.println(" d_epv;");
        this.d_writer.printAligned("void*", width);
        this.d_writer.println(" d_data;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("};");
        this.d_writer.println();
    }
}

