/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.backend.writers.LineCountingFilterWriter;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class Cxx {
    public static final int FILE_ROLE_MIN = 0;
    public static final int FILE_ROLE_MAX = 3;
    public static final int FILE_ROLE_NONE = 0;
    public static final int FILE_ROLE_IMPL = 1;
    public static final int FILE_ROLE_SKEL = 2;
    public static final int FILE_ROLE_STUB = 3;
    public static final String[] FILE_ROLE_SUFFIX;
    public static final int FILE_TYPE_MIN = 0;
    public static final int FILE_TYPE_MAX = 4;
    public static final int FILE_TYPE_NONE = 0;
    public static final int FILE_TYPE_CXX_HEADER = 1;
    public static final int FILE_TYPE_CXX_SOURCE = 2;
    public static final int FILE_TYPE_C_HEADER = 3;
    public static final int FILE_TYPE_C_SOURCE = 4;
    public static final String[] FILE_TYPE_EXTENSION;
    private static final String[] s_types;
    private static final String[] s_array_types;
    private static String s_exceptionType;

    public static String getFileSuffix(int role) {
        if (0 <= role && role <= 3) {
            return FILE_ROLE_SUFFIX[role];
        }
        return FILE_ROLE_SUFFIX[0];
    }

    public static String getFileExtension(int ftype) {
        if (0 <= ftype && ftype <= 4) {
            return FILE_TYPE_EXTENSION[ftype];
        }
        return FILE_TYPE_EXTENSION[0];
    }

    public static String generateFilename(SymbolID id, int role, int ftype) {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (s_babel_config.makePackageSubdirs() && s_babel_config.excludeExternal()) {
            return Cxx.generateFilename(id.getShortName(), role, ftype);
        }
        return Cxx.generateFilename(id.getFullName(), role, ftype);
    }

    public static String generateFilename(String symbolName, int role, int ftype) {
        String name = symbolName.replace('.', '_');
        String suffix = Cxx.getFileSuffix(role);
        String extension = Cxx.getFileExtension(ftype);
        if (suffix == null || suffix.equals("")) {
            return name + extension;
        }
        return name + "_" + suffix + extension;
    }

    public static String generateRoleDescription(SymbolID id, int role) {
        switch (role) {
            case 1: {
                return "Server-side implementation for " + id.getFullName();
            }
            case 2: {
                return "Server-side glue code for " + id.getFullName();
            }
            case 3: {
                return "Client-side glue code for " + id.getFullName();
            }
        }
        return "Generated code for " + id.getFullName();
    }

    public static LanguageWriterForCxx createHeader(Symbol symbol, int role, String filegroup) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Cxx.generateFilename(id, role, 1);
        LanguageWriterForCxx lw = null;
        if (role == 1) {
            Writer fw = FileManager.getInstance().createWriter(id, type, filegroup, filename);
            LineCountingFilterWriter lcfw = new LineCountingFilterWriter(fw);
            PrintWriter pw = new PrintWriter(lcfw);
            lw = new LanguageWriterForCxx(pw, lcfw);
        } else {
            PrintWriter pw = FileManager.getInstance().createFile(id, type, filegroup, filename);
            lw = new LanguageWriterForCxx(pw);
        }
        lw.writeBanner(symbol, filename, role == 1, Cxx.generateRoleDescription(id, role));
        return lw;
    }

    public static LanguageWriterForCxx createSource(Symbol symbol, int role, String filegroup) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Cxx.generateFilename(id, role, 2);
        LanguageWriterForCxx lw = null;
        if (role == 1) {
            Writer fw = FileManager.getInstance().createWriter(id, type, filegroup, filename);
            LineCountingFilterWriter lcfw = new LineCountingFilterWriter(fw);
            PrintWriter pw = new PrintWriter(lcfw);
            lw = new LanguageWriterForCxx(pw, lcfw);
        } else {
            PrintWriter pw = FileManager.getInstance().createFile(id, type, filegroup, filename);
            lw = new LanguageWriterForCxx(pw);
        }
        lw.writeBanner(symbol, filename, role == 1, Cxx.generateRoleDescription(id, role));
        return lw;
    }

    public static void nestPackagesInNamespaces(LanguageWriterForCxx writer, Symbol symbol) {
        StringTokenizer tokens = new StringTokenizer(symbol.getSymbolID().getFullName(), ".");
        int tokenCount = tokens.countTokens();
        int i = 0;
        while (i + 1 < tokenCount) {
            writer.println("namespace " + tokens.nextToken() + " { ");
            writer.increaseTabLevel();
            ++i;
        }
        writer.println();
    }

    public static void unnestPackagesInNamespaces(LanguageWriterForCxx writer, Symbol symbol) {
        Stack<String> stack = new Stack<String>();
        StringTokenizer tokens = new StringTokenizer(symbol.getSymbolID().getFullName(), ".");
        int tokenCount = tokens.countTokens();
        int i = 0;
        while (i + 1 < tokenCount) {
            stack.push(tokens.nextToken());
            ++i;
        }
        while (!stack.empty()) {
            writer.decreaseTabLevel();
            writer.print("} ");
            writer.writeCommentLine("end namespace " + (String)stack.pop());
        }
        writer.println();
    }

    public static void beginExternCRegion(LanguageWriterForCxx writer) {
        writer.println("extern \"C\" {");
        writer.println();
        writer.increaseTabLevel();
    }

    public static void endExternCRegion(LanguageWriterForCxx writer) {
        writer.decreaseTabLevel();
        writer.println();
        writer.println("} // end extern \"C\"");
    }

    public static String getSymbolName(SymbolID id, String postfix) {
        if (postfix == null || postfix.trim().equals("")) {
            return "::" + Utilities.replace(id.getFullName(), ".", "::");
        }
        return "::" + Utilities.replace(id.getFullName(), ".", "::") + "_" + postfix;
    }

    public static String getSymbolName(SymbolID id) {
        return Cxx.getSymbolName(id, null);
    }

    public static String getSymbolNameWithoutLeadingColons(SymbolID id, String postfix) {
        if (postfix == null || postfix.trim().equals("")) {
            return Utilities.replace(id.getFullName(), ".", "::");
        }
        return Utilities.replace(id.getFullName(), ".", "::") + "_" + postfix;
    }

    public static String getEnumName(SymbolID id) {
        return Cxx.getSymbolName(id);
    }

    public static String getObjectName(SymbolID id) {
        return Cxx.getSymbolName(id);
    }

    public static String argModeToString(Argument arg) {
        switch (arg.getMode()) {
            case 0: {
                return "in";
            }
            case 2: {
                return "out";
            }
            case 1: {
                return "inout";
            }
        }
        return "";
    }

    public static String reinterpretCast(String newtype, String arg) {
        return "reinterpret_cast< " + newtype + ">(" + arg + ")";
    }

    public static String constCast(String newtype, String arg) {
        return "const_cast< " + newtype + ">(" + arg + ")";
    }

    public static String getCxxString(Type type) throws CodeGenerationException {
        int t = type.getType();
        if (t < s_types.length) {
            return s_types[t];
        }
        if (t == 15) {
            Symbol symbol = Utilities.lookupSymbol(type.getSymbolID());
            return Cxx.getSymbolName(symbol.getSymbolID());
        }
        if (t == 16) {
            Type atype = type.getArrayType();
            int a = atype.getType();
            if (a < s_array_types.length) {
                return s_array_types[a];
            }
            return "::SIDL::array< " + Cxx.getObjectName(atype.getSymbolID()) + ">";
        }
        return null;
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        return Cxx.getCxxString(type);
    }

    public static String getArgumentString(Argument arg) throws CodeGenerationException {
        int mode = arg.getMode();
        StringBuffer argString = new StringBuffer(50);
        switch (mode) {
            case 0: {
                argString.append("/*in*/ ");
                break;
            }
            case 2: {
                argString.append("/*out*/ ");
                break;
            }
            case 1: {
                argString.append("/*inout*/ ");
                break;
            }
            default: {
                throw new CodeGenerationException("Unrecognized Argument Mode = " + mode);
            }
        }
        Type type = arg.getType();
        if (mode == 0 && (type.getType() == 10 || type.getType() == 5 || type.getType() == 3)) {
            argString.append("const ");
            argString.append(Cxx.getReturnString(type));
            argString.append("&");
        } else {
            argString.append(Cxx.getReturnString(type));
            if (mode != 0) {
                argString.append("&");
            }
        }
        argString.append(" ");
        argString.append(arg.getFormalName());
        return argString.toString();
    }

    public static String getMethodImplName(SymbolID id, String methodName) {
        return Cxx.getSymbolName(id, "impl") + "::" + methodName;
    }

    public static String getMethodSkelName(SymbolID id, String methodName) {
        return "skel_" + id.getFullName().replace('.', '_') + '_' + methodName;
    }

    public static String getMethodStubName(SymbolID id, String methodName) {
        return Cxx.getSymbolNameWithoutLeadingColons(id, "") + "::" + methodName;
    }

    public static Set generateDependencyIncludes(LanguageWriterForCxx writer, Extendable ext, boolean removeSelf) throws CodeGenerationException {
        HashSet<SymbolID> includes = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            includes.addAll(method.getSymbolReferences());
        }
        writer.generateInclude("SIDL_cxx.hh", true);
        if (removeSelf) {
            includes.remove(ext.getSymbolID());
        } else {
            includes.add(ext.getSymbolID());
        }
        writer.generateInclude(IOR.getHeaderFile(ext.getSymbolID()), true);
        if (!includes.isEmpty()) {
            writer.writeComment("Includes for all method dependencies.", false);
            ArrayList entries = Utilities.sort(includes);
            Iterator i2 = entries.iterator();
            while (i2.hasNext()) {
                String header = Cxx.generateFilename((SymbolID)i2.next(), 3, 1);
                writer.generateInclude(header, true);
            }
            writer.println();
        }
        return includes;
    }

    public static void generateMethodSignature(LanguageWriterForCxx writer, Method method, String altcomment, int role) throws CodeGenerationException {
        boolean canThrowNullIORException;
        if (method == null) {
            return;
        }
        Comment comment = method.getComment();
        writer.writeComment(comment, altcomment);
        boolean bl = canThrowNullIORException = role == 3;
        if (method.isStatic()) {
            writer.print("static ");
        }
        writer.println(Cxx.getReturnString(method.getReturnType()));
        writer.print(method.getShortMethodName());
        if (method.getArgumentList().size() > 0) {
            writer.println(" (");
            writer.increaseTabLevel();
            Cxx.generateArgumentList(writer, method);
            writer.println();
            writer.decreaseTabLevel();
            writer.println(")");
            Cxx.generateThrowsList(writer, method, canThrowNullIORException);
            writer.println(";");
        } else {
            writer.print("() ");
            Cxx.generateThrowsList(writer, method, canThrowNullIORException);
            writer.print(";");
        }
        writer.println();
    }

    public static void generateArgumentList(LanguageWriterForCxx writer, Method method) throws CodeGenerationException {
        ArrayList args = method.getArgumentList();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            writer.print(Cxx.getArgumentString(arg));
            if (!a.hasNext()) continue;
            writer.println(",");
        }
    }

    public static void generateThrowsList(LanguageWriterForCxx writer, Method method, boolean canThrowNullIORException) {
        Set exceptions = method.getThrows();
        if (exceptions == null || exceptions.isEmpty()) {
            if (canThrowNullIORException) {
                writer.println("throw ( ::SIDL::NullIORException ) ");
            } else {
                writer.println("throw () ");
            }
            return;
        }
        writer.println("throw ( ");
        writer.increaseTabLevel();
        if (canThrowNullIORException) {
            writer.print("::SIDL::NullIORException, ");
        }
        Iterator e = exceptions.iterator();
        while (e.hasNext()) {
            SymbolID id = (SymbolID)e.next();
            writer.print(Cxx.getObjectName(id));
            if (!e.hasNext()) continue;
            writer.println(", ");
        }
        writer.println();
        writer.decreaseTabLevel();
        writer.print(")");
    }

    static {
        FILE_ROLE_MIN = 0;
        FILE_ROLE_MAX = 3;
        FILE_ROLE_NONE = 0;
        FILE_ROLE_IMPL = 1;
        FILE_ROLE_SKEL = 2;
        FILE_ROLE_STUB = 3;
        FILE_ROLE_SUFFIX = new String[]{"", "Impl", "Skel", ""};
        FILE_TYPE_MIN = 0;
        FILE_TYPE_MAX = 4;
        FILE_TYPE_NONE = 0;
        FILE_TYPE_CXX_HEADER = 1;
        FILE_TYPE_CXX_SOURCE = 2;
        FILE_TYPE_C_HEADER = 3;
        FILE_TYPE_C_SOURCE = 4;
        FILE_TYPE_EXTENSION = new String[]{"", ".hh", ".cc", ".h", ".c"};
        s_types = new String[]{"void", "bool", "char", "::std::complex<double>", "double", "::std::complex<float>", "float", "int32_t", "int64_t", "void*", "::std::string"};
        s_array_types = new String[]{null, "::SIDL::array<bool>", "::SIDL::array<char>", "::SIDL::array< ::SIDL::dcomplex>", "::SIDL::array<double>", "::SIDL::array< ::SIDL::fcomplex>", "::SIDL::array<float>", "::SIDL::array<int32_t>", "::SIDL::array<int64_t>", "::SIDL::array<void*>", "::SIDL::array< ::std::string>"};
        s_exceptionType = null;
    }
}

