/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationFactory;
import gov.llnl.babel.symbols.BadRegexException;
import gov.llnl.babel.symbols.RegexMatch;
import gov.llnl.babel.symbols.RegexUnsupportedException;

public class UserOptions {
    private static final LongOpt[] d_long_opts = new LongOpt[]{new LongOpt("client", 1, null, 99), new LongOpt("generate-subdirs", 0, null, 103), new LongOpt("help", 0, null, 104), new LongOpt("output-directory", 1, null, 111), new LongOpt("vpath", 1, null, 86), new LongOpt("parse-check", 0, null, 112), new LongOpt("remote", 1, null, 114), new LongOpt("repository-path", 1, null, 82), new LongOpt("server", 1, null, 115), new LongOpt("text", 1, null, 116), new LongOpt("xml", 0, null, 120), new LongOpt("version", 0, null, 118), new LongOpt("exclude", 1, null, 101), new LongOpt("generate-sidl-stdlib", 0, null, 5), new LongOpt("no-default-repository", 0, null, 6), new LongOpt("suppress-timestamp", 0, null, 7), new LongOpt("comment-local-only", 0, null, 8), new LongOpt("hide-glue", 0, null, 117), new LongOpt("exclude-external", 0, null, 69), new LongOpt("language-subdir", 0, null, 108)};
    private boolean d_can_proceed = false;
    private static UserOptions s_my_instance = null;

    protected UserOptions() {
    }

    public static UserOptions getInstance() {
        if (s_my_instance == null) {
            s_my_instance = new UserOptions();
        }
        return s_my_instance;
    }

    /*
     * WARNING - void declaration
     */
    public int parseCommandlineOptions(BabelConfiguration theConfig, String[] args) {
        int c;
        Getopt commandlineOptions = new Getopt("babel", args, "Eghpvxluo:c:r:R:s:t:e:", d_long_opts);
        int numRequired = 0;
        boolean helpSet = false;
        boolean versionSet = false;
        block27: while ((c = commandlineOptions.getopt()) != -1) {
            void var7_7;
            switch (var7_7) {
                case 5: {
                    theConfig.setGenerateStdlib(true);
                    ++numRequired;
                    break;
                }
                case 6: {
                    System.err.println("Babel: Warning: no-default-repository is a babel driver script option only.");
                    break;
                }
                case 7: {
                    theConfig.setSuppressTimestamps(true);
                    break;
                }
                case 8: {
                    theConfig.setCommentLocalOnly(true);
                    break;
                }
                case 112: {
                    theConfig.setParseCheckOnly(true);
                    ++numRequired;
                    break;
                }
                case 99: {
                    String clang = commandlineOptions.getOptarg().toLowerCase();
                    if (this.validClientLanguage(clang)) {
                        theConfig.setGenerateClient(true);
                        theConfig.setTargetLanguage(clang);
                        ++numRequired;
                        break;
                    }
                    System.err.println("Babel: Error: Unsupported language (" + clang + ") specified for client option.");
                    break;
                }
                case 114: {
                    String rlang = commandlineOptions.getOptarg().toLowerCase();
                    if (UserOptions.validRemoteLanguage(rlang)) {
                        theConfig.setGenerateRemote(true);
                        theConfig.setTargetLanguage(rlang);
                    } else {
                        System.err.println("Babel: Error: Unsupported language (" + rlang + ") specified for remote option.");
                    }
                    System.err.println("\nBabel: *** Sorry. Remote invocation is not yet supported. ***\n");
                    break;
                }
                case 115: {
                    String slang = commandlineOptions.getOptarg().toLowerCase();
                    if (UserOptions.validServerLanguage(slang)) {
                        theConfig.setGenerateServer(true);
                        theConfig.setTargetLanguage(slang);
                        ++numRequired;
                        break;
                    }
                    System.err.println("Babel: Error: Unsupported language (" + slang + ") specified for server option.");
                    break;
                }
                case 116: {
                    String tlang = commandlineOptions.getOptarg().toLowerCase();
                    if (this.validTextRepresentation(tlang)) {
                        theConfig.setGenerateText(true);
                        theConfig.setTargetLanguage(tlang);
                        ++numRequired;
                        break;
                    }
                    System.err.println("Babel: Error: Unsupported language representation (" + tlang + ") specified for text option.");
                    break;
                }
                case 120: {
                    theConfig.setGenerateXML(true);
                    ++numRequired;
                    break;
                }
                case 104: {
                    helpSet = true;
                    ++numRequired;
                    break;
                }
                case 118: {
                    versionSet = true;
                    ++numRequired;
                    break;
                }
                case 82: {
                    theConfig.addToRepositoryPath(commandlineOptions.getOptarg());
                    break;
                }
                case 111: {
                    theConfig.setOutputDirectory(commandlineOptions.getOptarg());
                    break;
                }
                case 86: {
                    theConfig.setVPathDirectory(commandlineOptions.getOptarg());
                    break;
                }
                case 103: {
                    theConfig.setMakePackageSubdirs(true);
                    break;
                }
                case 101: {
                    try {
                        theConfig.addExcluded(new RegexMatch(commandlineOptions.getOptarg()));
                    }
                    catch (RegexUnsupportedException rue) {
                        System.err.println("Babel: The --exclude=<regex> | -e <regex> feature requires a Java runtime environment with the");
                        System.err.println("1.4 library or higher for regular expression support.");
                        System.err.println("You must use a more recent version of Java to use this feature.");
                    }
                    catch (BadRegexException bre) {
                        System.err.println("Babel: " + bre.getMessage());
                    }
                    continue block27;
                }
                case 108: {
                    theConfig.setMakeLanguageSubdir(true);
                    break;
                }
                case 117: {
                    theConfig.setMakeGlueSubdirs(true);
                    break;
                }
                case 69: {
                    theConfig.setExcludeExternal(true);
                    break;
                }
                case 58: {
                    break;
                }
                case 63: {
                    break;
                }
                default: {
                    System.err.println("Babel: Error: Should never have reached default in gov.llnl.babel.UserOptions.");
                }
            }
        }
        int returnIndex = commandlineOptions.getOptind();
        if (returnIndex == 0 && returnIndex == args.length) {
            helpSet = true;
            numRequired = 1;
        }
        if (theConfig.generateClient() && theConfig.getTargetLanguage().equals("python") && theConfig.generateStdlib()) {
            System.err.println("Babel: Warning:  Allowing concurrent request for python client and SIDL standard library generation.");
            --numRequired;
        }
        if (numRequired > 1) {
            System.err.println("Babel: Error: Only one of the following options or its equivalent is allowed:");
            System.err.println("         --help, --version, --client, --server, --text,");
            System.err.println("         --parse-check, or --generate-sidl-stdlib.");
        } else if (numRequired < 1) {
            System.err.println("Babel: Error: You must enter one of the following options or its equivalent along with");
            System.err.println("       any associated argument:");
            System.err.println("         --help, --version, --client, --server, --text,");
            System.err.println("         --parse-check, or --generate-sidl-stdlib.");
        } else if (versionSet || helpSet) {
            if (versionSet) {
                System.out.println("Babel version 0.8.8");
            }
            if (helpSet) {
                System.out.println();
                this.printUsage();
            }
        } else {
            this.d_can_proceed = true;
            if (theConfig.generateStdlib()) {
                theConfig.setGenerateServer(true);
                if (!theConfig.generateClient() || !"python".equals(theConfig.getTargetLanguage())) {
                    theConfig.setTargetLanguage("c");
                }
            }
        }
        return returnIndex;
    }

    public void printUsage() {
        System.out.println("Usage:  babel [ -h | --help ]");
        System.out.println("   or   babel [ -v | --version ]");
        System.out.println("   or   babel option(s) sidlfilename1 ... sidlfilenameN");
        System.out.println();
        System.out.println("where help, version, and option(s) are:");
        System.out.println(" -h       | --help          Display usage information and exit.");
        System.out.println(" -v       | --version       Display version and exit.");
        System.out.println(" -p       | --parse-check   Parse the sidl file but do not generate code.");
        System.out.println(" -x       | --xml           Generate only SIDL XML (deprecated; use -tXML).");
        System.out.println(" -c<lang> | --client=<lang> Generate only client code in specified language");
        System.out.println("                              (C | C++ | F77 | F90 | Java | Python).");
        System.out.println(" -s<lang> | --server=<lang> Generate server (and client) code in specified");
        System.out.println("                              language (C | C++ | F77 | F90 | Java | Python).");
        System.out.println(" -t<form> | --text=<form>   Generate text in specified form (XML | SIDL), where");
        System.out.println("                              XML updates the repository.");
        System.out.println(" -o<dir>  | --output-directory=<dir>");
        System.out.println("                            Set Babel output directory ('.' default).");
        System.out.println(" -R<path> | --repository-path=<path>");
        System.out.println("                            Set semicolon-separated URL list used to resolve");
        System.out.println("                              symbols.");
        System.out.println(" -e<regex> | --exclude=<regex>");
        System.out.println("                            Symbols matching the regular expression");
        System.out.println("                            are excluded from code generation.");
        System.out.println("                            Requires JRE 1.4 virtual machine or higher.");
        System.out.println("                            matching package hierarchy.");
        System.out.println(" -E        | --exclude-external");
        System.out.println("                            Code is generated only for the symbol hierarchies rooted");
        System.out.println("                            at the symbols specified on the command line.");
        System.out.println(" -V<path>  | --vpath=<path> Prepend alternative search path for reading Impl");
        System.out.println("                            splicer blocks.  Does not affect where Impls are");
        System.out.println("                            generated.");
        System.out.println("                            NOTE: --vpath=. is a no-op for autoconf/automake");
        System.out.println("                            If you really want current directory, use");
        System.out.println("                            another argument like `pwd` or even ./.");
        System.out.println(" -g       | --generate-subdirs");
        System.out.println("                            Postpend Java-style package subdirs");
        System.out.println("                            to paths specified by -o and -V.");
        System.out.println(" -l       | --language-subdir");
        System.out.println("                            Generate code in a language-specific");
        System.out.println("                            subdirectory.");
        System.out.println(" -u       | --hide-glue");
        System.out.println("                            Put \"glue\" (not modifiable by user) generated");
        System.out.println("                            code in a glue/ subdirectory.");
        System.out.println(" --no-default-repository    Prohibit use of default to resolve symbols.");
        System.out.println(" --suppress-timestamp       Suppress timestamps in generated files.");
        System.out.println(" --generate-sidl-stdlib     Regenerate only the SIDL standard library.");
        System.out.println(" --comment-local-only       Only comment locally defined methods in stub.");
        System.out.println();
        System.out.println("Note:  One of the following options or its equivalent must be specified:");
        System.out.println("         --help, --version, --client, --server, --xml, --text, --parse-check, or");
        System.out.println("         --generate-sidl-stdlib.");
        System.out.println();
        System.out.println("If you have any suggestions or questions not answered by the documenation,");
        System.out.println("please send email to components@llnl.gov.");
    }

    private boolean validClientLanguage(String lang) {
        CodeGenerationFactory factory = CodeGenerationFactory.getInstance();
        return factory.getCodeGenerator(lang, "stub") != null;
    }

    private static boolean validRemoteLanguage(String lang) {
        boolean isValid = false;
        return isValid;
    }

    private static boolean validServerLanguage(String lang) {
        CodeGenerationFactory factory = CodeGenerationFactory.getInstance();
        return factory.getCodeGenerator(lang, "skel") != null;
    }

    private boolean validTextRepresentation(String lang) {
        CodeGenerationFactory factory;
        boolean isValid = false;
        isValid = lang.equals("xml") ? true : (factory = CodeGenerationFactory.getInstance()).getCodeGenerator(lang, "text") != null;
        return isValid;
    }

    public boolean canProceed() {
        return this.d_can_proceed;
    }

    public static void main(String[] args) {
        UserOptions opts = UserOptions.getInstance();
        BabelConfiguration config = new BabelConfiguration();
        System.out.println("\n...Processing the command line...");
        opts.parseCommandlineOptions(config, args);
        if (opts.canProceed()) {
            System.out.println("\n*** Able to proceed with compilation request ***");
        } else {
            System.out.println("\n*** CANNOT proceed with compilation ***");
        }
        System.out.println("\n\n...Printing resulting settings...");
        System.out.println("Generate Client      = " + config.generateClient());
        System.out.println("Generate Server      = " + config.generateServer());
        System.out.println("Generate Text        = " + config.generateText());
        System.out.println("Generate SIDL Stdlib = " + config.generateStdlib());
        System.out.println("Parse Only           = " + config.parseCheckOnly());
        System.out.println("Target Language      = " + config.getTargetLanguage());
        System.out.println("Output Directory     = " + config.getOutputDirectory());
        System.out.println("VPATH Directory      = " + config.getVPathDirectory());
        System.out.println("Make Pkg Subdirs     = " + config.makePackageSubdirs());
        System.out.println("Repository Path      = " + config.getRepositoryPath());
        System.out.println("Suppress Timestamps  = " + config.suppressTimestamps());
        System.out.println("Make Language Subdir = " + config.makeLanguageSubdir());
        System.out.println("Make Glue Subdir     = " + config.makeGlueSubdirs());
        System.out.println("Exclude External Pkgs= " + config.excludeExternal());
        System.out.println("\n\n...Done.");
    }
}

