/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.vfs;

import java.io.InputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipEntry;

/**
 * Accessor for Zip file VFS.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public final class ZipVFileAccessor
    implements VFileAccessor
{
    /**
     * Get size of resource in bytes.
     *
     * @param resource the resource designator
     * @return the size of resource in bytes
     */
    public long getSize( final VFile file, final Object resource )
    {
        try 
        {
            final ZipFile zipFile = (ZipFile)resource;
            final String name = file.toString().substring( 1 );
            final ZipEntry entry = zipFile.getEntry( name );
            return entry.getSize();
        }
        catch( final Exception e )
        {
            return -1;
        }
    }

    /**
     * Get InputStream for resource.
     *
     * @param resource the resource designator
     * @return the input stream
     * @exception IOException if an error occurs
     */
    public InputStream getInputStream( final VFile file, final Object resource )
    {
        try
        {
            final ZipFile zipFile = (ZipFile)resource;
            final String name = file.toString().substring( 1 );
            final ZipEntry entry = zipFile.getEntry( name );
            return zipFile.getInputStream( entry );
        }
        catch( final Exception e )
        {
            return null;
        }
    }
}
