/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.source;

import java.io.IOException;
import java.io.InputStream;

/**
 * Description of a source. This interface provides a simple interface
 * for accessing a source of data. The source of data is assumed to
 * <b>not change</b> during the lifetime of the Source object. If you
 * have a data source that can change its content and you want it to
 * reflect it, use a {@link ModifiableSource} object instead.
 *
 * When the <code>Source</code> object is no longer needed
 * it must be released using the resolver. This is very similar like
 * looking up components from a <code>ComponentManager</code>.
 * In fact a source object can implement most lifecycle interfaces
 * like Composable, Initializable, Disposable etc.
 *
 * @author <a href="mailto:cziegeler@apache.org">Carsten Ziegeler</a>
 * @author <a href="mailto:ovidiu@cup.hp.com">Ovidiu Predescu</a>
 * @version CVS $Revision: 1.10 $ $Date: 2002/01/08 13:43:48 $
 */
public interface Source {

    /**
     * Return an <code>InputStream</code> object to read from the source.
     * This is the data at the point of invocation of this method,
     * so if this is an {@link ModifiableSource} object, you might get
     * different content from two invocations.
     */
    InputStream getInputStream()
    throws IOException;

    /**
     * Return the unique identifer for this source
     */
    String getSystemId();

}
