/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Iterator;

/**
 * The <code>ThreadContextAccessor</code> is the interface through which
 * ThreadContextPolicy objects access thread context. This is required so 
 * that it can be exposed only to ThreadContextPolicy and not the whole 
 * world.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public interface ThreadContextAccessor
{
    /**
     * Determine if ThreadContext contains specified key.
     *
     * @param key the key
     */
    boolean containsKey( String key );

    /**
     * Retrieve value for specified key.
     *
     * @param key the key
     */
    Object get( String key );
}
