/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Locale;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.component.Component;

/**
 * Maps the locale using the standard Java mapping: en-US would be mapped to
 * file ending with en_US.
 *
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version CVS $Revision: 1.6 $ $Date: 2002/01/02 19:04:56 $ $Author: neeme $
 */

public class DefaultMapper implements BundleInfoMapper, Component, Configurable {

    public static final class ConfigurationKeys {
        public static final String PREFIX = "prefix";
        public static final String SUFFIX = "suffix";
    }

    private String prefix = null;
    private String suffix = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (prefix == null) prefix = configuration.getChild(ConfigurationKeys.PREFIX).getValue();
        if (suffix == null) suffix = configuration.getChild(ConfigurationKeys.SUFFIX).getValue();
    }

    protected String getPrefix() {
        return prefix;
    }

    protected String getSuffix() {
        return suffix;
    }

    /**
     * Get the URI for the bundle, based on locale and filename.
     *
     * @return      the URI
     */
    public String map(BundleInfo bundleInfo) {
        String name = bundleInfo.getName();
        Locale loc = bundleInfo.getLocale();
        StringBuffer sb = new StringBuffer(getPrefix());
        sb.append('/').append(name);
        if (loc != null)
        {
            if (! loc.getLanguage().equals(""))
            {
                sb.append("_");
                sb.append(loc.getLanguage());
            }
            if (! loc.getCountry().equals(""))
            {
                sb.append("_");
                sb.append(loc.getCountry());
            }
            if (! loc.getVariant().equals(""))
            {
                sb.append("_");
                sb.append(loc.getVariant());
            }
        }
        sb.append(getSuffix());
        String result = sb.toString();
        return result;
    }

}
