/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.collections;

import org.apache.avalon.framework.CascadingRuntimeException;

/**
 * The BufferOverflowException is used when the buffer's capacity has been
 * exceeded.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 */
public class BufferOverflowException extends CascadingRuntimeException
{

    public BufferOverflowException( String message )
    {
        super( message, null );
    }

    public BufferOverflowException( String message, Throwable exception )
    {
        super( message, exception );
    }
}
