/*
 *  preferences_c.c
 *  Atari800MacX
 *
 *  Created by Mark Grebe on Fri Sep 13 2002.
 *  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "atari.h"
#include "prompts.h"
#include "input.h"
#include "rt-config.h"
#include "preferences_c.h"
#include "SDL.h"

extern char HPath[FILENAME_MAX];
extern int useBuiltinPalette;
extern int adjustPalette;
extern int paletteBlack;
extern int paletteWhite;
extern int paletteIntensity;
extern int paletteColorShift;
extern int FULLSCREEN;
extern int lockFullscreenSize;
extern int DOUBLESIZE;
extern int scaleFactor;
extern int WIDTH_MODE;
extern int SHOWFPS;
extern int JOYSTICK_MODE[4];
extern int JOYSTICK_AUTOFIRE[4];
extern int mouse_mode;
extern int mouse_speed;
extern int mouse_pot_min;
extern int mouse_pot_max;
extern int mouse_pen_ofs_h;
extern int mouse_pen_ofs_v;
extern int mouse_joy_inertia;
extern int global_artif_mode;
extern int sound_enabled;
extern int speed_limit;
extern int hold_start_on_reboot;
extern int hold_start;
extern int requestPrefsChange;
extern char paletteFilename[FILENAME_MAX];
extern int enable_r_patch;
extern int r_device_port;
extern int ignore_header_writeprotect;
extern int joystickButtonKey[4][24]; 
extern int joystick5200ButtonKey[4][24];
extern int joystick0TypePref, joystick1TypePref;
extern int joystick2TypePref, joystick3TypePref;
extern int joystick0Num, joystick1Num;
extern int joystick2Num, joystick3Num;
extern int paddlesXAxisOnly;
extern int SDL_TRIG_0;
extern int SDL_TRIG_0_B;
extern int SDL_JOY_0_LEFT;
extern int SDL_JOY_0_RIGHT;
extern int SDL_JOY_0_DOWN;
extern int SDL_JOY_0_UP;
extern int SDL_JOY_0_LEFTUP;
extern int SDL_JOY_0_RIGHTUP;
extern int SDL_JOY_0_LEFTDOWN;
extern int SDL_JOY_0_RIGHTDOWN;
extern int SDL_TRIG_1;
extern int SDL_TRIG_1_B;
extern int SDL_JOY_1_LEFT;
extern int SDL_JOY_1_RIGHT;
extern int SDL_JOY_1_DOWN;
extern int SDL_JOY_1_UP;
extern int SDL_JOY_1_LEFTUP;
extern int SDL_JOY_1_RIGHTUP;
extern int SDL_JOY_1_LEFTDOWN;
extern int SDL_JOY_1_RIGHTDOWN;


/* Variables brought over from RT_CONFIG.C */
char atari_osa_filename[FILENAME_MAX];
char atari_osb_filename[FILENAME_MAX];
char atari_xlxe_filename[FILENAME_MAX];
char atari_basic_filename[FILENAME_MAX];
char atari_5200_filename[FILENAME_MAX];
char atari_disk_dirs[MAX_DIRECTORIES][FILENAME_MAX];
char atari_diskset_dir[FILENAME_MAX];
char atari_rom_dir[FILENAME_MAX];
char atari_h1_dir[FILENAME_MAX];
char atari_h2_dir[FILENAME_MAX];
char atari_h3_dir[FILENAME_MAX];
char atari_h4_dir[FILENAME_MAX];
char atari_exe_dir[FILENAME_MAX];
char atari_state_dir[FILENAME_MAX];
char print_command[256];
int hd_read_only;
int refresh_rate;
int disable_basic;
int enable_sio_patch;
int enable_h_patch;
int enable_p_patch;
int enable_new_pokey;
int stereo_enabled;
int disk_directories;
/* Variables used for boot devices */
int prefsArgc = 0;
char *prefsArgv[15];
/* Storage for current and former preferences */
static ATARI800MACX_PREF prefs, lastPrefs;
/* Variables used to determine what has changed after a preferences update */
int displaySizeChanged;
int showfpsChanged;
int artifChanged;
int paletteChanged;
int machineTypeChanged;
int patchFlagsChanged;
int keyboardJoystickChanged;
int hardDiskChanged;
int hifiSoundChanged;

/* Arrays to translate menu indicies for gamepad keys to key values */
#define AKEY_BUTTON1  		0x100
#define AKEY_BUTTON2  		0x200
#define AKEY_BUTTON_START  	0x300
#define AKEY_BUTTON_SELECT 	0x400
#define AKEY_BUTTON_OPTION 	0x500
#define AKEY_BUTTON_RESET	0x600
#define AKEY_JOYSTICK_UP	0x700
#define AKEY_JOYSTICK_DOWN	0x701
#define AKEY_JOYSTICK_LEFT	0x702
#define AKEY_JOYSTICK_RIGHT	0x703

int joystickIndexToKey[] = 
    {AKEY_BUTTON1, AKEY_HELP, AKEY_BUTTON_RESET, AKEY_BUTTON_SELECT, 
     AKEY_BUTTON_OPTION, AKEY_BUTTON_START, AKEY_a, AKEY_b, AKEY_c,
     AKEY_d, AKEY_e, AKEY_f, AKEY_g, AKEY_h, AKEY_i, AKEY_j, AKEY_k,
     AKEY_l, AKEY_m, AKEY_n, AKEY_o, AKEY_p, AKEY_q, AKEY_r, AKEY_s, 
     AKEY_t, AKEY_u, AKEY_v, AKEY_w, AKEY_x, AKEY_y, AKEY_z, AKEY_SPACE,
     AKEY_ESCAPE, AKEY_0, AKEY_1, AKEY_2, AKEY_3, AKEY_4, AKEY_5, AKEY_6, AKEY_7,
     AKEY_8, AKEY_9, AKEY_LESS, AKEY_GREATER, AKEY_BACKSPACE, AKEY_BREAK,
     AKEY_TAB, AKEY_MINUS, AKEY_EQUAL, AKEY_RETURN, AKEY_CTRL, AKEY_COLON,
     AKEY_PLUS, AKEY_ASTERISK, AKEY_CAPSTOGGLE, AKEY_SHFT, AKEY_COMMA,
     AKEY_FULLSTOP, AKEY_SLASH, AKEY_ATARI, AKEY_JOYSTICK_UP, AKEY_JOYSTICK_DOWN,
     AKEY_JOYSTICK_LEFT, AKEY_JOYSTICK_RIGHT};
int joystick5200IndexToKey[] = 
    {AKEY_BUTTON1, AKEY_BUTTON2, AKEY_5200_START, AKEY_5200_PAUSE,
     AKEY_5200_RESET, AKEY_5200_0, AKEY_5200_1, AKEY_5200_2, AKEY_5200_3,
     AKEY_5200_4, AKEY_5200_5, AKEY_5200_6, AKEY_5200_7, AKEY_5200_8,
     AKEY_5200_9, AKEY_5200_HASH, AKEY_5200_ASTERISK, AKEY_JOYSTICK_UP, 
     AKEY_JOYSTICK_DOWN, AKEY_JOYSTICK_LEFT, AKEY_JOYSTICK_RIGHT};

/* Arrays to translate menu indicies for keyboard joystick keys to key values */
int keyboardStickIndexToKey[] =
    {SDLK_a, SDLK_b, SDLK_c, SDLK_d, SDLK_e, SDLK_f, SDLK_g, SDLK_h, SDLK_i, SDLK_j,
     SDLK_k, SDLK_l, SDLK_m, SDLK_n, SDLK_o, SDLK_p, SDLK_q, SDLK_r, SDLK_s, SDLK_t,
     SDLK_u, SDLK_v, SDLK_w, SDLK_x, SDLK_y, SDLK_z, SDLK_CARET , SDLK_1, SDLK_2, SDLK_3,
     SDLK_4, SDLK_5, SDLK_6, SDLK_7, SDLK_8, SDLK_9, SDLK_0, SDLK_MINUS, SDLK_EQUALS,
     SDLK_BACKSPACE, SDLK_TAB, SDLK_LEFTBRACKET, SDLK_RIGHTBRACKET, SDLK_BACKSLASH,
     SDLK_RETURN, SDLK_PERIOD, SDLK_COMMA, SDLK_SLASH, SDLK_LSHIFT, SDLK_LCTRL, SDLK_LALT, 
     SDLK_SPACE, SDLK_INSERT, SDLK_HOME, SDLK_PAGEUP, SDLK_DELETE, SDLK_END, SDLK_PAGEDOWN, 
     SDLK_LEFT, SDLK_UP, SDLK_DOWN, SDLK_RIGHT, SDLK_KP0, SDLK_KP1, SDLK_KP2, 
     SDLK_KP3, SDLK_KP4, SDLK_KP5, SDLK_KP6, SDLK_KP7, SDLK_KP8, SDLK_KP9, SDLK_KP_PERIOD,
     SDLK_KP_ENTER, SDLK_KP_PLUS, SDLK_KP_MINUS, SDLK_KP_MULTIPLY, SDLK_KP_DIVIDE
     };

ATARI800MACX_PREF *getPrefStorage(void) {
    int static firstTime = TRUE;
    
    if (firstTime) {
        firstTime = FALSE;
        return(&prefs);
        }
    else {
        lastPrefs = prefs;
        return(&prefs);
        }
    }

void commitPrefs() {
    int i;
    
    prefsArgv[prefsArgc++] = "Atari800MacX";
    if (prefs.cartFileEnabled) {
        prefsArgv[prefsArgc++] = "-cart";
        prefsArgv[prefsArgc++] = prefs.cartFile;
        }
    if (prefs.exeFileEnabled) {
        prefsArgv[prefsArgc++] = "-run";
        prefsArgv[prefsArgc++] = prefs.exeFile;
        }
    if (prefs.cassFileEnabled) {
        if (prefs.bootFromCassette)
            prefsArgv[prefsArgc++] = "-boottape";
        else
            prefsArgv[prefsArgc++] = "-tape";
        prefsArgv[prefsArgc++] = prefs.cassFile;
        }
    for (i=0;i<8;i++) {
        if (prefs.dFileEnabled[i]) {
            prefsArgv[prefsArgc++] = prefs.dFile[i];
            }
        }
}

void CalcMachineType(int type, int *machineType, int *ramSize)
{
    switch(type) {
        case 0:
            *machineType = MACHINE_OSA;
            *ramSize = 16;
            break;
        case 1:
            *machineType = MACHINE_OSA;
            *ramSize = 48;
            break;
        case 2:
            *machineType = MACHINE_OSA;
            *ramSize = 52;
            break;
        case 3:
            *machineType = MACHINE_OSB;
            *ramSize = 16;
            break;
        case 4:
            *machineType = MACHINE_OSB;
            *ramSize = 48;
            break;
        case 5:
            *machineType = MACHINE_OSB;
            *ramSize = 52;
            break;
        case 6:
            *machineType = MACHINE_XLXE;
            *ramSize = 16;
            break;
        case 7:
            *machineType = MACHINE_XLXE;
            *ramSize = 64;
            break;
        case 8:
            *machineType = MACHINE_XLXE;
            *ramSize = 128;
            break;
        case 9:
            *machineType = MACHINE_XLXE;
            *ramSize = RAM_320_RAMBO;
            break;
        case 10:
            *machineType = MACHINE_XLXE;
            *ramSize = RAM_320_COMPY_SHOP;
            break;
        case 11:
            *machineType = MACHINE_XLXE;
            *ramSize = 576;
            break;
        case 12:
            *machineType = MACHINE_XLXE;
            *ramSize = 1088;
            break;
        case 13:
            *machineType = MACHINE_5200;
            *ramSize = 16;
            break;
        }

}

void CalculatePrefsChanged()
{
    int new_machine_type;
    int new_ram_size;

    if ((FULLSCREEN != prefs.fullScreen) ||
        (DOUBLESIZE != prefs.doubleSize) ||
        (WIDTH_MODE != prefs.widthMode) ||
        ((scaleFactor != prefs.scaleFactor) && DOUBLESIZE))
        displaySizeChanged = TRUE;
    else
        displaySizeChanged = FALSE;

    if (SHOWFPS != prefs.showFPS)
        showfpsChanged = TRUE;
    else
        showfpsChanged = FALSE;
        
    if (strcmp(prefs.paletteFile, paletteFilename) == 0 &&
        (useBuiltinPalette == prefs.useBuiltinPalette) &&
        (adjustPalette == prefs.adjustPalette) &&
        (paletteBlack == prefs.blackLevel) &&
        (paletteWhite == prefs.whiteLevel) &&
        (paletteIntensity == prefs.intensity) &&
        (paletteColorShift == prefs.colorShift)) 
        paletteChanged = FALSE;
    else
        paletteChanged = TRUE;

    if (global_artif_mode != prefs.artifactingMode)
        artifChanged = TRUE;
    else
        artifChanged = FALSE;

    CalcMachineType(prefs.atariType, &new_machine_type, &new_ram_size);
    if ((machine_type != new_machine_type) ||
        (ram_size != new_ram_size))
        machineTypeChanged = TRUE;
    else
        machineTypeChanged = FALSE;
        
    if ((disable_basic != prefs.disableBasic) ||
        (enable_sio_patch != prefs.enableSioPatch) ||
        (enable_h_patch != prefs.enableHPatch) ||
        (enable_p_patch != prefs.enablePPatch) ||
        (enable_r_patch != prefs.enableRPatch) ||
        (hold_start_on_reboot != prefs.bootFromCassette))
        patchFlagsChanged = TRUE;
    else
        patchFlagsChanged = FALSE;
        
    if ((SDL_TRIG_1 != keyboardStickIndexToKey[prefs.leftJoyFire]) ||
        (SDL_TRIG_1_B != keyboardStickIndexToKey[prefs.leftJoyAltFire]) ||
        (SDL_JOY_1_LEFT != keyboardStickIndexToKey[prefs.leftJoyLeft]) ||
        (SDL_JOY_1_RIGHT != keyboardStickIndexToKey[prefs.leftJoyRight]) ||
        (SDL_JOY_1_DOWN != keyboardStickIndexToKey[prefs.leftJoyDown]) ||
        (SDL_JOY_1_UP != keyboardStickIndexToKey[prefs.leftJoyUp]) ||
        (SDL_JOY_1_LEFTUP != keyboardStickIndexToKey[prefs.leftJoyUpLeft]) ||
        (SDL_JOY_1_RIGHTUP != keyboardStickIndexToKey[prefs.leftJoyUpRight]) ||
        (SDL_JOY_1_LEFTDOWN != keyboardStickIndexToKey[prefs.leftJoyDownLeft]) ||
        (SDL_JOY_1_RIGHTDOWN != keyboardStickIndexToKey[prefs.leftJoyDownRight]) ||
        (SDL_TRIG_0 != keyboardStickIndexToKey[prefs.padJoyFire]) ||
        (SDL_TRIG_0_B != keyboardStickIndexToKey[prefs.padJoyAltFire]) ||
        (SDL_JOY_0_LEFT != keyboardStickIndexToKey[prefs.padJoyLeft]) ||
        (SDL_JOY_0_RIGHT != keyboardStickIndexToKey[prefs.padJoyRight]) ||
        (SDL_JOY_0_DOWN != keyboardStickIndexToKey[prefs.padJoyDown]) ||
        (SDL_JOY_0_UP != keyboardStickIndexToKey[prefs.padJoyUp]) ||
        (SDL_JOY_0_LEFTUP != keyboardStickIndexToKey[prefs.padJoyUpLeft]) ||
        (SDL_JOY_0_RIGHTUP != keyboardStickIndexToKey[prefs.padJoyUpRight]) ||
        (SDL_JOY_0_LEFTDOWN != keyboardStickIndexToKey[prefs.padJoyDownLeft]) ||
        (SDL_JOY_0_RIGHTDOWN != keyboardStickIndexToKey[prefs.padJoyDownRight]))
        keyboardJoystickChanged = TRUE;
    else
        keyboardJoystickChanged = FALSE;
        
    if ((strcmp(atari_h1_dir, prefs.hardDiskDir[0]) != 0) ||
        (strcmp(atari_h2_dir, prefs.hardDiskDir[1]) != 0) ||
        (strcmp(atari_h3_dir, prefs.hardDiskDir[2]) != 0) ||
        (strcmp(atari_h4_dir, prefs.hardDiskDir[3]) != 0) ||
        (strcmp(HPath, prefs.hPath) != 0))
        hardDiskChanged = TRUE;
    else
        hardDiskChanged = FALSE;
    
    if (enable_new_pokey != prefs.enableHifiSound)
        hifiSoundChanged = TRUE;
    else
        hifiSoundChanged = FALSE;

}

int RtConfigLoad(const char *rtconfig_filename)
{
    int i,j;

    printf("-----------------------------------\n");

    FULLSCREEN = prefs.fullScreen;
    lockFullscreenSize = prefs.lockFullscreenSize;
    DOUBLESIZE = prefs.doubleSize;
    scaleFactor = prefs.scaleFactor; 
    WIDTH_MODE = prefs.widthMode; 
    SHOWFPS = prefs.showFPS;

    if (prefs.tvMode == 0) {
        tv_mode = TV_NTSC;
        }
    else {
        tv_mode = TV_PAL;
        }
    refresh_rate = prefs.refreshRatio;
    global_artif_mode = prefs.artifactingMode;
    useBuiltinPalette = prefs.useBuiltinPalette;
    adjustPalette = prefs.adjustPalette;
    paletteBlack = prefs.blackLevel;
    paletteWhite = prefs.whiteLevel;
    paletteIntensity = prefs.intensity;
    paletteColorShift = prefs.colorShift; 
    strcpy(paletteFilename, prefs.paletteFile);
    CalcMachineType(prefs.atariType, &machine_type, &ram_size);
    disable_basic = prefs.disableBasic;
    enable_sio_patch = prefs.enableSioPatch;
    enable_h_patch = prefs.enableHPatch;
    enable_p_patch = prefs.enablePPatch;
    enable_r_patch = prefs.enableRPatch;
    r_device_port = prefs.rPatchPort;
    strncpy(print_command, prefs.printCommand,256);
    sound_enabled = prefs.enableSound;
    enable_new_pokey = prefs.enableHifiSound;
    ignore_header_writeprotect = prefs.ignoreHeaderWriteprotect;
    speed_limit = prefs.speedLimit;
    hold_start_on_reboot = prefs.bootFromCassette;
    hold_start = prefs.bootFromCassette;
    strcpy(atari_h1_dir, prefs.hardDiskDir[0]);
    strcpy(atari_h2_dir, prefs.hardDiskDir[1]);
    strcpy(atari_h3_dir, prefs.hardDiskDir[2]);
    strcpy(atari_h4_dir, prefs.hardDiskDir[3]);
    hd_read_only = prefs.hardDrivesReadOnly;
    strcpy(HPath, prefs.hPath);
    strcpy(atari_osa_filename, prefs.osARomFile);
    strcpy(atari_osb_filename, prefs.osBRomFile);
    strcpy(atari_xlxe_filename, prefs.xlRomFile);
    strcpy(atari_basic_filename, prefs.basicRomFile);
    strcpy(atari_5200_filename, prefs.a5200RomFile);
    strcpy(atari_disk_dirs[0], prefs.diskImageDir);
    strcpy(atari_diskset_dir,prefs.diskSetDir);
    strcpy(atari_rom_dir, prefs.cartImageDir);
    strcpy(atari_exe_dir, prefs.exeFileDir);
    strcpy(atari_state_dir, prefs.savedStateDir);
    for (i=0;i<4;i++) {
        JOYSTICK_MODE[i] = prefs.joystickMode[i];
        JOYSTICK_AUTOFIRE[i] = prefs.joystickAutofire[i];
        } 
    joy_multijoy = prefs.enableMultijoy;

    mouse_mode = prefs.mouseDevice;
    mouse_speed = prefs.mouseSpeed;
    mouse_pot_min = prefs.mouseMinVal;
    mouse_pot_max = prefs.mouseMaxVal;
    mouse_pen_ofs_h = prefs.mouseHOffset;
    mouse_pen_ofs_v = prefs.mouseVOffset;
    mouse_joy_inertia = prefs.mouseInertia;

    for (i=0;i<4;i++) {
        for (j=0;j<24;j++) {
            joystickButtonKey[i][j] = joystickIndexToKey[prefs.buttonAssignment[i][j]];
            joystick5200ButtonKey[i][j] = joystick5200IndexToKey[prefs.button5200Assignment[i][j]];
            }
        }

    joystick0TypePref = prefs.joystick1Type;
    joystick1TypePref = prefs.joystick2Type;
    joystick2TypePref = prefs.joystick3Type;
    joystick3TypePref = prefs.joystick4Type;
    joystick0Num = prefs.joystick1Num;
    joystick1Num = prefs.joystick2Num;
    joystick2Num = prefs.joystick2Num;
    joystick3Num = prefs.joystick4Num;
    paddlesXAxisOnly  = prefs.paddlesXAxisOnly; 
    
    SDL_TRIG_1 = keyboardStickIndexToKey[prefs.leftJoyFire];
    SDL_TRIG_1_B = keyboardStickIndexToKey[prefs.leftJoyAltFire];
    SDL_JOY_1_LEFT = keyboardStickIndexToKey[prefs.leftJoyLeft];
    SDL_JOY_1_RIGHT = keyboardStickIndexToKey[prefs.leftJoyRight];
    SDL_JOY_1_DOWN = keyboardStickIndexToKey[prefs.leftJoyDown];
    SDL_JOY_1_UP = keyboardStickIndexToKey[prefs.leftJoyUp];
    SDL_JOY_1_LEFTUP = keyboardStickIndexToKey[prefs.leftJoyUpLeft];
    SDL_JOY_1_RIGHTUP = keyboardStickIndexToKey[prefs.leftJoyUpRight];
    SDL_JOY_1_LEFTDOWN = keyboardStickIndexToKey[prefs.leftJoyDownLeft];
    SDL_JOY_1_RIGHTDOWN = keyboardStickIndexToKey[prefs.leftJoyDownRight];
    SDL_TRIG_0 = keyboardStickIndexToKey[prefs.padJoyFire];
    SDL_TRIG_0_B = keyboardStickIndexToKey[prefs.padJoyAltFire];
    SDL_JOY_0_LEFT = keyboardStickIndexToKey[prefs.padJoyLeft];
    SDL_JOY_0_RIGHT = keyboardStickIndexToKey[prefs.padJoyRight];
    SDL_JOY_0_DOWN = keyboardStickIndexToKey[prefs.padJoyDown];
    SDL_JOY_0_UP = keyboardStickIndexToKey[prefs.padJoyUp];
    SDL_JOY_0_LEFTUP = keyboardStickIndexToKey[prefs.padJoyUpLeft];
    SDL_JOY_0_RIGHTUP = keyboardStickIndexToKey[prefs.padJoyUpRight];
    SDL_JOY_0_LEFTDOWN = keyboardStickIndexToKey[prefs.padJoyDownLeft];
    SDL_JOY_0_RIGHTDOWN = keyboardStickIndexToKey[prefs.padJoyDownRight];

    return(TRUE);
}
void RtConfigSave(void)
{
}
void RtConfigUpdate(void)
{
}


