/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.ITypeParameter;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMMethod;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMNode;
import org.aspectj.org.eclipse.jdt.internal.core.Assert;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.Member;
import org.aspectj.org.eclipse.jdt.internal.core.NamedMember;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;

public class SourceMethod
extends NamedMember
implements IMethod {
    protected String[] fParameterTypes;

    protected SourceMethod(JavaElement parent, String name, String[] parameterTypes) {
        super(parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.fParameterTypes = parameterTypes == null ? CharOperation.NO_STRINGS : parameterTypes;
    }

    protected void closing(Object info) throws JavaModelException {
        super.closing(info);
        SourceMethodElementInfo elementInfo = (SourceMethodElementInfo)info;
        ITypeParameter[] typeParameters = elementInfo.typeParameters;
        int i = 0;
        int length = typeParameters.length;
        while (i < length) {
            ((TypeParameter)typeParameters[i]).close();
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.fParameterTypes, ((SourceMethod)o).fParameterTypes);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        if (node.getNodeType() == 6) {
            try {
                IDOMMethod m = (IDOMMethod)node;
                if (this.isConstructor()) {
                    return (m.isConstructor() || m.getName().equals(this.getElementName())) && this.signatureEquals(m);
                }
                return super.equalsDOMNode(node) && this.signatureEquals(m);
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    public int getElementType() {
        return 9;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] exs = info.getExceptionTypeNames();
        return CompilationUnitStructureRequestor.convertTypeNamesToSigs(exs);
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.fParameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        return CharOperation.toStrings(names);
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        ITypeParameter[] typeParameters = this.getTypeParameters();
        int length = typeParameters.length;
        String[] typeParameterSignatures = new String[length];
        int i = 0;
        while (i < length) {
            TypeParameter typeParameter = (TypeParameter)typeParameters[i];
            TypeParameterElementInfo info = (TypeParameterElementInfo)typeParameter.getElementInfo();
            char[][] bounds = info.bounds;
            if (bounds == null) {
                typeParameterSignatures[i] = Signature.createTypeParameterSignature(typeParameter.getElementName(), CharOperation.NO_STRINGS);
            } else {
                int boundsLength = bounds.length;
                char[][] boundSignatures = new char[boundsLength][];
                int j = 0;
                while (j < boundsLength) {
                    boundSignatures[j] = Signature.createCharArrayTypeSignature(bounds[j], false);
                    ++j;
                }
                typeParameterSignatures[i] = new String(Signature.createTypeParameterSignature(typeParameter.getElementName().toCharArray(), boundSignatures));
            }
            ++i;
        }
        return typeParameterSignatures;
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getMethod(this.name, this.fParameterTypes);
    }

    public String getReturnType() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(info.getReturnTypeName(), false);
    }

    public String getSignature() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.getSignature();
    }

    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.fParameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.fParameterTypes[i].hashCode());
            ++i;
        }
        return hash;
    }

    public boolean isConstructor() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isSimilar(IMethod method) {
        return Member.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append('(');
        String[] parameterTypes = this.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected boolean signatureEquals(IDOMMethod method) {
        String[] otherTypes = method.getParameterTypes();
        String[] types = this.getParameterTypes();
        boolean ok = true;
        if (otherTypes == null || otherTypes.length == 0) {
            ok = types == null || types.length == 0;
        } else if (types != null) {
            ok = otherTypes.length == types.length;
        } else {
            return false;
        }
        if (ok && types != null) {
            int i = 0;
            while (i < types.length) {
                String otherType = Signature.createTypeSignature(otherTypes[i].toCharArray(), false);
                if (!types[i].equals(otherType)) {
                    ok = false;
                    break;
                }
                ++i;
            }
        }
        return ok;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            SourceMethodElementInfo methodInfo = (SourceMethodElementInfo)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(methodInfo.getReturnTypeName());
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append(Signature.toString(parameters[i]));
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append(Signature.toString(parameters[i]));
                    }
                }
                catch (IllegalArgumentException e) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }
}

