/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.WorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTConverter;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTRequestor;
import org.aspectj.org.eclipse.jdt.core.dom.BindingKey;
import org.aspectj.org.eclipse.jdt.core.dom.BindingResolver;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.aspectj.org.eclipse.jdt.core.dom.IBinding;
import org.aspectj.org.eclipse.jdt.core.dom.NodeSearcher;
import org.aspectj.org.eclipse.jdt.core.dom.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.CancelableNameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.CancelableProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import org.eclipse.core.runtime.IProgressMonitor;

class CompilationUnitResolver
extends Compiler {
    HashtableOfObject requestedSources;
    HashtableOfObject requestedKeys;
    DefaultBindingResolver.BindingTables bindingTables;

    public CompilationUnitResolver(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, false);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        SourceTypeElementInfo sourceType = (SourceTypeElementInfo)sourceTypes[0];
        this.accept((org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)sourceType.getHandle().getCompilationUnit()), accessRestriction);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void beginToCompile(org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sourceUnits, String[] bindingKeys) {
        CompilationUnitDeclaration parsedUnit;
        int sourceLength = sourceUnits.length;
        int keyLength = bindingKeys.length;
        int maxUnits = sourceLength + keyLength;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[maxUnits];
        int index = 0;
        this.requestedSources = new HashtableOfObject();
        int i = 0;
        while (true) {
            Object var11_11;
            if (i >= sourceLength) break;
            org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = sourceUnits[i];
            CompilationResult unitResult = new CompilationResult(sourceUnit, index++, maxUnits, this.options.maxProblemsPerUnit);
            try {
                if (this.options.verbose) {
                    System.out.println(Util.bind("compilation.request", new String[]{String.valueOf(index++ + 1), String.valueOf(maxUnits), new String(sourceUnit.getFileName())}));
                }
                parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                this.addCompilationUnit(sourceUnit, parsedUnit);
                this.requestedSources.put(unitResult.getFileName(), sourceUnit);
            }
            catch (Throwable throwable) {
                var11_11 = null;
                sourceUnits[i] = null;
                throw throwable;
            }
            {
                var11_11 = null;
                sourceUnits[i] = null;
                ++i;
                continue;
            }
            break;
        }
        this.requestedKeys = new HashtableOfObject();
        i = 0;
        while (true) {
            if (i >= keyLength) {
                this.lookupEnvironment.completeTypeBindings();
                return;
            }
            BindingKey bindingKey = new BindingKey(bindingKeys[i], this);
            parsedUnit = bindingKey.getCompilationUnitDeclaration();
            if (parsedUnit != null) {
                this.requestedKeys.put(parsedUnit.compilationResult.getFileName(), bindingKey);
            } else {
                switch (bindingKey.scanner.token) {
                    case 0: {
                        char[] pkgName = CharOperation.concatWith(bindingKey.compoundName(), '.');
                        this.requestedKeys.put(pkgName, bindingKey);
                        break;
                    }
                    case 1: {
                        char[] key = bindingKey.scanner.source;
                        this.requestedKeys.put(key, bindingKey);
                        break;
                    }
                }
            }
            ++i;
        }
    }

    IBinding createBinding(String key) {
        if (this.bindingTables == null) {
            throw new RuntimeException("Cannot be called outside ASTParser#createASTs(...)");
        }
        BindingKey bindingKey = new BindingKey(key, this);
        Binding compilerBinding = bindingKey.getCompilerBinding();
        if (compilerBinding == null) {
            return null;
        }
        DefaultBindingResolver resolver = new DefaultBindingResolver(this.lookupEnvironment, null, this.bindingTables);
        if (compilerBinding.kind() == 68) {
            return new TypeBinding(resolver, (ArrayBinding)compilerBinding);
        }
        return resolver.getBinding(compilerBinding);
    }

    public static ASTNode convert(CompilationUnitDeclaration compilationUnitDeclaration, char[] source, int apiLevel, Map options, boolean needToResolveBindings, WorkingCopyOwner owner, DefaultBindingResolver.BindingTables bindingTables, IProgressMonitor monitor) {
        BindingResolver resolver = null;
        AST ast = AST.newAST(apiLevel);
        ast.setDefaultNodeFlag(2);
        CompilationUnit compilationUnit = null;
        ASTConverter converter = new ASTConverter(options, needToResolveBindings, monitor);
        resolver = needToResolveBindings ? new DefaultBindingResolver(compilationUnitDeclaration.scope, owner, bindingTables) : new BindingResolver();
        ast.setBindingResolver(resolver);
        converter.setAST(ast);
        compilationUnit = converter.convert(compilationUnitDeclaration, source);
        compilationUnit.setLineEndTable(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return compilationUnit;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }
        };
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, false);
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        super.handleInternalException(internalException, unit, result);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        super.handleInternalException(abortException, unit);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    public static void parse(ICompilationUnit[] compilationUnits, ASTRequestor astRequestor, int apiLevel, Map options, IProgressMonitor monitor) {
        CompilerOptions compilerOptions = new CompilerOptions(options);
        CommentRecorderParser parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory()), false);
        int i = 0;
        int length = compilationUnits.length;
        while (i < length) {
            org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)compilationUnits[i]);
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
            CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(sourceUnit, compilationResult);
            if (compilationUnitDeclaration.ignoreMethodBodies) {
                compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            } else {
                parser.scanner.setSource(compilationResult);
                TypeDeclaration[] types = compilationUnitDeclaration.types;
                if (types != null) {
                    int j = types.length;
                    while (--j >= 0) {
                        types[j].parseMethod(parser, compilationUnitDeclaration);
                    }
                }
                ASTNode node = CompilationUnitResolver.convert(compilationUnitDeclaration, sourceUnit.getContents(), apiLevel, options, false, null, null, monitor);
                astRequestor.acceptAST(compilationUnits[i], (CompilationUnit)node);
            }
            ++i;
        }
    }

    public static CompilationUnitDeclaration parse(org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, Map settings) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        block10: {
            CompilationResult compilationResult;
            CommentRecorderParser parser;
            block8: {
                TypeDeclaration enclosingTypeDeclaration;
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode node;
                block9: {
                    if (sourceUnit == null) {
                        throw new IllegalStateException();
                    }
                    CompilerOptions compilerOptions = new CompilerOptions(settings);
                    parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory()), false);
                    compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
                    compilationUnitDeclaration = parser.dietParse(sourceUnit, compilationResult);
                    if (compilationUnitDeclaration.ignoreMethodBodies) {
                        compilationUnitDeclaration.ignoreFurtherInvestigation = true;
                        return null;
                    }
                    if (nodeSearcher == null) break block8;
                    char[] source = sourceUnit.getContents();
                    int searchPosition = nodeSearcher.position;
                    if (searchPosition < 0 || searchPosition > source.length) {
                        return compilationUnitDeclaration;
                    }
                    compilationUnitDeclaration.traverse((ASTVisitor)nodeSearcher, compilationUnitDeclaration.scope);
                    node = nodeSearcher.found;
                    if (node == null) {
                        return compilationUnitDeclaration;
                    }
                    enclosingTypeDeclaration = nodeSearcher.enclosingType;
                    if (!(node instanceof AbstractMethodDeclaration)) break block9;
                    ((AbstractMethodDeclaration)node).parseStatements(parser, compilationUnitDeclaration);
                    break block10;
                }
                if (enclosingTypeDeclaration == null) break block10;
                if (node instanceof Initializer) {
                    ((Initializer)node).parseStatements(parser, enclosingTypeDeclaration, compilationUnitDeclaration);
                } else {
                    ((TypeDeclaration)node).parseMethod(parser, compilationUnitDeclaration);
                }
                break block10;
            }
            parser.scanner.setSource(compilationResult);
            TypeDeclaration[] types = compilationUnitDeclaration.types;
            if (types != null) {
                int i = types.length;
                while (--i >= 0) {
                    types[i].parseMethod(parser, compilationUnitDeclaration);
                }
            }
        }
        return compilationUnitDeclaration;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void resolve(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, int apiLevel, Map options, IJavaProject javaProject, WorkingCopyOwner owner, IProgressMonitor monitor) {
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        try {
            try {
                environment = new CancelableNameEnvironment((JavaProject)javaProject, owner, monitor);
                problemFactory = new CancelableProblemFactory(monitor);
                CompilationUnitResolver resolver = new CompilationUnitResolver(environment, CompilationUnitResolver.getHandlingPolicy(), options, CompilationUnitResolver.getRequestor(), problemFactory);
                resolver.resolve(compilationUnits, bindingKeys, requestor, apiLevel, options, owner, monitor);
                if (NameLookup.VERBOSE) {
                    System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
                }
            }
            catch (JavaModelException e) {
                CompilationUnitResolver.parse(compilationUnits, requestor, apiLevel, options, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory == null) throw throwable;
            problemFactory.monitor = null;
            throw throwable;
        }
        {
            Object var11_14 = null;
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory == null) return;
            problemFactory.monitor = null;
            return;
        }
    }

    public static CompilationUnitDeclaration resolve(org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, IJavaProject javaProject, NodeSearcher nodeSearcher, Map options, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitDeclaration unit = null;
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        try {
            environment = new CancelableNameEnvironment((JavaProject)javaProject, owner, monitor);
            problemFactory = new CancelableProblemFactory(monitor);
            CompilationUnitResolver resolver = new CompilationUnitResolver(environment, CompilationUnitResolver.getHandlingPolicy(), options, CompilationUnitResolver.getRequestor(), problemFactory);
            unit = resolver.resolve(null, sourceUnit, nodeSearcher, true, true, true);
            if (NameLookup.VERBOSE) {
                System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit;
            Object var10_11 = null;
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_12 = null;
                if (environment != null) {
                    environment.monitor = null;
                }
                if (problemFactory == null) break block6;
                problemFactory.monitor = null;
            }
            throw throwable;
        }
    }

    public void removeUnresolvedBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = 0;
            int max = types.length;
            while (i < max) {
                this.removeUnresolvedBindings(types[i]);
                ++i;
            }
        }
    }

    private void removeUnresolvedBindings(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int i = 0;
            int max = memberTypes.length;
            while (i < max) {
                this.removeUnresolvedBindings(memberTypes[i]);
                ++i;
            }
        }
        if (type.binding != null && (type.binding.modifiers & 0x2000000) != 0) {
            type.binding = null;
        }
        if ((fields = type.fields) != null) {
            int i = 0;
            int max = fields.length;
            while (i < max) {
                if (fields[i].binding != null && (fields[i].binding.modifiers & 0x2000000) != 0) {
                    fields[i].binding = null;
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            int max = methods.length;
            while (i < max) {
                if (methods[i].binding != null && (methods[i].binding.modifiers & 0x2000000) != 0) {
                    methods[i].binding = null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolve(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor astRequestor, int apiLevel, Map compilerOptions, WorkingCopyOwner owner, IProgressMonitor monitor) {
        astRequestor.compilationUnitResolver = this;
        this.bindingTables = new DefaultBindingResolver.BindingTables();
        CompilationUnitDeclaration unit = null;
        int i = 0;
        try {
            try {
                int keysLength;
                int j;
                Object[] keys;
                DefaultBindingResolver resolver;
                int length = compilationUnits.length;
                org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sourceUnits = new org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit[length];
                System.arraycopy(compilationUnits, 0, sourceUnits, 0, length);
                this.beginToCompile(sourceUnits, bindingKeys);
                while (true) {
                    Object var20_25;
                    if (i >= this.totalUnits) {
                        resolver = new DefaultBindingResolver(this.lookupEnvironment, owner, this.bindingTables);
                        keys = this.requestedKeys.valueTable;
                        j = 0;
                        keysLength = keys.length;
                        break;
                    }
                    unit = this.unitsToProcess[i];
                    try {
                        DefaultBindingResolver resolver2;
                        IBinding binding;
                        Binding compilerBinding;
                        BindingKey bindingKey;
                        this.process(unit, i);
                        ICompilationUnit source = (ICompilationUnit)this.requestedSources.removeKey(unit.compilationResult.getFileName());
                        if (source != null) {
                            CompilationResult compilationResult = unit.compilationResult;
                            org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = compilationResult.compilationUnit;
                            char[] contents = sourceUnit.getContents();
                            AST ast = AST.newAST(apiLevel);
                            ast.setDefaultNodeFlag(2);
                            ASTConverter converter = new ASTConverter(compilerOptions, true, monitor);
                            DefaultBindingResolver resolver3 = new DefaultBindingResolver(unit.scope, owner, this.bindingTables);
                            ast.setBindingResolver(resolver3);
                            converter.setAST(ast);
                            CompilationUnit compilationUnit = converter.convert(unit, contents);
                            compilationUnit.setLineEndTable(compilationResult.lineSeparatorPositions);
                            ast.setDefaultNodeFlag(0);
                            ast.setOriginalModificationCount(ast.modificationCount());
                            astRequestor.acceptAST(source, compilationUnit);
                        }
                        if ((bindingKey = (BindingKey)this.requestedKeys.removeKey(unit.compilationResult.getFileName())) != null && (compilerBinding = bindingKey.getCompilerBinding(unit)) != null && (binding = (resolver2 = new DefaultBindingResolver(unit.scope, owner, this.bindingTables)).getBinding(compilerBinding)) != null) {
                            astRequestor.acceptBinding(bindingKey.getKey(), binding);
                        }
                    }
                    catch (Throwable throwable) {
                        var20_25 = null;
                        unit.cleanUp();
                        throw throwable;
                    }
                    {
                        var20_25 = null;
                        unit.cleanUp();
                        this.unitsToProcess[i] = null;
                        this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
                        ++i;
                        continue;
                    }
                    break;
                }
                while (j < keysLength) {
                    IBinding binding;
                    Binding compilerBinding;
                    BindingKey key = (BindingKey)keys[j];
                    if (key != null && (compilerBinding = key.getCompilerBinding()) != null && (binding = resolver.getBinding(compilerBinding)) != null) {
                        astRequestor.acceptBinding(((BindingKey)this.requestedKeys.valueTable[j]).getKey(), binding);
                    }
                    ++j;
                }
            }
            catch (AbortCompilation e) {
                this.handleInternalException(e, unit);
            }
            catch (Error e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
            catch (RuntimeException e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var22_28 = null;
            astRequestor.compilationUnitResolver = null;
            throw throwable;
        }
        {
            Object var22_29 = null;
            astRequestor.compilationUnitResolver = null;
            return;
        }
    }

    private CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]{sourceUnit});
                unit = this.unitsToProcess[0];
            } else {
                this.lookupEnvironment.buildTypeBindings(unit, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            if (nodeSearcher == null) {
                this.parser.getMethodBodies(unit);
            } else {
                int searchPosition = nodeSearcher.position;
                if (searchPosition >= 0 && searchPosition <= sourceUnit.getContents().length) {
                    unit.traverse((ASTVisitor)nodeSearcher, unit.scope);
                    org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode node = nodeSearcher.found;
                    this.parser.scanner.setSource(unit.compilationResult);
                    if (node != null) {
                        TypeDeclaration enclosingTypeDeclaration = nodeSearcher.enclosingType;
                        if (node instanceof AbstractMethodDeclaration) {
                            ((AbstractMethodDeclaration)node).parseStatements(this.parser, unit);
                        } else if (enclosingTypeDeclaration != null) {
                            if (node instanceof Initializer) {
                                ((Initializer)node).parseStatements(this.parser, enclosingTypeDeclaration, unit);
                            } else if (node instanceof TypeDeclaration) {
                                ((TypeDeclaration)node).parseMethod(this.parser, unit);
                            }
                        }
                    }
                }
            }
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                if (unit.scope != null && verifyMethods) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                if (analyzeCode) {
                    unit.analyseCode();
                }
                if (generateCode) {
                    unit.generateCode();
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    public CompilationUnitDeclaration resolve(org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(null, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(unit, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }
}

