/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.patterns.WildTypePattern;

public class AstUtil {
    public static final char[] PREFIX = "ajc".toCharArray();

    private AstUtil() {
    }

    public static void addMethodBinding(SourceTypeBinding sourceType, MethodBinding method) {
        int len = sourceType.methods.length;
        MethodBinding[] temp = new MethodBinding[len + 1];
        System.arraycopy(sourceType.methods, 0, temp, 0, len);
        temp[len] = method;
        sourceType.methods = temp;
    }

    public static void addMethodDeclaration(TypeDeclaration typeDec, AbstractMethodDeclaration dec) {
        AbstractMethodDeclaration[] methods = typeDec.methods;
        int len = methods.length;
        AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[len + 1];
        System.arraycopy(methods, 0, newMethods, 0, len);
        newMethods[len] = dec;
        typeDec.methods = newMethods;
    }

    public static Argument makeFinalArgument(char[] name, TypeBinding typeBinding) {
        long pos = 0L;
        LocalVariableBinding binding = new LocalVariableBinding(name, typeBinding, 16, true);
        Argument ret = new Argument(name, pos, AstUtil.makeTypeReference(typeBinding), 16);
        ret.binding = binding;
        return ret;
    }

    public static TypeReference makeTypeReference(TypeBinding binding) {
        QualifiedTypeReference ref = new QualifiedTypeReference(new char[][]{binding.sourceName()}, new long[]{0L});
        ref.resolvedType = binding;
        ref.constant = Constant.NotAConstant;
        return ref;
    }

    public static NameReference makeNameReference(TypeBinding binding) {
        char[][] name = new char[][]{binding.sourceName()};
        long[] dummyPositions = new long[name.length];
        QualifiedNameReference ref = new QualifiedNameReference(name, dummyPositions, 0, 0);
        ref.binding = binding;
        ref.constant = Constant.NotAConstant;
        return ref;
    }

    public static ReturnStatement makeReturnStatement(Expression expr) {
        return new ReturnStatement(expr, 0, 0);
    }

    public static MethodDeclaration makeMethodDeclaration(MethodBinding binding) {
        MethodDeclaration ret = new MethodDeclaration(null);
        ret.binding = binding;
        int nargs = binding.parameters.length;
        ret.arguments = new Argument[nargs];
        for (int i = 0; i < nargs; ++i) {
            ret.arguments[i] = AstUtil.makeFinalArgument(("arg" + i).toCharArray(), binding.parameters[i]);
        }
        return ret;
    }

    public static void setStatements(MethodDeclaration ret, List statements) {
        ret.statements = statements.toArray(new Statement[statements.size()]);
    }

    public static SingleNameReference makeLocalVariableReference(LocalVariableBinding binding) {
        SingleNameReference ret = new SingleNameReference(binding.name, 0L);
        ret.binding = binding;
        ret.codegenBinding = binding;
        ret.constant = ASTNode.NotAConstant;
        ret.bits &= 0xFFFFFFF8;
        ret.bits |= 3;
        return ret;
    }

    public static SingleNameReference makeResolvedLocalVariableReference(LocalVariableBinding binding) {
        SingleNameReference ret = new SingleNameReference(binding.name, 0L);
        ret.binding = binding;
        ret.codegenBinding = binding;
        ret.constant = ASTNode.NotAConstant;
        ret.bits &= 0xFFFFFFF8;
        ret.bits |= 2;
        return ret;
    }

    public static int makePublic(int modifiers) {
        return AstUtil.makePackageVisible(modifiers) | 1;
    }

    public static int makePackageVisible(int modifiers) {
        return modifiers &= 0xFFFFFFF8;
    }

    public static CompilationUnitScope getCompilationUnitScope(Scope scope) {
        if (scope instanceof CompilationUnitScope) {
            return (CompilationUnitScope)scope;
        }
        return AstUtil.getCompilationUnitScope(scope.parent);
    }

    public static void generateParameterLoads(TypeBinding[] parameters, CodeStream codeStream) {
        int paramIndex = 0;
        int varIndex = 0;
        while (paramIndex < parameters.length) {
            TypeBinding param = parameters[paramIndex++];
            codeStream.load(param, varIndex);
            varIndex += AstUtil.slotsNeeded(param);
        }
    }

    public static void generateReturn(TypeBinding returnType, CodeStream codeStream) {
        block7: {
            block8: {
                block6: {
                    if (returnType.id != 6) break block6;
                    codeStream.return_();
                    break block7;
                }
                if (!returnType.isBaseType()) break block8;
                switch (returnType.id) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 10: {
                        codeStream.ireturn();
                        break block7;
                    }
                    case 9: {
                        codeStream.freturn();
                        break block7;
                    }
                    case 7: {
                        codeStream.lreturn();
                        break block7;
                    }
                    case 8: {
                        codeStream.dreturn();
                        break block7;
                    }
                    default: {
                        throw new RuntimeException("huh");
                    }
                }
            }
            codeStream.areturn();
        }
    }

    public static char[] makeMangledName(ReferenceBinding type) {
        return CharOperation.concatWith(type.compoundName, '_');
    }

    public static char[] makeAjcMangledName(char[] kind, ReferenceBinding type, char[] name) {
        return CharOperation.concat(CharOperation.concat(PREFIX, new char[]{'$'}, kind), '$', AstUtil.makeMangledName(type), '$', name);
    }

    public static char[] makeAjcMangledName(char[] kind, char[] p, char[] name) {
        return CharOperation.concat(CharOperation.concat(PREFIX, new char[]{'$'}, kind), '$', p, '$', name);
    }

    public static List getAjSyntheticAttribute() {
        ArrayList<EclipseAttributeAdapter> ret = new ArrayList<EclipseAttributeAdapter>(1);
        ret.add(new EclipseAttributeAdapter(new AjAttribute.AjSynthetic()));
        return ret;
    }

    public static long makeLongPos(int start, int end) {
        return (long)end | (long)start << 32;
    }

    public static char[][] getCompoundName(String string) {
        return WildTypePattern.splitNames(string);
    }

    public static TypeBinding[] insert(TypeBinding first, TypeBinding[] rest) {
        if (rest == null) {
            return new TypeBinding[]{first};
        }
        int len = rest.length;
        TypeBinding[] ret = new TypeBinding[len + 1];
        ret[0] = first;
        System.arraycopy(rest, 0, ret, 1, len);
        return ret;
    }

    public static Argument[] insert(Argument first, Argument[] rest) {
        if (rest == null) {
            return new Argument[]{first};
        }
        int len = rest.length;
        Argument[] ret = new Argument[len + 1];
        ret[0] = first;
        System.arraycopy(rest, 0, ret, 1, len);
        return ret;
    }

    public static Argument[] copyArguments(Argument[] inArgs) {
        if (inArgs == null) {
            return new Argument[0];
        }
        int len = inArgs.length;
        Argument[] outArgs = new Argument[len];
        System.arraycopy(inArgs, 0, outArgs, 0, len);
        return outArgs;
    }

    public static Statement[] remove(int i, Statement[] statements) {
        int len = statements.length;
        Statement[] ret = new Statement[len - 1];
        System.arraycopy(statements, 0, ret, 0, i);
        System.arraycopy(statements, i + 1, ret, i, len - i - 1);
        return ret;
    }

    public static int slotsNeeded(TypeBinding type) {
        if (type == BaseTypes.DoubleBinding || type == BaseTypes.LongBinding) {
            return 2;
        }
        return 1;
    }

    public static void replaceMethodBinding(MessageSend send, MethodBinding newBinding) {
        send.binding = send.codegenBinding = newBinding;
        send.setActualReceiverType(newBinding.declaringClass);
    }
}

