/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.ui.UserPreferencesAdapter;

public class AjcBuildOptions
implements BuildOptionsAdapter {
    private UserPreferencesAdapter preferencesAdapter = null;
    private static final String AJC = "ajc";
    private static final String USE_JAVAC_MODE = "ajc.useJavacMode";
    private static final String WORKING_DIR = "ajc.workingDir";
    private static final String PREPROCESS_MODE = "ajc.preprocessMode";
    private static final String CHARACTER_ENCODING = "ajc.characterEncoding";
    private static final String SOURCE_ONE_POINT_FOUR_MODE = "ajc.sourceOnePointFourMode";
    private static final String LENIENT_MODE = "ajc.lenientSpecMode";
    private static final String STRICT_MODE = "ajc.strictSpecMode";
    private static final String PORTING_MODE = "ajc.portingMode";
    private static final String VERBOSE_MODE = "ajc.verboseMode";
    private static final String NONSTANDARD_OPTIONS = "ajc.nonStandardOptions";
    private static final String INCREMENTAL_MODE = "ajc.incrementalMode";
    private static final String COMPLIANCE_LEVEL = "ajc.complianceLevel";
    private static final String SOURCE_LEVEL = "ajc.sourceLevel";
    private static final String WARNINGS = "ajc.warnings";
    private static final String DEBUG_OPTIONS = "ajc.debugOptions";
    private static final String NO_IMPORT_ERROR = "ajc.noImportError";
    private static final String PRESERVE_LOCALS = "ajc.preserveLocals";
    private static final String DEFAULT = "default";

    public AjcBuildOptions(UserPreferencesAdapter userPreferencesAdapter) {
        this.preferencesAdapter = userPreferencesAdapter;
    }

    public boolean getUseJavacMode() {
        return this.getBooleanOptionVal(USE_JAVAC_MODE);
    }

    public void setUseJavacMode(boolean value) {
        this.setBooleanOptionVal(USE_JAVAC_MODE, value);
    }

    public String getWorkingOutputPath() {
        return this.preferencesAdapter.getProjectPreference(WORKING_DIR);
    }

    public void setWorkingDir(String path) {
        this.preferencesAdapter.setProjectPreference(WORKING_DIR, path);
    }

    public boolean getPreprocessMode() {
        return this.getBooleanOptionVal(PREPROCESS_MODE);
    }

    public void setPreprocessMode(boolean value) {
        this.setBooleanOptionVal(PREPROCESS_MODE, value);
    }

    public String getCharacterEncoding() {
        return this.preferencesAdapter.getProjectPreference(CHARACTER_ENCODING);
    }

    public void setCharacterEncoding(String value) {
        this.preferencesAdapter.setProjectPreference(CHARACTER_ENCODING, value);
    }

    public boolean getSourceOnePointFourMode() {
        return this.getBooleanOptionVal(SOURCE_ONE_POINT_FOUR_MODE);
    }

    public void setSourceOnePointFourMode(boolean value) {
        this.setBooleanOptionVal(SOURCE_ONE_POINT_FOUR_MODE, value);
    }

    public boolean getIncrementalMode() {
        return this.getBooleanOptionVal(INCREMENTAL_MODE);
    }

    public void setIncrementalMode(boolean value) {
        this.setBooleanOptionVal(INCREMENTAL_MODE, value);
    }

    public boolean getLenientSpecMode() {
        return this.getBooleanOptionVal(LENIENT_MODE);
    }

    public void setLenientSpecMode(boolean value) {
        this.setBooleanOptionVal(LENIENT_MODE, value);
    }

    public boolean getStrictSpecMode() {
        return this.getBooleanOptionVal(STRICT_MODE);
    }

    public void setStrictSpecMode(boolean value) {
        this.setBooleanOptionVal(STRICT_MODE, value);
    }

    public boolean getPortingMode() {
        return this.getBooleanOptionVal(PORTING_MODE);
    }

    public void setPortingMode(boolean value) {
        this.setBooleanOptionVal(PORTING_MODE, value);
    }

    public boolean getVerboseMode() {
        return this.getBooleanOptionVal(VERBOSE_MODE);
    }

    public void setVerboseMode(boolean value) {
        this.setBooleanOptionVal(VERBOSE_MODE, value);
    }

    public String getNonStandardOptions() {
        return this.preferencesAdapter.getProjectPreference(NONSTANDARD_OPTIONS);
    }

    public void setNonStandardOptions(String value) {
        this.preferencesAdapter.setProjectPreference(NONSTANDARD_OPTIONS, value);
    }

    public String getComplianceLevel() {
        return this.preferencesAdapter.getProjectPreference(COMPLIANCE_LEVEL);
    }

    public void setComplianceLevel(String value) {
        this.preferencesAdapter.setProjectPreference(COMPLIANCE_LEVEL, value);
    }

    public String getSourceCompatibilityLevel() {
        return this.preferencesAdapter.getProjectPreference(SOURCE_LEVEL);
    }

    public void setSourceCompatibilityLevel(String value) {
        this.preferencesAdapter.setProjectPreference(SOURCE_LEVEL, value);
    }

    public Set getWarnings() {
        String warnings = this.preferencesAdapter.getProjectPreference(WARNINGS);
        return this.toWarningSet(warnings);
    }

    public void setWarnings(Set warningSet) {
        String warnings = this.fromWarningSet(warningSet);
        this.preferencesAdapter.setProjectPreference(WARNINGS, warnings);
    }

    public Set getDebugLevel() {
        String debug = this.preferencesAdapter.getProjectPreference(DEBUG_OPTIONS);
        return this.toDebugSet(debug);
    }

    public void setDebugLevel(Set debugSet) {
        String debug = this.fromDebugSet(debugSet);
        this.preferencesAdapter.setProjectPreference(DEBUG_OPTIONS, debug);
    }

    public boolean getNoImportError() {
        return this.getBooleanOptionVal(NO_IMPORT_ERROR);
    }

    public void setNoImportError(boolean value) {
        this.setBooleanOptionVal(NO_IMPORT_ERROR, value);
    }

    public boolean getPreserveAllLocals() {
        return this.getBooleanOptionVal(PRESERVE_LOCALS);
    }

    public void setPreserveAllLocals(boolean value) {
        this.setBooleanOptionVal(PRESERVE_LOCALS, value);
    }

    private boolean getBooleanOptionVal(String name) {
        if (this.preferencesAdapter.getProjectPreference(name) != null) {
            return this.preferencesAdapter.getProjectPreference(name).equals("true");
        }
        return false;
    }

    private void setBooleanOptionVal(String name, boolean value) {
        if (value) {
            this.preferencesAdapter.setProjectPreference(name, "true");
        } else {
            this.preferencesAdapter.setProjectPreference(name, "false");
        }
    }

    private Set toWarningSet(String warnings) {
        if (null == warnings) {
            return null;
        }
        if (warnings.equals(DEFAULT)) {
            return null;
        }
        HashSet<String> warningSet = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(warnings, ",");
        while (tok.hasMoreTokens()) {
            String warning = tok.nextToken();
            warningSet.add(warning);
        }
        return warningSet;
    }

    private String fromWarningSet(Set warningSet) {
        if (warningSet == null) {
            return DEFAULT;
        }
        StringBuffer warnings = new StringBuffer();
        Iterator it = warningSet.iterator();
        while (it.hasNext()) {
            String w = (String)it.next();
            if (warnings.length() > 0) {
                warnings.append(',');
            }
            warnings.append(w);
        }
        return warnings.toString();
    }

    private Set toDebugSet(String debugOptions) {
        if (null == debugOptions) {
            return null;
        }
        if (debugOptions.equals(DEFAULT)) {
            return null;
        }
        HashSet<String> debugSet = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(debugOptions, ",");
        while (tok.hasMoreTokens()) {
            String debug = tok.nextToken();
            debugSet.add(debug);
        }
        return debugSet;
    }

    private String fromDebugSet(Set debugSet) {
        if (debugSet == null) {
            return DEFAULT;
        }
        StringBuffer debugOptions = new StringBuffer();
        Iterator it = debugSet.iterator();
        while (it.hasNext()) {
            String d = (String)it.next();
            if (debugOptions.length() > 0) {
                debugOptions.append(',');
            }
            debugOptions.append(d);
        }
        return debugOptions.toString();
    }

    public Map getJavaOptionsMap() {
        return null;
    }
}

