/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.util.ArrayList;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NameEnvironment
implements INameEnvironment,
SuffixConstants {
    boolean isIncrementalBuild = false;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    String[] initialTypeNames;
    SourceFile[] additionalUnits;

    NameEnvironment(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        this.computeClasspathLocations(root, javaProject, binaryLocationsPerProject);
        this.setNames(null, null);
    }

    public NameEnvironment(IJavaProject javaProject) {
        try {
            this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject, null);
        }
        catch (CoreException e) {
            this.sourceLocations = new ClasspathMultiDirectory[0];
            this.binaryLocations = new ClasspathLocation[0];
        }
        this.setNames(null, null);
    }

    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        IMarker cycleMarker = javaProject.getCycleMarker();
        if (cycleMarker != null) {
            int severity;
            int n = severity = "error".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.circularClasspath", true)) ? 2 : 1;
            if (severity != (Integer)cycleMarker.getAttribute("severity")) {
                cycleMarker.setAttribute("severity", severity);
            }
        }
        IClasspathEntry[] classpathEntries = javaProject.getExpandedClasspath(true, false, null, null);
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        int i = 0;
        int l = classpathEntries.length;
        while (i < l) {
            ClasspathEntry entry = (ClasspathEntry)classpathEntries[i];
            IPath path = entry.getPath();
            Object target = JavaModel.getTarget(root, path, true);
            if (target != null) {
                switch (entry.getEntryKind()) {
                    case 3: {
                        IContainer outputFolder;
                        IPath outputPath;
                        if (!(target instanceof IContainer)) break;
                        IPath iPath = outputPath = entry.getOutputLocation() != null ? entry.getOutputLocation() : javaProject.getOutputLocation();
                        if (outputPath.segmentCount() == 1) {
                            outputFolder = javaProject.getProject();
                        } else {
                            outputFolder = root.getFolder(outputPath);
                            if (!outputFolder.exists()) {
                                this.createFolder(outputFolder);
                            }
                        }
                        sLocations.add(ClasspathLocation.forSourceFolder((IContainer)target, outputFolder, entry.fullInclusionPatternChars(), entry.fullExclusionPatternChars()));
                        break;
                    }
                    case 2: {
                        IProject prereqProject;
                        if (!(target instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target)) break;
                        JavaProject prereqJavaProject = (JavaProject)JavaCore.create(prereqProject);
                        IClasspathEntry[] prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                        ArrayList<IProject> seen = new ArrayList<IProject>();
                        int j = 0;
                        int m = prereqClasspathEntries.length;
                        while (j < m) {
                            Object prereqTarget;
                            IClasspathEntry prereqEntry = prereqClasspathEntries[j];
                            if (prereqEntry.getEntryKind() == 3 && (prereqTarget = JavaModel.getTarget(root, prereqEntry.getPath(), true)) instanceof IContainer) {
                                IProject binaryFolder;
                                IPath prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                                IContainer iContainer = binaryFolder = prereqOutputPath.segmentCount() == 1 ? prereqProject : root.getFolder(prereqOutputPath);
                                if (binaryFolder.exists() && !seen.contains(binaryFolder)) {
                                    seen.add(binaryFolder);
                                    ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder(binaryFolder, true, entry.getAccessRuleSet());
                                    bLocations.add(bLocation);
                                    if (binaryLocationsPerProject != null) {
                                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(prereqProject);
                                        if (existingLocations == null) {
                                            existingLocations = new ClasspathLocation[]{bLocation};
                                        } else {
                                            int size = existingLocations.length;
                                            ClasspathLocation[] classpathLocationArray = existingLocations;
                                            existingLocations = new ClasspathLocation[size + 1];
                                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                            existingLocations[size] = bLocation;
                                        }
                                        binaryLocationsPerProject.put(prereqProject, existingLocations);
                                    }
                                }
                            }
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        if (target instanceof IResource) {
                            AccessRuleSet accessRuleSet;
                            IResource resource = (IResource)target;
                            ClasspathLocation bLocation = null;
                            if (resource instanceof IFile) {
                                if (!Util.isArchiveFileName(path.lastSegment())) break;
                                accessRuleSet = "ignore".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                                bLocation = ClasspathLocation.forLibrary((IFile)resource, accessRuleSet);
                            } else if (resource instanceof IContainer) {
                                accessRuleSet = "ignore".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                                bLocation = ClasspathLocation.forBinaryFolder((IContainer)target, false, accessRuleSet);
                            }
                            bLocations.add(bLocation);
                            if (binaryLocationsPerProject == null) break;
                            IProject p = resource.getProject();
                            ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(p);
                            if (existingLocations == null) {
                                existingLocations = new ClasspathLocation[]{bLocation};
                            } else {
                                int size = existingLocations.length;
                                ClasspathLocation[] classpathLocationArray = existingLocations;
                                existingLocations = new ClasspathLocation[size + 1];
                                System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                existingLocations[size] = bLocation;
                            }
                            binaryLocationsPerProject.put(p, existingLocations);
                            break;
                        }
                        if (!(target instanceof File) || !Util.isArchiveFileName(path.lastSegment())) break;
                        AccessRuleSet accessRuleSet = "ignore".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                        bLocations.add(ClasspathLocation.forLibrary(path.toString(), accessRuleSet));
                    }
                }
            }
            ++i;
        }
        ArrayList<ClasspathMultiDirectory> outputFolders = new ArrayList<ClasspathMultiDirectory>(1);
        this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
        if (!sLocations.isEmpty()) {
            sLocations.toArray(this.sourceLocations);
            int i2 = 0;
            int l2 = this.sourceLocations.length;
            while (i2 < l2) {
                block32: {
                    ClasspathMultiDirectory md = this.sourceLocations[i2];
                    IPath outputPath = md.binaryFolder.getFullPath();
                    int j = 0;
                    while (j < i2) {
                        if (outputPath.equals(this.sourceLocations[j].binaryFolder.getFullPath())) {
                            md.hasIndependentOutputFolder = this.sourceLocations[j].hasIndependentOutputFolder;
                            break block32;
                        }
                        ++j;
                    }
                    outputFolders.add(md);
                    j = 0;
                    int m = this.sourceLocations.length;
                    while (j < m) {
                        if (!outputPath.equals(this.sourceLocations[j].sourceFolder.getFullPath())) {
                            ++j;
                            continue;
                        }
                        break block32;
                    }
                    md.hasIndependentOutputFolder = true;
                }
                ++i2;
            }
        }
        this.binaryLocations = new ClasspathLocation[outputFolders.size() + bLocations.size()];
        int index = 0;
        int i3 = 0;
        int l3 = outputFolders.size();
        while (i3 < l3) {
            this.binaryLocations[index++] = (ClasspathLocation)outputFolders.get(i3);
            ++i3;
        }
        i3 = 0;
        l3 = bLocations.size();
        while (i3 < l3) {
            this.binaryLocations[index++] = (ClasspathLocation)bLocations.get(i3);
            ++i3;
        }
    }

    public void cleanup() {
        this.initialTypeNames = null;
        this.additionalUnits = null;
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].cleanup();
            ++i;
        }
        i = 0;
        l = this.binaryLocations.length;
        while (i < l) {
            this.binaryLocations[i].cleanup();
            ++i;
        }
    }

    private void createFolder(IContainer folder) throws CoreException {
        if (!folder.exists()) {
            this.createFolder(folder.getParent());
            ((IFolder)folder).create(true, true, null);
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String qBinaryFileName;
        if (this.initialTypeNames != null) {
            int i = 0;
            int l = this.initialTypeNames.length;
            while (i < l) {
                if (qualifiedTypeName.equals(this.initialTypeNames[i])) {
                    if (this.isIncrementalBuild) {
                        throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedTypeName));
                    }
                    return null;
                }
                ++i;
            }
        }
        if (this.additionalUnits != null && this.sourceLocations.length > 0) {
            Path qSourceFilePath = new Path(qualifiedTypeName);
            int qSegmentCount = qSourceFilePath.segmentCount();
            int i = 0;
            int l = this.additionalUnits.length;
            while (i < l) {
                block13: {
                    SourceFile additionalUnit = this.additionalUnits[i];
                    IPath fullPath = additionalUnit.resource.getFullPath();
                    int prefixCount = additionalUnit.sourceLocation.sourceFolder.getFullPath().segmentCount();
                    if (qSegmentCount == fullPath.segmentCount() - prefixCount) {
                        int j = 0;
                        while (j < qSegmentCount - 1) {
                            if (qSourceFilePath.segment(j).equals(fullPath.segment(j + prefixCount))) {
                                ++j;
                                continue;
                            }
                            break block13;
                        }
                        if (org.aspectj.org.eclipse.jdt.internal.core.util.Util.equalsIgnoreJavaLikeExtension(fullPath.segment(qSegmentCount - 1 + prefixCount), qSourceFilePath.segment(qSegmentCount - 1))) {
                            return new NameEnvironmentAnswer(additionalUnit, null);
                        }
                    }
                }
                ++i;
            }
        }
        String binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
        String qPackageName = "";
        if (qualifiedTypeName.length() > typeName.length) {
            int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
            qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
            binaryFileName = qBinaryFileName.substring(typeNameStart);
        }
        int i = 0;
        int l = this.binaryLocations.length;
        while (i < l) {
            NameEnvironmentAnswer answer = this.binaryLocations[i].findClass(binaryFileName, qPackageName, qBinaryFileName);
            if (answer != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith(compoundName, packageName, '/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        int i = 0;
        int l = this.binaryLocations.length;
        while (i < l) {
            if (this.binaryLocations[i].isPackage(qualifiedPackageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setNames(String[] initialTypeNames, SourceFile[] additionalUnits) {
        this.initialTypeNames = initialTypeNames;
        this.additionalUnits = additionalUnits;
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].reset();
            ++i;
        }
        i = 0;
        l = this.binaryLocations.length;
        while (i < l) {
            this.binaryLocations[i].reset();
            ++i;
        }
    }
}

