/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Map;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class InternalBuilder {
    private static BuildManager buildManager = ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager();
    private boolean forgetStateRequested = false;
    private IProject[] interestingProjects = ICoreConstants.EMPTY_PROJECT_ARRAY;
    private String label;
    private String natureId;
    private ElementTree oldState;
    private String pluginId;
    private IProject project;

    protected abstract IProject[] build(int var1, Map var2, IProgressMonitor var3) throws CoreException;

    protected abstract void clean(IProgressMonitor var1) throws CoreException;

    final void clearForgetLastBuiltState() {
        this.forgetStateRequested = false;
    }

    protected void forgetLastBuiltState() {
        this.oldState = null;
        this.forgetStateRequested = true;
    }

    protected IResourceDelta getDelta(IProject project) {
        return buildManager.getDelta(project);
    }

    final IProject[] getInterestingProjects() {
        return this.interestingProjects;
    }

    final String getLabel() {
        return this.label;
    }

    final ElementTree getLastBuiltTree() {
        return this.oldState;
    }

    final String getNatureId() {
        return this.natureId;
    }

    final String getPluginId() {
        return this.pluginId;
    }

    protected IProject getProject() {
        return this.project;
    }

    protected boolean hasBeenBuilt(IProject project) {
        return buildManager.hasBeenBuilt(project);
    }

    public boolean isInterrupted() {
        return InternalBuilder.buildManager.autoBuildJob.isInterrupted();
    }

    protected void needRebuild() {
        buildManager.requestRebuild();
    }

    final void setInterestingProjects(IProject[] value) {
        this.interestingProjects = value;
    }

    final void setLabel(String value) {
        this.label = value;
    }

    final void setLastBuiltTree(ElementTree value) {
        this.oldState = value;
    }

    final void setNatureId(String id) {
        this.natureId = id;
    }

    final void setPluginId(String value) {
        this.pluginId = value;
    }

    final void setProject(IProject value) {
        Assert.isTrue(this.project == null);
        this.project = value;
    }

    protected abstract void startupOnInitialize();

    final boolean wasForgetStateRequested() {
        return this.forgetStateRequested;
    }
}

