/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;

public abstract class ConcreteTypeMunger
implements PartialOrder.PartialComparable {
    protected ResolvedTypeMunger munger;
    protected ResolvedTypeX aspectType;

    public ConcreteTypeMunger(ResolvedTypeMunger munger, ResolvedTypeX aspectType) {
        this.munger = munger;
        this.aspectType = aspectType;
    }

    public ResolvedTypeMunger getMunger() {
        return this.munger;
    }

    public ResolvedTypeX getAspectType() {
        return this.aspectType;
    }

    public ResolvedMember getSignature() {
        return this.munger.getSignature();
    }

    public ISourceLocation getSourceLocation() {
        if (this.munger == null) {
            return null;
        }
        return this.munger.getSourceLocation();
    }

    public boolean matches(ResolvedTypeX onType) {
        if (this.munger == null) {
            throw new RuntimeException("huh: " + this);
        }
        return this.munger.matches(onType, this.aspectType);
    }

    public ResolvedMember getMatchingSyntheticMember(Member member) {
        return this.munger.getMatchingSyntheticMember(member, this.aspectType);
    }

    public int compareTo(Object other) {
        ConcreteTypeMunger o = (ConcreteTypeMunger)other;
        ResolvedTypeX otherAspect = o.aspectType;
        if (this.aspectType.equals(otherAspect)) {
            return this.getSignature().getStart() < o.getSignature().getStart() ? -1 : 1;
        }
        if (this.aspectType.isAssignableFrom(o.aspectType)) {
            return 1;
        }
        if (o.aspectType.isAssignableFrom(this.aspectType)) {
            return -1;
        }
        return 0;
    }

    public int fallbackCompareTo(Object other) {
        return 0;
    }
}

