/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.SignatureImpl;
import org.aspectj.runtime.reflect.StringMaker;

class JoinPointImpl
implements ProceedingJoinPoint {
    Object _this;
    Object target;
    Object[] args;
    JoinPoint.StaticPart staticPart;
    private AroundClosure arc;

    public JoinPointImpl(JoinPoint.StaticPart staticPart, Object _this, Object target, Object[] args) {
        this.staticPart = staticPart;
        this._this = _this;
        this.target = target;
        this.args = args;
    }

    public Object getThis() {
        return this._this;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object[] getArgs() {
        if (this.args == null) {
            this.args = new Object[0];
        }
        Object[] argsCopy = new Object[this.args.length];
        System.arraycopy(this.args, 0, argsCopy, 0, this.args.length);
        return argsCopy;
    }

    public JoinPoint.StaticPart getStaticPart() {
        return this.staticPart;
    }

    public String getKind() {
        return this.staticPart.getKind();
    }

    public Signature getSignature() {
        return this.staticPart.getSignature();
    }

    public SourceLocation getSourceLocation() {
        return this.staticPart.getSourceLocation();
    }

    public final String toString() {
        return ((Object)this.staticPart).toString();
    }

    public final String toShortString() {
        return this.staticPart.toShortString();
    }

    public final String toLongString() {
        return this.staticPart.toLongString();
    }

    public void set$AroundClosure(AroundClosure arc) {
        this.arc = arc;
    }

    public Object proceed() throws Throwable {
        if (this.arc == null) {
            return null;
        }
        return this.arc.run(this.arc.getState());
    }

    public Object proceed(Object[] adviceBindings) throws Throwable {
        if (this.arc == null) {
            return null;
        }
        Object[] state = this.arc.getState();
        for (int i = state.length - 2; i >= 0; --i) {
            int formalIndex = adviceBindings.length - 1 - (state.length - 2) + i;
            if (formalIndex < 0 || formalIndex >= adviceBindings.length) continue;
            state[i] = adviceBindings[formalIndex];
        }
        return this.arc.run(state);
    }

    static class EnclosingStaticPartImpl
    extends StaticPartImpl
    implements JoinPoint.EnclosingStaticPart {
        public EnclosingStaticPartImpl(String kind, Signature signature, SourceLocation sourceLocation) {
            super(kind, signature, sourceLocation);
        }
    }

    static class StaticPartImpl
    implements JoinPoint.StaticPart {
        String kind;
        Signature signature;
        SourceLocation sourceLocation;

        public StaticPartImpl(String kind, Signature signature, SourceLocation sourceLocation) {
            this.kind = kind;
            this.signature = signature;
            this.sourceLocation = sourceLocation;
        }

        public String getKind() {
            return this.kind;
        }

        public Signature getSignature() {
            return this.signature;
        }

        public SourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        String toString(StringMaker sm) {
            StringBuffer buf = new StringBuffer();
            buf.append(sm.makeKindName(this.getKind()));
            buf.append("(");
            buf.append(((SignatureImpl)this.getSignature()).toString(sm));
            buf.append(")");
            return buf.toString();
        }

        public final String toString() {
            return this.toString(StringMaker.middleStringMaker);
        }

        public final String toShortString() {
            return this.toString(StringMaker.shortStringMaker);
        }

        public final String toLongString() {
            return this.toString(StringMaker.longStringMaker);
        }
    }
}

