/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config;

import amazon.fws.clicommando.config.ConfirmConfig;
import amazon.fws.clicommando.config.ExampleConfig;
import amazon.fws.clicommando.config.LoadedClassConfig;
import amazon.fws.clicommando.config.OutputFormatConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.config.ProcessorConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.security.SecurityKeys;
import amazon.fws.clicommando.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandConfig {
    private String name;
    private String alias;
    private String requestUrl;
    private String response;
    private String responseHeaders;
    private ConfirmConfig confirmation;
    private ProcessorConfig processor;
    private OutputFormatConfig outputConfig;
    private LoadedClassConfig executionControlConfig = null;
    private LoadedClassConfig customParamProcessingConfig = null;
    private Map<String, ParamConfig> parameters;
    private List<SecurityKeys> securityKeys;
    private String helpRef;
    private String synopsis;
    private String shortDesc;
    private String longDesc;
    List<ExampleConfig> inputExamples;
    public static final Comparator<CommandConfig> ALIAS_COMPARE = new Comparator<CommandConfig>(){

        @Override
        public int compare(CommandConfig e1, CommandConfig e2) {
            return e1.getAlias().toLowerCase().compareTo(e2.getAlias().toLowerCase());
        }
    };
    public static final Comparator<CommandConfig> NAME_COMPARE = new Comparator<CommandConfig>(){

        @Override
        public int compare(CommandConfig e1, CommandConfig e2) {
            return e1.getName().toLowerCase().compareTo(e2.getName().toLowerCase());
        }
    };

    public CommandConfig(String name, String alias, String helpRef) {
        this.alias = alias;
        this.name = name;
        this.helpRef = helpRef;
        this.parameters = new Hashtable<String, ParamConfig>();
        this.inputExamples = new ArrayList<ExampleConfig>();
        this.securityKeys = new ArrayList<SecurityKeys>();
    }

    public void setHelpText(String synop, String sDesc, String lDesc) {
        this.synopsis = synop;
        this.shortDesc = sDesc;
        this.longDesc = lDesc;
    }

    public String getHelpRef() {
        return this.helpRef;
    }

    public void setHelpRef(String helpRef) {
        this.helpRef = helpRef;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getLongDesc() {
        return this.longDesc;
    }

    public List<ExampleConfig> getInputExamples() {
        return this.inputExamples;
    }

    public void addInputExamples(ExampleConfig inputExample) {
        this.inputExamples.add(inputExample);
    }

    public String getRequestUrl() {
        if (StringUtils.isEmpty(this.requestUrl)) {
            return this.requestUrl;
        }
        String safetyNote = "";
        Collection<ParamConfig> params = this.getAllParameters();
        for (ParamConfig pc : params) {
            if (!pc.isSecureInput()) continue;
            safetyNote = "\n***Note: This --show-request contains potentially sensitive information and should not be shared with anyone.";
            break;
        }
        return this.requestUrl + safetyNote;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public ConfirmConfig getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(ConfirmConfig confirmation) {
        this.confirmation = confirmation;
    }

    public Map<String, ParamConfig> getParameters() {
        return this.parameters;
    }

    public OutputFormatConfig getOutputConfig() {
        return this.outputConfig;
    }

    public void setOutputConfig(OutputFormatConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public ProcessorConfig getProcessor() {
        return this.processor;
    }

    public void setProcessor(ProcessorConfig processor) {
        this.processor = processor;
    }

    public Collection<ParamConfig> getAllParameters() {
        return this.parameters.values();
    }

    public List<SecurityKeys> getSecurityKeys() {
        return this.securityKeys;
    }

    public boolean isCredentialsConfigured() {
        return this.getSecurityKeys().size() >= 1;
    }

    public LoadedClassConfig getExecutionControlConfig() {
        return this.executionControlConfig;
    }

    public void setExecutionControlConfig(LoadedClassConfig executionControlConfig) {
        this.executionControlConfig = executionControlConfig;
    }

    public LoadedClassConfig getCustomParamProcessingConfig() {
        return this.customParamProcessingConfig;
    }

    public void setCustomParamProcessingConfig(LoadedClassConfig customParamProcessingConfig) {
        this.customParamProcessingConfig = customParamProcessingConfig;
    }

    public Collection<ParamConfig> getArgumentsSortedByIndex() {
        TreeMap<Integer, ParamConfig> args = new TreeMap<Integer, ParamConfig>();
        for (ParamConfig pc : this.getAllParameters()) {
            if (pc.getType() != ParamConfig.Type.ARGUMENT && pc.getType() != ParamConfig.Type.ARGUMENTS_LIST) continue;
            int index = pc.getFirstOption().getIndex() != null ? pc.getFirstOption().getIndex() : -1;
            args.put(index, pc);
        }
        return args.values();
    }

    public Collection<ParamConfig> getParamsSortedByOptions() {
        ArrayList<ParamConfig> args = new ArrayList<ParamConfig>();
        for (ParamConfig pc : this.getAllParameters()) {
            if (pc.getType() == ParamConfig.Type.ARGUMENT || pc.getType() == ParamConfig.Type.ARGUMENTS_LIST) continue;
            args.add(pc);
        }
        Collections.sort(args, ParamConfig.OPTION_COMPARE);
        return args;
    }

    public Collection<ParamConfig> getOptParamsSortedByRequired() {
        ArrayList<ParamConfig> args = new ArrayList<ParamConfig>();
        for (ParamConfig pc : this.getAllParameters()) {
            if (pc.getType() == ParamConfig.Type.ARGUMENT || pc.getType() == ParamConfig.Type.ARGUMENTS_LIST) continue;
            args.add(pc);
        }
        Collections.sort(args, ParamConfig.REQUIRED_AND_NAME_COMPARE);
        return args;
    }

    public Collection<ParamConfig> getNonDirectiveParameters() {
        ArrayList<ParamConfig> ret = new ArrayList<ParamConfig>();
        for (ParamConfig param : this.getAllParameters()) {
            if (param.isDirective().booleanValue()) continue;
            ret.add(param);
        }
        return ret;
    }

    public Map<String, ParamConfig> getParameterMap() {
        return this.parameters;
    }

    public boolean doesParameterExist(String paramName) {
        return this.parameters.containsKey(paramName);
    }

    public void setParameters(Map<String, ParamConfig> parameters) {
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void addParameter(ParamConfig param) {
        if (this.parameters.containsKey(param.getName())) {
            throw new ConfigurationErrorException("Too many parameters with the same name " + param.getName());
        }
        this.parameters.put(param.getName(), param);
    }

    public ParamConfig getParameter(String name) {
        if (!this.parameters.containsKey(name)) {
            throw new ConfigurationErrorException("No param named " + name);
        }
        return this.parameters.get(name);
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.confirmation == null ? 0 : this.confirmation.hashCode());
        result = 31 * result + (this.executionControlConfig == null ? 0 : this.executionControlConfig.hashCode());
        result = 31 * result + (this.helpRef == null ? 0 : this.helpRef.hashCode());
        result = 31 * result + (this.inputExamples == null ? 0 : ((Object)this.inputExamples).hashCode());
        result = 31 * result + (this.longDesc == null ? 0 : this.longDesc.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.outputConfig == null ? 0 : this.outputConfig.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.processor == null ? 0 : this.processor.hashCode());
        result = 31 * result + (this.requestUrl == null ? 0 : this.requestUrl.hashCode());
        result = 31 * result + (this.response == null ? 0 : this.response.hashCode());
        result = 31 * result + (this.responseHeaders == null ? 0 : this.responseHeaders.hashCode());
        result = 31 * result + (this.securityKeys == null ? 0 : ((Object)this.securityKeys).hashCode());
        result = 31 * result + (this.shortDesc == null ? 0 : this.shortDesc.hashCode());
        result = 31 * result + (this.synopsis == null ? 0 : this.synopsis.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandConfig other = (CommandConfig)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.confirmation == null ? other.confirmation != null : !this.confirmation.equals(other.confirmation)) {
            return false;
        }
        if (this.executionControlConfig == null ? other.executionControlConfig != null : !this.executionControlConfig.equals(other.executionControlConfig)) {
            return false;
        }
        if (this.helpRef == null ? other.helpRef != null : !this.helpRef.equals(other.helpRef)) {
            return false;
        }
        if (this.inputExamples == null ? other.inputExamples != null : !((Object)this.inputExamples).equals(other.inputExamples)) {
            return false;
        }
        if (this.longDesc == null ? other.longDesc != null : !this.longDesc.equals(other.longDesc)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.outputConfig == null ? other.outputConfig != null : !this.outputConfig.equals(other.outputConfig)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.processor == null ? other.processor != null : !this.processor.equals(other.processor)) {
            return false;
        }
        if (this.requestUrl == null ? other.requestUrl != null : !this.requestUrl.equals(other.requestUrl)) {
            return false;
        }
        if (this.response == null ? other.response != null : !this.response.equals(other.response)) {
            return false;
        }
        if (this.responseHeaders == null ? other.responseHeaders != null : !this.responseHeaders.equals(other.responseHeaders)) {
            return false;
        }
        if (this.securityKeys == null ? other.securityKeys != null : !((Object)this.securityKeys).equals(other.securityKeys)) {
            return false;
        }
        if (this.shortDesc == null ? other.shortDesc != null : !this.shortDesc.equals(other.shortDesc)) {
            return false;
        }
        return !(this.synopsis == null ? other.synopsis != null : !this.synopsis.equals(other.synopsis));
    }

    public String toString() {
        return "Command " + this.name + "/" + this.alias + (this.processor != null ? "\n\t" + this.processor.toString() : "") + (this.outputConfig != null ? "\n\t" + this.outputConfig.toString() : "") + (this.helpRef != null ? "\n\t" + this.helpRef : "") + "\n\t" + this.parameters.toString() + "\n\tResq:" + this.requestUrl + "\n\tResp:" + this.response + "\n\tSecurityKeys:" + this.securityKeys;
    }
}

