/*
 * Copyright Samsung Electronics Co.,LTD.
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*!
 * \file      Exynos.h
 * \brief     header file for Exynos
 * \author    Sangwoo, Park(sw5771.park@samsung.com)
 * \date      2012/03/14
 *
 * <b>Revision History: </b>
 * - 2012/03/14 : Sangwoo, Park(sw5771.park@samsung.com) \n
 *   Initial version
 *
 */

/**
 * @mainpage Exynos SDK API Reference
 *
 * @section Introduction
 *  This library is common development API on S.LSI chip of Samsung.
 *
 * @section Sub-module
 *
 * @subpage ExynosBuffer
 *  \n
 * @subpage ExynosRect
 *  \n
 * @subpage ExynosMutex
 *  \n
 * @subpage ExynosJpegEncoder
 *  \n
 * @subpage ExynosJpegDecoder
 *  \n
 * @subpage ExynosCamera
 *  \n
 * @subpage ExynosHdmi
 *  \n
 * @subpage ExynosDC
 *  \n
 * @subpage exynos_gscaler
 *  \n
 * @subpage exynos_v4l2
 *  \n
 * @subpage exynos_rotator
 *  \n
 *
 * @section Copyright
 *  Copyright (c) 2008-2011 Samsung Electronics Co., Ltd.All rights reserved. \n
 *  Proprietary and Confidential
 *
 * @image html samsung.png
 */

/*!
 * \defgroup Exynos S/W Platform
 * \brief Exynos SDK for S.LSI's chip
 */

#ifndef EXYNOS_H_
#define EXYNOS_H_

#endif //EXYNOS_H_

