/*
 * Copyright 2009, The Android Open Source Project
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


// Compressed gmoji table, sorted
// Originally scraped from http://www.corp.google.com/eng/doc/emoji/dev.html
// Input text file "external/webkit/WebKit/android/emoji/gmojiraw.txt"

static const uint16_t gGmojiPUA[] = {
    0x000, 0x001, 0x002, 0x003, 0x004, 0x005, 0x006, 0x007,
    0x008, 0x009, 0x00A, 0x00B, 0x00C, 0x00D, 0x00E, 0x00F,
    0x010, 0x011, 0x012, 0x013, 0x014, 0x015, 0x016, 0x017,
    0x018, 0x019, 0x01A, 0x01B, 0x01C, 0x01D, 0x01E, 0x01F,
    0x020, 0x021, 0x022, 0x023, 0x024, 0x025, 0x026, 0x027,
    0x028, 0x029, 0x02A, 0x02B, 0x02C, 0x02D, 0x02E, 0x02F,
    0x030, 0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037,
    0x038, 0x039, 0x03A, 0x03B, 0x03C, 0x03D, 0x03E, 0x03F,
    0x040, 0x041, 0x042, 0x043, 0x044, 0x045, 0x046, 0x047,
    0x048, 0x049, 0x04A, 0x04B, 0x04C, 0x04D, 0x04E, 0x04F,
    0x050, 0x051, 0x052, 0x053, 0x054, 0x055, 0x056, 0x057,
    0x058, 0x059, 0x05A, 0x05B, 0x190, 0x191, 0x192, 0x193,
    0x194, 0x195, 0x196, 0x197, 0x198, 0x199, 0x19A, 0x19B,
    0x19C, 0x19D, 0x19E, 0x19F, 0x1A0, 0x1A1, 0x1A2, 0x1A3,
    0x1A4, 0x1A5, 0x1A6, 0x1A7, 0x1A8, 0x1A9, 0x1AA, 0x1AB,
    0x1AC, 0x1AD, 0x1AE, 0x1AF, 0x1B0, 0x1B1, 0x1B2, 0x1B3,
    0x1B4, 0x1B5, 0x1B6, 0x1B7, 0x1B8, 0x1B9, 0x1BA, 0x1BB,
    0x1BC, 0x1BD, 0x1BE, 0x1BF, 0x1C0, 0x1C1, 0x1C2, 0x1C3,
    0x1C4, 0x1C5, 0x1C6, 0x1C7, 0x1C8, 0x1C9, 0x1CA, 0x1CB,
    0x1CC, 0x1CD, 0x1CE, 0x1CF, 0x1D0, 0x1D1, 0x1D2, 0x1D3,
    0x1D4, 0x1D5, 0x1D6, 0x1D7, 0x1D8, 0x1D9, 0x1DA, 0x1DB,
    0x1DC, 0x1DD, 0x1DE, 0x1DF, 0x1E0, 0x1E1, 0x1E2, 0x1E3,
    0x320, 0x321, 0x322, 0x323, 0x324, 0x325, 0x326, 0x327,
    0x328, 0x329, 0x32A, 0x32B, 0x32C, 0x32D, 0x32E, 0x32F,
    0x330, 0x331, 0x332, 0x333, 0x334, 0x335, 0x336, 0x337,
    0x338, 0x339, 0x33A, 0x33B, 0x33C, 0x33D, 0x33E, 0x33F,
    0x340, 0x341, 0x342, 0x343, 0x344, 0x345, 0x346, 0x347,
    0x348, 0x349, 0x34A, 0x34B, 0x34C, 0x34D, 0x34E, 0x34F,
    0x350, 0x351, 0x352, 0x353, 0x354, 0x355, 0x356, 0x357,
    0x358, 0x359, 0x35A, 0x35B, 0x35C, 0x35D, 0x35E, 0x35F,
    0x360, 0x361, 0x362, 0x363, 0x364, 0x365, 0x366, 0x367,
    0x368, 0x369, 0x4B0, 0x4B1, 0x4B2, 0x4B3, 0x4B4, 0x4B5,
    0x4B6, 0x4B7, 0x4B8, 0x4B9, 0x4BA, 0x4BB, 0x4BC, 0x4BD,
    0x4BE, 0x4BF, 0x4C0, 0x4C1, 0x4C2, 0x4C3, 0x4C4, 0x4C5,
    0x4C6, 0x4C7, 0x4C8, 0x4C9, 0x4CA, 0x4CB, 0x4CC, 0x4CD,
    0x4CE, 0x4CF, 0x4D0, 0x4D1, 0x4D2, 0x4D3, 0x4D4, 0x4D5,
    0x4D6, 0x4D7, 0x4D8, 0x4D9, 0x4DA, 0x4DB, 0x4DC, 0x4DD,
    0x4DE, 0x4DF, 0x4E0, 0x4E1, 0x4E2, 0x4E3, 0x4E4, 0x4E5,
    0x4E6, 0x4E7, 0x4E8, 0x4E9, 0x4EA, 0x4EB, 0x4EC, 0x4ED,
    0x4EE, 0x4EF, 0x4F0, 0x4F1, 0x4F2, 0x4F3, 0x4F4, 0x4F5,
    0x4F6, 0x4F7, 0x4F8, 0x4F9, 0x4FA, 0x4FB, 0x4FC, 0x4FD,
    0x4FE, 0x4FF, 0x500, 0x501, 0x502, 0x503, 0x504, 0x505,
    0x506, 0x507, 0x508, 0x509, 0x50A, 0x50B, 0x50C, 0x50D,
    0x50E, 0x50F, 0x510, 0x511, 0x512, 0x513, 0x514, 0x515,
    0x516, 0x517, 0x518, 0x519, 0x51A, 0x51B, 0x51C, 0x51D,
    0x51E, 0x51F, 0x520, 0x521, 0x522, 0x523, 0x524, 0x525,
    0x526, 0x527, 0x528, 0x529, 0x52A, 0x52B, 0x52C, 0x52D,
    0x52E, 0x52F, 0x530, 0x531, 0x532, 0x533, 0x534, 0x535,
    0x536, 0x537, 0x538, 0x539, 0x53A, 0x53B, 0x53C, 0x53D,
    0x53E, 0x53F, 0x540, 0x541, 0x542, 0x543, 0x544, 0x545,
    0x546, 0x547, 0x548, 0x549, 0x54A, 0x54B, 0x54C, 0x54D,
    0x54E, 0x54F, 0x550, 0x551, 0x552, 0x553, 0x7D0, 0x7D1,
    0x7D2, 0x7D3, 0x7D4, 0x7D5, 0x7D6, 0x7D7, 0x7D8, 0x7D9,
    0x7DA, 0x7DB, 0x7DC, 0x7DD, 0x7DE, 0x7DF, 0x7E0, 0x7E1,
    0x7E2, 0x7E3, 0x7E4, 0x7E5, 0x7E6, 0x7E7, 0x7E8, 0x7E9,
    0x7EA, 0x7EB, 0x7EC, 0x7ED, 0x7EE, 0x7EF, 0x7F0, 0x7F1,
    0x7F2, 0x7F3, 0x7F4, 0x7F5, 0x7F6, 0x7F7, 0x7F8, 0x7F9,
    0x7FA, 0x7FB, 0x7FC, 0x7FD, 0x7FE, 0x7FF, 0x800, 0x801,
    0x802, 0x803, 0x804, 0x805, 0x806, 0x807, 0x808, 0x809,
    0x80A, 0x80B, 0x80C, 0x80D, 0x80E, 0x80F, 0x810, 0x811,
    0x812, 0x813, 0x814, 0x815, 0x816, 0x817, 0x818, 0x819,
    0x81A, 0x81B, 0x81C, 0x81D, 0x81E, 0x81F, 0x820, 0x821,
    0x822, 0x823, 0x824, 0x825, 0x826, 0x827, 0x828, 0x829,
    0x82A, 0x82B, 0x82C, 0x82D, 0x82E, 0x82F, 0x830, 0x831,
    0x832, 0x833, 0x834, 0x835, 0x836, 0x837, 0x838, 0x839,
    0x83A, 0x83B, 0x83C, 0x960, 0x961, 0x962, 0x963, 0x964,
    0x965, 0x966, 0x967, 0x968, 0x969, 0x96A, 0x96B, 0x96C,
    0x96D, 0x96E, 0x96F, 0x970, 0x971, 0x972, 0x973, 0x974,
    0x975, 0x976, 0x977, 0x978, 0x979, 0x97A, 0x97B, 0x97C,
    0x97D, 0x97E, 0x97F, 0x980, 0x981, 0x982, 0x983, 0x984,
    0x985, 0x986, 0x987, 0x988, 0xAF0, 0xAF1, 0xAF2, 0xAF3,
    0xAF4, 0xAF5, 0xAF6, 0xAF7, 0xAF8, 0xAF9, 0xAFA, 0xAFB,
    0xAFC, 0xAFD, 0xAFE, 0xAFF, 0xB00, 0xB01, 0xB02, 0xB03,
    0xB04, 0xB05, 0xB06, 0xB07, 0xB08, 0xB09, 0xB0A, 0xB0B,
    0xB0C, 0xB0D, 0xB0E, 0xB0F, 0xB10, 0xB11, 0xB12, 0xB13,
    0xB14, 0xB15, 0xB16, 0xB17, 0xB18, 0xB19, 0xB1A, 0xB1B,
    0xB1C, 0xB1D, 0xB1E, 0xB1F, 0xB20, 0xB21, 0xB22, 0xB23,
    0xB24, 0xB25, 0xB26, 0xB27, 0xB28, 0xB29, 0xB2A, 0xB2B,
    0xB2C, 0xB2D, 0xB2E, 0xB2F, 0xB30, 0xB31, 0xB32, 0xB33,
    0xB34, 0xB35, 0xB36, 0xB37, 0xB38, 0xB39, 0xB3A, 0xB3B,
    0xB3C, 0xB3D, 0xB3E, 0xB3F, 0xB40, 0xB41, 0xB42, 0xB43,
    0xB44, 0xB45, 0xB46, 0xB47, 0xB48, 0xB49, 0xB4A, 0xB4B,
    0xB4C, 0xB4D, 0xB4E, 0xB4F, 0xB50, 0xB51, 0xB52, 0xB53,
    0xB54, 0xB55, 0xB56, 0xB57, 0xB58, 0xB59, 0xB5A, 0xB5B,
    0xB5C, 0xB5D, 0xB5E, 0xB5F, 0xB60, 0xB61, 0xB62, 0xB63,
    0xB64, 0xB65, 0xB66, 0xB67, 0xB68, 0xB69, 0xB6A, 0xB6B,
    0xB6C, 0xB6D, 0xB6E, 0xB6F, 0xB70, 0xB71, 0xB72, 0xB73,
    0xB74, 0xB75, 0xB76, 0xB77, 0xB78, 0xB79, 0xB7A, 0xB7B,
    0xB7C, 0xB7D, 0xB7E, 0xB7F, 0xB80, 0xB81, 0xB82, 0xB83,
    0xB84, 0xB85, 0xB86, 0xB87, 0xB88, 0xB89, 0xB8A, 0xB8B,
    0xB8C, 0xB8D, 0xB8E, 0xB8F, 0xB90, 0xB91, 0xB92, 0xB93,
    0xB94, 0xB95, 0xB96, 0xB97, 0xB98, 0xB99, 0xB9A, 0xB9B,
    0xB9C, 0xB9D, 0xB9E, 0xB9F, 0xBA0, 0xBA1, 0xBA2, 0xE10,
    0xE11, 0xE12, 0xE13, 0xE14, 0xE15, 0xE16, 0xE17, 0xE18,
    0xE19, 0xE1A, 0xE1B, 0xE1C, 0xE1D, 0xE1E, 0xE1F, 0xE20,
    0xE21, 0xE22, 0xE23, 0xE24, 0xE25, 0xE26, 0xE27, 0xE28,
    0xE29, 0xE2A, 0xE2B, 0xE2C, 0xE2D, 0xE2E, 0xE2F, 0xE30,
    0xE31, 0xE32, 0xE33, 0xE40, 0xE41, 0xE42, 0xE43, 0xE44,
    0xE45, 0xE46, 0xE47, 0xE48, 0xE49, 0xE4A, 0xE70, 0xE71,
    0xE72, 0xE73, 0xE74, 0xE75, 0xE76, 0xE77, 0xE78, 0xE79,
    0xE7A, 0xE7B, 0xE7C, 0xE7D, 0xEA0
};

#define GMOJI_PUA_MIN   0xFE000
#define GMOJI_PUA_MAX   0xFEEA0
#define GMOJI_PUA_COUNT (sizeof(gGmojiPUA) / sizeof(gGmojiPUA[0]))
// GMOJI_PUA_COUNT should be 805

