/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import com.google.analytics.tracking.android.AnalyticsStore;
import com.google.analytics.tracking.android.AnalyticsStoreStateListener;
import com.google.analytics.tracking.android.AnalyticsThread;
import com.google.analytics.tracking.android.GANetworkReceiver;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.PersistentAnalyticsStore;
import com.google.analytics.tracking.android.ServiceManager;
import com.google.android.gms.common.util.VisibleForTesting;

public class GAServiceManager
implements ServiceManager {
    private static final int MSG_KEY = 1;
    private static final Object MSG_OBJECT = new Object();
    private Context ctx;
    private AnalyticsStore store;
    private volatile AnalyticsThread thread;
    private int dispatchPeriodInSeconds = 1800;
    private boolean pendingDispatch = true;
    private boolean connected = true;
    private boolean listenForNetwork = true;
    private AnalyticsStoreStateListener listener = new AnalyticsStoreStateListener(){

        @Override
        public void reportStoreIsEmpty(boolean isEmpty) {
            GAServiceManager.this.updatePowerSaveMode(isEmpty, GAServiceManager.this.connected);
        }
    };
    private Handler handler;
    private GANetworkReceiver networkReceiver;
    private boolean storeIsEmpty = false;
    private static GAServiceManager instance;

    public static GAServiceManager getInstance() {
        if (instance == null) {
            instance = new GAServiceManager();
        }
        return instance;
    }

    private GAServiceManager() {
    }

    @VisibleForTesting
    GAServiceManager(Context ctx, AnalyticsThread thread, AnalyticsStore store, boolean listenForNetwork) {
        this.store = store;
        this.thread = thread;
        this.listenForNetwork = listenForNetwork;
        this.initialize(ctx, thread);
    }

    private void initializeNetworkReceiver() {
        this.networkReceiver = new GANetworkReceiver(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.ctx.registerReceiver((BroadcastReceiver)this.networkReceiver, filter);
    }

    private void initializeHandler() {
        this.handler = new Handler(this.ctx.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (1 == msg.what && MSG_OBJECT.equals(msg.obj)) {
                    GAUsage.getInstance().setDisableUsage(true);
                    GAServiceManager.this.dispatch();
                    GAUsage.getInstance().setDisableUsage(false);
                    if (GAServiceManager.this.dispatchPeriodInSeconds > 0 && !GAServiceManager.this.storeIsEmpty) {
                        GAServiceManager.this.handler.sendMessageDelayed(GAServiceManager.this.handler.obtainMessage(1, MSG_OBJECT), (long)(GAServiceManager.this.dispatchPeriodInSeconds * 1000));
                    }
                }
                return true;
            }
        });
        if (this.dispatchPeriodInSeconds > 0) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(this.dispatchPeriodInSeconds * 1000));
        }
    }

    synchronized void initialize(Context ctx, AnalyticsThread thread) {
        if (this.ctx != null) {
            return;
        }
        this.ctx = ctx.getApplicationContext();
        if (this.thread == null) {
            this.thread = thread;
            if (this.pendingDispatch) {
                thread.dispatch();
            }
        }
    }

    @VisibleForTesting
    AnalyticsStoreStateListener getListener() {
        return this.listener;
    }

    synchronized AnalyticsStore getStore() {
        if (this.store == null) {
            if (this.ctx == null) {
                throw new IllegalStateException("Cant get a store unless we have a context");
            }
            this.store = new PersistentAnalyticsStore(this.listener, this.ctx);
        }
        if (this.handler == null) {
            this.initializeHandler();
        }
        if (this.networkReceiver == null && this.listenForNetwork) {
            this.initializeNetworkReceiver();
        }
        return this.store;
    }

    @Override
    public synchronized void dispatch() {
        if (this.thread == null) {
            Log.w("dispatch call queued.  Need to call GAServiceManager.getInstance().initialize().");
            this.pendingDispatch = true;
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.DISPATCH);
        this.thread.dispatch();
    }

    @Override
    public synchronized void setDispatchPeriod(int dispatchPeriodInSeconds) {
        if (this.handler == null) {
            Log.w("Need to call initialize() and be in fallback mode to start dispatch.");
            this.dispatchPeriodInSeconds = dispatchPeriodInSeconds;
            return;
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_DISPATCH_PERIOD);
        if (!this.storeIsEmpty && this.connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
        }
        this.dispatchPeriodInSeconds = dispatchPeriodInSeconds;
        if (dispatchPeriodInSeconds > 0 && !this.storeIsEmpty && this.connected) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(dispatchPeriodInSeconds * 1000));
        }
    }

    @VisibleForTesting
    synchronized void updatePowerSaveMode(boolean storeIsEmpty, boolean connected) {
        if (this.storeIsEmpty == storeIsEmpty && this.connected == connected) {
            return;
        }
        if ((storeIsEmpty || !connected) && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
        }
        if (!storeIsEmpty && connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(this.dispatchPeriodInSeconds * 1000));
        }
        Log.iDebug("PowerSaveMode " + (storeIsEmpty || !connected ? "initiated." : "terminated."));
        this.storeIsEmpty = storeIsEmpty;
        this.connected = connected;
    }

    @Override
    public synchronized void updateConnectivityStatus(boolean connected) {
        this.updatePowerSaveMode(this.storeIsEmpty, connected);
    }
}

