/* This file is part of the Project Athena Zephyr Notification System.
 * It contains the version identification of the Zephyr server
 *
 *	Created by:	John T. Kohl
 *
 *	$Id: version.c 2564 2010-03-17 15:29:10Z kcr@ATHENA.MIT.EDU $
 *
 *	Copyright (c) 1989 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <zephyr/mit-copyright.h>

#include <sys/utsname.h>

#include "zserver.h"
#include "version.h"

const char zephyr_version[] = "Zephyr system version 2.0";

#ifdef DEBUG
const char version[] = "Zephyr server (DEBUG) $Revision: 2564 $";
#else
const char version[] = "Zephyr server $Revision: 2564 $";
#endif

#if !defined (lint) && !defined (SABER)
static const char rcsid_version_c[] =
    "$Id: version.c 2564 2010-03-17 15:29:10Z kcr@ATHENA.MIT.EDU $";
static const char copyright[] =
    "Copyright (c) 1987,1988,1989,1990 Massachusetts Institute of Technology.\n";
#endif

char *
get_version(void)
{
  static char vers_buf[256];
  struct utsname un;

  if (vers_buf[0] == '\0') {
#ifdef DEBUG
    sprintf(vers_buf,"Zephyr Server (DEBUG) $Revision: 2564 $: %s",
	    ZSERVER_VERSION_STRING);
#else
    sprintf(vers_buf,"Zephyr Server $Revision: 2564 $: %s",
	    ZSERVER_VERSION_STRING);
#endif /* DEBUG */

    (void) strcat(vers_buf, "/");

    uname(&un);
    (void) strcat(vers_buf, un.machine);
    (void) strcat(vers_buf, "-");
    (void) strcat(vers_buf, un.sysname);
  }
  return(vers_buf);
}
