/* db-reader.c generated by valac 0.16.0, the Vala compiler
 * generated from db-reader.vala, do not modify */

/* db-reader.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define ZEITGEIST_TYPE_DB_READER (zeitgeist_db_reader_get_type ())
#define ZEITGEIST_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader))
#define ZEITGEIST_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))
#define ZEITGEIST_IS_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_IS_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_DB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))

typedef struct _ZeitgeistDbReader ZeitgeistDbReader;
typedef struct _ZeitgeistDbReaderClass ZeitgeistDbReaderClass;
typedef struct _ZeitgeistDbReaderPrivate ZeitgeistDbReaderPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;

#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_WHERE_CLAUSE (zeitgeist_where_clause_get_type ())
#define ZEITGEIST_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause))
#define ZEITGEIST_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))
#define ZEITGEIST_IS_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_IS_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))

typedef struct _ZeitgeistWhereClause ZeitgeistWhereClause;
typedef struct _ZeitgeistWhereClauseClass ZeitgeistWhereClauseClass;

#define ZEITGEIST_TYPE_RESULT_TYPE (zeitgeist_result_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;

#define ZEITGEIST_WHERE_CLAUSE_TYPE_TYPE (zeitgeist_where_clause_type_get_type ())

#define ZEITGEIST_TYPE_STORAGE_STATE (zeitgeist_storage_state_get_type ())

#define ZEITGEIST_TYPE_RELEVANT_RESULT_TYPE (zeitgeist_relevant_result_type_get_type ())

#define ZEITGEIST_DB_READER_TYPE_RELATED_URI (zeitgeist_db_reader_related_uri_get_type ())
typedef struct _ZeitgeistDbReaderRelatedUri ZeitgeistDbReaderRelatedUri;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _zeitgeist_db_reader_related_uri_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_db_reader_related_uri_free (var), NULL)))
#define __g_list_free__zeitgeist_db_reader_related_uri_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__zeitgeist_db_reader_related_uri_free0_ (var), NULL)))
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;

struct _ZeitgeistDbReader {
	GObject parent_instance;
	ZeitgeistDbReaderPrivate * priv;
	sqlite3* db;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistDbReaderClass {
	GObjectClass parent_class;
	void (*close) (ZeitgeistDbReader* self);
};

struct _ZeitgeistDbReaderPrivate {
	ZeitgeistSQLiteDatabase* _database;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT
} ZeitgeistSQLiteEventViewRows;

typedef enum  {
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS = 0,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS = 1,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS = 2,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS = 3,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS = 4,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS = 5,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR = 6,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR = 7,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR = 8,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR = 9,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN = 10,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN = 11,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN = 12,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN = 13,
	ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR = 14,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION = 15,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION = 16,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION = 17,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION = 18,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE = 19,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE = 20,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE = 21,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE = 22,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI = 23,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI = 24,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI = 25,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI = 26,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN = 27,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN = 28,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN = 29,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN = 30
} ZeitgeistResultType;

typedef enum  {
	ZEITGEIST_WHERE_CLAUSE_TYPE_AND,
	ZEITGEIST_WHERE_CLAUSE_TYPE_OR
} ZeitgeistWhereClauseType;

typedef enum  {
	ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE = 0,
	ZEITGEIST_STORAGE_STATE_AVAILABLE = 1,
	ZEITGEIST_STORAGE_STATE_ANY = 2
} ZeitgeistStorageState;

typedef enum  {
	ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT = 0,
	ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED = 1
} ZeitgeistRelevantResultType;

struct _ZeitgeistDbReaderRelatedUri {
	guint32 id;
	gint64 timestamp;
	gchar* uri;
	gint32 counter;
};

typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, void* user_data);
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};


static gpointer zeitgeist_db_reader_parent_class = NULL;

GType zeitgeist_db_reader_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_DB_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderPrivate))
enum  {
	ZEITGEIST_DB_READER_DUMMY_PROPERTY,
	ZEITGEIST_DB_READER_DATABASE
};
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistDbReader* zeitgeist_db_reader_new (GError** error);
ZeitgeistDbReader* zeitgeist_db_reader_construct (GType object_type, GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
ZeitgeistEvent* zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, guint32 event_id, GError** error);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST;
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value);
const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self, gint id, GError** error);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
ZeitgeistSubject* zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, GError** error);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value);
GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
static void _g_object_unref0_ (gpointer var);
ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self);
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
GType zeitgeist_where_clause_get_type (void) G_GNUC_CONST;
guint32* zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self, ZeitgeistWhereClause* where, guint max_events, guint result_type, int* result_length1, GError** error);
gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self);
GType zeitgeist_result_type_get_type (void) G_GNUC_CONST;
static gchar* zeitgeist_db_reader_group_and_sort (ZeitgeistDbReader* self, const gchar* field, const gchar* where_sql, gboolean* count_asc, const gchar* aggregation_type);
gboolean zeitgeist_result_type_is_sort_order_asc (ZeitgeistResultType result_type);
gboolean zeitgeist_where_clause_get_is_simple (ZeitgeistWhereClause* self);
GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self);
static void _vala_array_add1 (guint32** array, int* length, int* size, guint32 value);
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, GError** error);
GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error);
GType zeitgeist_where_clause_type_get_type (void) G_GNUC_CONST;
ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type, gboolean negate);
ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type, ZeitgeistWhereClauseType type, gboolean negate);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
void zeitgeist_where_clause_add (ZeitgeistWhereClause* self, const gchar* condition, const gchar* argument);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
GType zeitgeist_storage_state_get_type (void) G_GNUC_CONST;
void zeitgeist_where_clause_set_is_simple (ZeitgeistWhereClause* self, gboolean simple);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self, GPtrArray* templates, GError** error);
void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self, ZeitgeistWhereClause* clause);
gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error);
GType zeitgeist_relevant_result_type_get_type (void) G_GNUC_CONST;
static GType zeitgeist_db_reader_related_uri_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ZeitgeistDbReaderRelatedUri* zeitgeist_db_reader_related_uri_dup (const ZeitgeistDbReaderRelatedUri* self);
static void zeitgeist_db_reader_related_uri_free (ZeitgeistDbReaderRelatedUri* self);
static void zeitgeist_db_reader_related_uri_copy (const ZeitgeistDbReaderRelatedUri* self, ZeitgeistDbReaderRelatedUri* dest);
static void zeitgeist_db_reader_related_uri_destroy (ZeitgeistDbReaderRelatedUri* self);
static void _zeitgeist_db_reader_related_uri_free0_ (gpointer var);
static void _g_free0_ (gpointer var);
static gboolean _vala_uint32_array_contains (guint32* stack, int stack_length, guint32 needle);
static gint ___lambda6_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b);
static gint ____lambda6__gcompare_func (gconstpointer a, gconstpointer b);
static gint ___lambda7_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b);
static gint ____lambda7__gcompare_func (gconstpointer a, gconstpointer b);
static gint ____lambda8_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b);
static gint _____lambda8__gcompare_func (gconstpointer a, gconstpointer b);
static void _g_list_free__zeitgeist_db_reader_related_uri_free0_ (GList* self);
void zeitgeist_db_reader_close (ZeitgeistDbReader* self);
static void zeitgeist_db_reader_real_close (ZeitgeistDbReader* self);
void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self);
static ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_template (ZeitgeistDbReader* self, ZeitgeistEvent* template, GError** error);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
void zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
gboolean zeitgeist_utils_parse_wildcard (gchar** val);
gboolean zeitgeist_utils_parse_negation (gchar** val);
void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* needle, gboolean negation);
void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self, const gchar* column, gint val, gboolean negation);
gint zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self, const gchar* name);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
void zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
void zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
gboolean zeitgeist_utils_parse_noexpand (gchar** val);
GList* zeitgeist_symbol_get_all_children (const gchar* symbol_uri);
static void zeitgeist_db_reader_delete_from_cache (ZeitgeistDbReader* self, const gchar* table, gint64 rowid);
void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self, gint id);
static void zeitgeist_db_reader_set_database (ZeitgeistDbReader* self, ZeitgeistSQLiteDatabase* value);
static GObject * zeitgeist_db_reader_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table, gint64 rowid, gpointer self);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type, ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
static void zeitgeist_db_reader_finalize (GObject* obj);
static void _vala_zeitgeist_db_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_db_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ZeitgeistDbReader* zeitgeist_db_reader_construct (GType object_type, GError** error) {
	ZeitgeistDbReader * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = zeitgeist_sq_lite_database_new_read_only (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp1_;
	self = (ZeitgeistDbReader*) g_object_new (object_type, "database", _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	return self;
}


ZeitgeistDbReader* zeitgeist_db_reader_new (GError** error) {
	return zeitgeist_db_reader_construct (ZEITGEIST_TYPE_DB_READER, error);
}


ZeitgeistEvent* zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, guint32 event_id, GError** error) {
	ZeitgeistEvent* result = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	ZeitgeistEvent* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint64 _tmp5_ = 0LL;
	ZeitgeistSQLiteTableLookup* _tmp6_;
	sqlite3_stmt* _tmp7_;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	ZeitgeistSQLiteTableLookup* _tmp18_;
	sqlite3_stmt* _tmp19_;
	gint _tmp20_ = 0;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	ZeitgeistEvent* _tmp23_;
	ZeitgeistEvent* _tmp24_;
	sqlite3_stmt* _tmp25_;
	const gchar* _tmp26_ = NULL;
	sqlite3_stmt* _tmp27_;
	void* _tmp28_ = NULL;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	sqlite3_stmt* _tmp29_;
	gint _tmp30_ = 0;
	gint _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_event_new ();
	event = _tmp0_;
	_tmp1_ = event;
	_tmp2_ = event_id;
	zeitgeist_event_set_id (_tmp1_, _tmp2_);
	_tmp3_ = event;
	_tmp4_ = stmt;
	_tmp5_ = sqlite3_column_int64 (_tmp4_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP);
	zeitgeist_event_set_timestamp (_tmp3_, _tmp5_);
	_tmp6_ = self->interpretations_table;
	_tmp7_ = stmt;
	_tmp8_ = sqlite3_column_int (_tmp7_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION);
	_tmp9_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp6_, _tmp8_, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = event;
	zeitgeist_event_set_interpretation (_tmp11_, _tmp10_);
	_tmp12_ = self->manifestations_table;
	_tmp13_ = stmt;
	_tmp14_ = sqlite3_column_int (_tmp13_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION);
	_tmp15_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp12_, _tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = event;
	zeitgeist_event_set_manifestation (_tmp17_, _tmp16_);
	_tmp18_ = self->actors_table;
	_tmp19_ = stmt;
	_tmp20_ = sqlite3_column_int (_tmp19_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR);
	_tmp21_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp18_, _tmp20_, &_inner_error_);
	_tmp22_ = _tmp21_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = event;
	zeitgeist_event_set_actor (_tmp23_, _tmp22_);
	_tmp24_ = event;
	_tmp25_ = stmt;
	_tmp26_ = sqlite3_column_text (_tmp25_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI);
	zeitgeist_event_set_origin (_tmp24_, _tmp26_);
	_tmp27_ = stmt;
	_tmp28_ = sqlite3_column_blob (_tmp27_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data = (guint8*) _tmp28_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp29_ = stmt;
	_tmp30_ = sqlite3_column_bytes (_tmp29_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data_length1 = _tmp30_;
	_tmp31_ = data_length1;
	_tmp32_ = data;
	_tmp32__length1 = data_length1;
	if (_tmp32_ != NULL) {
		ZeitgeistEvent* _tmp33_;
		GByteArray* _tmp34_;
		GByteArray* _tmp35_;
		ZeitgeistEvent* _tmp36_;
		GByteArray* _tmp37_;
		GByteArray* _tmp38_;
		guint8* _tmp39_;
		gint _tmp39__length1;
		_tmp33_ = event;
		_tmp34_ = g_byte_array_new ();
		_tmp35_ = _tmp34_;
		zeitgeist_event_set_payload (_tmp33_, _tmp35_);
		_g_byte_array_unref0 (_tmp35_);
		_tmp36_ = event;
		_tmp37_ = zeitgeist_event_get_payload (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = data;
		_tmp39__length1 = data_length1;
		g_byte_array_append (_tmp38_, _tmp39_, _tmp39__length1);
	}
	result = event;
	return result;
}


ZeitgeistSubject* zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, GError** error) {
	ZeitgeistSubject* result = NULL;
	ZeitgeistSubject* _tmp0_;
	ZeitgeistSubject* subject;
	ZeitgeistSubject* _tmp1_;
	sqlite3_stmt* _tmp2_;
	const gchar* _tmp3_ = NULL;
	ZeitgeistSubject* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_ = NULL;
	ZeitgeistSubject* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_ = NULL;
	ZeitgeistSubject* _tmp10_;
	sqlite3_stmt* _tmp11_;
	const gchar* _tmp12_ = NULL;
	ZeitgeistSubject* _tmp13_;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	ZeitgeistSubject* _tmp21_;
	ZeitgeistSQLiteTableLookup* _tmp22_;
	sqlite3_stmt* _tmp23_;
	gint _tmp24_ = 0;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	ZeitgeistSubject* _tmp27_;
	ZeitgeistSQLiteTableLookup* _tmp28_;
	sqlite3_stmt* _tmp29_;
	gint _tmp30_ = 0;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_;
	ZeitgeistSubject* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_subject_new ();
	subject = _tmp0_;
	_tmp1_ = subject;
	_tmp2_ = stmt;
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI);
	zeitgeist_subject_set_uri (_tmp1_, _tmp3_);
	_tmp4_ = subject;
	_tmp5_ = stmt;
	_tmp6_ = sqlite3_column_text (_tmp5_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT);
	zeitgeist_subject_set_text (_tmp4_, _tmp6_);
	_tmp7_ = subject;
	_tmp8_ = stmt;
	_tmp9_ = sqlite3_column_text (_tmp8_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE);
	zeitgeist_subject_set_storage (_tmp7_, _tmp9_);
	_tmp10_ = subject;
	_tmp11_ = stmt;
	_tmp12_ = sqlite3_column_text (_tmp11_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI);
	zeitgeist_subject_set_origin (_tmp10_, _tmp12_);
	_tmp13_ = subject;
	_tmp14_ = stmt;
	_tmp15_ = sqlite3_column_text (_tmp14_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI);
	zeitgeist_subject_set_current_uri (_tmp13_, _tmp15_);
	_tmp16_ = self->interpretations_table;
	_tmp17_ = stmt;
	_tmp18_ = sqlite3_column_int (_tmp17_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION);
	_tmp19_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp16_, _tmp18_, &_inner_error_);
	_tmp20_ = _tmp19_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = subject;
	zeitgeist_subject_set_interpretation (_tmp21_, _tmp20_);
	_tmp22_ = self->manifestations_table;
	_tmp23_ = stmt;
	_tmp24_ = sqlite3_column_int (_tmp23_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION);
	_tmp25_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp22_, _tmp24_, &_inner_error_);
	_tmp26_ = _tmp25_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = subject;
	zeitgeist_subject_set_manifestation (_tmp27_, _tmp26_);
	_tmp28_ = self->mimetypes_table;
	_tmp29_ = stmt;
	_tmp30_ = sqlite3_column_int (_tmp29_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE);
	_tmp31_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp28_, _tmp30_, &_inner_error_);
	_tmp32_ = _tmp31_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp33_ = subject;
	zeitgeist_subject_set_mimetype (_tmp33_, _tmp32_);
	result = subject;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void g_ptr_array_set (GPtrArray* self, guint index, gpointer data) {
	gpointer _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	_tmp1_ = index;
	g_ptr_array_remove_index_fast (self, _tmp1_);
}


GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	GPtrArray* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	ZeitgeistSQLiteDatabase* _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* sql_event_ids;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* sql;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint rc;
	ZeitgeistSQLiteDatabase* _tmp11_;
	gint _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GHashTable* events;
	ZeitgeistSQLiteDatabase* _tmp38_;
	gint _tmp39_;
	GPtrArray* _tmp40_;
	GPtrArray* results;
	GPtrArray* _tmp41_;
	guint32* _tmp42_;
	gint _tmp42__length1;
	gint i;
	guint32* _tmp43_;
	gint _tmp43__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	if (_tmp0__length1 == 0) {
		GPtrArray* _tmp1_;
		_tmp1_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_database;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_tmp4_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp2_, _tmp3_, _tmp3__length1);
	sql_event_ids = _tmp4_;
	_tmp5_ = sql_event_ids;
	_tmp6_ = g_strdup_printf ("\n" \
"            SELECT * FROM event_view\n" \
"            WHERE id IN (%s)\n" \
"            ", _tmp5_);
	sql = _tmp6_;
	_tmp7_ = self->db;
	_tmp8_ = sql;
	_tmp10_ = sqlite3_prepare_v2 (_tmp7_, _tmp8_, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp9_;
	rc = _tmp10_;
	_tmp11_ = self->priv->_database;
	_tmp12_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp11_, _tmp12_, "db-reader.vala:138: SQL error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = g_direct_hash;
	_tmp14_ = g_direct_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, NULL, _g_object_unref0_);
	events = _tmp15_;
	while (TRUE) {
		sqlite3_stmt* _tmp16_;
		gint _tmp17_ = 0;
		gint _tmp18_;
		sqlite3_stmt* _tmp19_;
		gint64 _tmp20_ = 0LL;
		guint32 event_id;
		GHashTable* _tmp21_;
		guint32 _tmp22_;
		gconstpointer _tmp23_ = NULL;
		ZeitgeistEvent* _tmp24_;
		ZeitgeistEvent* event;
		ZeitgeistEvent* _tmp25_;
		sqlite3_stmt* _tmp34_;
		ZeitgeistSubject* _tmp35_ = NULL;
		ZeitgeistSubject* subject;
		ZeitgeistEvent* _tmp36_;
		ZeitgeistSubject* _tmp37_;
		_tmp16_ = stmt;
		_tmp17_ = sqlite3_step (_tmp16_);
		rc = _tmp17_;
		_tmp18_ = rc;
		if (!(_tmp18_ == SQLITE_ROW)) {
			break;
		}
		_tmp19_ = stmt;
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		event_id = (guint32) _tmp20_;
		_tmp21_ = events;
		_tmp22_ = event_id;
		_tmp23_ = g_hash_table_lookup (_tmp21_, GUINT_TO_POINTER (_tmp22_));
		_tmp24_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp23_);
		event = _tmp24_;
		_tmp25_ = event;
		if (_tmp25_ == NULL) {
			sqlite3_stmt* _tmp26_;
			guint32 _tmp27_;
			ZeitgeistEvent* _tmp28_ = NULL;
			ZeitgeistEvent* _tmp29_;
			GHashTable* _tmp30_;
			guint32 _tmp31_;
			ZeitgeistEvent* _tmp32_;
			ZeitgeistEvent* _tmp33_;
			_tmp26_ = stmt;
			_tmp27_ = event_id;
			_tmp28_ = zeitgeist_db_reader_get_event_from_row (self, _tmp26_, _tmp27_, &_inner_error_);
			_tmp29_ = _tmp28_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (event);
					_g_hash_table_unref0 (events);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					_g_free0 (sql_event_ids);
					return NULL;
				} else {
					_g_object_unref0 (event);
					_g_hash_table_unref0 (events);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					_g_free0 (sql_event_ids);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_g_object_unref0 (event);
			event = _tmp29_;
			_tmp30_ = events;
			_tmp31_ = event_id;
			_tmp32_ = event;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			g_hash_table_insert (_tmp30_, GUINT_TO_POINTER (_tmp31_), _tmp33_);
		}
		_tmp34_ = stmt;
		_tmp35_ = zeitgeist_db_reader_get_subject_from_row (self, _tmp34_, &_inner_error_);
		subject = _tmp35_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (event);
				_g_hash_table_unref0 (events);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				return NULL;
			} else {
				_g_object_unref0 (event);
				_g_hash_table_unref0 (events);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp36_ = event;
		_tmp37_ = subject;
		zeitgeist_event_add_subject (_tmp36_, _tmp37_);
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
	}
	_tmp38_ = self->priv->_database;
	_tmp39_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp38_, _tmp39_, "Error", SQLITE_DONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp40_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	results = _tmp40_;
	_tmp41_ = results;
	_tmp42_ = event_ids;
	_tmp42__length1 = event_ids_length1;
	g_ptr_array_set_length (_tmp41_, _tmp42__length1);
	i = 0;
	_tmp43_ = event_ids;
	_tmp43__length1 = event_ids_length1;
	{
		guint32* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp43_;
		id_collection_length1 = _tmp43__length1;
		for (id_it = 0; id_it < _tmp43__length1; id_it = id_it + 1) {
			guint32 id = 0U;
			id = id_collection[id_it];
			{
				GPtrArray* _tmp44_;
				gint _tmp45_;
				GHashTable* _tmp46_;
				guint32 _tmp47_;
				gconstpointer _tmp48_ = NULL;
				ZeitgeistEvent* _tmp49_;
				_tmp44_ = results;
				_tmp45_ = i;
				i = _tmp45_ + 1;
				_tmp46_ = events;
				_tmp47_ = id;
				_tmp48_ = g_hash_table_lookup (_tmp46_, GUINT_TO_POINTER (_tmp47_));
				_tmp49_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp48_);
				g_ptr_array_set (_tmp44_, (guint) _tmp45_, _tmp49_);
			}
		}
	}
	result = results;
	_g_hash_table_unref0 (events);
	_sqlite3_finalize0 (stmt);
	_g_free0 (sql);
	_g_free0 (sql_event_ids);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (guint32** array, int* length, int* size, guint32 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint32, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guint32* zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self, ZeitgeistWhereClause* where, guint max_events, guint result_type, int* result_length1, GError** error) {
	guint32* result = NULL;
	gchar* _tmp0_;
	gchar* sql;
	gchar* _tmp1_;
	gchar* where_sql;
	ZeitgeistWhereClause* _tmp2_;
	gboolean _tmp3_ = FALSE;
	guint _tmp8_;
	guint _tmp182_;
	gboolean _tmp183_ = FALSE;
	gboolean time_asc;
	const gchar* _tmp184_ = NULL;
	gboolean _tmp185_;
	const gchar* _tmp186_;
	const gchar* _tmp187_;
	gchar* _tmp188_ = NULL;
	gchar* _tmp189_;
	gchar* _tmp190_;
	ZeitgeistWhereClause* _tmp191_;
	gboolean _tmp192_ = FALSE;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp195_;
	const gchar* _tmp196_;
	sqlite3_stmt* _tmp197_ = NULL;
	gint _tmp198_ = 0;
	ZeitgeistSQLiteDatabase* _tmp199_;
	gint _tmp200_;
	ZeitgeistWhereClause* _tmp201_;
	GPtrArray* _tmp202_ = NULL;
	GPtrArray* _tmp203_;
	GPtrArray* arguments;
	guint32* _tmp218_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	gboolean _tmp236_ = FALSE;
	gint _tmp237_;
	gboolean _tmp239_;
	guint32* _tmp249_;
	gint _tmp249__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (where != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT id FROM event_view ");
	sql = _tmp0_;
	_tmp1_ = g_strdup ("");
	where_sql = _tmp1_;
	_tmp2_ = where;
	_tmp3_ = zeitgeist_where_clause_is_empty (_tmp2_);
	if (!_tmp3_) {
		ZeitgeistWhereClause* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = where;
		_tmp5_ = zeitgeist_where_clause_get_sql_conditions (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("WHERE ", _tmp6_, NULL);
		_g_free0 (where_sql);
		where_sql = _tmp7_;
		_g_free0 (_tmp6_);
	}
	_tmp8_ = result_type;
	switch (_tmp8_) {
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS:
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = sql;
			_tmp10_ = where_sql;
			_tmp11_ = g_strconcat (_tmp10_, " ORDER BY ", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (sql);
			sql = _tmp13_;
			_g_free0 (_tmp12_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS:
		{
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = sql;
			_tmp15_ = where_sql;
			_tmp16_ = g_strconcat (_tmp15_, " ORDER BY ", NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
			_g_free0 (sql);
			sql = _tmp18_;
			_g_free0 (_tmp17_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN:
		{
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp19_ = sql;
			_tmp20_ = where_sql;
			_tmp21_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp20_, NULL, "max");
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
			_g_free0 (sql);
			sql = _tmp23_;
			_g_free0 (_tmp22_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN:
		{
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp24_ = sql;
			_tmp25_ = where_sql;
			_tmp26_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp25_, NULL, "max");
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
			_g_free0 (sql);
			sql = _tmp28_;
			_g_free0 (_tmp27_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN:
		{
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp29_ = sql;
			_tmp30_ = where_sql;
			_tmp31_ = FALSE;
			_tmp32_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp30_, &_tmp31_, "max");
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
			_g_free0 (sql);
			sql = _tmp34_;
			_g_free0 (_tmp33_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN:
		{
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			gboolean _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp35_ = sql;
			_tmp36_ = where_sql;
			_tmp37_ = TRUE;
			_tmp38_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp36_, &_tmp37_, "max");
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
			_g_free0 (sql);
			sql = _tmp40_;
			_g_free0 (_tmp39_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS:
		{
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp41_ = sql;
			_tmp42_ = where_sql;
			_tmp43_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp42_, NULL, "max");
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp41_, _tmp44_, NULL);
			_g_free0 (sql);
			sql = _tmp45_;
			_g_free0 (_tmp44_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS:
		{
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp46_ = sql;
			_tmp47_ = where_sql;
			_tmp48_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp47_, NULL, "max");
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
			_g_free0 (sql);
			sql = _tmp50_;
			_g_free0 (_tmp49_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS:
		{
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gboolean _tmp53_;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp51_ = sql;
			_tmp52_ = where_sql;
			_tmp53_ = FALSE;
			_tmp54_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp52_, &_tmp53_, "max");
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp51_, _tmp55_, NULL);
			_g_free0 (sql);
			sql = _tmp56_;
			_g_free0 (_tmp55_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS:
		{
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			gboolean _tmp59_;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp57_ = sql;
			_tmp58_ = where_sql;
			_tmp59_ = TRUE;
			_tmp60_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp58_, &_tmp59_, "max");
			_tmp61_ = _tmp60_;
			_tmp62_ = g_strconcat (_tmp57_, _tmp61_, NULL);
			_g_free0 (sql);
			sql = _tmp62_;
			_g_free0 (_tmp61_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI:
		{
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp63_ = sql;
			_tmp64_ = where_sql;
			_tmp65_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp64_, NULL, "max");
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strconcat (_tmp63_, _tmp66_, NULL);
			_g_free0 (sql);
			sql = _tmp67_;
			_g_free0 (_tmp66_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI:
		{
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			gchar* _tmp72_;
			_tmp68_ = sql;
			_tmp69_ = where_sql;
			_tmp70_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp69_, NULL, "max");
			_tmp71_ = _tmp70_;
			_tmp72_ = g_strconcat (_tmp68_, _tmp71_, NULL);
			_g_free0 (sql);
			sql = _tmp72_;
			_g_free0 (_tmp71_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI:
		{
			const gchar* _tmp73_;
			const gchar* _tmp74_;
			gboolean _tmp75_;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			gchar* _tmp78_;
			_tmp73_ = sql;
			_tmp74_ = where_sql;
			_tmp75_ = FALSE;
			_tmp76_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp74_, &_tmp75_, "max");
			_tmp77_ = _tmp76_;
			_tmp78_ = g_strconcat (_tmp73_, _tmp77_, NULL);
			_g_free0 (sql);
			sql = _tmp78_;
			_g_free0 (_tmp77_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI:
		{
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			gboolean _tmp81_;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp79_ = sql;
			_tmp80_ = where_sql;
			_tmp81_ = TRUE;
			_tmp82_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp80_, &_tmp81_, "max");
			_tmp83_ = _tmp82_;
			_tmp84_ = g_strconcat (_tmp79_, _tmp83_, NULL);
			_g_free0 (sql);
			sql = _tmp84_;
			_g_free0 (_tmp83_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR:
		{
			const gchar* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_;
			gchar* _tmp89_;
			_tmp85_ = sql;
			_tmp86_ = where_sql;
			_tmp87_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp86_, NULL, "max");
			_tmp88_ = _tmp87_;
			_tmp89_ = g_strconcat (_tmp85_, _tmp88_, NULL);
			_g_free0 (sql);
			sql = _tmp89_;
			_g_free0 (_tmp88_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR:
		{
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			gchar* _tmp92_ = NULL;
			gchar* _tmp93_;
			gchar* _tmp94_;
			_tmp90_ = sql;
			_tmp91_ = where_sql;
			_tmp92_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp91_, NULL, "max");
			_tmp93_ = _tmp92_;
			_tmp94_ = g_strconcat (_tmp90_, _tmp93_, NULL);
			_g_free0 (sql);
			sql = _tmp94_;
			_g_free0 (_tmp93_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR:
		{
			const gchar* _tmp95_;
			const gchar* _tmp96_;
			gboolean _tmp97_;
			gchar* _tmp98_ = NULL;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp95_ = sql;
			_tmp96_ = where_sql;
			_tmp97_ = FALSE;
			_tmp98_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp96_, &_tmp97_, "max");
			_tmp99_ = _tmp98_;
			_tmp100_ = g_strconcat (_tmp95_, _tmp99_, NULL);
			_g_free0 (sql);
			sql = _tmp100_;
			_g_free0 (_tmp99_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR:
		{
			const gchar* _tmp101_;
			const gchar* _tmp102_;
			gboolean _tmp103_;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_;
			gchar* _tmp106_;
			_tmp101_ = sql;
			_tmp102_ = where_sql;
			_tmp103_ = TRUE;
			_tmp104_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp102_, &_tmp103_, "max");
			_tmp105_ = _tmp104_;
			_tmp106_ = g_strconcat (_tmp101_, _tmp105_, NULL);
			_g_free0 (sql);
			sql = _tmp106_;
			_g_free0 (_tmp105_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR:
		{
			const gchar* _tmp107_;
			const gchar* _tmp108_;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_;
			gchar* _tmp111_;
			_tmp107_ = sql;
			_tmp108_ = where_sql;
			_tmp109_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp108_, NULL, "min");
			_tmp110_ = _tmp109_;
			_tmp111_ = g_strconcat (_tmp107_, _tmp110_, NULL);
			_g_free0 (sql);
			sql = _tmp111_;
			_g_free0 (_tmp110_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN:
		{
			const gchar* _tmp112_;
			const gchar* _tmp113_;
			gchar* _tmp114_ = NULL;
			gchar* _tmp115_;
			gchar* _tmp116_;
			_tmp112_ = sql;
			_tmp113_ = where_sql;
			_tmp114_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp113_, NULL, "max");
			_tmp115_ = _tmp114_;
			_tmp116_ = g_strconcat (_tmp112_, _tmp115_, NULL);
			_g_free0 (sql);
			sql = _tmp116_;
			_g_free0 (_tmp115_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN:
		{
			const gchar* _tmp117_;
			const gchar* _tmp118_;
			gchar* _tmp119_ = NULL;
			gchar* _tmp120_;
			gchar* _tmp121_;
			_tmp117_ = sql;
			_tmp118_ = where_sql;
			_tmp119_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp118_, NULL, "max");
			_tmp120_ = _tmp119_;
			_tmp121_ = g_strconcat (_tmp117_, _tmp120_, NULL);
			_g_free0 (sql);
			sql = _tmp121_;
			_g_free0 (_tmp120_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN:
		{
			const gchar* _tmp122_;
			const gchar* _tmp123_;
			gboolean _tmp124_;
			gchar* _tmp125_ = NULL;
			gchar* _tmp126_;
			gchar* _tmp127_;
			_tmp122_ = sql;
			_tmp123_ = where_sql;
			_tmp124_ = FALSE;
			_tmp125_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp123_, &_tmp124_, "max");
			_tmp126_ = _tmp125_;
			_tmp127_ = g_strconcat (_tmp122_, _tmp126_, NULL);
			_g_free0 (sql);
			sql = _tmp127_;
			_g_free0 (_tmp126_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN:
		{
			const gchar* _tmp128_;
			const gchar* _tmp129_;
			gboolean _tmp130_;
			gchar* _tmp131_ = NULL;
			gchar* _tmp132_;
			gchar* _tmp133_;
			_tmp128_ = sql;
			_tmp129_ = where_sql;
			_tmp130_ = TRUE;
			_tmp131_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp129_, &_tmp130_, "max");
			_tmp132_ = _tmp131_;
			_tmp133_ = g_strconcat (_tmp128_, _tmp132_, NULL);
			_g_free0 (sql);
			sql = _tmp133_;
			_g_free0 (_tmp132_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp134_;
			const gchar* _tmp135_;
			gchar* _tmp136_ = NULL;
			gchar* _tmp137_;
			gchar* _tmp138_;
			_tmp134_ = sql;
			_tmp135_ = where_sql;
			_tmp136_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp135_, NULL, "max");
			_tmp137_ = _tmp136_;
			_tmp138_ = g_strconcat (_tmp134_, _tmp137_, NULL);
			_g_free0 (sql);
			sql = _tmp138_;
			_g_free0 (_tmp137_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp139_;
			const gchar* _tmp140_;
			gchar* _tmp141_ = NULL;
			gchar* _tmp142_;
			gchar* _tmp143_;
			_tmp139_ = sql;
			_tmp140_ = where_sql;
			_tmp141_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp140_, NULL, "max");
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strconcat (_tmp139_, _tmp142_, NULL);
			_g_free0 (sql);
			sql = _tmp143_;
			_g_free0 (_tmp142_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp144_;
			const gchar* _tmp145_;
			gboolean _tmp146_;
			gchar* _tmp147_ = NULL;
			gchar* _tmp148_;
			gchar* _tmp149_;
			_tmp144_ = sql;
			_tmp145_ = where_sql;
			_tmp146_ = FALSE;
			_tmp147_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp145_, &_tmp146_, "max");
			_tmp148_ = _tmp147_;
			_tmp149_ = g_strconcat (_tmp144_, _tmp148_, NULL);
			_g_free0 (sql);
			sql = _tmp149_;
			_g_free0 (_tmp148_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp150_;
			const gchar* _tmp151_;
			gboolean _tmp152_;
			gchar* _tmp153_ = NULL;
			gchar* _tmp154_;
			gchar* _tmp155_;
			_tmp150_ = sql;
			_tmp151_ = where_sql;
			_tmp152_ = TRUE;
			_tmp153_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp151_, &_tmp152_, "max");
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strconcat (_tmp150_, _tmp154_, NULL);
			_g_free0 (sql);
			sql = _tmp155_;
			_g_free0 (_tmp154_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE:
		{
			const gchar* _tmp156_;
			const gchar* _tmp157_;
			gchar* _tmp158_ = NULL;
			gchar* _tmp159_;
			gchar* _tmp160_;
			_tmp156_ = sql;
			_tmp157_ = where_sql;
			_tmp158_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp157_, NULL, "max");
			_tmp159_ = _tmp158_;
			_tmp160_ = g_strconcat (_tmp156_, _tmp159_, NULL);
			_g_free0 (sql);
			sql = _tmp160_;
			_g_free0 (_tmp159_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE:
		{
			const gchar* _tmp161_;
			const gchar* _tmp162_;
			gchar* _tmp163_ = NULL;
			gchar* _tmp164_;
			gchar* _tmp165_;
			_tmp161_ = sql;
			_tmp162_ = where_sql;
			_tmp163_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp162_, NULL, "max");
			_tmp164_ = _tmp163_;
			_tmp165_ = g_strconcat (_tmp161_, _tmp164_, NULL);
			_g_free0 (sql);
			sql = _tmp165_;
			_g_free0 (_tmp164_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE:
		{
			const gchar* _tmp166_;
			const gchar* _tmp167_;
			gboolean _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			gchar* _tmp171_;
			_tmp166_ = sql;
			_tmp167_ = where_sql;
			_tmp168_ = FALSE;
			_tmp169_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp167_, &_tmp168_, "max");
			_tmp170_ = _tmp169_;
			_tmp171_ = g_strconcat (_tmp166_, _tmp170_, NULL);
			_g_free0 (sql);
			sql = _tmp171_;
			_g_free0 (_tmp170_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE:
		{
			const gchar* _tmp172_;
			const gchar* _tmp173_;
			gboolean _tmp174_;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_;
			gchar* _tmp177_;
			_tmp172_ = sql;
			_tmp173_ = where_sql;
			_tmp174_ = TRUE;
			_tmp175_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp173_, &_tmp174_, "max");
			_tmp176_ = _tmp175_;
			_tmp177_ = g_strconcat (_tmp172_, _tmp176_, NULL);
			_g_free0 (sql);
			sql = _tmp177_;
			_g_free0 (_tmp176_);
			break;
		}
		default:
		{
			gchar* _tmp178_;
			gchar* error_message;
			const gchar* _tmp179_;
			const gchar* _tmp180_;
			GError* _tmp181_;
			_tmp178_ = g_strdup ("Invalid ResultType.");
			error_message = _tmp178_;
			_tmp179_ = error_message;
			g_warning ("db-reader.vala:276: %s", _tmp179_);
			_tmp180_ = error_message;
			_tmp181_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp180_);
			_inner_error_ = _tmp181_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				return NULL;
			} else {
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (error_message);
		}
	}
	_tmp182_ = result_type;
	_tmp183_ = zeitgeist_result_type_is_sort_order_asc ((ZeitgeistResultType) _tmp182_);
	time_asc = _tmp183_;
	_tmp185_ = time_asc;
	if (_tmp185_) {
		_tmp184_ = "ASC";
	} else {
		_tmp184_ = "DESC";
	}
	_tmp186_ = sql;
	_tmp187_ = _tmp184_;
	_tmp188_ = g_strdup_printf (" timestamp %s", _tmp187_);
	_tmp189_ = _tmp188_;
	_tmp190_ = g_strconcat (_tmp186_, _tmp189_, NULL);
	_g_free0 (sql);
	sql = _tmp190_;
	_g_free0 (_tmp189_);
	_tmp191_ = where;
	_tmp192_ = zeitgeist_where_clause_get_is_simple (_tmp191_);
	if (_tmp192_) {
		const gchar* _tmp193_;
		gchar* _tmp194_ = NULL;
		_tmp193_ = sql;
		_tmp194_ = string_replace (_tmp193_, "FROM event_view", "FROM event");
		_g_free0 (sql);
		sql = _tmp194_;
	}
	_tmp195_ = self->db;
	_tmp196_ = sql;
	_tmp198_ = sqlite3_prepare_v2 (_tmp195_, _tmp196_, -1, &_tmp197_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp197_;
	rc = _tmp198_;
	_tmp199_ = self->priv->_database;
	_tmp200_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp199_, _tmp200_, "db-reader.vala:291: SQL error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp201_ = where;
	_tmp202_ = zeitgeist_where_clause_get_bind_arguments (_tmp201_);
	_tmp203_ = _g_ptr_array_ref0 (_tmp202_);
	arguments = _tmp203_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp204_;
			_tmp204_ = TRUE;
			while (TRUE) {
				gboolean _tmp205_;
				gint _tmp207_;
				GPtrArray* _tmp208_;
				gint _tmp209_;
				gint _tmp210_;
				sqlite3_stmt* _tmp211_;
				gint _tmp212_;
				GPtrArray* _tmp213_;
				gint _tmp214_;
				gconstpointer _tmp215_ = NULL;
				gchar* _tmp216_;
				GDestroyNotify _tmp217_;
				_tmp205_ = _tmp204_;
				if (!_tmp205_) {
					gint _tmp206_;
					_tmp206_ = i;
					i = _tmp206_ + 1;
				}
				_tmp204_ = FALSE;
				_tmp207_ = i;
				_tmp208_ = arguments;
				_tmp209_ = g_ptr_array_get_length (_tmp208_);
				_tmp210_ = _tmp209_;
				if (!(_tmp207_ < _tmp210_)) {
					break;
				}
				_tmp211_ = stmt;
				_tmp212_ = i;
				_tmp213_ = arguments;
				_tmp214_ = i;
				_tmp215_ = g_ptr_array_index (_tmp213_, (guint) _tmp214_);
				_tmp216_ = g_strdup ((const gchar*) _tmp215_);
				_tmp217_ = g_free;
				sqlite3_bind_text (_tmp211_, _tmp212_ + 1, _tmp216_, -1, _tmp217_);
			}
		}
	}
	_tmp218_ = g_new0 (guint32, 0);
	event_ids = _tmp218_;
	event_ids_length1 = 0;
	_event_ids_size_ = event_ids_length1;
	while (TRUE) {
		sqlite3_stmt* _tmp219_;
		gint _tmp220_ = 0;
		gint _tmp221_;
		sqlite3_stmt* _tmp222_;
		const gchar* _tmp223_ = NULL;
		guint64 _tmp224_ = 0ULL;
		guint32 event_id;
		gboolean _tmp225_ = FALSE;
		guint32* _tmp226_;
		gint _tmp226__length1;
		gboolean _tmp231_;
		_tmp219_ = stmt;
		_tmp220_ = sqlite3_step (_tmp219_);
		rc = _tmp220_;
		_tmp221_ = rc;
		if (!(_tmp221_ == SQLITE_ROW)) {
			break;
		}
		_tmp222_ = stmt;
		_tmp223_ = sqlite3_column_text (_tmp222_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		_tmp224_ = uint64_parse (_tmp223_);
		event_id = (guint32) _tmp224_;
		_tmp226_ = event_ids;
		_tmp226__length1 = event_ids_length1;
		if (_tmp226__length1 == 0) {
			_tmp225_ = TRUE;
		} else {
			guint32* _tmp227_;
			gint _tmp227__length1;
			guint32* _tmp228_;
			gint _tmp228__length1;
			guint32 _tmp229_;
			guint32 _tmp230_;
			_tmp227_ = event_ids;
			_tmp227__length1 = event_ids_length1;
			_tmp228_ = event_ids;
			_tmp228__length1 = event_ids_length1;
			_tmp229_ = _tmp227_[_tmp228__length1 - 1];
			_tmp230_ = event_id;
			_tmp225_ = _tmp229_ != _tmp230_;
		}
		_tmp231_ = _tmp225_;
		if (_tmp231_) {
			guint32* _tmp232_;
			gint _tmp232__length1;
			guint32 _tmp233_;
			guint32* _tmp234_;
			gint _tmp234__length1;
			guint _tmp235_;
			_tmp232_ = event_ids;
			_tmp232__length1 = event_ids_length1;
			_tmp233_ = event_id;
			_vala_array_add1 (&event_ids, &event_ids_length1, &_event_ids_size_, _tmp233_);
			_tmp234_ = event_ids;
			_tmp234__length1 = event_ids_length1;
			_tmp235_ = max_events;
			if (((guint) _tmp234__length1) == _tmp235_) {
				break;
			}
		}
	}
	_tmp237_ = rc;
	if (_tmp237_ != SQLITE_DONE) {
		gint _tmp238_;
		_tmp238_ = rc;
		_tmp236_ = _tmp238_ != SQLITE_ROW;
	} else {
		_tmp236_ = FALSE;
	}
	_tmp239_ = _tmp236_;
	if (_tmp239_) {
		gint _tmp240_;
		sqlite3* _tmp241_;
		const gchar* _tmp242_ = NULL;
		gchar* _tmp243_ = NULL;
		gchar* error_message;
		const gchar* _tmp244_;
		ZeitgeistSQLiteDatabase* _tmp245_;
		gint _tmp246_;
		const gchar* _tmp247_;
		GError* _tmp248_;
		_tmp240_ = rc;
		_tmp241_ = self->db;
		_tmp242_ = sqlite3_errmsg (_tmp241_);
		_tmp243_ = g_strdup_printf ("Error in find_event_ids: %d, %s", _tmp240_, _tmp242_);
		error_message = _tmp243_;
		_tmp244_ = error_message;
		g_warning ("db-reader.vala:317: %s", _tmp244_);
		_tmp245_ = self->priv->_database;
		_tmp246_ = rc;
		zeitgeist_sq_lite_database_assert_not_corrupt (_tmp245_, _tmp246_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				event_ids = (g_free (event_ids), NULL);
				_g_ptr_array_unref0 (arguments);
				_sqlite3_finalize0 (stmt);
				_g_free0 (where_sql);
				_g_free0 (sql);
				return NULL;
			} else {
				_g_free0 (error_message);
				event_ids = (g_free (event_ids), NULL);
				_g_ptr_array_unref0 (arguments);
				_sqlite3_finalize0 (stmt);
				_g_free0 (where_sql);
				_g_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp247_ = error_message;
		_tmp248_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp247_);
		_inner_error_ = _tmp248_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			return NULL;
		} else {
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (error_message);
	}
	_tmp249_ = event_ids;
	_tmp249__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp249__length1;
	}
	result = _tmp249_;
	_g_ptr_array_unref0 (arguments);
	_sqlite3_finalize0 (stmt);
	_g_free0 (where_sql);
	_g_free0 (sql);
	return result;
}


guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* _tmp1_;
	guint _tmp2_;
	ZeitgeistWhereClause* _tmp3_ = NULL;
	ZeitgeistWhereClause* where;
	ZeitgeistWhereClause* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gint _tmp7_ = 0;
	guint32* _tmp8_ = NULL;
	guint32* _tmp9_;
	gint _tmp9__length1;
	gint __tmp9__size_;
	guint32* _tmp10_;
	gint _tmp10__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = time_range;
	_tmp1_ = event_templates;
	_tmp2_ = storage_state;
	_tmp3_ = zeitgeist_db_reader_get_where_clause_for_query (self, _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	where = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = where;
	_tmp5_ = max_events;
	_tmp6_ = result_type;
	_tmp8_ = zeitgeist_db_reader_find_event_ids_for_clause (self, _tmp4_, _tmp5_, _tmp6_, &_tmp7_, &_inner_error_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	__tmp9__size_ = _tmp9__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_object_unref0 (where);
	return result;
}


GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error) {
	GPtrArray* result = NULL;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint _tmp5_ = 0;
	guint32* _tmp6_ = NULL;
	guint32* _tmp7_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	guint32* _tmp8_;
	gint _tmp8__length1;
	GPtrArray* _tmp9_ = NULL;
	GPtrArray* _tmp10_;
	GPtrArray* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = time_range;
	_tmp1_ = event_templates;
	_tmp2_ = storage_state;
	_tmp3_ = max_events;
	_tmp4_ = result_type;
	_tmp6_ = zeitgeist_db_reader_find_event_ids (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	__tmp7__size_ = _tmp7__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp9_ = zeitgeist_db_reader_get_events (self, _tmp8_, _tmp7__length1, NULL, &_inner_error_);
	_tmp10_ = _tmp9_;
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp11_;
	return result;
}


ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* where;
	ZeitgeistTimeRange* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	ZeitgeistTimeRange* _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gboolean _tmp19_ = FALSE;
	guint _tmp20_;
	gboolean _tmp22_;
	GPtrArray* _tmp34_;
	ZeitgeistWhereClause* _tmp35_ = NULL;
	ZeitgeistWhereClause* tpl_conditions;
	ZeitgeistWhereClause* _tmp36_;
	ZeitgeistWhereClause* _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = zeitgeist_time_range_get_start (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp4_;
		ZeitgeistTimeRange* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = where;
		_tmp5_ = time_range;
		_tmp6_ = zeitgeist_time_range_get_start (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("timestamp >= %" G_GINT64_FORMAT, _tmp7_);
		_tmp9_ = _tmp8_;
		zeitgeist_where_clause_add (_tmp4_, _tmp9_, NULL);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = time_range;
	_tmp11_ = zeitgeist_time_range_get_end (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp13_;
		ZeitgeistTimeRange* _tmp14_;
		gint64 _tmp15_;
		gint64 _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp13_ = where;
		_tmp14_ = time_range;
		_tmp15_ = zeitgeist_time_range_get_end (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("timestamp <= %" G_GINT64_FORMAT, _tmp16_);
		_tmp18_ = _tmp17_;
		zeitgeist_where_clause_add (_tmp13_, _tmp18_, NULL);
		_g_free0 (_tmp18_);
	}
	_tmp20_ = storage_state;
	if (_tmp20_ == ((guint) ZEITGEIST_STORAGE_STATE_AVAILABLE)) {
		_tmp19_ = TRUE;
	} else {
		guint _tmp21_;
		_tmp21_ = storage_state;
		_tmp19_ = _tmp21_ == ((guint) ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE);
	}
	_tmp22_ = _tmp19_;
	if (_tmp22_) {
		ZeitgeistWhereClause* _tmp23_;
		guint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		ZeitgeistWhereClause* _tmp27_;
		_tmp23_ = where;
		_tmp24_ = storage_state;
		_tmp25_ = g_strdup_printf ("%u", _tmp24_);
		_tmp26_ = _tmp25_;
		zeitgeist_where_clause_add (_tmp23_, "(subj_storage_state=? OR subj_storage_state IS NULL)", _tmp26_);
		_g_free0 (_tmp26_);
		_tmp27_ = where;
		zeitgeist_where_clause_set_is_simple (_tmp27_, FALSE);
	} else {
		guint _tmp28_;
		_tmp28_ = storage_state;
		if (_tmp28_ != ((guint) ZEITGEIST_STORAGE_STATE_ANY)) {
			guint _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			GError* _tmp32_;
			GError* _tmp33_;
			_tmp29_ = storage_state;
			_tmp30_ = g_strdup_printf ("Unknown storage state '%u'", _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp31_);
			_inner_error_ = _tmp33_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp34_ = event_templates;
	_tmp35_ = zeitgeist_db_reader_get_where_clause_from_event_templates (self, _tmp34_, &_inner_error_);
	tpl_conditions = _tmp35_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = where;
	_tmp37_ = tpl_conditions;
	zeitgeist_where_clause_extend (_tmp36_, _tmp37_);
	result = where;
	_g_object_unref0 (tpl_conditions);
	return result;
}


static void _zeitgeist_db_reader_related_uri_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (zeitgeist_db_reader_related_uri_free (var), NULL));
}


static gpointer _zeitgeist_db_reader_related_uri_dup0 (gpointer self) {
	return self ? zeitgeist_db_reader_related_uri_dup (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gboolean _vala_uint32_array_contains (guint32* stack, int stack_length, guint32 needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint ___lambda6_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b) {
	gint result = 0;
	ZeitgeistDbReaderRelatedUri* _tmp0_;
	gint32 _tmp1_;
	ZeitgeistDbReaderRelatedUri* _tmp2_;
	gint32 _tmp3_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).counter;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).counter;
	result = (gint) (_tmp1_ - _tmp3_);
	return result;
}


static gint ____lambda6__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda6_ (a, b);
	return result;
}


static gint ___lambda7_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b) {
	gint result = 0;
	ZeitgeistDbReaderRelatedUri* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistDbReaderRelatedUri* _tmp2_;
	gint64 _tmp3_;
	gint64 delta;
	gint64 _tmp4_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).timestamp;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).timestamp;
	delta = _tmp1_ - _tmp3_;
	_tmp4_ = delta;
	if (_tmp4_ < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		gint64 _tmp5_;
		_tmp5_ = delta;
		if (_tmp5_ > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gint ____lambda7__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda7_ (a, b);
	return result;
}


static gint ____lambda8_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b) {
	gint result = 0;
	ZeitgeistDbReaderRelatedUri* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistDbReaderRelatedUri* _tmp2_;
	gint64 _tmp3_;
	gint64 delta;
	gint64 _tmp4_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).timestamp;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).timestamp;
	delta = _tmp1_ - _tmp3_;
	_tmp4_ = delta;
	if (_tmp4_ < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		gint64 _tmp5_;
		_tmp5_ = delta;
		if (_tmp5_ > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gint _____lambda8__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ____lambda8_ (a, b);
	return result;
}


static void _g_list_free__zeitgeist_db_reader_related_uri_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _zeitgeist_db_reader_related_uri_free0_, NULL);
	g_list_free (self);
}


gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error) {
	gchar** result = NULL;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (result_event_templates != NULL, NULL);
	_tmp1_ = result_type;
	if (_tmp1_ == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = result_type;
		_tmp0_ = _tmp2_ == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED);
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		ZeitgeistTimeRange* _tmp4_;
		GPtrArray* _tmp5_;
		guint _tmp6_;
		gint _tmp7_ = 0;
		guint32* _tmp8_ = NULL;
		guint32* ids;
		gint ids_length1;
		gint _ids_size_;
		gboolean _tmp9_ = FALSE;
		GPtrArray* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gboolean _tmp14_;
		guint32* result_ids = NULL;
		gint result_ids_length1 = 0;
		gint _result_ids_size_ = 0;
		ZeitgeistTimeRange* _tmp16_;
		GPtrArray* _tmp17_;
		guint _tmp18_;
		gint _tmp19_ = 0;
		guint32* _tmp20_ = NULL;
		guint32* _tmp21_;
		gint _tmp21__length1;
		gint __tmp21__size_;
		guint32* _tmp22_;
		gint _tmp22__length1;
		guint32* _tmp23_;
		gint _tmp23__length1;
		guint32* _tmp24_ = NULL;
		guint32* pot;
		gint pot_length1;
		gint _pot_size_;
		sqlite3_stmt* stmt = NULL;
		ZeitgeistSQLiteDatabase* _tmp49_;
		guint32* _tmp50_;
		gint _tmp50__length1;
		gchar* _tmp51_ = NULL;
		gchar* sql_event_ids;
		const gchar* _tmp52_;
		gchar* _tmp53_ = NULL;
		gchar* sql;
		sqlite3* _tmp54_;
		const gchar* _tmp55_;
		sqlite3_stmt* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gint rc;
		ZeitgeistSQLiteDatabase* _tmp58_;
		gint _tmp59_;
		GPtrArray* _tmp60_;
		GPtrArray* temp_related_uris;
		ZeitgeistSQLiteDatabase* _tmp77_;
		gint _tmp78_;
		GHashFunc _tmp79_;
		GEqualFunc _tmp80_;
		GHashTable* _tmp81_;
		GHashTable* uri_counter;
		GList* temp_ruris;
		GList* values;
		GHashTable* _tmp180_;
		GList* _tmp181_ = NULL;
		GList* _tmp184_;
		guint _tmp192_;
		GList* _tmp193_;
		guint _tmp194_ = 0U;
		gchar** _tmp195_ = NULL;
		gchar** results;
		gint results_length1;
		gint _results_size_;
		gint i;
		GList* _tmp196_;
		gchar** _tmp212_;
		gint _tmp212__length1;
		_tmp4_ = time_range;
		_tmp5_ = event_templates;
		_tmp6_ = storage_state;
		_tmp8_ = zeitgeist_db_reader_find_event_ids (self, _tmp4_, _tmp5_, _tmp6_, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp7_, &_inner_error_);
		ids = _tmp8_;
		ids_length1 = _tmp7_;
		_ids_size_ = ids_length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp10_ = event_templates;
		_tmp11_ = g_ptr_array_get_length (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			guint32* _tmp13_;
			gint _tmp13__length1;
			_tmp13_ = ids;
			_tmp13__length1 = ids_length1;
			_tmp9_ = _tmp13__length1 == 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp14_ = _tmp9_;
		if (_tmp14_) {
			GError* _tmp15_;
			_tmp15_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "No results found for the event_templates");
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp16_ = time_range;
		_tmp17_ = result_event_templates;
		_tmp18_ = storage_state;
		_tmp20_ = zeitgeist_db_reader_find_event_ids (self, _tmp16_, _tmp17_, _tmp18_, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp19_, &_inner_error_);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = _tmp19_;
		__tmp21__size_ = _tmp21__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result_ids = (g_free (result_ids), NULL);
		result_ids = _tmp21_;
		result_ids_length1 = _tmp21__length1;
		_result_ids_size_ = result_ids_length1;
		_tmp22_ = ids;
		_tmp22__length1 = ids_length1;
		_tmp23_ = result_ids;
		_tmp23__length1 = result_ids_length1;
		_tmp24_ = g_new0 (guint32, _tmp22__length1 + _tmp23__length1);
		pot = _tmp24_;
		pot_length1 = _tmp22__length1 + _tmp23__length1;
		_pot_size_ = pot_length1;
		{
			guint32 i;
			i = (guint32) 0;
			{
				gboolean _tmp25_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp26_;
					guint32 _tmp28_;
					guint32* _tmp29_;
					gint _tmp29__length1;
					guint32* _tmp30_;
					gint _tmp30__length1;
					guint32 _tmp31_;
					guint32* _tmp32_;
					gint _tmp32__length1;
					guint32 _tmp33_;
					guint32 _tmp34_;
					guint32 _tmp35_;
					_tmp26_ = _tmp25_;
					if (!_tmp26_) {
						guint32 _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp25_ = FALSE;
					_tmp28_ = i;
					_tmp29_ = ids;
					_tmp29__length1 = ids_length1;
					if (!(_tmp28_ < ((guint32) _tmp29__length1))) {
						break;
					}
					_tmp30_ = pot;
					_tmp30__length1 = pot_length1;
					_tmp31_ = i;
					_tmp32_ = ids;
					_tmp32__length1 = ids_length1;
					_tmp33_ = i;
					_tmp34_ = _tmp32_[_tmp33_];
					_tmp30_[_tmp31_] = _tmp34_;
					_tmp35_ = _tmp30_[_tmp31_];
				}
			}
		}
		{
			guint32 i;
			i = (guint32) 0;
			{
				gboolean _tmp36_;
				_tmp36_ = TRUE;
				while (TRUE) {
					gboolean _tmp37_;
					guint32 _tmp39_;
					guint32* _tmp40_;
					gint _tmp40__length1;
					guint32* _tmp41_;
					gint _tmp41__length1;
					guint32* _tmp42_;
					gint _tmp42__length1;
					guint32 _tmp43_;
					guint32* _tmp44_;
					gint _tmp44__length1;
					guint32* _tmp45_;
					gint _tmp45__length1;
					guint32 _tmp46_;
					guint32 _tmp47_;
					guint32 _tmp48_;
					_tmp37_ = _tmp36_;
					if (!_tmp37_) {
						guint32 _tmp38_;
						_tmp38_ = i;
						i = _tmp38_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp39_ = i;
					_tmp40_ = result_ids;
					_tmp40__length1 = result_ids_length1;
					if (!(_tmp39_ < ((guint32) _tmp40__length1))) {
						break;
					}
					_tmp41_ = pot;
					_tmp41__length1 = pot_length1;
					_tmp42_ = ids;
					_tmp42__length1 = ids_length1;
					_tmp43_ = i;
					_tmp44_ = result_ids;
					_tmp44__length1 = result_ids_length1;
					_tmp45_ = ids;
					_tmp45__length1 = ids_length1;
					_tmp46_ = i;
					_tmp47_ = _tmp44_[_tmp45__length1 + _tmp46_];
					_tmp41_[_tmp42__length1 + _tmp43_] = _tmp47_;
					_tmp48_ = _tmp41_[_tmp42__length1 + _tmp43_];
				}
			}
		}
		_tmp49_ = self->priv->_database;
		_tmp50_ = pot;
		_tmp50__length1 = pot_length1;
		_tmp51_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp49_, _tmp50_, _tmp50__length1);
		sql_event_ids = _tmp51_;
		_tmp52_ = sql_event_ids;
		_tmp53_ = g_strdup_printf ("\n" \
"               SELECT id, timestamp, subj_uri FROM event_view \n" \
"               WHERE id IN (%s) ORDER BY timestamp ASC\n" \
"               ", _tmp52_);
		sql = _tmp53_;
		_tmp54_ = self->db;
		_tmp55_ = sql;
		_tmp57_ = sqlite3_prepare_v2 (_tmp54_, _tmp55_, -1, &_tmp56_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp56_;
		rc = _tmp57_;
		_tmp58_ = self->priv->_database;
		_tmp59_ = rc;
		zeitgeist_sq_lite_database_assert_query_success (_tmp58_, _tmp59_, "db-reader.vala:443: SQL error", SQLITE_OK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp60_ = g_ptr_array_new_with_free_func (_zeitgeist_db_reader_related_uri_free0_);
		temp_related_uris = _tmp60_;
		while (TRUE) {
			sqlite3_stmt* _tmp61_;
			gint _tmp62_ = 0;
			gint _tmp63_;
			sqlite3_stmt* _tmp64_;
			const gchar* _tmp65_ = NULL;
			guint64 _tmp66_ = 0ULL;
			sqlite3_stmt* _tmp67_;
			gint64 _tmp68_ = 0LL;
			sqlite3_stmt* _tmp69_;
			const gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			ZeitgeistDbReaderRelatedUri _tmp72_ = {0};
			ZeitgeistDbReaderRelatedUri ruri;
			GPtrArray* _tmp73_;
			ZeitgeistDbReaderRelatedUri _tmp74_;
			ZeitgeistDbReaderRelatedUri _tmp75_;
			ZeitgeistDbReaderRelatedUri* _tmp76_;
			_tmp61_ = stmt;
			_tmp62_ = sqlite3_step (_tmp61_);
			rc = _tmp62_;
			_tmp63_ = rc;
			if (!(_tmp63_ == SQLITE_ROW)) {
				break;
			}
			_tmp64_ = stmt;
			_tmp65_ = sqlite3_column_text (_tmp64_, 0);
			_tmp66_ = uint64_parse (_tmp65_);
			_tmp67_ = stmt;
			_tmp68_ = sqlite3_column_int64 (_tmp67_, 1);
			_tmp69_ = stmt;
			_tmp70_ = sqlite3_column_text (_tmp69_, 2);
			_tmp71_ = g_strdup (_tmp70_);
			memset (&_tmp72_, 0, sizeof (ZeitgeistDbReaderRelatedUri));
			_tmp72_.id = (guint32) _tmp66_;
			_tmp72_.timestamp = _tmp68_;
			_g_free0 (_tmp72_.uri);
			_tmp72_.uri = _tmp71_;
			_tmp72_.counter = (gint32) 0;
			ruri = _tmp72_;
			_tmp73_ = temp_related_uris;
			_tmp74_ = ruri;
			_tmp75_ = _tmp74_;
			_tmp76_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp75_);
			g_ptr_array_add (_tmp73_, _tmp76_);
			zeitgeist_db_reader_related_uri_destroy (&ruri);
		}
		_tmp77_ = self->priv->_database;
		_tmp78_ = rc;
		zeitgeist_sq_lite_database_assert_query_success (_tmp77_, _tmp78_, "Error in find_related_uris", SQLITE_DONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp79_ = g_str_hash;
		_tmp80_ = g_str_equal;
		_tmp81_ = g_hash_table_new_full (_tmp79_, _tmp80_, _g_free0_, _zeitgeist_db_reader_related_uri_free0_);
		uri_counter = _tmp81_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp82_;
				_tmp82_ = TRUE;
				while (TRUE) {
					gboolean _tmp83_;
					gint _tmp85_;
					GPtrArray* _tmp86_;
					gint _tmp87_;
					gint _tmp88_;
					GPtrArray* _tmp89_;
					GPtrArray* window;
					gboolean count_in_window;
					gboolean _tmp110_;
					_tmp83_ = _tmp82_;
					if (!_tmp83_) {
						gint _tmp84_;
						_tmp84_ = i;
						i = _tmp84_ + 1;
					}
					_tmp82_ = FALSE;
					_tmp85_ = i;
					_tmp86_ = temp_related_uris;
					_tmp87_ = g_ptr_array_get_length (_tmp86_);
					_tmp88_ = _tmp87_;
					if (!(_tmp85_ < _tmp88_)) {
						break;
					}
					_tmp89_ = g_ptr_array_new_with_free_func (NULL);
					window = _tmp89_;
					count_in_window = FALSE;
					{
						gint _tmp90_;
						gint _tmp91_ = 0;
						gint j;
						_tmp90_ = i;
						_tmp91_ = MAX (0, _tmp90_ - 5);
						j = _tmp91_;
						{
							gboolean _tmp92_;
							_tmp92_ = TRUE;
							while (TRUE) {
								gboolean _tmp93_;
								gint _tmp95_;
								gint _tmp96_;
								GPtrArray* _tmp97_;
								gint _tmp98_;
								gint _tmp99_;
								gint _tmp100_ = 0;
								GPtrArray* _tmp101_;
								GPtrArray* _tmp102_;
								gint _tmp103_;
								gconstpointer _tmp104_ = NULL;
								GPtrArray* _tmp105_;
								gint _tmp106_;
								gconstpointer _tmp107_ = NULL;
								guint32 _tmp108_;
								guint32* _tmp109_;
								gint _tmp109__length1;
								_tmp93_ = _tmp92_;
								if (!_tmp93_) {
									gint _tmp94_;
									_tmp94_ = j;
									j = _tmp94_ + 1;
								}
								_tmp92_ = FALSE;
								_tmp95_ = j;
								_tmp96_ = i;
								_tmp97_ = temp_related_uris;
								_tmp98_ = g_ptr_array_get_length (_tmp97_);
								_tmp99_ = _tmp98_;
								_tmp100_ = MIN (_tmp96_, _tmp99_);
								if (!(_tmp95_ < _tmp100_)) {
									break;
								}
								_tmp101_ = window;
								_tmp102_ = temp_related_uris;
								_tmp103_ = j;
								_tmp104_ = g_ptr_array_index (_tmp102_, (guint) _tmp103_);
								g_ptr_array_add (_tmp101_, (ZeitgeistDbReaderRelatedUri*) _tmp104_);
								_tmp105_ = temp_related_uris;
								_tmp106_ = j;
								_tmp107_ = g_ptr_array_index (_tmp105_, (guint) _tmp106_);
								_tmp108_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp107_)).id;
								_tmp109_ = ids;
								_tmp109__length1 = ids_length1;
								if (_vala_uint32_array_contains (_tmp109_, _tmp109__length1, _tmp108_)) {
									count_in_window = TRUE;
									break;
								}
							}
						}
					}
					_tmp110_ = count_in_window;
					if (_tmp110_) {
						{
							gint j;
							j = 0;
							{
								gboolean _tmp111_;
								_tmp111_ = TRUE;
								while (TRUE) {
									gboolean _tmp112_;
									gint _tmp114_;
									GPtrArray* _tmp115_;
									gint _tmp116_;
									gint _tmp117_;
									GPtrArray* _tmp118_;
									gint _tmp119_;
									gconstpointer _tmp120_ = NULL;
									guint32 _tmp121_;
									guint32* _tmp122_;
									gint _tmp122__length1;
									_tmp112_ = _tmp111_;
									if (!_tmp112_) {
										gint _tmp113_;
										_tmp113_ = j;
										j = _tmp113_ + 1;
									}
									_tmp111_ = FALSE;
									_tmp114_ = j;
									_tmp115_ = window;
									_tmp116_ = g_ptr_array_get_length (_tmp115_);
									_tmp117_ = _tmp116_;
									if (!(_tmp114_ < _tmp117_)) {
										break;
									}
									_tmp118_ = window;
									_tmp119_ = j;
									_tmp120_ = g_ptr_array_index (_tmp118_, (guint) _tmp119_);
									_tmp121_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp120_)).id;
									_tmp122_ = result_ids;
									_tmp122__length1 = result_ids_length1;
									if (_vala_uint32_array_contains (_tmp122_, _tmp122__length1, _tmp121_)) {
										GHashTable* _tmp123_;
										GPtrArray* _tmp124_;
										gint _tmp125_;
										gconstpointer _tmp126_ = NULL;
										const gchar* _tmp127_;
										gconstpointer _tmp128_ = NULL;
										GHashTable* _tmp152_;
										GPtrArray* _tmp153_;
										gint _tmp154_;
										gconstpointer _tmp155_ = NULL;
										const gchar* _tmp156_;
										gconstpointer _tmp157_ = NULL;
										gint32 _tmp158_;
										GHashTable* _tmp159_;
										GPtrArray* _tmp160_;
										gint _tmp161_;
										gconstpointer _tmp162_ = NULL;
										const gchar* _tmp163_;
										gconstpointer _tmp164_ = NULL;
										gint64 _tmp165_;
										GPtrArray* _tmp166_;
										gint _tmp167_;
										gconstpointer _tmp168_ = NULL;
										gint64 _tmp169_;
										_tmp123_ = uri_counter;
										_tmp124_ = window;
										_tmp125_ = j;
										_tmp126_ = g_ptr_array_index (_tmp124_, (guint) _tmp125_);
										_tmp127_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp126_)).uri;
										_tmp128_ = g_hash_table_lookup (_tmp123_, _tmp127_);
										if (((ZeitgeistDbReaderRelatedUri*) _tmp128_) == NULL) {
											GPtrArray* _tmp129_;
											gint _tmp130_;
											gconstpointer _tmp131_ = NULL;
											guint32 _tmp132_;
											GPtrArray* _tmp133_;
											gint _tmp134_;
											gconstpointer _tmp135_ = NULL;
											gint64 _tmp136_;
											GPtrArray* _tmp137_;
											gint _tmp138_;
											gconstpointer _tmp139_ = NULL;
											const gchar* _tmp140_;
											gchar* _tmp141_;
											ZeitgeistDbReaderRelatedUri _tmp142_ = {0};
											ZeitgeistDbReaderRelatedUri ruri;
											GHashTable* _tmp143_;
											GPtrArray* _tmp144_;
											gint _tmp145_;
											gconstpointer _tmp146_ = NULL;
											const gchar* _tmp147_;
											gchar* _tmp148_;
											ZeitgeistDbReaderRelatedUri _tmp149_;
											ZeitgeistDbReaderRelatedUri _tmp150_;
											ZeitgeistDbReaderRelatedUri* _tmp151_;
											_tmp129_ = window;
											_tmp130_ = j;
											_tmp131_ = g_ptr_array_index (_tmp129_, (guint) _tmp130_);
											_tmp132_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp131_)).id;
											_tmp133_ = window;
											_tmp134_ = j;
											_tmp135_ = g_ptr_array_index (_tmp133_, (guint) _tmp134_);
											_tmp136_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp135_)).timestamp;
											_tmp137_ = window;
											_tmp138_ = j;
											_tmp139_ = g_ptr_array_index (_tmp137_, (guint) _tmp138_);
											_tmp140_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp139_)).uri;
											_tmp141_ = g_strdup (_tmp140_);
											memset (&_tmp142_, 0, sizeof (ZeitgeistDbReaderRelatedUri));
											_tmp142_.id = _tmp132_;
											_tmp142_.timestamp = _tmp136_;
											_g_free0 (_tmp142_.uri);
											_tmp142_.uri = _tmp141_;
											_tmp142_.counter = (gint32) 0;
											ruri = _tmp142_;
											_tmp143_ = uri_counter;
											_tmp144_ = window;
											_tmp145_ = j;
											_tmp146_ = g_ptr_array_index (_tmp144_, (guint) _tmp145_);
											_tmp147_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp146_)).uri;
											_tmp148_ = g_strdup (_tmp147_);
											_tmp149_ = ruri;
											_tmp150_ = _tmp149_;
											_tmp151_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp150_);
											g_hash_table_insert (_tmp143_, _tmp148_, _tmp151_);
											zeitgeist_db_reader_related_uri_destroy (&ruri);
										}
										_tmp152_ = uri_counter;
										_tmp153_ = window;
										_tmp154_ = j;
										_tmp155_ = g_ptr_array_index (_tmp153_, (guint) _tmp154_);
										_tmp156_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp155_)).uri;
										_tmp157_ = g_hash_table_lookup (_tmp152_, _tmp156_);
										_tmp158_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp157_)).counter;
										(*((ZeitgeistDbReaderRelatedUri*) _tmp157_)).counter = _tmp158_ + 1;
										_tmp159_ = uri_counter;
										_tmp160_ = window;
										_tmp161_ = j;
										_tmp162_ = g_ptr_array_index (_tmp160_, (guint) _tmp161_);
										_tmp163_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp162_)).uri;
										_tmp164_ = g_hash_table_lookup (_tmp159_, _tmp163_);
										_tmp165_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp164_)).timestamp;
										_tmp166_ = window;
										_tmp167_ = j;
										_tmp168_ = g_ptr_array_index (_tmp166_, (guint) _tmp167_);
										_tmp169_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp168_)).timestamp;
										if (_tmp165_ < _tmp169_) {
											GHashTable* _tmp170_;
											GPtrArray* _tmp171_;
											gint _tmp172_;
											gconstpointer _tmp173_ = NULL;
											const gchar* _tmp174_;
											gconstpointer _tmp175_ = NULL;
											GPtrArray* _tmp176_;
											gint _tmp177_;
											gconstpointer _tmp178_ = NULL;
											gint64 _tmp179_;
											_tmp170_ = uri_counter;
											_tmp171_ = window;
											_tmp172_ = j;
											_tmp173_ = g_ptr_array_index (_tmp171_, (guint) _tmp172_);
											_tmp174_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp173_)).uri;
											_tmp175_ = g_hash_table_lookup (_tmp170_, _tmp174_);
											_tmp176_ = window;
											_tmp177_ = j;
											_tmp178_ = g_ptr_array_index (_tmp176_, (guint) _tmp177_);
											_tmp179_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp178_)).timestamp;
											(*((ZeitgeistDbReaderRelatedUri*) _tmp175_)).timestamp = _tmp179_;
										}
									}
								}
							}
						}
					}
					_g_ptr_array_unref0 (window);
				}
			}
		}
		temp_ruris = NULL;
		values = NULL;
		_tmp180_ = uri_counter;
		_tmp181_ = g_hash_table_get_values (_tmp180_);
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp181_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistDbReaderRelatedUri* uri = NULL;
				uri = (ZeitgeistDbReaderRelatedUri*) uri_it->data;
				{
					ZeitgeistDbReaderRelatedUri* _tmp182_;
					ZeitgeistDbReaderRelatedUri* _tmp183_;
					_tmp182_ = uri;
					_tmp183_ = _zeitgeist_db_reader_related_uri_dup0 (_tmp182_);
					values = g_list_append (values, _tmp183_);
				}
			}
			_g_list_free0 (uri_collection);
		}
		values = g_list_sort (values, ____lambda6__gcompare_func);
		values = g_list_sort (values, ____lambda7__gcompare_func);
		_tmp184_ = values;
		{
			GList* ruri_collection = NULL;
			GList* ruri_it = NULL;
			ruri_collection = _tmp184_;
			for (ruri_it = ruri_collection; ruri_it != NULL; ruri_it = ruri_it->next) {
				ZeitgeistDbReaderRelatedUri _tmp185_ = {0};
				ZeitgeistDbReaderRelatedUri ruri = {0};
				zeitgeist_db_reader_related_uri_copy ((ZeitgeistDbReaderRelatedUri*) ruri_it->data, &_tmp185_);
				ruri = _tmp185_;
				{
					GList* _tmp186_;
					guint _tmp187_ = 0U;
					guint _tmp188_;
					_tmp186_ = temp_ruris;
					_tmp187_ = g_list_length (_tmp186_);
					_tmp188_ = max_results;
					if (_tmp187_ < _tmp188_) {
						ZeitgeistDbReaderRelatedUri _tmp189_;
						ZeitgeistDbReaderRelatedUri _tmp190_;
						ZeitgeistDbReaderRelatedUri* _tmp191_;
						_tmp189_ = ruri;
						_tmp190_ = _tmp189_;
						_tmp191_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp190_);
						temp_ruris = g_list_append (temp_ruris, _tmp191_);
					} else {
						zeitgeist_db_reader_related_uri_destroy (&ruri);
						break;
					}
					zeitgeist_db_reader_related_uri_destroy (&ruri);
				}
			}
		}
		_tmp192_ = result_type;
		if (_tmp192_ == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT)) {
			temp_ruris = g_list_sort (temp_ruris, _____lambda8__gcompare_func);
		}
		_tmp193_ = temp_ruris;
		_tmp194_ = g_list_length (_tmp193_);
		_tmp195_ = g_new0 (gchar*, _tmp194_ + 1);
		results = _tmp195_;
		results_length1 = _tmp194_;
		_results_size_ = results_length1;
		i = 0;
		_tmp196_ = temp_ruris;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp196_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistDbReaderRelatedUri* _tmp197_;
				ZeitgeistDbReaderRelatedUri* uri = NULL;
				_tmp197_ = _zeitgeist_db_reader_related_uri_dup0 ((ZeitgeistDbReaderRelatedUri*) uri_it->data);
				uri = _tmp197_;
				{
					gchar** _tmp198_;
					gint _tmp198__length1;
					gint _tmp199_;
					ZeitgeistDbReaderRelatedUri* _tmp200_;
					const gchar* _tmp201_;
					gchar* _tmp202_;
					gchar* _tmp203_;
					FILE* _tmp204_;
					ZeitgeistDbReaderRelatedUri* _tmp205_;
					gint32 _tmp206_;
					ZeitgeistDbReaderRelatedUri* _tmp207_;
					gint64 _tmp208_;
					ZeitgeistDbReaderRelatedUri* _tmp209_;
					const gchar* _tmp210_;
					gint _tmp211_;
					_tmp198_ = results;
					_tmp198__length1 = results_length1;
					_tmp199_ = i;
					_tmp200_ = uri;
					_tmp201_ = (*_tmp200_).uri;
					_tmp202_ = g_strdup (_tmp201_);
					_g_free0 (_tmp198_[_tmp199_]);
					_tmp198_[_tmp199_] = _tmp202_;
					_tmp203_ = _tmp198_[_tmp199_];
					_tmp204_ = stdout;
					_tmp205_ = uri;
					_tmp206_ = (*_tmp205_).counter;
					_tmp207_ = uri;
					_tmp208_ = (*_tmp207_).timestamp;
					_tmp209_ = uri;
					_tmp210_ = (*_tmp209_).uri;
					fprintf (_tmp204_, "%i %lld %s\n", (gint) _tmp206_, _tmp208_, _tmp210_);
					_tmp211_ = i;
					i = _tmp211_ + 1;
					_zeitgeist_db_reader_related_uri_free0 (uri);
				}
			}
		}
		_tmp212_ = results;
		_tmp212__length1 = results_length1;
		if (result_length1) {
			*result_length1 = _tmp212__length1;
		}
		result = _tmp212_;
		__g_list_free__zeitgeist_db_reader_related_uri_free0_0 (values);
		__g_list_free__zeitgeist_db_reader_related_uri_free0_0 (temp_ruris);
		_g_hash_table_unref0 (uri_counter);
		_g_ptr_array_unref0 (temp_related_uris);
		_g_free0 (sql);
		_g_free0 (sql_event_ids);
		_sqlite3_finalize0 (stmt);
		pot = (g_free (pot), NULL);
		result_ids = (g_free (result_ids), NULL);
		ids = (g_free (ids), NULL);
		return result;
	} else {
		GError* _tmp213_;
		_tmp213_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Unsupported RelevantResultType");
		_inner_error_ = _tmp213_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


/**
     * Clear all resources Engine is using (close database connection, etc.).
     *
     * After executing this method on an instance, no other function
     * may be called.
     */
static void zeitgeist_db_reader_real_close (ZeitgeistDbReader* self) {
	ZeitgeistSQLiteDatabase* _tmp0_;
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_database_close (_tmp0_);
}


void zeitgeist_db_reader_close (ZeitgeistDbReader* self) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_DB_READER_GET_CLASS (self)->close (self);
}


static gchar* zeitgeist_db_reader_group_and_sort (ZeitgeistDbReader* self, const gchar* field, const gchar* where_sql, gboolean* count_asc, const gchar* aggregation_type) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* aggregation_sql;
	gchar* _tmp1_;
	gchar* order_sql;
	gboolean* _tmp2_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field != NULL, NULL);
	g_return_val_if_fail (where_sql != NULL, NULL);
	g_return_val_if_fail (aggregation_type != NULL, NULL);
	_tmp0_ = g_strdup ("");
	aggregation_sql = _tmp0_;
	_tmp1_ = g_strdup ("");
	order_sql = _tmp1_;
	_tmp2_ = count_asc;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp3_ = field;
		_tmp4_ = g_strdup_printf (", COUNT(%s) AS num_events", _tmp3_);
		_g_free0 (aggregation_sql);
		aggregation_sql = _tmp4_;
		_tmp6_ = count_asc;
		if (*_tmp6_) {
			_tmp5_ = "ASC";
		} else {
			_tmp5_ = "DESC";
		}
		_tmp7_ = _tmp5_;
		_tmp8_ = g_strdup_printf ("num_events %s,", _tmp7_);
		_g_free0 (order_sql);
		order_sql = _tmp8_;
	}
	_tmp9_ = field;
	_tmp10_ = aggregation_type;
	_tmp11_ = aggregation_sql;
	_tmp12_ = where_sql;
	_tmp13_ = field;
	_tmp14_ = field;
	_tmp15_ = order_sql;
	_tmp16_ = g_strdup_printf ("\n" \
"            NATURAL JOIN (\n" \
"                SELECT %s,\n" \
"                %s(timestamp) AS timestamp\n" \
"                %s\n" \
"                FROM event_view %s\n" \
"                GROUP BY %s)\n" \
"            GROUP BY %s\n" \
"            ORDER BY %s \n" \
"            ", _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
	result = _tmp16_;
	_g_free0 (order_sql);
	_g_free0 (aggregation_sql);
	return result;
}


ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self, GPtrArray* templates, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* where;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
	where = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				ZeitgeistEvent* _tmp11_;
				ZeitgeistEvent* event_template;
				ZeitgeistEvent* _tmp12_;
				ZeitgeistWhereClause* _tmp13_ = NULL;
				ZeitgeistWhereClause* _tmp14_;
				ZeitgeistWhereClause* _tmp15_;
				ZeitgeistWhereClause* _tmp16_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = templates;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = templates;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp10_);
				event_template = _tmp11_;
				_tmp12_ = event_template;
				_tmp13_ = zeitgeist_db_reader_get_where_clause_from_event_template (self, _tmp12_, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						return NULL;
					} else {
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp15_ = where;
				_tmp16_ = _tmp14_;
				zeitgeist_where_clause_extend (_tmp15_, _tmp16_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (event_template);
			}
		}
	}
	result = where;
	return result;
}


static ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_template (ZeitgeistDbReader* self, ZeitgeistEvent* template, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* where;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	ZeitgeistEvent* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	ZeitgeistEvent* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	ZeitgeistEvent* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gboolean _tmp45_ = FALSE;
	ZeitgeistEvent* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gboolean _tmp64_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (template != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = template;
	_tmp2_ = zeitgeist_event_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((guint32) 0)) {
		ZeitgeistWhereClause* _tmp4_;
		ZeitgeistEvent* _tmp5_;
		guint32 _tmp6_;
		guint32 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = where;
		_tmp5_ = template;
		_tmp6_ = zeitgeist_event_get_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", _tmp7_);
		_tmp9_ = _tmp8_;
		zeitgeist_where_clause_add (_tmp4_, "id=?", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = template;
	_tmp11_ = zeitgeist_event_get_interpretation (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = zeitgeist_utils_is_empty_string (_tmp12_);
	if (!_tmp13_) {
		ZeitgeistEvent* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		ZeitgeistEvent* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		ZeitgeistSQLiteTableLookup* _tmp20_;
		ZeitgeistWhereClause* _tmp21_ = NULL;
		ZeitgeistWhereClause* subwhere;
		ZeitgeistWhereClause* _tmp22_;
		gboolean _tmp23_ = FALSE;
		_tmp14_ = template;
		_tmp15_ = zeitgeist_event_get_interpretation (_tmp14_);
		_tmp16_ = _tmp15_;
		zeitgeist_db_reader_assert_no_wildcard (self, "interpretation", _tmp16_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp17_ = template;
		_tmp18_ = zeitgeist_event_get_interpretation (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->interpretations_table;
		_tmp21_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "interpretation", _tmp19_, _tmp20_, &_inner_error_);
		subwhere = _tmp21_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp22_ = subwhere;
		_tmp23_ = zeitgeist_where_clause_is_empty (_tmp22_);
		if (!_tmp23_) {
			ZeitgeistWhereClause* _tmp24_;
			ZeitgeistWhereClause* _tmp25_;
			_tmp24_ = where;
			_tmp25_ = subwhere;
			zeitgeist_where_clause_extend (_tmp24_, _tmp25_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp26_ = template;
	_tmp27_ = zeitgeist_event_get_manifestation (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = zeitgeist_utils_is_empty_string (_tmp28_);
	if (!_tmp29_) {
		ZeitgeistEvent* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		ZeitgeistEvent* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ZeitgeistSQLiteTableLookup* _tmp36_;
		ZeitgeistWhereClause* _tmp37_ = NULL;
		ZeitgeistWhereClause* subwhere;
		ZeitgeistWhereClause* _tmp38_;
		gboolean _tmp39_ = FALSE;
		_tmp30_ = template;
		_tmp31_ = zeitgeist_event_get_interpretation (_tmp30_);
		_tmp32_ = _tmp31_;
		zeitgeist_db_reader_assert_no_wildcard (self, "manifestation", _tmp32_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp33_ = template;
		_tmp34_ = zeitgeist_event_get_manifestation (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->manifestations_table;
		_tmp37_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "manifestation", _tmp35_, _tmp36_, &_inner_error_);
		subwhere = _tmp37_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp38_ = subwhere;
		_tmp39_ = zeitgeist_where_clause_is_empty (_tmp38_);
		if (!_tmp39_) {
			ZeitgeistWhereClause* _tmp40_;
			ZeitgeistWhereClause* _tmp41_;
			_tmp40_ = where;
			_tmp41_ = subwhere;
			zeitgeist_where_clause_extend (_tmp40_, _tmp41_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp42_ = template;
	_tmp43_ = zeitgeist_event_get_actor (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = zeitgeist_utils_is_empty_string (_tmp44_);
	if (!_tmp45_) {
		ZeitgeistEvent* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* val;
		gboolean _tmp50_ = FALSE;
		gboolean like;
		gboolean _tmp51_ = FALSE;
		gboolean negated;
		gboolean _tmp52_;
		_tmp46_ = template;
		_tmp47_ = zeitgeist_event_get_actor (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup (_tmp48_);
		val = _tmp49_;
		_tmp50_ = zeitgeist_utils_parse_wildcard (&val);
		like = _tmp50_;
		_tmp51_ = zeitgeist_utils_parse_negation (&val);
		negated = _tmp51_;
		_tmp52_ = like;
		if (_tmp52_) {
			ZeitgeistWhereClause* _tmp53_;
			const gchar* _tmp54_;
			gboolean _tmp55_;
			_tmp53_ = where;
			_tmp54_ = val;
			_tmp55_ = negated;
			zeitgeist_where_clause_add_wildcard_condition (_tmp53_, "actor", _tmp54_, _tmp55_);
		} else {
			ZeitgeistWhereClause* _tmp56_;
			ZeitgeistSQLiteTableLookup* _tmp57_;
			const gchar* _tmp58_;
			gint _tmp59_ = 0;
			gboolean _tmp60_;
			_tmp56_ = where;
			_tmp57_ = self->actors_table;
			_tmp58_ = val;
			_tmp59_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp57_, _tmp58_);
			_tmp60_ = negated;
			zeitgeist_where_clause_add_match_condition (_tmp56_, "actor", _tmp59_, _tmp60_);
		}
		_g_free0 (val);
	}
	_tmp61_ = template;
	_tmp62_ = zeitgeist_event_get_origin (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = zeitgeist_utils_is_empty_string (_tmp63_);
	if (!_tmp64_) {
		ZeitgeistEvent* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* val;
		gboolean _tmp69_ = FALSE;
		gboolean like;
		gboolean _tmp70_ = FALSE;
		gboolean negated;
		const gchar* _tmp71_;
		gboolean _tmp72_;
		_tmp65_ = template;
		_tmp66_ = zeitgeist_event_get_origin (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strdup (_tmp67_);
		val = _tmp68_;
		_tmp69_ = zeitgeist_utils_parse_wildcard (&val);
		like = _tmp69_;
		_tmp70_ = zeitgeist_utils_parse_negation (&val);
		negated = _tmp70_;
		_tmp71_ = val;
		zeitgeist_db_reader_assert_no_noexpand (self, _tmp71_, "origin", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_free0 (val);
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp72_ = like;
		if (_tmp72_) {
			ZeitgeistWhereClause* _tmp73_;
			const gchar* _tmp74_;
			gboolean _tmp75_;
			_tmp73_ = where;
			_tmp74_ = val;
			_tmp75_ = negated;
			zeitgeist_where_clause_add_wildcard_condition (_tmp73_, "origin", _tmp74_, _tmp75_);
		} else {
			ZeitgeistWhereClause* _tmp76_;
			const gchar* _tmp77_;
			gboolean _tmp78_;
			_tmp76_ = where;
			_tmp77_ = val;
			_tmp78_ = negated;
			zeitgeist_where_clause_add_text_condition_subquery (_tmp76_, "origin", _tmp77_, _tmp78_);
		}
		_g_free0 (val);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp79_;
			_tmp79_ = TRUE;
			while (TRUE) {
				gboolean _tmp80_;
				gint _tmp82_;
				ZeitgeistEvent* _tmp83_;
				gint _tmp84_ = 0;
				ZeitgeistEvent* _tmp85_;
				GPtrArray* _tmp86_;
				GPtrArray* _tmp87_;
				gint _tmp88_;
				gconstpointer _tmp89_ = NULL;
				ZeitgeistSubject* _tmp90_;
				ZeitgeistSubject* subject_template;
				ZeitgeistSubject* _tmp91_;
				const gchar* _tmp92_;
				const gchar* _tmp93_;
				gboolean _tmp94_ = FALSE;
				ZeitgeistSubject* _tmp107_;
				const gchar* _tmp108_;
				const gchar* _tmp109_;
				gboolean _tmp110_ = FALSE;
				ZeitgeistSubject* _tmp123_;
				const gchar* _tmp124_;
				const gchar* _tmp125_;
				gboolean _tmp126_ = FALSE;
				ZeitgeistSubject* _tmp143_;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				gboolean _tmp146_ = FALSE;
				ZeitgeistSubject* _tmp161_;
				const gchar* _tmp162_;
				const gchar* _tmp163_;
				gboolean _tmp164_ = FALSE;
				ZeitgeistSubject* _tmp179_;
				const gchar* _tmp180_;
				const gchar* _tmp181_;
				gboolean _tmp182_ = FALSE;
				ZeitgeistSubject* _tmp187_;
				const gchar* _tmp188_;
				const gchar* _tmp189_;
				gboolean _tmp190_ = FALSE;
				ZeitgeistSubject* _tmp205_;
				const gchar* _tmp206_;
				const gchar* _tmp207_;
				gboolean _tmp208_ = FALSE;
				_tmp80_ = _tmp79_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = i;
					i = _tmp81_ + 1;
				}
				_tmp79_ = FALSE;
				_tmp82_ = i;
				_tmp83_ = template;
				_tmp84_ = zeitgeist_event_num_subjects (_tmp83_);
				if (!(_tmp82_ < _tmp84_)) {
					break;
				}
				_tmp85_ = template;
				_tmp86_ = zeitgeist_event_get_subjects (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = i;
				_tmp89_ = g_ptr_array_index (_tmp87_, (guint) _tmp88_);
				_tmp90_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp89_);
				subject_template = _tmp90_;
				_tmp91_ = subject_template;
				_tmp92_ = zeitgeist_subject_get_interpretation (_tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = zeitgeist_utils_is_empty_string (_tmp93_);
				if (!_tmp94_) {
					ZeitgeistEvent* _tmp95_;
					const gchar* _tmp96_;
					const gchar* _tmp97_;
					ZeitgeistSubject* _tmp98_;
					const gchar* _tmp99_;
					const gchar* _tmp100_;
					ZeitgeistSQLiteTableLookup* _tmp101_;
					ZeitgeistWhereClause* _tmp102_ = NULL;
					ZeitgeistWhereClause* subwhere;
					ZeitgeistWhereClause* _tmp103_;
					gboolean _tmp104_ = FALSE;
					_tmp95_ = template;
					_tmp96_ = zeitgeist_event_get_interpretation (_tmp95_);
					_tmp97_ = _tmp96_;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject interpretation", _tmp97_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp98_ = subject_template;
					_tmp99_ = zeitgeist_subject_get_interpretation (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = self->interpretations_table;
					_tmp102_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "subj_interpretation", _tmp100_, _tmp101_, &_inner_error_);
					subwhere = _tmp102_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp103_ = subwhere;
					_tmp104_ = zeitgeist_where_clause_is_empty (_tmp103_);
					if (!_tmp104_) {
						ZeitgeistWhereClause* _tmp105_;
						ZeitgeistWhereClause* _tmp106_;
						_tmp105_ = where;
						_tmp106_ = subwhere;
						zeitgeist_where_clause_extend (_tmp105_, _tmp106_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp107_ = subject_template;
				_tmp108_ = zeitgeist_subject_get_manifestation (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = zeitgeist_utils_is_empty_string (_tmp109_);
				if (!_tmp110_) {
					ZeitgeistSubject* _tmp111_;
					const gchar* _tmp112_;
					const gchar* _tmp113_;
					ZeitgeistSubject* _tmp114_;
					const gchar* _tmp115_;
					const gchar* _tmp116_;
					ZeitgeistSQLiteTableLookup* _tmp117_;
					ZeitgeistWhereClause* _tmp118_ = NULL;
					ZeitgeistWhereClause* subwhere;
					ZeitgeistWhereClause* _tmp119_;
					gboolean _tmp120_ = FALSE;
					_tmp111_ = subject_template;
					_tmp112_ = zeitgeist_subject_get_manifestation (_tmp111_);
					_tmp113_ = _tmp112_;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject manifestation", _tmp113_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp114_ = subject_template;
					_tmp115_ = zeitgeist_subject_get_manifestation (_tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = self->manifestations_table;
					_tmp118_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "subj_manifestation", _tmp116_, _tmp117_, &_inner_error_);
					subwhere = _tmp118_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp119_ = subwhere;
					_tmp120_ = zeitgeist_where_clause_is_empty (_tmp119_);
					if (!_tmp120_) {
						ZeitgeistWhereClause* _tmp121_;
						ZeitgeistWhereClause* _tmp122_;
						_tmp121_ = where;
						_tmp122_ = subwhere;
						zeitgeist_where_clause_extend (_tmp121_, _tmp122_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp123_ = subject_template;
				_tmp124_ = zeitgeist_subject_get_mimetype (_tmp123_);
				_tmp125_ = _tmp124_;
				_tmp126_ = zeitgeist_utils_is_empty_string (_tmp125_);
				if (!_tmp126_) {
					ZeitgeistSubject* _tmp127_;
					const gchar* _tmp128_;
					const gchar* _tmp129_;
					gchar* _tmp130_;
					gchar* val;
					gboolean _tmp131_ = FALSE;
					gboolean like;
					gboolean _tmp132_ = FALSE;
					gboolean negated;
					const gchar* _tmp133_;
					gboolean _tmp134_;
					_tmp127_ = subject_template;
					_tmp128_ = zeitgeist_subject_get_mimetype (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = g_strdup (_tmp129_);
					val = _tmp130_;
					_tmp131_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp131_;
					_tmp132_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp132_;
					_tmp133_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp133_, "mime-type", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp134_ = like;
					if (_tmp134_) {
						ZeitgeistWhereClause* _tmp135_;
						const gchar* _tmp136_;
						gboolean _tmp137_;
						_tmp135_ = where;
						_tmp136_ = val;
						_tmp137_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp135_, "subj_mimetype", _tmp136_, _tmp137_);
					} else {
						ZeitgeistWhereClause* _tmp138_;
						ZeitgeistSQLiteTableLookup* _tmp139_;
						const gchar* _tmp140_;
						gint _tmp141_ = 0;
						gboolean _tmp142_;
						_tmp138_ = where;
						_tmp139_ = self->mimetypes_table;
						_tmp140_ = val;
						_tmp141_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp139_, _tmp140_);
						_tmp142_ = negated;
						zeitgeist_where_clause_add_match_condition (_tmp138_, "subj_mimetype", _tmp141_, _tmp142_);
					}
					_g_free0 (val);
				}
				_tmp143_ = subject_template;
				_tmp144_ = zeitgeist_subject_get_uri (_tmp143_);
				_tmp145_ = _tmp144_;
				_tmp146_ = zeitgeist_utils_is_empty_string (_tmp145_);
				if (!_tmp146_) {
					ZeitgeistSubject* _tmp147_;
					const gchar* _tmp148_;
					const gchar* _tmp149_;
					gchar* _tmp150_;
					gchar* val;
					gboolean _tmp151_ = FALSE;
					gboolean like;
					gboolean _tmp152_ = FALSE;
					gboolean negated;
					const gchar* _tmp153_;
					gboolean _tmp154_;
					_tmp147_ = subject_template;
					_tmp148_ = zeitgeist_subject_get_uri (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = g_strdup (_tmp149_);
					val = _tmp150_;
					_tmp151_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp151_;
					_tmp152_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp152_;
					_tmp153_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp153_, "uri", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp154_ = like;
					if (_tmp154_) {
						ZeitgeistWhereClause* _tmp155_;
						const gchar* _tmp156_;
						gboolean _tmp157_;
						_tmp155_ = where;
						_tmp156_ = val;
						_tmp157_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp155_, "subj_id", _tmp156_, _tmp157_);
					} else {
						ZeitgeistWhereClause* _tmp158_;
						const gchar* _tmp159_;
						gboolean _tmp160_;
						_tmp158_ = where;
						_tmp159_ = val;
						_tmp160_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp158_, "subj_id", _tmp159_, _tmp160_);
					}
					_g_free0 (val);
				}
				_tmp161_ = subject_template;
				_tmp162_ = zeitgeist_subject_get_origin (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = zeitgeist_utils_is_empty_string (_tmp163_);
				if (!_tmp164_) {
					ZeitgeistSubject* _tmp165_;
					const gchar* _tmp166_;
					const gchar* _tmp167_;
					gchar* _tmp168_;
					gchar* val;
					gboolean _tmp169_ = FALSE;
					gboolean like;
					gboolean _tmp170_ = FALSE;
					gboolean negated;
					const gchar* _tmp171_;
					gboolean _tmp172_;
					_tmp165_ = subject_template;
					_tmp166_ = zeitgeist_subject_get_origin (_tmp165_);
					_tmp167_ = _tmp166_;
					_tmp168_ = g_strdup (_tmp167_);
					val = _tmp168_;
					_tmp169_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp169_;
					_tmp170_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp170_;
					_tmp171_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp171_, "subject origin", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp172_ = like;
					if (_tmp172_) {
						ZeitgeistWhereClause* _tmp173_;
						const gchar* _tmp174_;
						gboolean _tmp175_;
						_tmp173_ = where;
						_tmp174_ = val;
						_tmp175_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp173_, "subj_origin", _tmp174_, _tmp175_);
					} else {
						ZeitgeistWhereClause* _tmp176_;
						const gchar* _tmp177_;
						gboolean _tmp178_;
						_tmp176_ = where;
						_tmp177_ = val;
						_tmp178_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp176_, "subj_origin", _tmp177_, _tmp178_);
					}
					_g_free0 (val);
				}
				_tmp179_ = subject_template;
				_tmp180_ = zeitgeist_subject_get_text (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = zeitgeist_utils_is_empty_string (_tmp181_);
				if (!_tmp182_) {
					ZeitgeistWhereClause* _tmp183_;
					ZeitgeistSubject* _tmp184_;
					const gchar* _tmp185_;
					const gchar* _tmp186_;
					_tmp183_ = where;
					_tmp184_ = subject_template;
					_tmp185_ = zeitgeist_subject_get_text (_tmp184_);
					_tmp186_ = _tmp185_;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp183_, "subj_text_id", _tmp186_, FALSE);
				}
				_tmp187_ = subject_template;
				_tmp188_ = zeitgeist_subject_get_current_uri (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = zeitgeist_utils_is_empty_string (_tmp189_);
				if (!_tmp190_) {
					ZeitgeistSubject* _tmp191_;
					const gchar* _tmp192_;
					const gchar* _tmp193_;
					gchar* _tmp194_;
					gchar* val;
					gboolean _tmp195_ = FALSE;
					gboolean like;
					gboolean _tmp196_ = FALSE;
					gboolean negated;
					const gchar* _tmp197_;
					gboolean _tmp198_;
					_tmp191_ = subject_template;
					_tmp192_ = zeitgeist_subject_get_current_uri (_tmp191_);
					_tmp193_ = _tmp192_;
					_tmp194_ = g_strdup (_tmp193_);
					val = _tmp194_;
					_tmp195_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp195_;
					_tmp196_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp196_;
					_tmp197_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp197_, "current_uri", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp198_ = like;
					if (_tmp198_) {
						ZeitgeistWhereClause* _tmp199_;
						const gchar* _tmp200_;
						gboolean _tmp201_;
						_tmp199_ = where;
						_tmp200_ = val;
						_tmp201_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp199_, "subj_id_current", _tmp200_, _tmp201_);
					} else {
						ZeitgeistWhereClause* _tmp202_;
						const gchar* _tmp203_;
						gboolean _tmp204_;
						_tmp202_ = where;
						_tmp203_ = val;
						_tmp204_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp202_, "subj_id_current", _tmp203_, _tmp204_);
					}
					_g_free0 (val);
				}
				_tmp205_ = subject_template;
				_tmp206_ = zeitgeist_subject_get_storage (_tmp205_);
				_tmp207_ = _tmp206_;
				_tmp208_ = zeitgeist_utils_is_empty_string (_tmp207_);
				if (!_tmp208_) {
					ZeitgeistSubject* _tmp209_;
					const gchar* _tmp210_;
					const gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* val;
					const gchar* _tmp213_;
					const gchar* _tmp214_;
					const gchar* _tmp215_;
					ZeitgeistWhereClause* _tmp216_;
					const gchar* _tmp217_;
					_tmp209_ = subject_template;
					_tmp210_ = zeitgeist_subject_get_storage (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup (_tmp211_);
					val = _tmp212_;
					_tmp213_ = val;
					zeitgeist_db_reader_assert_no_negation (self, "subject storage", _tmp213_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp214_ = val;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject storage", _tmp214_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp215_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp215_, "subject storage", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp216_ = where;
					_tmp217_ = val;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp216_, "subj_storage_id", _tmp217_, FALSE);
					_g_free0 (val);
				}
				_g_object_unref0 (subject_template);
			}
		}
	}
	result = where;
	return result;
}


/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* error_message;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "!");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = field;
	_tmp3_ = g_strdup_printf ("Field '%s' doesn't support negation", _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = error_message;
	g_warning ("db-reader.vala:812: %s", _tmp4_);
	_tmp5_ = error_message;
	_tmp6_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp5_);
	_inner_error_ = _tmp6_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* error_message;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "+");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = field;
	_tmp3_ = g_strdup_printf ("Field '%s' doesn't support the no-expand operator", _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = error_message;
	g_warning ("db-reader.vala:828: %s", _tmp4_);
	_tmp5_ = error_message;
	_tmp6_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp5_);
	_inner_error_ = _tmp6_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


/**
     * If the value ends with the wildcard character, throw an error.
     */
void zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* error_message;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = g_str_has_suffix (_tmp0_, "*");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = field;
	_tmp3_ = g_strdup_printf ("Field '%s' doesn't support prefix search", _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = error_message;
	g_warning ("db-reader.vala:843: %s", _tmp4_);
	_tmp5_ = error_message;
	_tmp6_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp5_);
	_inner_error_ = _tmp6_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _symbol;
	gboolean _tmp2_ = FALSE;
	gboolean negated;
	gboolean _tmp3_ = FALSE;
	gboolean noexpand;
	GList* symbols = NULL;
	gboolean _tmp4_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	ZeitgeistWhereClause* _tmp9_;
	ZeitgeistWhereClause* subwhere;
	GList* _tmp10_;
	guint _tmp11_ = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (lookup_table != NULL, NULL);
	_tmp0_ = symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_symbol = _tmp1_;
	_tmp2_ = zeitgeist_utils_parse_negation (&_symbol);
	negated = _tmp2_;
	_tmp3_ = zeitgeist_utils_parse_noexpand (&_symbol);
	noexpand = _tmp3_;
	_tmp4_ = noexpand;
	if (_tmp4_) {
		_g_list_free0 (symbols);
		symbols = NULL;
	} else {
		const gchar* _tmp5_;
		GList* _tmp6_ = NULL;
		_tmp5_ = _symbol;
		_tmp6_ = zeitgeist_symbol_get_all_children (_tmp5_);
		_g_list_free0 (symbols);
		symbols = _tmp6_;
	}
	_tmp7_ = _symbol;
	symbols = g_list_prepend (symbols, _tmp7_);
	_tmp8_ = negated;
	_tmp9_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, _tmp8_);
	subwhere = _tmp9_;
	_tmp10_ = symbols;
	_tmp11_ = g_list_length (_tmp10_);
	if (_tmp11_ == ((guint) 1)) {
		ZeitgeistWhereClause* _tmp12_;
		const gchar* _tmp13_;
		ZeitgeistSQLiteTableLookup* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_ = 0;
		_tmp12_ = subwhere;
		_tmp13_ = table_name;
		_tmp14_ = lookup_table;
		_tmp15_ = _symbol;
		_tmp16_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp14_, _tmp15_);
		zeitgeist_where_clause_add_match_condition (_tmp12_, _tmp13_, _tmp16_, FALSE);
	} else {
		gchar* _tmp17_;
		gchar* sql;
		gchar* _tmp18_;
		gchar* sub_sql;
		gboolean first;
		GList* _tmp19_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		ZeitgeistWhereClause* _tmp34_;
		const gchar* _tmp35_;
		_tmp17_ = g_strdup ("(%s)");
		sql = _tmp17_;
		_tmp18_ = g_strdup ("");
		sub_sql = _tmp18_;
		first = TRUE;
		_tmp19_ = symbols;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp19_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				const gchar* uri = NULL;
				uri = (const gchar*) uri_it->data;
				{
					gboolean _tmp20_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					ZeitgeistSQLiteTableLookup* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_ = 0;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp20_ = first;
					if (!_tmp20_) {
						const gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp21_ = sub_sql;
						_tmp22_ = g_strconcat (_tmp21_, " OR ", NULL);
						_g_free0 (sub_sql);
						sub_sql = _tmp22_;
					}
					_tmp23_ = sub_sql;
					_tmp24_ = table_name;
					_tmp25_ = lookup_table;
					_tmp26_ = uri;
					_tmp27_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp25_, _tmp26_);
					_tmp28_ = g_strdup_printf ("%s = %i ", _tmp24_, _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat (_tmp23_, _tmp29_, NULL);
					_g_free0 (sub_sql);
					sub_sql = _tmp30_;
					_g_free0 (_tmp29_);
					first = FALSE;
				}
			}
		}
		_tmp31_ = sql;
		_tmp32_ = sub_sql;
		_tmp33_ = g_strdup_printf (_tmp31_, _tmp32_);
		_g_free0 (sql);
		sql = _tmp33_;
		_tmp34_ = subwhere;
		_tmp35_ = sql;
		zeitgeist_where_clause_add (_tmp34_, _tmp35_, NULL);
		_g_free0 (sub_sql);
		_g_free0 (sql);
	}
	result = subwhere;
	_g_list_free0 (symbols);
	_g_free0 (_symbol);
	return result;
}


static void zeitgeist_db_reader_delete_from_cache (ZeitgeistDbReader* self, const gchar* table, gint64 rowid) {
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	const gchar* _tmp0_;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	gint64 _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = table;
	if (g_strcmp0 (_tmp0_, "interpretation") == 0) {
		ZeitgeistSQLiteTableLookup* _tmp1_;
		ZeitgeistSQLiteTableLookup* _tmp2_;
		_tmp1_ = self->interpretations_table;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (table_lookup);
		table_lookup = _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = table;
		if (g_strcmp0 (_tmp3_, "manifestation") == 0) {
			ZeitgeistSQLiteTableLookup* _tmp4_;
			ZeitgeistSQLiteTableLookup* _tmp5_;
			_tmp4_ = self->manifestations_table;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (table_lookup);
			table_lookup = _tmp5_;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = table;
			if (g_strcmp0 (_tmp6_, "mimetype") == 0) {
				ZeitgeistSQLiteTableLookup* _tmp7_;
				ZeitgeistSQLiteTableLookup* _tmp8_;
				_tmp7_ = self->mimetypes_table;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_g_object_unref0 (table_lookup);
				table_lookup = _tmp8_;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = table;
				if (g_strcmp0 (_tmp9_, "actor") == 0) {
					ZeitgeistSQLiteTableLookup* _tmp10_;
					ZeitgeistSQLiteTableLookup* _tmp11_;
					_tmp10_ = self->actors_table;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_g_object_unref0 (table_lookup);
					table_lookup = _tmp11_;
				} else {
					_g_object_unref0 (table_lookup);
					return;
				}
			}
		}
	}
	_tmp12_ = table_lookup;
	_tmp13_ = rowid;
	zeitgeist_sq_lite_table_lookup_remove (_tmp12_, (gint) _tmp13_);
	_g_object_unref0 (table_lookup);
}


ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self) {
	ZeitgeistSQLiteDatabase* result;
	ZeitgeistSQLiteDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_database;
	result = _tmp0_;
	return result;
}


static void zeitgeist_db_reader_set_database (ZeitgeistDbReader* self, ZeitgeistSQLiteDatabase* value) {
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_database);
	self->priv->_database = _tmp1_;
	g_object_notify ((GObject *) self, "database");
}


static void _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table, gint64 rowid, gpointer self) {
	zeitgeist_db_reader_delete_from_cache (self, table, rowid);
}


static GObject * zeitgeist_db_reader_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistDbReader * self;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_db_reader_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_DB_READER (obj);
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_database_set_deletion_callback (_tmp0_, _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->_database;
	_tmp2_ = _tmp1_->database;
	self->db = _tmp2_;
	{
		ZeitgeistSQLiteDatabase* _tmp3_;
		ZeitgeistSQLiteTableLookup* _tmp4_;
		ZeitgeistSQLiteTableLookup* _tmp5_;
		ZeitgeistSQLiteDatabase* _tmp6_;
		ZeitgeistSQLiteTableLookup* _tmp7_;
		ZeitgeistSQLiteTableLookup* _tmp8_;
		ZeitgeistSQLiteDatabase* _tmp9_;
		ZeitgeistSQLiteTableLookup* _tmp10_;
		ZeitgeistSQLiteTableLookup* _tmp11_;
		ZeitgeistSQLiteDatabase* _tmp12_;
		ZeitgeistSQLiteTableLookup* _tmp13_;
		ZeitgeistSQLiteTableLookup* _tmp14_;
		_tmp3_ = self->priv->_database;
		_tmp4_ = zeitgeist_sq_lite_table_lookup_new (_tmp3_, "interpretation", &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->interpretations_table);
		self->interpretations_table = _tmp5_;
		_tmp6_ = self->priv->_database;
		_tmp7_ = zeitgeist_sq_lite_table_lookup_new (_tmp6_, "manifestation", &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->manifestations_table);
		self->manifestations_table = _tmp8_;
		_tmp9_ = self->priv->_database;
		_tmp10_ = zeitgeist_sq_lite_table_lookup_new (_tmp9_, "mimetype", &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->mimetypes_table);
		self->mimetypes_table = _tmp11_;
		_tmp12_ = self->priv->_database;
		_tmp13_ = zeitgeist_sq_lite_table_lookup_new (_tmp12_, "actor", &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->actors_table);
		self->actors_table = _tmp14_;
	}
	goto __finally1;
	__catch1_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = err;
		_tmp16_ = _tmp15_->message;
		g_critical ("db-reader.vala:68: TableLookup initialization failed: %s", _tmp16_);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void zeitgeist_db_reader_related_uri_copy (const ZeitgeistDbReaderRelatedUri* self, ZeitgeistDbReaderRelatedUri* dest) {
	guint32 _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint32 _tmp4_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).timestamp;
	(*dest).timestamp = _tmp1_;
	_tmp2_ = (*self).uri;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp3_;
	_tmp4_ = (*self).counter;
	(*dest).counter = _tmp4_;
}


static void zeitgeist_db_reader_related_uri_destroy (ZeitgeistDbReaderRelatedUri* self) {
	_g_free0 ((*self).uri);
}


static ZeitgeistDbReaderRelatedUri* zeitgeist_db_reader_related_uri_dup (const ZeitgeistDbReaderRelatedUri* self) {
	ZeitgeistDbReaderRelatedUri* dup;
	dup = g_new0 (ZeitgeistDbReaderRelatedUri, 1);
	zeitgeist_db_reader_related_uri_copy (self, dup);
	return dup;
}


static void zeitgeist_db_reader_related_uri_free (ZeitgeistDbReaderRelatedUri* self) {
	zeitgeist_db_reader_related_uri_destroy (self);
	g_free (self);
}


static GType zeitgeist_db_reader_related_uri_get_type (void) {
	static volatile gsize zeitgeist_db_reader_related_uri_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_db_reader_related_uri_type_id__volatile)) {
		GType zeitgeist_db_reader_related_uri_type_id;
		zeitgeist_db_reader_related_uri_type_id = g_boxed_type_register_static ("ZeitgeistDbReaderRelatedUri", (GBoxedCopyFunc) zeitgeist_db_reader_related_uri_dup, (GBoxedFreeFunc) zeitgeist_db_reader_related_uri_free);
		g_once_init_leave (&zeitgeist_db_reader_related_uri_type_id__volatile, zeitgeist_db_reader_related_uri_type_id);
	}
	return zeitgeist_db_reader_related_uri_type_id__volatile;
}


static void zeitgeist_db_reader_class_init (ZeitgeistDbReaderClass * klass) {
	zeitgeist_db_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDbReaderPrivate));
	ZEITGEIST_DB_READER_CLASS (klass)->close = zeitgeist_db_reader_real_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_db_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_db_reader_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_db_reader_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_db_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DB_READER_DATABASE, g_param_spec_object ("database", "database", "database", ZEITGEIST_SQ_LITE_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void zeitgeist_db_reader_instance_init (ZeitgeistDbReader * self) {
	self->priv = ZEITGEIST_DB_READER_GET_PRIVATE (self);
}


static void zeitgeist_db_reader_finalize (GObject* obj) {
	ZeitgeistDbReader * self;
	self = ZEITGEIST_DB_READER (obj);
	_g_object_unref0 (self->priv->_database);
	_g_object_unref0 (self->interpretations_table);
	_g_object_unref0 (self->manifestations_table);
	_g_object_unref0 (self->mimetypes_table);
	_g_object_unref0 (self->actors_table);
	G_OBJECT_CLASS (zeitgeist_db_reader_parent_class)->finalize (obj);
}


GType zeitgeist_db_reader_get_type (void) {
	static volatile gsize zeitgeist_db_reader_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_db_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDbReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_db_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDbReader), 0, (GInstanceInitFunc) zeitgeist_db_reader_instance_init, NULL };
		GType zeitgeist_db_reader_type_id;
		zeitgeist_db_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDbReader", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_db_reader_type_id__volatile, zeitgeist_db_reader_type_id);
	}
	return zeitgeist_db_reader_type_id__volatile;
}


static void _vala_zeitgeist_db_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistDbReader * self;
	self = ZEITGEIST_DB_READER (object);
	switch (property_id) {
		case ZEITGEIST_DB_READER_DATABASE:
		g_value_set_object (value, zeitgeist_db_reader_get_database (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_db_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistDbReader * self;
	self = ZEITGEIST_DB_READER (object);
	switch (property_id) {
		case ZEITGEIST_DB_READER_DATABASE:
		zeitgeist_db_reader_set_database (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



