/*
 * Copyright 2004-2005 The Unichrome Project  [unichrome.sf.net]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */
#ifndef _VIA_VT162X_H_
#define _VIA_VT162X_H_ 1

struct VT162xModePrivate {
    char   id[12]; /* "VT162x" */
    CARD8  Standard;
};

/* Hmm this seemed like a reasonable approach initially. perhaps not. */
static struct VT162xModePrivate VT162xModePrivateNTSC = { { 'V', 'T', '1', '6', '2', 'x', 0, 0, 0, 0, 0, 0 }, TVTYPE_NTSC,};
static struct VT162xModePrivate VT162xModePrivatePAL = {  { 'V', 'T', '1', '6', '2', 'x', 0, 0, 0, 0, 0, 0 }, TVTYPE_PAL,};
static struct VT162xModePrivate VT162xModePrivate480P = { { 'V', 'T', '1', '6', '2', 'x', 0, 0, 0, 0, 0, 0 }, TVTYPE_480P,};
static struct VT162xModePrivate VT162xModePrivate576P = { { 'V', 'T', '1', '6', '2', 'x', 0, 0, 0, 0, 0, 0 }, TVTYPE_576P,};
static struct VT162xModePrivate VT162xModePrivate720P = { { 'V', 'T', '1', '6', '2', 'x', 0, 0, 0, 0, 0, 0 }, TVTYPE_720P,};
static struct VT162xModePrivate VT162xModePrivate1080I = {{ 'V', 'T', '1', '6', '2', 'x', 0, 0, 0, 0, 0, 0 }, TVTYPE_1080I,};

#define MODEPREFIX(name) NULL, NULL, name, 0,M_T_DEFAULT
#define MODESUFFIXNTSC       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct VT162xModePrivate),(void *)&VT162xModePrivateNTSC,0,0.0,0.0
#define MODESUFFIXPAL        0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct VT162xModePrivate),(void *)&VT162xModePrivatePAL,0,0.0,0.0
#define MODESUFFIX480P       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct VT162xModePrivate),(void *)&VT162xModePrivate480P,0,0.0,0.0
#define MODESUFFIX576P       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct VT162xModePrivate),(void *)&VT162xModePrivate576P,0,0.0,0.0
#define MODESUFFIX720P       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct VT162xModePrivate),(void *)&VT162xModePrivate720P,0,0.0,0.0
#define MODESUFFIX1080I      0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct VT162xModePrivate),(void *)&VT162xModePrivate1080I,0,0.0,0.0

/*
 *
 * VT1621 modetables
 *
 */
/* for dotclock i just took HTotal*VTotal*50 -- is not actually used - just to satisfy modevalidation */
static DisplayModeRec VT1621Modes[] = {
    { MODEPREFIX("640x480"),     23520,  640,  656,  752,  784, 0,  480,  520,  523,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("640x480"),     26250,  640,  664,  792,  840, 0,  480,  529,  539,  625, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("800x600"),     39900,  800,  840,  976, 1064, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("800x600"),     36000,  800,  824,  904,  960, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("640x480Over"), 20580,  640,  656,  752,  784, 0,  480,  494,  507,  525, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("640x480Over"), 24000,  640,  672,  888,  960, 0,  480,  485,  491,  500, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("800x600Over"), 36400,  800,  840,  960, 1040, 0,  600,  602,  604,  700, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("800x600Over"), 29500,  800,  824,  896,  944, 0,  600,  599,  604,  625, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MODESUFFIXNTSC },
};

struct VT1621TableRec {
    char *  name;
    CARD16  Width;
    CARD16  Height;
    int     Standard;
    CARD8   PrimaryCR6C;
    CARD8   TV[0x25];
    CARD8   TVC[0x18];
    CARD8   TVS[0x18];
    CARD32  SubCarrier;
    CARD32  DotCrawlSubCarrier;
};

static struct VT1621TableRec 
VT1621Table[] = {
    { "640x480", 640,  480, TVTYPE_NTSC, 0,
      { 0x64, 0x03, 0x22, 0x33, 0x43,    0, 0x10, 0x7D,  0xAC, 0x05, 0x99, 0x17, 0x93, 0xA5, 0x03, 0xBA,
	   0,    0, 0x0A, 0xCD, 0x80, 0x28,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x6D },
      { 0x48, 0x01, 0x02,    0, 0xFC, 0xF9, 0xFF, 0x10,  0x23, 0x2C, 0x09, 0x08, 0x0A, 0x0C, 0x0D, 0x0D },
      { 0x48, 0x02, 0x02, 0xFD, 0x06, 0xF8, 0x0B, 0xF3,  0x0F, 0x70, 0x05, 0xF9, 0x0B, 0xF1, 0x11, 0x6E },
      0x207FFFBE, 0x207FF6BE,
    },
    { "640x480", 640,  480, TVTYPE_PAL, 0x04,
      { 0x64, 0x01, 0x02, 0x33, 0x40,    0, 0x10, 0xAD,  0xD3, 0x37, 0xA3,    0, 0x94, 0xFF, 0x03, 0xBA,
	   0,    0, 0x07, 0x26, 0x2C, 0x20,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x76 },
      { 0x48,    0,    0, 0xFE, 0xFC, 0xFD, 0x05, 0x12,  0x1F, 0x25, 0x0B, 0x08, 0x0A, 0x0C, 0x0D, 0x0D }, 
      { 0x48, 0xFE, 0x03, 0xFB, 0x06, 0xF8, 0x0A, 0xF5,  0x0C, 0x73, 0x06, 0xF8, 0x0B, 0xF2, 0x10, 0x6F },
      0x25D56350, 0,
    },
    { "800x600", 800,  600, TVTYPE_NTSC, 0x1E,
      { 0x84, 0x03, 0x2A, 0x33, 0x43,    0, 0x10, 0xDD,  0xB9, 0x15, 0x99, 0x17, 0x93, 0xA5, 0x03, 0xBA,
	   0,    0, 0x0A, 0xED, 0x98, 0x1C,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x6D },
      { 0x48,    0, 0xFF, 0xFD, 0xFC, 0xFF, 0x07, 0x13,  0x1E, 0x22, 0x0D, 0x08, 0x09, 0x0A, 0x0B, 0x0C },
      { 0x48, 0x02, 0x02, 0xFD, 0x06, 0xF8, 0x0B, 0xF3,  0x0F, 0x70, 0x05, 0xF9, 0x0B, 0xF1, 0x11, 0x6E },
      0x1B5E5096, 0x1B5E5796,
    },
    { "800x600", 800,  600, TVTYPE_PAL, 0x04,
      { 0x84, 0x03, 0x1A, 0x33, 0x40,    0, 0x10, 0x85,  0xF1, 0x4B, 0xA3,    0, 0x94, 0xFF, 0x03, 0xBA,
	   0,    0, 0x07, 0x25, 0x2C, 0x1C,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x76 },
      { 0x48, 0xFF, 0xFE, 0xFD, 0xFE, 0x02, 0x0A, 0x13,  0x1A, 0x1D, 0x0F, 0x08, 0x09, 0x0A, 0x0B, 0x0B },
      { 0x48, 0xFB, 0x04, 0xFB, 0x07, 0xF8, 0x09, 0xF6,  0x0A, 0x74, 0x06, 0xF8, 0x0B, 0xF2, 0x10, 0x6F },
      0x1F872818, 0,
    },
    { "640x480Over", 640,  480, TVTYPE_NTSC, 0,
      { 0x64, 0x03, 0x02, 0x33, 0x43,    0, 0x10, 0x7D,  0x72, 0x05, 0x99, 0x17, 0x93, 0xA5, 0x03, 0xBA,
	   0,    0, 0x0D, 0x45, 0x38, 0x34,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x6D },
      { 0x48,    0, 0x01, 0x02, 0xFF, 0xF9, 0xFA, 0x0C,  0x26, 0x32, 0x07, 0x08, 0x0A, 0x0D, 0x0E, 0x0F },
      { 0x48, 0x02, 0x02, 0xFD, 0x06, 0xF8, 0x0B, 0xF3,  0x0F, 0x70, 0x05, 0xF9, 0x0B, 0xF1, 0x11, 0x6E },
      0x252491F1, 0x252499F1,
    },
    { "640x480Over", 640, 480, TVTYPE_PAL, 0,
      { 0x64, 0x01, 0x12, 0x33, 0x40,    0, 0x10, 0x1D,  0x68, 0x26, 0xA3,    0, 0x94, 0xFF, 0x03, 0xBA,
	   0,    0, 0x0F, 0x67, 0x58, 0x3C,    0,    0,     0,    0,    0,    0, 0x0A,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x76 },
      { 0x48,    0, 0x01, 0x01, 0xFE, 0xFA, 0xFD, 0x0E,  0x24, 0x2E, 0x07, 0x07, 0x0A, 0x0D, 0x0F, 0x0F },
      { 0x48, 0xFD, 0x03, 0xFB, 0x07, 0xF8, 0x0A, 0xF5,  0x0B, 0x74, 0x06, 0xF8, 0x0B, 0xF2, 0x10, 0x6F },
      0x2F4ABC24, 0,
    },
    { "800x600Over", 800, 600, TVTYPE_NTSC, 0,
      { 0x84, 0x03, 0x0A, 0x33, 0x43,    0, 0x10, 0xC5,  0xAD, 0x10, 0x99, 0x17, 0x93, 0xA5, 0x03, 0xBA,
	   0,    0, 0x04, 0x07, 0x20, 0x0C,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x6D },
      { 0x48,    0, 0xFF, 0xFD, 0xFC, 0xFE, 0x06, 0x13,  0x1E, 0x23, 0x0D, 0x08, 0x0A, 0x0B, 0x0C, 0x0C },
      { 0x48, 0x02, 0x02, 0xFD, 0x06, 0xF8, 0x0B, 0xF3,  0x0F, 0x70, 0x05, 0xF9, 0x0B, 0xF1, 0x11, 0x6E },
      0x1C000008, 0x1C000808,
    },
    { "800x600Over", 800, 600, TVTYPE_PAL, 0,
      { 0x84, 0x03, 0x02, 0x33, 0x40,    0, 0x10, 0x75,  0x7B, 0x34, 0xA3,    0, 0x94, 0xFF, 0x03, 0xBA,
	   0,    0, 0x08, 0xFD, 0xEF, 0x20,    0,    0,     0,    0,    0,    0, 0x02,    0,    0,    0,
	0x75, 0x0C, 0x04, 0x76 },
      { 0x48, 0xFF, 0xFE, 0xFD, 0xFE, 0x02, 0x0A, 0x13,  0x1A, 0x1D, 0x0F, 0x08, 0x09, 0x0A, 0x0B, 0x0B },
      { 0x48, 0xFB, 0x04, 0xFB, 0x07, 0xF8, 0x09, 0xF6,  0x0A, 0x74, 0x06, 0xF8, 0x0B, 0xF2, 0x10, 0x6F },
      0x26798C0C, 0,
    },
    { NULL, 0, 0, 0, 0,
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0 },
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0 },
      0, 0,
    }
};

/*
 *
 * VT1622 modetables
 *
 */
static DisplayModeRec VT1622Modes[] = {
    { MODEPREFIX("640x480"),        23520,  640,  656,  744,  784, 0,  480,  487,  491,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("640x480"),        30000,  640,  680,  808, 1000, 0,  480,  520,  523,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("800x600"),        39900,  800,  840,  976, 1064, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("800x600"),        34500,  800,  816,  880,  920, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("1024x768"),       54810, 1024, 1032, 1088, 1160, 0,  768,  780,  792,  945, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("1024x768"),       57000, 1024, 1040, 1112, 1200, 0,  768,  829,  840,  950, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("848x480"),        34860,  848,  872, 1032, 1200, 0,  480,  495,  509,  581, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("848x480"),        36000,  848,  872, 1032, 1200, 0,  480,  498,  509,  600, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x480"),        25200,  720,  728,  776,  840, 0,  480,  511,  515,  600, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("720x576"),        28500,  720,  728,  744,  760, 0,  576,  635,  643,  750, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("640x480Over"),    20160,  640,  648,  704,  720, 0,  480,  487,  491,  560, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("640x480Over"),    21000,  640,  664,  792,  840, 0,  480,  485,  491,  500, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("800x600Over"),    35910,  800,  840,  984, 1080, 0,  600,  601,  604,  665, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("800x600Over"),    32500,  800,  832,  928, 1000, 0,  600,  600,  604,  650, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("1024x768Over"),   50400, 1024, 1040, 1112, 1200, 0,  768,  772,  776,  840, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("1024x768Over"),   49500, 1024, 1032, 1112, 1200, 0,  768,  771,  776,  825, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("848x480Over"),    27720,  848,  856,  928, 1008, 0,  480,  490,  493,  550, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("848x480Over"),    33000,  848,  872, 1032, 1200, 0,  480,  490,  493,  550, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x480Over"),    21000,  720,  728,  760,  800, 0,  480,  480,  483,  525, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("720x576Over"),    30000,  720,  728,  864, 1000, 0,  576,  576,  579,  600, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x480Noscale"), 27972,  720,  736,  768,  888, 0,  480,  480,  483,  525, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("720x576Noscale"), 28000,  720,  728,  864,  896, 0,  576,  576,  579,  625, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MODESUFFIXNTSC },
};

struct VT162XTableRec {
    char *  name;
    CARD16  Width;
    CARD16  Height;
    int     Standard;
    CARD8   PrimaryCR6C;
    CARD8   SecondaryCR6C;
    CARD8   TV1[0x30];
    CARD8   TV2[0x1B];
    CARD8   RGB[6];
    CARD8   YCbCr[3];
    CARD32  SubCarrier;
    CARD32  DotCrawlSubCarrier;
};

static struct VT162XTableRec
VT1622Table[] = {
    { "640x480", 640, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0, 0x02, 0x03,    0, 0x10, 0x7E,  0x9D, 0x0D, 0x60, 0x17, 0x52, 0x45, 0x0F,    0,
	   0,    0, 0xD0, 0x33, 0xBF, 0x3A,    0,    0,     0,    0, 0xE9,    0,    0,    0,    0, 0x05,
	0x12, 0x0C, 0x04, 0x74,    0, 0x5A, 0x2F, 0x97,  0x50,    0,    0, 0xAA, 0x2B, 0x7A, 0xD8,    0 },
      { 0xDC, 0x50, 0x04,    0,    0, 0x40, 0x0F, 0x81,  0x23, 0x57, 0x02, 0x0F, 0x29, 0x73, 0x23, 0x86,
	0xC4, 0xEA, 0xDF, 0x05, 0x92, 0xA1, 0x04,    0,     0, 0x7F, 0x03 },
      { 0xAF, 0xAA, 0xAA, 0x91, 0x9C, 0x27 },
      { 0x50, 0x4B, 0x4D },
      0x252491F1, 0x252487BE,
    },
    { "640x480", 640, 480, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0x82,    0,    0, 0x10, 0x3E,  0xA4, 0x37, 0x67,    0, 0x49, 0x49, 0x0F,    0,
	   0,    0, 0xEC, 0x2A, 0xB8, 0x29,    0,    0,     0,    0, 0xED,    0, 0x0A,    0,    0, 0x04,
	0x12, 0x0C, 0x04, 0x7B,    0, 0x64, 0x30, 0x93,  0x49, 0x5F, 0x15, 0xA5, 0x23, 0x7A, 0xCC,    0 },
      { 0xF9, 0x50, 0x04,    0,    0, 0x45, 0xE7, 0x81,  0x23, 0x57, 0x02, 0x1F, 0x31, 0x75, 0x23, 0x8A,
	0xC8, 0xF0, 0xFF, 0x05, 0xD7, 0x8E, 0x03, 0x7F,  0xCF, 0xBF, 0x03 },
      { 0x8A, 0x86, 0x86, 0x8D, 0x96, 0x20 },
      { 0x42, 0x49, 0x49 },
      0x2D66772D, 0,
    },
    { "800x600", 800, 600, TVTYPE_NTSC, 0x1E, 0,
      { 0x84,    0,    0, 0x24, 0x03,    0, 0x10, 0xDE,  0xD4, 0x0E, 0x59, 0x17, 0x46, 0x40, 0x0F,    0,
	   0,    0, 0xEA, 0x0D, 0x98, 0x1C,    0,    0,     0,    0, 0x3D,    0, 0x01,    0,    0, 0x85,
	0x0D, 0x0A, 0x04, 0x74,    0, 0x5A, 0x41, 0x96,  0x6B,    0,    0, 0xAA, 0x2B, 0xA6, 0x1E, 0x10 },
      { 0xE4, 0x69, 0x04,    0,    0, 0x3F, 0x27, 0x21,  0x34, 0xED, 0x02, 0x27, 0xF5, 0x9D, 0x24, 0xB7,
	0x0D, 0x40,    0, 0x58, 0xB6, 0x3B, 0x05,    0,  0x01, 0xEF, 0x05 },
      { 0x93, 0x90, 0x90, 0x91, 0x9C, 0 },
      { 0x43, 0x4A, 0x49 },
      0x1B5E5096, 0x1B5E4912,
    },
    { "800x600", 800, 600, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0xA4,    0,    0, 0x19, 0x66,  0xBF, 0x12, 0x60,    0, 0x56, 0x45, 0x0F,    0,
	   0,    0, 0xEC, 0x15, 0xFD, 0x28,    0,    0,     0,    0, 0x16,    0, 0x01,    0,    0, 0x85,
	0x10, 0x0C, 0x04, 0x7B,    0, 0x64, 0x37, 0x93,  0x54, 0x5F, 0x15, 0xA5, 0x23, 0x8F, 0xF4,    0 },
      { 0xE7, 0x45, 0x04,    0,    0, 0x44, 0x97, 0x21,  0x33, 0xED, 0x02, 0x97, 0x87, 0x87, 0x23, 0x9F,
	0xE7, 0x16, 0xE7, 0x16, 0xCC, 0xF3, 0x04,    0,  0x01, 0x4F, 0x04 },
      { 0xB8, 0xB4, 0xB4, 0, 0, 0 },
      { 0x58, 0x5E, 0x5E },
      0x277A7DE4, 0,
    },
    { "1024x768", 1024, 768, TVTYPE_NTSC, 0x12, 0x1C,
      { 0x84,    0,    0, 0x44, 0x03,    0, 0x10, 0x80,  0x15, 0x0A, 0x58, 0x17, 0x5B, 0x40, 0x0F,    0,
	   0,    0, 0xE9, 0x1E, 0x9D, 0x19,    0,    0,     0,    0, 0x9C,    0, 0x05,    0,    0, 0x85,
	0x0A, 0x05, 0x04, 0x74,    0, 0x5A, 0x56, 0x96,  0x8B,    0,    0, 0xAA, 0x2B, 0xDA, 0x79, 0x10 },
      { 0xDA, 0x50, 0x04,    0,    0, 0x3F, 0x87, 0xFF,  0x34, 0xB0, 0x03, 0x6F, 0xDB, 0xCD, 0x35, 0xF1,
	0x5E, 0xA5, 0x7E, 0x5A, 0x33, 0x26, 0x07,    0,  0x01, 0x27, 0x08 },
      { 0xC2, 0xBE, 0xBE, 0x91, 0x9C, 0 },
      { 0x58, 0x4B, 0x4A },
      0x14EB66D6, 0x14EB6118,
    },
    { "1024x768", 1024, 768, TVTYPE_PAL, 0x1E, 0,
      { 0x84,    0,    0, 0xC0,    0,    0, 0x10, 0xA0,  0x2A, 0x38, 0x70,    0, 0x4E, 0x50, 0x0F,    0,
	   0,    0, 0xE4, 0x23, 0xD1, 0x0C,    0,    0,     0,    0, 0x96,    0, 0x07,    0,    0, 0x85,
	0x0C, 0x0C, 0x04, 0x7B,    0, 0x64, 0x53, 0x90,  0x7B, 0x5B, 0x15, 0xA0, 0x22, 0xD1, 0x71, 0x10 },
      { 0xDD, 0x60, 0x04,    0,    0, 0x45, 0xAF, 0xFF,  0x34, 0xB5, 0x03, 0x57, 0xA8, 0xC8, 0x35, 0xEC,
	0x4C, 0xCC, 0x67, 0x5A, 0x14, 0x5C, 0x06,    0,  0x01, 0x1F, 0x07 },
      { 0xA9, 0xA6, 0xA6, 0x90, 0x99, 0 },
      { 0x51, 0x49, 0x49 },
      0x1A8CC372, 0,
    },
    { "848x480", 848, 480, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x24, 0x03,    0, 0x10, 0x46,  0xCC, 0x0E, 0x56, 0x17, 0x43, 0x3E, 0x0F,    0,
	   0,    0, 0xE8, 0x29, 0x67, 0x19,    0,    0,     0,    0, 0x29,    0, 0x0B,    0,    0, 0x85,
	0x0E, 0x08, 0x04, 0x74,    0, 0x5A, 0x3D, 0x96,  0x64,    0,    0, 0xAA, 0x2B, 0x9C, 0x17, 0x10 },
      { 0xDC, 0x50,    0,    0,    0, 0x40, 0xAF, 0x51,  0x34, 0x44, 0x02, 0xE3, 0xC1, 0x93, 0x23, 0xAD,
	0xFD, 0x2B, 0x7C, 0x17, 0x6D, 0xCA, 0x04,    0,  0x01, 0x2F, 0x05 },
      { 0x94, 0x90, 0x91, 0x91, 0x9C, 0 },
      { 0x44, 0x45, 0x45 },
      0x1D3CA863, 0x1D3CA05B,
    },
    { "848x480", 848, 480, TVTYPE_PAL, 0x08, 0,
      { 0x04,    0,    0, 0xC2,    0,    0, 0x10, 0x47,  0xE4, 0x09, 0x64,    0, 0x4F, 0x48, 0x0F,    0,
	   0,    0, 0xE7, 0x05, 0x2C, 0x1C,    0,    0,     0,    0, 0x5E,    0, 0x09,    0,    0, 0x84,
	0x0A, 0x0C, 0x04, 0x7B,    0, 0x64, 0x46, 0x93,  0x68, 0x5F, 0x15, 0xA5, 0x23, 0xB4, 0x2A, 0x10 },
      { 0xE7, 0x45, 0x04,    0,    0, 0x43, 0xAF, 0x51,  0x34, 0x57, 0x02, 0x7F, 0x4F, 0xA9, 0x34, 0xD1,
	0x2B, 0x5D, 0xAA, 0x58, 0xD7, 0x01, 0x03,    0,  0x01, 0x7F, 0x04 },
      { 0xA4, 0xA0, 0xA1, 0, 0, 0 },
      { 0x50, 0x49, 0x49 },
      0x1F872818, 0,
    },
    { "720x480", 720, 480, TVTYPE_NTSC, 0x04, 0,
      { 0x04,    0,    0, 0x26, 0x03,    0, 0x10, 0x6D,  0xC3, 0x08, 0x56, 0x17, 0x43, 0x3E, 0x0F,    0,
	   0,    0, 0x0D, 0x07, 0x60, 0x34,    0,    0,     0,    0, 0x1E,    0, 0x03,    0,    0, 0x85,
	0x0F, 0x08, 0x04, 0x74,    0, 0x5A, 0x39, 0x95,  0x5E,    0,    0, 0xAA, 0x2B, 0x92, 0xFF,    0 },
      { 0xE4, 0x69, 0x04,    0,    0, 0x40, 0x47, 0xD1,  0x23, 0x57, 0x02, 0xBF, 0xAF, 0x8D, 0x23, 0xA4,
	0xF3, 0x20, 0x36, 0x17, 0x92, 0x33, 0x04,    0,     0, 0xBF, 0x03 },
      { 0x94, 0x90, 0x90, 0x91, 0x9C, 0 },
      { 0x42, 0x49, 0x48 },
      0x1E555518, 0x1E554CC3,
    },
    { "720x576", 720, 576, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0xA2,    0,    0, 0x10, 0x1E,  0xAC, 0x38, 0x67,    0, 0x57, 0x49, 0x0F,    0,
	   0,    0, 0xF0, 0x0F, 0xD1, 0x38,    0,    0,     0,    0, 0xF2,    0, 0x02,    0,    0, 0x84,
	0x13, 0x0C, 0x04, 0x7B, 0x48, 0x64, 0x30, 0x93,  0x49, 0x5F, 0x15, 0xA5, 0x23, 0x8B, 0xBD,    0 },
      { 0xE7, 0x45, 0x04,    0,    0, 0x45, 0xF7, 0xD1,  0x22, 0xED, 0x02, 0x1D, 0x29, 0x75, 0x23, 0x88,
	0xC6, 0xF0, 0xFA, 0x0F, 0xCC, 0x30, 0x14,    0,     0, 0x8F, 0x03 },
      { 0xB5, 0xB1, 0xB1, 0, 0, 0 },
      { 0x59, 0x4D, 0x4A },
      0x2D839832, 0,
    },
    { "640x480Over", 640, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0, 0x02, 0x03,    0, 0x10, 0x48,  0x72, 0x0A, 0x60, 0x17, 0x52, 0x45, 0x0F,    0,
	   0,    0, 0xED, 0x23, 0x80, 0x35,    0,    0,     0,    0, 0xE9,    0, 0x02,    0,    0, 0x05,
	0x12, 0x0C, 0x04, 0x75,    0, 0x5A, 0x2F, 0x97,  0x50,    0,    0, 0xAA, 0x2B, 0x7A, 0xD8,    0 },
      { 0xC4, 0x50, 0x04,    0,    0, 0x41, 0xCF, 0x7F,  0x22, 0x2F, 0x02, 0xFF, 0x7F, 0x71, 0x22, 0x83,
	0xC0, 0xE5, 0xC0, 0x05, 0x44,    0, 0x04,    0,     0, 0xFF, 0x02 },
      { 0xAD, 0xA9, 0xA9, 0, 0, 0 },
      { 0x4F, 0x49, 0x49 },
      0x25EAAA5E, 0x25EA9FF4,
    },
    { "640x480Over", 640, 480, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0x82,    0,    0, 0x10, 0xB0,  0x39, 0x39, 0x67,    0, 0x48, 0x4A, 0x0F,    0,
	   0,    0, 0x2C, 0x05, 0x2C, 0x30,    0,    0,     0,    0, 0xC8,    0, 0x02,    0,    0, 0x05,
	0x15, 0x0C, 0x04, 0x7B,    0, 0x64, 0x28, 0x93,  0x3E, 0x5F, 0x15, 0xA5, 0x23, 0x65, 0xCC,    0 },
      { 0xF9, 0x50, 0x04,    0,    0, 0x45, 0x47, 0x7F,  0x23, 0xF3, 0x01, 0x9F, 0x7F, 0x62, 0x22, 0x72,
	0xA7, 0xCB, 0x05, 0x05, 0x33,    0, 0x03,    0,     0, 0x9F, 0x02 },
      { 0x8A, 0x86, 0x86, 0x90, 0x99, 0 },
      { 0x42, 0x49, 0x49 },
      0x360C44BC, 0,
    },
    { "800x600Over", 800, 600, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x24, 0x03,    0, 0x10, 0xEF,  0xB0, 0x0A, 0x5A, 0x17, 0x46, 0x40, 0x0F,    0,
	   0,    0, 0xE8, 0x32, 0xC3, 0x19,    0,    0,     0,    0, 0x33,    0, 0x01,    0,    0, 0x85,
	0x0D, 0x0A, 0x04, 0x75,    0, 0x5A, 0x41, 0x96,  0x68,    0,    0, 0xAA, 0x2B, 0x9E, 0x1E, 0x10 },
      { 0xE4, 0x69, 0x04,    0,    0, 0x40, 0x37, 0x21,  0x34, 0x98, 0x02, 0x01, 0x21, 0x97, 0x34, 0xB1,
	0xFF, 0x34, 0xB6, 0x17, 0x11,    0, 0x05,    0,  0x01, 0x57, 0x05 },
      { 0x93, 0x90, 0x90, 0, 0, 0 },
      { 0x42, 0x45, 0x45 },
      0x1C61CEE0, 0x1C61C714,
    },
    { "800x600Over", 800, 600, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0xA0,    0,    0, 0x19, 0xA6,  0x9F, 0x38, 0x60,    0, 0x57, 0x45, 0x0F,    0,
	   0,    0, 0xC8, 0x12, 0x8F, 0x1C,    0,    0,     0,    0, 0x0E,    0, 0x03,    0,    0, 0x85,
	0x10, 0x0C, 0x04, 0x7B,    0, 0x64, 0x37, 0x93,  0x54, 0x5F, 0x15, 0xA5, 0x23, 0x8B, 0xF4,    0 },
      { 0xE9, 0x50, 0x04,    0,    0, 0x44, 0xE7, 0x1F,  0x33, 0x89, 0x02, 0x8D, 0xBC, 0x85, 0x23, 0x9C,
	0xE4, 0x13, 0xD4, 0x16, 0x28, 0x90, 0x04,    0,  0x01, 0x0F, 0x04 },
      { 0xB8, 0xB4, 0xB4, 0x90, 0x99, 0 },
      { 0x58, 0x48, 0x48 },
      0x27E98D57, 0,
    },
    { "1024x768Over", 1024, 768, TVTYPE_NTSC, 0x16, 0x1C,
      { 0x84,    0,    0, 0x44, 0x03,    0, 0x10, 0xA0,  0xAA, 0x05, 0x57, 0x17, 0x5C, 0x3F, 0x0F,    0,
	   0,    0, 0xE8, 0x33, 0x1A, 0x16,    0,    0,     0,    0, 0x66,    0, 0x01,    0,    0, 0x85,
	0x0A, 0x05, 0x04, 0x74,    0, 0x5A, 0x4B, 0x96,  0x79,    0,    0, 0xAA, 0x2B, 0xB9, 0x4B, 0x10 },
      { 0xE4, 0x50, 0x04,    0,    0, 0x40, 0xAF, 0xFF,  0x34, 0x47, 0x03, 0xAF, 0xFF, 0xB1, 0x34, 0xD1,
	0x30, 0x68, 0x0B, 0x59, 0x66,    0, 0x06,    0,  0x01, 0x7F, 0x07 },
      { 0xC2, 0xBE, 0xBE, 0, 0, 0 },
      { 0x57, 0x45, 0x45 },
      0x1844440E, 0x18443D63,
    },
    { "1024x768Over", 1024, 768, TVTYPE_PAL, 0x1E, 0,
      { 0x84,    0,    0, 0xC0,    0,    0, 0x10, 0xA8,  0xC5, 0x36, 0x5D,    0, 0x4E, 0x43, 0x0F,    0,
	   0,    0, 0xC9, 0x0A, 0x79, 0x1C,    0,    0,     0,    0, 0x6E,    0, 0x03,    0,    0, 0x85,
	0x0C, 0x0C, 0x04, 0x7B,    0, 0x64, 0x4B, 0x93,  0x6F, 0x5F, 0x15, 0xA5, 0x23, 0xBE, 0x5A, 0x10 },
      { 0xDD, 0x60, 0x04,    0,    0, 0x43, 0xAF, 0xFF,  0x34, 0x38, 0x03, 0xCF, 0xDF, 0xB4, 0x34, 0xD6,
	0x35, 0x75, 0x47, 0x59, 0x47, 0x20, 0x05,    0,  0x01, 0x2F, 0x06 },
      { 0xA9, 0xA6, 0xA6, 0x90, 0x99, 0 },
      { 0x51, 0x49, 0x49 },
      0x1D7B0E38, 0,
    },
    { "848x480Over", 848, 480, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x44, 0x03,    0, 0x10, 0x96,  0xA7, 0x08, 0x5B, 0x17, 0x46, 0x40, 0x0F,    0,
	   0,    0, 0xE8, 0x3C, 0x2D, 0x22,    0,    0,     0,    0, 0x3D,    0, 0x01,    0,    0, 0x85,
	0x0D, 0x08, 0x04, 0x75,    0, 0x5A, 0x41, 0x96,  0x69,    0,    0, 0xAA, 0x2B, 0xA2, 0x24, 0x10 },
      { 0xDC, 0x50,    0,    0,    0, 0x40, 0xEF, 0x51,  0x33, 0x25, 0x02, 0x1F, 0x4D, 0x9C, 0x34, 0xB5,
	0x0C, 0x3D, 0xF1, 0x57, 0x30, 0x01, 0x04,    0,  0x01, 0x1F, 0x04 },
      { 0xC0, 0xBC, 0xBC, 0, 0, 0 },
      { 0x58, 0x45, 0x45 },
      0x1B9364A1, 0x1B933067,
    },
    { "848x480Over", 848, 480, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0xC0,    0,    0, 0x10, 0x47,  0xA8, 0x39, 0x64,    0, 0x4E, 0x46, 0x0F,    0,
	   0,    0, 0xEA, 0x15, 0xF2, 0x28,    0,    0,     0,    0, 0x39,    0, 0x0B,    0,    0, 0x84,
	0x0F, 0x0C, 0x04, 0x7B,    0, 0x64, 0x40, 0x93,  0x5F, 0x5F, 0x15, 0xA5, 0x23, 0xA3, 0x2A, 0x10 },
      { 0xE7, 0x45, 0x04,    0,    0, 0x43, 0xAF, 0x4F,  0x34, 0x25, 0x02, 0x1F, 0x4F, 0x9B, 0x34, 0xB7,
	0x0A, 0x3F, 0xF0, 0x57, 0x85,    0, 0x03,    0,  0x01, 0x1F, 0x04 },
      { 0xA4, 0xA1, 0xA1, 0x90, 0x99, 0 },
      { 0x4E, 0x49, 0x49 },
      0x2264E5EC, 0,
    },
    { "720x480Over", 720, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0, 0x02, 0x03,    0, 0x10, 0x18,  0x28, 0x09, 0x5B, 0x17, 0x46, 0x41, 0x0F,    0,
	   0,    0, 0xEE, 0x0D, 0xA0, 0x38,    0,    0,     0,    0, 0xEE,    0, 0x02,    0,    0, 0x85,
	0x11, 0x08, 0x04, 0x75,    0, 0x5A, 0x31, 0x95,  0x51,    0,    0, 0xAA, 0x2B, 0x7A, 0xDB,    0 },
      { 0xE4, 0x69, 0x04,    0,    0, 0x40, 0x1F, 0xCF,  0x23, 0x0C, 0x02, 0x1F, 0xCF, 0x76, 0x23, 0x88,
	0xC9, 0xEF, 0xFF, 0x05,    0,    0,    0,    0,     0, 0x1F, 0x03 },
      { 0xAB, 0xA7, 0xA7, 0, 0, 0 },
      { 0x4D, 0x49, 0x49 },
      0x2466661D, 0x24665C1E,
    },
    { "720x576Over", 720, 576, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0xA6,    0,    0, 0x10, 0x10,  0x7D, 0x32, 0x60,    0, 0x57, 0x46, 0x0F,    0,
	   0,    0, 0xEC, 0x15, 0xDC, 0x28,    0,    0,     0,    0, 0xEE,    0, 0x0A,    0,    0, 0x84,
	0x13, 0x0C, 0x04, 0x7B, 0x48, 0x64, 0x30, 0x93,  0x49, 0x5F, 0x15, 0xA5, 0x23, 0x77, 0xFF,    0 },
      { 0xE7, 0x45, 0x04,    0,    0, 0x45, 0xE7, 0xCF,  0x23, 0x57, 0x02, 0x1F, 0x80, 0x75, 0x23, 0x89,
	0xC7, 0xF1, 0xFF, 0x05, 0xD7, 0x80, 0x03,    0,     0, 0xBF, 0x03 },
      { 0xBA, 0xB8, 0xB8, 0x90, 0x99, 0 },
      { 0x58, 0x48, 0x49 },
      0x2D66772D, 0,
    },
    { "720x480Noscale", 720, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0,    0, 0x03,    0, 0x10, 0x98,  0x98, 0x08, 0x5A, 0x17, 0x49, 0x41,    0, 0x89, 
           0,    0, 0xA9, 0x19, 0xDC, 0x24,    0,    0,     0,    0, 0xEE, 0x03, 0x02, 0x80,    0, 0x04, 
        0x11, 0x08, 0x04, 0x75,    0, 0x5A, 0x31, 0x95,  0x51,    0,    0, 0xAA, 0x2B, 0x7A, 0xDB,    0 }, 
      { 0xE4, 0x69, 0x04,    0,    0, 0x40, 0x77, 0xD0,  0x23, 0x0C, 0x02, 0x77, 0xD0, 0x80, 0x23, 0x88, 
        0xC9, 0x30, 0xD0, 0x16,    0,    0,    0,    0,     0, 0x77, 0x03 }, 
      { 0xBA, 0xB8, 0xB8, 0x90, 0x99, 0 }, /* added later - untested */
      { 0x58, 0x48, 0x49 }, /* added later - untested */
      0x20BA2E8B, 0,
    },
    { "720x576Noscale", 720, 576, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0xA4,    0,    0, 0x10, 0x75,  0xA5, 0x3A, 0x5A,    0, 0x49, 0x46,    0, 0x89, 
           0,    0, 0xE9, 0x19, 0xDC, 0x24,    0,    0,     0,    0, 0xEE,    0, 0x0A,    0,    0, 0x04, 
        0x13, 0x0C, 0x04, 0x7B, 0x48, 0x64, 0x30, 0x93,  0x49, 0x5F, 0x15, 0xA5, 0x23, 0x77, 0xFF,    0 }, 
      { 0xE7, 0x45, 0x04,    0,    0, 0x45, 0x7F, 0xD0,  0x23, 0x70, 0x02, 0x7F, 0xD0, 0x93, 0x23, 0x89,
        0xC7, 0xF1, 0xBD, 0x06,    0,    0,    0,    0,     0, 0x7F, 0x03 }, 
      { 0xBA, 0xB8, 0xB8, 0x90, 0x99, 0 }, /* added later - untested */
      { 0x58, 0x48, 0x49 }, /* added later - untested */
      0x288933E3, 0,
    },
    { NULL, 0, 0, 0, 0, 0,
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0 },
      { 0, 0, 0, 0, 0, 0},
      { 0, 0, 0 },
      0, 0,
    }
};

/*
 *
 * VT1622A/VT1623 modetables
 *
 */
static DisplayModeRec VT1623Modes[] = {
    { MODEPREFIX("640x480"),      23520,  640,  656,  744,  784, 0,  480,  487,  491,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("640x480"),      30000,  640,  680,  808, 1000, 0,  480,  520,  523,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("800x600"),      39900,  800,  840,  976, 1064, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("800x600"),      34500,  800,  816,  880,  920, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("1024x768"),     54810, 1024, 1032, 1088, 1160, 0,  768,  780,  792,  945, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("1024x768"),     57000, 1024, 1040, 1112, 1200, 0,  768,  829,  840,  950, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("848x480"),      34860,  848,  872, 1032, 1200, 0,  480,  495,  509,  581, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("848x480"),      36000,  848,  872, 1032, 1200, 0,  480,  498,  509,  600, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x480"),      25200,  720,  728,  776,  840, 0,  480,  511,  515,  600, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("720x576"),      28500,  720,  728,  744,  760, 0,  576,  635,  643,  750, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("640x480Over"),  20160,  640,  648,  704,  720, 0,  480,  490,  491,  560, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("640x480Over"),  21000,  640,  664,  792,  840, 0,  480,  485,  491,  500, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("800x600Over"),  35910,  800,  840,  984, 1080, 0,  600,  601,  604,  665, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("800x600Over"),  32500,  800,  832,  928, 1000, 0,  600,  600,  604,  650, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("1024x768Over"), 50400, 1024, 1040, 1112, 1200, 0,  768,  772,  776,  840, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("1024x768Over"), 49500, 1024, 1032, 1112, 1200, 0,  768,  771,  776,  825, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("848x480Over"),  27720,  848,  856,  928, 1008, 0,  480,  490,  493,  550, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("848x480Over"),  33000,  848,  872, 1032, 1200, 0,  480,  490,  493,  550, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x480Over"),  21000,  720,  728,  760,  800, 0,  480,  480,  483,  525, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXNTSC },
    { MODEPREFIX("720x576Over"),  27000,  720,  768,  800,  864, 0,  576,  577,  579,  625, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x576Noscale"),  28000,  720,  736,  768,  896,  0,  576,  576,  579,  625,  0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL  },
    { MODEPREFIX("720x480Noscale"),  27972,  720,  736,  768,  888,  0,  480,  480,  483,  525,  0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC  },
    { MODEPREFIX("720x480pal"), 27972,  720,  736,  768,  888, 0,  480,  480,  483,  525, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL },
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MODESUFFIXNTSC },
};

static struct VT162XTableRec
VT1623Table[] = {
    { "640x480", 640, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0, 0x06, 0x03,    0, 0x20, 0x28,  0x9A, 0x0C, 0x55,    0, 0x52, 0x3B, 0x0F,    0,
	   0,    0, 0xF8, 0x3E, 0x81, 0x56,    0,    0,     0,    0, 0xEA,    0,    0,    0,    0, 0x11,
	0x15, 0x0C, 0x5F, 0x75, 0x08, 0x56, 0x2F, 0x90,  0x50,    0,    0, 0xA3, 0x29, 0x5B, 0xBF,    0 },
      {    0,    0,    0,    0,    0, 0x3B, 0x0F, 0x7F,  0x23, 0x57, 0x02, 0x0F, 0x26, 0x73, 0x63, 0x86,
	0xC4, 0xEA, 0xDF, 0x05, 0x92, 0xA1, 0x84,    0,     0, 0x7F, 0x03 },
      { 0x6A, 0x62, 0x65, 0x91, 0x9C, 0x27 },
      { 0x50, 0x4B, 0x4D },
      0x252491F1, 0x252487BE,
    },
    { "640x480", 640, 480, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0x06,    0,    0, 0x20, 0xBF,  0x9F, 0x37, 0x5D,    0, 0x4F, 0x42, 0x0F,    0,
	   0,    0, 0xAC, 0x15, 0x6E, 0x28,    0,    0,     0,    0, 0xED,    0, 0x02,    0,    0, 0x99,
	0x17, 0x0C, 0x31, 0x7A, 0x04, 0x62, 0x30, 0x8E,  0x4A, 0x5B, 0x15, 0xA0, 0x22, 0x5C, 0xCC,    0 },
      {    0,    0,    0,    0,    0, 0x43, 0xE7, 0x7F,  0x23, 0x57, 0x02, 0x1F, 0x2F, 0x75, 0x63, 0x8A,
	0xC8, 0xF0, 0xFF, 0x05, 0xD7, 0x8E, 0x83, 0x7F,  0xCF, 0xBF, 0x03 },
      { 0x6A, 0x62, 0x65, 0x8D, 0x96, 0x20 },
      { 0x42, 0x49, 0x49 },
      0x2D66772D, 0,
    },
    { "800x600", 800, 600, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x04, 0x03,    0, 0x20, 0x58,  0xD4, 0x09, 0x52,    0, 0x51, 0x3B, 0x0F,    0,
	   0,    0, 0x6A, 0x0D, 0x4C, 0x1C,    0,    0,     0,    0, 0x3E,    0, 0x01,    0,    0, 0x44,
	0x10, 0x0A, 0x9C, 0x75, 0x04, 0x56, 0x41, 0x90,  0x6B,    0,    0, 0xA3, 0x29, 0x86, 0x10, 0x10 },
      {    0,    0,    0,    0,    0, 0x3A, 0x27, 0x1F,  0x34, 0xED, 0x02, 0x27, 0xF5, 0x9D, 0x64, 0xB7,
	0x0D, 0x40,    0, 0x58, 0xB6, 0x3B, 0x85,    0,  0x01, 0xEF, 0x05 },
      { 0x6A, 0x62, 0x65, 0x91, 0x9C, 0 },
      { 0x43, 0x4A, 0x49 },
      0x1B5E5096, 0x1B5E4912,
    },
    { "800x600", 800, 600, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0x04,    0,    0, 0x20, 0x27,  0xB8, 0x0D, 0x5C,    0, 0x4E, 0x40, 0x0F,    0,
	   0,    0, 0xEC, 0x2A, 0xFD, 0x28,    0,    0,     0,    0, 0x11,    0, 0x01,    0,    0, 0xAA,
	0x13, 0x0C, 0x9F, 0x79, 0x0C, 0x62, 0x37, 0x8E,  0x54, 0x5B, 0x15, 0xA0, 0x22, 0x70, 0xF4,    0 },
      {    0,    0,    0,    0,    0, 0x41, 0x97, 0x1F,  0x33, 0xED, 0x02, 0x97, 0x87, 0x87, 0x63, 0x9F,
	0xE7, 0x16, 0xE7, 0x16, 0xCC, 0xF3, 0x84,    0,  0x01, 0x4F, 0x04 },
      { 0x6A, 0x62, 0x65, 0, 0, 0},
      { 0x58, 0x5E, 0x5E },
      0x277A7DE4, 0,
    },
    { "1024x768", 1024, 768, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x04, 0x03,    0, 0x20, 0x47,  0x12, 0x08, 0x50,    0, 0x50, 0x3A, 0x0F,    0,
	   0,    0, 0xEF, 0x37, 0x77, 0x2A,    0,    0,     0,    0, 0xA1,    0, 0x05,    0,    0, 0x77,
	0x0D, 0x05, 0xEF, 0x73, 0x0C, 0x56, 0x56, 0x90,  0x8B,    0,    0, 0xA3, 0x29, 0xB9, 0x6A, 0x10 },
      {    0,    0,    0,    0,    0, 0x39, 0x87, 0xFF,  0x34, 0xB0, 0x03, 0x6F, 0xDC, 0xCD, 0x35, 0xF1,
	0x5E, 0xA5, 0x7E, 0x5A, 0x33, 0x26, 0x87,    0,  0x01, 0x27, 0x08 },
      { 0x6A, 0x62, 0x65, 0x91, 0x9C, 0 },
      { 0x58, 0x4B, 0x4A },
      0x14EB66D6, 0x14EB6118,
    },
    { "1024x768", 1024, 768, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0x04,    0,    0, 0x20, 0x57,  0x25, 0x35, 0x5A,    0, 0x4D, 0x40, 0x0F,    0,
	   0,    0, 0xE8, 0x23, 0xD1, 0x18,    0,    0,     0,    0, 0x96,    0, 0x07,    0,    0, 0xFF,
	0x0F, 0x0C, 0x87, 0x79,    0, 0x62, 0x53, 0x8E,  0x7B, 0x5B, 0x15, 0xA0, 0x22, 0xB6, 0x5A, 0x10 },
      {    0,    0,    0,    0,    0, 0x40, 0xAF, 0xFF,  0x34, 0xB5, 0x03, 0x57, 0xA8, 0xC8, 0x35, 0xEC,
	0x4C, 0xCC, 0x67, 0x5A, 0x14, 0x5C, 0x06,    0,  0x01, 0x1F, 0x07 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x50, 0x69, 0x69 },
      0x1A8CC372, 0,
    },
    { "848x480", 848, 480, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x04, 0x03,    0, 0x20, 0xA7,  0xC1, 0x07, 0x50,    0, 0x50, 0x39, 0x0F,    0,
	   0,    0, 0xF0, 0x29, 0x67, 0x31,    0,    0,     0,    0, 0x2A,    0, 0x03,    0,    0, 0x33,
	0x11, 0x08, 0x47, 0x73, 0x0C, 0x56, 0x3C, 0x90,  0x65,    0,    0, 0xA3, 0x29, 0x7C,    0, 0x10 },
      {    0,    0,    0,    0,    0, 0x39, 0xAF, 0x4F,  0x34, 0x44, 0x02, 0xE3, 0xC2, 0x93, 0x63, 0xAD,
	0xFD, 0x2B, 0x7C, 0x17, 0x6D, 0xCA, 0x84,    0,  0x01, 0x2F, 0x05 },
      { 0x6A, 0x62, 0x65, 0x91, 0x9C, 0 },
      { 0x44, 0x45, 0x45 },
      0x1D3CA863, 0x1D3CA05B,
    },
    { "848x480", 848, 480, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0x06,    0,    0, 0x20, 0xA7,  0xE6, 0x06, 0x5C,    0, 0x4E, 0x41, 0x0F,    0,
	   0,    0, 0xE6, 0x23, 0x84, 0x18,    0,    0,     0,    0, 0x56,    0, 0x01,    0,    0, 0xCC,
	0x0F, 0x0C, 0x60, 0x79,    0, 0x62, 0x46, 0x8E,  0x68, 0x5B, 0x15, 0xA0, 0x22, 0x94, 0x2A, 0x10 },
      {    0,    0,    0,    0,    0, 0x40, 0xAF, 0x4F,  0x34, 0x57, 0x02, 0x7F, 0x31, 0xA9, 0x74, 0xD1,
	0x2B, 0x5D, 0xAA, 0x58, 0xD7, 0x26, 0x83,    0,  0x01, 0x7F, 0x04 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x50, 0x49, 0x49 },
      0x1F872818, 0,
    },
    { "720x480", 720, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0, 0x06, 0x03,    0, 0x20, 0x3F,  0xB6, 0x07, 0x52,    0, 0x51, 0x3A, 0x0F,    0,
	   0,    0, 0xED, 0x31, 0x50, 0x35,    0,    0,     0,    0, 0x1E,    0, 0x03,    0,    0, 0x33,
	0x12, 0x08, 0x57, 0x75,    0, 0x56, 0x3A, 0x90,  0x61,    0,    0, 0xA3, 0x29, 0x76, 0xF1,    0 },
      {    0,    0,    0,    0,    0, 0x3A, 0x47, 0xCF,  0x23, 0x57, 0x02, 0xBF, 0xAD, 0x8D, 0x63, 0xA4,
	0xF3, 0x20, 0x36, 0x17, 0x92, 0x33, 0x84,    0,     0, 0xBF, 0x03 },
      { 0x6A, 0x62, 0x65, 0x91, 0x9C, 0 },
      { 0x42, 0x49, 0x48 },
      0x1E555518, 0x1E554CC3,
    },
    { "720x576", 720, 576, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0x06,    0,    0, 0x20, 0x0F,  0xAF, 0x35, 0x5D,    0, 0x4F, 0x41, 0x0F,    0,
	   0,    0, 0xF8, 0x3C, 0x73, 0x56,    0,    0,     0,    0, 0xED,    0, 0x02,    0,    0, 0x99,
	0x18, 0x0C, 0x76, 0x7A, 0x44, 0x62, 0x30, 0x8E,  0x49, 0x5B, 0x15, 0xA0, 0x22, 0x5C, 0xBD,    0 },
      {    0,    0,    0,    0,    0, 0x43, 0xF7, 0xCF,  0x22, 0xED, 0x02, 0x1D, 0x29, 0x75, 0x63, 0x88,
	0xC6, 0xF0, 0xFA, 0x0F, 0xCC, 0x30, 0x94,    0,     0, 0x8F, 0x03 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x59, 0x4D, 0x4A },
      0x2D839832, 0,
    },
    { "640x480Over", 640, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0, 0x06, 0x03,    0, 0x20, 0x10,  0x76, 0x0A, 0x56, 0x05, 0x50, 0x3B, 0x0F,    0,
	   0,    0, 0xED, 0x23, 0xC0, 0x34,    0,    0,     0,    0, 0xE5,    0, 0x02,    0,    0, 0x11,
	0x17, 0x0C, 0x46, 0x73, 0x0C, 0x56, 0x2E, 0x90,  0x4E,    0,    0, 0xA3, 0x29, 0x59, 0xBA,    0 },
      {    0,    0,    0,    0,    0, 0x3A, 0xCF, 0x7F,  0x22, 0x2F, 0x02, 0xFF, 0x59, 0x71, 0x62, 0x83,
	0xC0, 0xE5, 0xC0, 0x05, 0x44, 0x44, 0x84,    0,     0, 0xFF, 0x02 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x4F, 0x49, 0x49 },
      0x25EAAA5E, 0x25EA9FF4,
    },
    { "640x480Over", 640, 480, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0, 0x06,    0,    0, 0x20, 0x23,  0x4E, 0x2A, 0x61,    0, 0x4D, 0x47, 0x0F,    0,
	   0,    0, 0x4A, 0x0F, 0x37, 0x28,    0,    0,     0,    0, 0xC7,    0, 0x02,    0,    0, 0x88,
	0x1B, 0x0C, 0xFF, 0x79,    0, 0x62, 0x28, 0x8E,  0x3E, 0x5B, 0x15, 0xA0, 0x22, 0x49, 0xCC,    0 },
      {    0,    0,    0,    0,    0, 0x44, 0x47, 0x7F,  0x23, 0xF3, 0x01, 0x9F, 0x3F, 0x62, 0x62, 0x72,
	0xA7, 0xCB, 0x05, 0x05, 0x33, 0x70, 0x83,    0,     0, 0x9F, 0x02 },
      { 0x6A, 0x62, 0x65, 0x90, 0x99, 0 },
      { 0x42, 0x49, 0x49 },
      0x360C44BC, 0,
    },
    { "800x600Over", 800, 600, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x04, 0x03,    0, 0x20, 0x5F,  0xA4, 0x08, 0x51,    0, 0x50, 0x39, 0x0F,    0,
	   0,    0, 0xE8, 0x33, 0xE6, 0x18,    0,    0,     0,    0, 0x32,    0, 0x03,    0,    0, 0x33,
	0x11, 0x0A, 0x9B, 0x73, 0x08, 0x56, 0x3F, 0x90,  0x68,    0,    0, 0xA3, 0x29, 0x82, 0x02, 0x10 },
      {    0,    0,    0,    0,    0, 0x39, 0x37, 0x21,  0x34, 0x98, 0x02, 0x01, 0x21, 0x97, 0x74, 0xB1,
	0xFF, 0x34, 0xB6, 0x17, 0x11,    0, 0x85,    0,  0x01, 0x57, 0x05 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x42, 0x45, 0x45 },
      0x1C61CEE0, 0x1C61C714,
    },
    { "800x600Over", 800, 600, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0x04,    0,    0, 0x20, 0x47,  0x90, 0x3B, 0x5A,    0, 0x4D, 0x3F, 0x0F,    0,
	   0,    0, 0xE8, 0x24, 0x8F, 0x1C,    0,    0,     0,    0, 0x0E,    0, 0x03,    0,    0, 0xAA,
	0x14, 0x0C, 0x2F, 0x79,    0, 0x62, 0x37, 0x8E,  0x54, 0x5B, 0x15, 0xA0, 0x22, 0x6E, 0xF4,    0 },
      {    0,    0,    0,    0,    0, 0x41, 0xE7, 0x1F,  0x33, 0x89, 0x02, 0x8D, 0xCD, 0x85, 0x63, 0x9C,
	0xE4, 0x13, 0xD4, 0x16, 0x28, 0x60, 0x84,    0,  0x01, 0x0F, 0x04 },
      { 0x6A, 0x62, 0x65, 0x90, 0x99, 0 },
      { 0x58, 0x48, 0x48 },
      0x27E98D57, 0,
    },
    { "1024x768Over", 1024, 768, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x04, 0x03,    0, 0x20, 0x52,  0xAE, 0x09, 0x50,    0, 0x50, 0x39, 0x0F,    0,
	   0,    0, 0xE8, 0x33, 0x0D, 0x15,    0,    0,     0,    0, 0x66,    0, 0x03,    0,    0, 0x55,
	0x0F, 0x05, 0xF1, 0x73, 0x08, 0x56, 0x4A, 0x90,  0x79,    0,    0, 0xA3, 0x29, 0x9B, 0x33, 0x10 },
      {    0,    0,    0,    0,    0, 0x39, 0xAF, 0xFF,  0x34, 0x47, 0x03, 0xAF, 0xC3, 0xB1, 0x34, 0xD1,
	0x30, 0x68, 0x0B, 0x59, 0x66, 0x40, 0x86,    0,  0x01, 0x7F, 0x07 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x57, 0x45, 0x45 },
      0x1844440E, 0x18443D63,
    },
    { "1024x768Over", 1024, 768, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0x04,    0,    0, 0x20, 0x56,  0xC0, 0x32, 0x5A,    0, 0x4D, 0x40, 0x0F,    0,
	   0,    0, 0xC9, 0x14, 0x79, 0x1C,    0,    0,     0,    0, 0x6D,    0, 0x03,    0,    0, 0xDD,
	0x0F, 0x0C, 0xCA, 0x79, 0x08, 0x62, 0x4B, 0x8E,  0x6F, 0x5B, 0x15, 0xA0, 0x22, 0xA1, 0x5A, 0x10 },
      {    0,    0,    0,    0,    0, 0x40, 0xAF, 0xFF,  0x34, 0x38, 0x03, 0xCF, 0xDF, 0xB4, 0x34, 0xD6,
	0x35, 0x75, 0x47, 0x59, 0x47, 0x20, 0x05,    0,  0x01, 0x2F, 0x06 },
      { 0x6A, 0x62, 0x65, 0x90, 0x99, 0 },
      { 0x51, 0x49, 0x49 },
      0x1D7B0E38, 0,
    },
    { "848x480Over", 848, 480, TVTYPE_NTSC, 0, 0,
      { 0x84,    0,    0, 0x04, 0x03,    0, 0x20, 0x4E,  0x9E, 0x07, 0x51,    0, 0x50, 0x3A, 0x0F,    0,
	   0,    0, 0xED, 0x23, 0x08, 0x35,    0,    0,     0,    0, 0x3C,    0, 0x03,    0,    0, 0x44,
	0x11, 0x0A, 0xF0, 0x73, 0x04, 0x56, 0x41, 0x90,  0x6A,    0,    0, 0xA3, 0x29, 0x87, 0x0A, 0x10 },
      {    0,    0,    0,    0,    0, 0x39, 0xEF, 0x51,  0x33, 0x25, 0x02, 0x1F, 0x47, 0x9C, 0x74, 0xB5,
	0x0C, 0x3D, 0xF1, 0x57, 0x30, 0x0C, 0x84,    0,  0x01, 0x1F, 0x04 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x58, 0x45, 0x45 },
      0x1B9364A1, 0x1B933067,
    },
    { "848x480Over", 848, 480, TVTYPE_PAL, 0, 0,
      { 0x84,    0,    0, 0x04,    0,    0, 0x20, 0xA5,  0xA1, 0x38, 0x5E,    0, 0x4D, 0x41, 0x0F,    0,
	   0,    0, 0xC7, 0x1E, 0x79, 0x1C,    0,    0,     0,    0, 0x39,    0, 0x03,    0,    0, 0xBB,
	0x12, 0x0C, 0x5A, 0x79, 0x0C, 0x62, 0x40, 0x8E,  0x5F, 0x5B, 0x15, 0xA0, 0x22, 0x88, 0x2A, 0x10 },
      {    0,    0,    0,    0,    0, 0x3A, 0xAF, 0x4F,  0x34, 0x25, 0x02, 0x1F, 0x4F, 0x9B, 0x74, 0xB7,
	0x0A, 0x3F, 0xF0, 0x58, 0x85,    0, 0x83,    0,  0x01, 0x1F, 0x04 },
      { 0x6A, 0x62, 0x65, 0x90, 0x99, 0 },
      { 0x4E, 0x49, 0x49 },
      0x2264E5EC, 0,
    },
    { "720x480Over", 720, 480, TVTYPE_NTSC, 0, 0,
      { 0x04,    0,    0,    0, 0x03,    0, 0x20, 0x28,  0x52, 0x08, 0x50,    0, 0x4E, 0x2F, 0x0F,    0,
	   0,    0, 0x2D, 0x07, 0x28, 0x34,    0,    0,     0,    0, 0xEE,    0, 0x02,    0,    0, 0x11,
	0x16, 0x08, 0xDF, 0x76, 0x04, 0x56, 0x31, 0x90,  0x51,    0,    0, 0xA3, 0x29, 0x5D, 0xC3,    0 },
      {    0,    0,    0,    0, 0x08, 0x3A, 0x1F, 0xCF,  0x23, 0x0C, 0x02, 0x1F, 0xCE, 0x76, 0x23, 0x88,
	0xC9, 0xEF, 0xFF, 0x05,    0,    0,    0,    0,     0, 0x1F, 0x03 },
      { 0x6A, 0x62, 0x65, 0, 0, 0 },
      { 0x4D, 0x49, 0x49 },
      0x2466661D, 0x24665C1E,
    },
    { "720x576Over", 720, 576, TVTYPE_PAL, 0, 0,
      { 0x04,    0,    0,    0,    0,    0, 0x20, 0x3F,  0x89, 0x35, 0x50,    0, 0x43, 0x2E, 0x0F,    0,
	   0,    0, 0xE8, 0x23, 0x84, 0x20,    0,    0,     0,    0, 0xFF,    0, 0x02,    0,    0, 0x99,
	0x17, 0x0C, 0x6F, 0x79, 0x48, 0x62, 0x34, 0x8E,  0x4F, 0x5B, 0x15, 0xA0, 0x22, 0x67, 0xFF,    0 },
      {    0,    0,    0,    0,    0, 0x3A, 0x5F, 0xCF,  0x23, 0x70, 0x02, 0x5F, 0xBF, 0x7E, 0x23, 0x94,
	0xD0, 0x27, 0x8F, 0x16,    0,    0, 0x04,    0,     0, 0x5F, 0x03 },
      { 0x6A, 0x62, 0x65, 0x90, 0x99, 0 },
      { 0x58, 0x48, 0x49 },
      0x2A098ACB, 0,
    },
    { "720x576Noscale", 720, 576, TVTYPE_PAL, 0, 0,
	{ 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x78, 0x78, 0x38, 0x5a, 0x00, 0x49, 0x2e, 0x00, 0x80,
	0x00, 0x00, 0x03, 0x0f, 0x16, 0x0c, 0x8d, 0x33, 0x89, 0x28, 0xee, 0x10, 0x02, 0x80, 0x00, 0x00,
	0x13, 0x0c, 0x04, 0x7b, 0x48, 0x64, 0x30, 0x93, 0x49, 0x5f, 0x15, 0xa5, 0x23, 0x77, 0xff, 0x00,
	},
	{ 0x00, 0x00, 0x04, 0x00, 0x00, 0x45, 0x7f, 0xd0, 0x23, 0x70, 0x02, 0x7f, 0xd0, 0x83, 0x23, 0x9c,
	0xdb, 0x08, 0xb7, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03,   },

       { 0xBA, 0xB8, 0xB8, 0x90, 0x99, 0 },
       { 0x58, 0x48, 0x49 },
         0x2889338d, 0,
	},
    
    { "720x480Noscale", 720, 480, TVTYPE_NTSC, 0, 0,
    	{ 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x20, 0x78, 0x78, 0x06, 0x5a, 0x00, 0x49, 0x2f, 0x00, 0x80,
	  0x00, 0x00, 0xed, 0x23, 0xde, 0x34, 0x97, 0xab, 0xca, 0x20, 0xee, 0x10, 0x02, 0x80, 0x00, 0x11,
   	  0x11, 0x08, 0x04, 0x76, 0x08, 0x5a, 0x31, 0x95, 0x51, 0x00, 0x00, 0xaa, 0x2b, 0x7a, 0xdb, 0x00,
	},
	{ 0x00, 0x00, 0x04, 0x00, 0x00, 0x40, 0x77, 0xd0, 0x23, 0x0c, 0x02, 0x77, 0xd0, 0x83, 0x23, 0x98,
    	0xde, 0xe8, 0xc4, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x03,   },
  	{ 0xBA, 0xB8, 0xB8, 0x90, 0x99, 0 },
  	{ 0x58, 0x48, 0x49 },
  	0x20caab97, 0,
    },
    
    { "720x480pal", 720, 480, TVTYPE_PAL, 0, 0,
      { 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x20, 0x74,  0x8c, 0x06, 0x50, 0x00, 0x4e, 0x2f, 0x00, 0x07,
        0x00, 0x00, 0xa9, 0x19, 0x6e, 0x24, 0xe3, 0x33,  0x89, 0x28, 0xee, 0x10, 0x02, 0x80, 0x00, 0x11,
        0x11, 0x08, 0x04, 0x76, 0x08, 0x5a, 0x31, 0x95,  0x51, 0x00, 0x00, 0xaa, 0x2b, 0x7a, 0xdb, 0x00,
        },
      { 0x00, 0x00, 0x04, 0x00, 0x00, 0x40, 0x77, 0xd0,  0x23, 0x0c, 0x02, 0x77, 0xd0, 0xb0, 0x23, 0x88,
        0xc9, 0x30, 0xd0, 0x16, 0x00, 0x00, 0x00, 0x00,  0x00, 0x77, 0x03 },
      { 0xBA, 0xB8, 0xB8, 0x90, 0x99, 0 },
      { 0x58, 0x48, 0x49 },
      0x288933e3, 0,
    },
    { NULL, 0, 0, 0, 0, 0,
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0 },
      { 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0 },
      0, 0,
    }
};

/*
 *
 * VT1625 modetables
 *
 */

static DisplayModeRec VT1625Modes[] = {
/* all available modes are: */
/*  { MODEPREFIX("640x480"), ... ,   MODESUFFIXNTSC },
    { MODEPREFIX("800x600"), ... ,   MODESUFFIXNTSC },
    { MODEPREFIX("1024x768"), ... ,   MODESUFFIXNTSC },

    { MODEPREFIX("720x480"), ... ,   MODESUFFIX480P },

    { MODEPREFIX("640x480"), ... ,   MODESUFFIX720P },
    { MODEPREFIX("800x600"), ... ,   MODESUFFIX720P },
    { MODEPREFIX("1024x768"), ... ,   MODESUFFIX720P },
    { MODEPREFIX("720x480"), ... ,   MODESUFFIX720P },
    { MODEPREFIX("720x576"), ... ,   MODESUFFIX720P },

    { MODEPREFIX("640x480"), ... ,   MODESUFFIX1080I },
    { MODEPREFIX("800x600"), ... ,   MODESUFFIX1080I },
    { MODEPREFIX("1024x768"), ... ,   MODESUFFIX1080I },
    { MODEPREFIX("720x480"), ... ,   MODESUFFIX1080I },
    { MODEPREFIX("720x576"), ... ,   MODESUFFIX1080I }, 

    { MODEPREFIX("640x480Over"), ... ,   MODESUFFIXNTSC },
    { MODEPREFIX("800x600Over"), ... ,   MODESUFFIXNTSC },
    { MODEPREFIX("1024x768Over"), ... ,   MODESUFFIXNTSC },
    { MODEPREFIX("720x480Over"), ... ,   MODESUFFIXNTSC },

    { MODEPREFIX("640x480Over"), ... ,   MODESUFFIXPAL },
    { MODEPREFIX("800x600Over"), ... ,   MODESUFFIXPAL },
    { MODEPREFIX("1024x768Over"), ... ,   MODESUFFIXPAL },
    { MODEPREFIX("720x576Over"), ... ,   MODESUFFIXPAL },*/
/*                                clock    HR   SH1   SH2   HFL       VR   SV1   SV2   VFL*/
    { MODEPREFIX("640x480"),      30000,  640,  680,  808, 1000, 0,  480,  520,  523,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL   },
    { MODEPREFIX("800x600"),      34500,  800,  816,  880,  920, 0,  600,  604,  620,  750, 0, V_PHSYNC | V_PVSYNC, MODESUFFIXPAL   },
    { MODEPREFIX("1024x768"),     57000, 1024, 1040, 1112, 1200, 0,  768,  829,  840,  950, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXPAL   },
    { MODEPREFIX("720x576"),      28500,  720,  728,  744,  760, 0,  576,  635,  643,  750, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXPAL   },
    { MODEPREFIX("720x576Over"),  27000,  720,  768,  800,  864, 0,  576,  577,  579,  625, 0, V_NHSYNC | V_PVSYNC, MODESUFFIXPAL   },

    { MODEPREFIX("1280x720"),     74250, 1280, 1320, 1376, 1650, 0,  720,  722,  728,  750, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX720P  },
    { MODEPREFIX("1920x1080"),    74250, 1920, 1960, 2016, 2200, 0, 1080, 1082, 1088, 1125, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX1080I },

    { MODEPREFIX("640x480"),      24696,  640,  656,  744,  784, 0,  480,  482,  483,  525, 0, V_NHSYNC | V_NVSYNC, MODESUFFIXNTSC  },

    { MODEPREFIX("720x480Under"), 28224,  720,  728,  744,  784, 0,  480,  490,  496,  600, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX480P  },
    { MODEPREFIX("720x480Fit"),   28980,  720,  728,  776,  840, 0,  480,  484,  499,  575, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX480P  },
    { MODEPREFIX("720x480Over"),  27027,  720,  784,  808,  858, 0,  480,  483,  486,  525, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX480P  },

    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MODESUFFIXNTSC },
};

static struct VT162XTableRec
VT1625Table[] = {
    { "640x480", 640, 480, TVTYPE_NTSC, 0, 0,
      /*  00                                                                                         0F */
      { 0x03,    0, 0x10, 0x40, 0x10,    0,    0, 0x28,  0x47, 0x15, 0x7B,    0, 0x50, 0x57,    0, 0x9E,
	   0, 0x80, 0xFA, 0x21, 0xE0, 0x68, 0xD6, 0x7B,  0xF0, 0x21, 0x02, 0x50, 0x41, 0x80,    0, 0x10,
	0x1C, 0x2A, 0xCB, 0x77,    0,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      /*  4A                            4F    50                                                     59 */
      { 0xC5,    0,    0, 0x01, 0x10, 0x4A, 0x0F, 0x83,  0x23, 0x57, 0x22, 0x59, 0x83, 0x7F, 0x23, 0x91,
      /*  5A                            5F    60                       64 */
	0xD2, 0x13, 0x7C, 0x16, 0x49,    0, 0x92, 0x20,     0, 0x7F, 0x03 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x55, 0x37, 0x5C,    0,    0,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x55, 0x56, 0x55 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x21F07BD6, 0x21F087BE,
    },
    { "720x480Under", 720, 480, TVTYPE_480P, 0, 0,
      /*  00                                                                                         0F */
      { 0x03,    0, 0x10, 0x40, 0x10,    0,    0, 0x2A,  0x41, 0x14, 0x7B,    0, 0x50, 0x57,    0, 0xB7,
	   0, 0x80, 0xAB, 0x27, 0x70, 0x2C, 0xD6, 0x7B,  0xF0, 0x21, 0x02, 0x50, 0x41, 0x80,    0, 0x01,
	0x2F, 0x08, 0xCB, 0x7E,    0,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      /*  4A                            4F    50                                                     59 */
      { 0xC5, 0x0F,    0, 0x01,   0, 0x4A, 0x0F, 0xCF,  0x23, 0x57, 0x22, 0x59, 0x83, 0x7F, 0x23, 0x91,
      /*  5A                            5F    60                       64 */
	0xD2, 0x13, 0x7A, 0x16, 0x49, 0xF1, 0x92, 0xA8,     0, 0x7F, 0x03 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x55, 0x37, 0x5C,    0,    0,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x55, 0x54, 0x56 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x21F07BD6, 0x21F087BE,
    },
    { "720x480Fit", 720, 480, TVTYPE_480P, 0, 0,
      /*  00                                                                                         0F */
      { 0x03,    0, 0x10, 0x40, 0x10,    0,    0, 0x41,  0x43, 0xFF, 0x7B,    0, 0x50, 0x57,    0, 0xB7,
           0, 0x80, 0xCD, 0x21, 0x73, 0x34, 0xD6, 0x7B,  0xF0, 0x21, 0x02, 0x50, 0x43, 0x80,    0, 0x01,
        0x2F, 0x08, 0xCA, 0x7E, 0x02,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      /*  4A                            4F    50                                                     59 */
      { 0xC5, 0x0F,    0, 0x01,    0, 0x4A, 0x47, 0xCF,  0x23, 0x3E, 0x22, 0x59, 0x8B, 0x7F, 0x23, 0x91,
      /*  5A                            5F    60                       64 */
        0xD2, 0x13, 0x7A, 0x16, 0x30, 0xD4, 0x8C, 0x28,     0, 0x97, 0x03 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x55, 0x37, 0x5C,    0,    0,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x55, 0x54, 0x56 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x21F07BD6, 0x21F087BE,
    },
    { "720x480Over", 720, 480, TVTYPE_480P, 0, 0,
      /*  00                                                                                         0F */
      { 0x03,    0, 0x10, 0x40, 0x10,    0,    0, 0x33,  0x20, 0xFF, 0x7B,    0, 0x50, 0x57,    0, 0x9E,
           0, 0x80, 0x04, 0x08, 0x08, 0x10, 0xD6, 0x7B,  0xF0, 0x21, 0x02, 0x50, 0x43, 0x80,    0, 0x01,
        0x2F, 0x08, 0xDC, 0x7E, 0x02,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      /*  4A                            4F    50                                                     59 */
      { 0xC5, 0x0F,    0, 0x01,    0, 0x4A, 0x59, 0xCF,  0x23, 0x0C, 0x22, 0x59, 0xCF, 0x7F, 0x23, 0x91,
      /*  5A                            5F    60                       64 */
        0xD2, 0xE1, 0x7D, 0x06,    0,    0, 0x80, 0x28,     0, 0x59, 0x03 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x55, 0x37, 0x5C,    0,    0,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x55, 0x54, 0x56 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x21F07BD6, 0x21F087BE,
    },

    { "1280x720", 1280, 720, TVTYPE_720P, 0, 0,
      /*  00                                                                                         0F */
      { 0x83,    0, 0x10, 0x40, 0x94, 0x00,    0, 0xFF,  0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9E,
        0x00, 0x80, 0x89, 0x10, 0x63, 0x24, 0x00, 0x00,  0x00, 0x00,    0, 0x50, 0x40, 0x80, 0x00, 0x03,
        0x25, 0x00, 0x00, 0x7E, 0x00,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
/* hdtv - 4A 0x85, 4B 0x0A */
      /*  4A                            4F    50                                                     59 */
      { 0xC5, 0x0F,    0, 0x01,    0, 0x00, 0x71, 0xFF,  0x46, 0xED, 0x12, 0x71, 0xFF, 0x50, 0x46, 0x30,
      /*  5A                            5F    60                       64 */
        0x30, 0x1C, 0x47, 0x96, 0x00, 0x00, 0x80, 0x28,  0x00, 0x71, 0x36 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x55, 0x39, 0x66,    0,    0,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x55, 0x56, 0x55 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x0, 0x0,
    },

    { "1920x1080", 1920, 540, TVTYPE_1080I, 0, 0,
      /*  00                                                                                         0F */
      { 0x83,    0, 0x10, 0x4A, 0x86, 0x39,    0, 0x8B,  0x3D, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9E,
        0x00, 0x80, 0x4A, 0x08, 0x37, 0x14, 0x00, 0x00,  0x00, 0x00, 0x00, 0x50, 0x44, 0x80, 0x00, 0x03,
        0x25, 0x00, 0x00, 0x7E, 0x00,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      /*  4A                            4F    50                                                     59 */
      { 0xC5, 0x0F,    0, 0x01,    0, 0x00, 0x97, 0x7F,  0x78, 0x64, 0x14, 0x97, 0x7f, 0x59, 0x78, 0xb0,
      /*  5A                            5F    60                       64 */
        0x1a, 0xec, 0xfa, 0x08, 0x00, 0x00, 0x80, 0x20,  0xFF, 0x97, 0x28 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x55, 0x39, 0x66,    0,    0,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x55, 0x56, 0x55 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x0, 0x0,
    },
    { "720x576Over", 720, 576, TVTYPE_PAL, 0, 0,
      /*  00                                                                                         0F */
      { 0x03,    0, 0x10, 0x1F, 0x03,    0,    0, 0x39,  0x19, 0x01, 0x88, 0x00, 0x55, 0x5E, 0x00, 0x9E,
           0, 0x80, 0x04, 0x08, 0x08, 0x10, 0xCB, 0x8A,  0x09, 0x2A, 0x00, 0x50, 0x41, 0x80,    0, 0x10,
        0x17, 0x0C, 0x32, 0x7D, 0x02,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      /*  4A                            4F    50                                                     59 */
      { 0xC5, 0x0F,    0, 0x01, 0x10, 0x51, 0x5F, 0xCF,  0x23, 0x70, 0x22, 0x5F, 0xD0, 0x7F, 0x23, 0x92,
      /*  5A                            5F    60                       64 */
        0xCE, 0x0C, 0x8E, 0x16,    0,    0, 0x80, 0x20,  0xFF, 0x5F, 0x03 },
      /* RBG 65,66,67,27,2b,2c */
      { 0x6A, 0x62, 0x65, 0x90, 0x99,    0 },
      /* Y-Cb-Cr 65,66,67 */
      { 0x58, 0x48, 0x49 },
      /* Subcarrier 19,18,17,16, DotCrawl Subcarrier (set bit 3 of reg 11 then subcarrier) */
      0x2A098ACB, 0,
    },

/*
    { "1920x1080", 1920, 540, TVTYPE_NTSC, 0, 0,
      { 0x83,    0, 0x10, 0x4A, 0x86, 0x39,    0, 0x8B,  0x3D, 0x32,    0,    0,    0,    0,    0, 0x9E,
	   0, 0x80, 0x4A, 0x08, 0x37, 0x14,    0,    0,     0,    0,    0, 0x50, 0x44, 0x80,    0, 0x03,
	0x25,    0,    0, 0x7E,    0,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      { 0xC5, 0x0F,    0, 0x01,    0,    0, 0x97, 0x7F,  0x78, 0x64, 0x14, 0x97, 0x7F, 0x59, 0x78, 0xB0,
	0x1A, 0xEC, 0xFA, 0x08,    0,    0, 0x80, 0x20,  0xFF, 0x97, 0x28 },
      { 0x55, 0x56, 0x55, 0x91, 0x9C, 0 },
      { 0x42, 0x49, 0x48 },
      0x1E555518, 0x1E554CC3,
    },
    { "960x540", 960, 540, TVTYPE_NTSC, 0, 0,
      { 0x83,    0, 0x10, 0x4A, 0x86, 0x39,    0, 0x8B,  0x3D, 0x32,    0,    0,    0,    0,    0, 0x9E,
	   0, 0x80, 0x4A, 0x08, 0x37, 0x14,    0,    0,     0,    0,    0, 0x50, 0x44, 0x80,    0, 0x03,
	0x25,    0,    0, 0x7E,    0,    0,    0,    0,     0,    0,    0,    0,    0,    0,    0,    0 },
      { 0xC5, 0x0F,    0, 0x01,    0,    0, 0x97, 0x7F,  0x78, 0x64, 0x14, 0x97, 0x7F, 0x59, 0x78, 0xB0,
	0x1A, 0xEC, 0xFA, 0x08,    0,    0, 0x80, 0x20,  0xFF, 0x97, 0x28 },
      { 0x55, 0x56, 0x55, 0x91, 0x9C, 0 },
      { 0x42, 0x49, 0x48 },
      0x1E555518, 0x1E554CC3,
    },
*/
    { NULL, 0, 0, 0, 0, 0,
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0 },
      { 0, 0, 0, 0, 0, 0 },
      { 0, 0, 0 },
      0, 0,
    }
};

#endif /* _VIA_VT162X_H_ */
